<?php

/**
 * WooCommerce API Manager API Key Class
 *
 * Author: Neah Plugins
 * Author: Todd Lahman LLC
 *
 */
/**
 *
 *
 * @package Update API Manager/Update Handler
 * @author Todd Lahman LLC
 * @copyright   Copyright (c) Todd Lahman LLC
 * @since 1.0.0
 *
 */
if (!defined('ABSPATH')) exit; // Exit if accessed directly
if (!class_exists('Api_Manager_Woo_RFQ_Key')) {
    class Api_Manager_Woo_RFQ_Key
    {

        // API Key URL
        public function create_software_api_url($args)
        {

            $api_url = add_query_arg('wc-api', 'am-software-api', GPLS_WOO_RFQ_PLUS()->upgrade_url);

            return $api_url . '&' . http_build_query($args);
        }

        public function activate($args)
        {

            require_once(gpls_woo_rfq_plus_DIR . 'includes/am/classes/class-wc-api-manager-passwords.php');
            $api_manager_Password_Management = new API_Manager_Woo_RFQ_Password_Management();

            // Generate a unique installation $instance id
            $instance = $api_manager_Password_Management->generate_password(12, false);
//d(GPLS_WOO_RFQ_PLUS());
            $defaults = array(
                'request' => 'activation',
                'product_id' => GPLS_WOO_RFQ_PLUS()->ame_product_id,
                'instance' => $instance,
                'platform' => GPLS_WOO_RFQ_PLUS()->ame_domain,
                'software_version' => GPLS_WOO_RFQ_PLUS()->ame_software_version
            );

            $args = wp_parse_args($defaults, $args);

            $target_url = self::create_software_api_url($args);


            $request = wp_remote_get($target_url);

            if (is_wp_error($request) || wp_remote_retrieve_response_code($request) != 200) {

                np_write_log($request, __FILE__, __LINE__);
                np_write_log(wp_remote_retrieve_response_code($request), __FILE__, __LINE__);
                return false;
            }

            $response = wp_remote_retrieve_body($request);

            update_option(GPLS_WOO_RFQ_PLUS()->ame_instance_key, $instance);

            return $response;
        }

        public function deactivate($args)
        {

            $instance = get_option(GPLS_WOO_RFQ_PLUS()->ame_instance_key);

            $defaults = array(
                'request' => 'deactivation',
                'product_id' => GPLS_WOO_RFQ_PLUS()->ame_product_id,
                'instance' => $instance,
                'platform' => GPLS_WOO_RFQ_PLUS()->ame_domain
            );

            $args = wp_parse_args($defaults, $args);

            $target_url = self::create_software_api_url($args);

            $request = wp_remote_get($target_url);

            if (is_wp_error($request) || wp_remote_retrieve_response_code($request) != 200) {
                // Request failed
                np_write_log($request, __FILE__, __LINE__);
                np_write_log(wp_remote_retrieve_response_code($request), __FILE__, __LINE__);
                return false;
            }

            $response = wp_remote_retrieve_body($request);
            $response_arr = json_decode($response);
            if (isset($response_arr->deactivated) && $response_arr->deactivated == 'true') {
              //  delete_option(GPLS_WOO_RFQ_PLUS()->ame_instance_key);
            } else {
                np_write_log($response, __FILE__, __LINE__);
            }

            return $response;
        }

        /**
         * Checks if the software is activated or deactivated
         * @param array $args
         * @return array
         */
        public function status($args)
        {

            $defaults = array(
                'request' => 'status',
                'product_id' => GPLS_WOO_RFQ_PLUS()->ame_product_id,
                'instance' => GPLS_WOO_RFQ_PLUS()->ame_instance_id,
                'platform' => GPLS_WOO_RFQ_PLUS()->ame_domain
            );

            $args = wp_parse_args($defaults, $args);

            $target_url = self::create_software_api_url($args);

            $request = wp_remote_get($target_url);

            if (is_wp_error($request) || wp_remote_retrieve_response_code($request) != 200) {
                // Request failed
                return false;
            }

            $response = wp_remote_retrieve_body($request);

            return $response;
        }

    }
}

// Class is instantiated as an object by other classes on-demand
