<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WC_Email_Vendor_New_RFQ' ) ) :

/**
 * New RFQ Email
 *
 * An email sent to the admin when a new RFQ is received.
 *
 * @class       WC_Email_New_Order
 * @extends     WC_Email
 */
    #[\AllowDynamicProperties]
class WC_Email_Vendor_New_RFQ extends WC_Email {

	/**
	 * Constructor
	 */
	public function __construct() {

		$this->id               = 'new_vendor_rfq';
		$this->title            = __( 'RFQ-ToolKit New RFQ For WC Marketplace Vendor', 'rfqtk' );
		$this->description      = __( 'New quote request emails are sent to the WC Marketplace vendor recipient list when an quote request is received.', 'rfqtk' );
		$this->heading          = __( 'New customer quote request', 'rfqtk' );
		$this->subject          = __( '[{site_title}] New customer quote request ({order_number}) - {order_date}', 'rfqtk' );

        $this->template_html = 'emails/vendor-new-rfq.php';
        $this->template_plain = 'emails/plain/vendor-new-rfq.php';

		$this->_templates = array($this->template_html,$this->template_plain);

        $this->placeholders   = array(
            '{order_date}'   => '',
            '{order_number}' => '',
        );

		// Triggers for this email


        add_filter('woocommerce_template_directory', array($this, 'gpls_rfq_woocommerce_locate_template_dir'), 10, 2);


		if(!has_action('woocommerce_order_status_gplsquote-req_notification', array( $this, 'trigger' )))
		{
            add_action('woocommerce_order_status_gplsquote-req_notification', array($this, 'trigger'), 1000);
        }





		// Call parent constructor
		parent::__construct();

		// Other settings

	}
    /**
     * Get email subject.
     *
     * @since  3.1.0
     * @return string
     */
    public function get_default_subject() {
        return __('[{site_title}] New vendor Quote Request ({order_number}) - {order_date}', 'rfqtk');
    }

    /**
     * Get email heading.
     *
     * @since  3.1.0
     * @return string
     */
    public function get_default_heading() {
        return __(' New vendor Quote Request', 'rfqtk');
    }

	public function gpls_rfq_woocommerce_locate_template_dir($dir,$template)
	{

			return $dir;

	}

	/**
	 * Trigger.
	 */
	public function trigger( $order_id ) {

        if(defined("WC_Email_Vendor_New_RFQ".$order_id))return;
        define("WC_Email_Vendor_New_RFQ".$order_id,true);

        if (!function_exists('get_vendor_from_an_order')
        || !function_exists('get_wcmp_product_vendors')) {
            return;
        }

        $vendors = get_vendor_from_an_order($order_id);

        if ($vendors) {
            foreach ($vendors as $vendor) {

                $vendor_obj = get_wcmp_vendor_by_term($vendor);
                $vendor_email = $vendor_obj->user_data->user_email;
                $vendor_id = $vendor_obj->term_id;

                if ($order_id && $vendor_email) {
                    $this->object = new WC_Order($order_id);
                    //$this->find[] = '{order_date}';
                    //$this->replace[] = date_i18n(wc_date_format(), strtotime($this->object->get_date_created()));
                    //$this->find[] = '{order_number}';
                    //$this->replace[] = $this->object->get_order_number();
                    $this->vendor_email = $vendor_email;
                    $this->vendor_id = $vendor_id;
                    $this->recipient = $vendor_email;

                    $this->placeholders['{order_date}']   = wc_format_datetime( $this->object->get_date_created() );
                    $this->placeholders['{order_number}'] = $this->object->get_order_number();

                }

                if (!$this->is_enabled() || !$this->get_recipient()) {
                    return;
                }

                $this->send($this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments());
            }
        }


	}

    /**
     * get_content_html function.
     *
     * @access public
     * @return string
     */
    function get_content_html() {
        return wc_get_template_html($this->template_html, array(
            'email_heading' => $this->get_heading(),
            'vendor_id' => $this->vendor_id,
            'order' => $this->object,
            'blogname' => $this->get_blogname(),
            'sent_to_admin' => false,
            'plain_text' => false,
            'show_prices' => false

        ),'',gpls_woo_rfq_plus_DIR . 'woocommerce/');
    }

    /**
     * get_content_plain function.
     *
     * @access public
     * @return string
     */
    function get_content_plain() {
        return wc_get_template_html($this->template_plain, array(
            'email_heading' => $this->get_heading(),
            'vendor_id' => $this->vendor_id,
            'order' => $this->object,
            'blogname' => $this->get_blogname(),
            'sent_to_admin' => false,
            'plain_text' => true,
            'show_prices' => false

        ),'',gpls_woo_rfq_plus_DIR . 'woocommerce/');
    }

    /**
     * Initialise Settings Form Fields
     *
     * @access public
     * @return void
     */
    function init_form_fields() {
        global $WCMp;
        $this->form_fields = array(
            'enabled' => array(
                'title' => __('Enable/Disable', 'rfqtk'),
                'type' => 'checkbox',
                'label' => __('Enable this email notification.', 'rfqtk'),
                'default' => 'yes'
            ),
            'subject' => array(
                'title' => __('Subject', 'rfqtk'),
                'type' => 'text',
                'description' => sprintf(__('This controls the email subject line. Leave it blank to use the default subject: <code>%s</code>.', 'rfqtk'), $this->subject),
                'placeholder' => '',
                'default' => ''
            ),
            'heading' => array(
                'title' => __('Email Heading', 'rfqtk'),
                'type' => 'text',
                'description' => sprintf(__('This controls the main heading contained within the email notification. Leave it blank to use the default heading: <code>%s</code>.', 'rfqtk'), $this->heading),
                'placeholder' => '',
                'default' => ''
            ),
            'email_type' => array(
                'title' => __('Email Type', 'rfqtk'),
                'type' => 'select',
                'description' => __('Choose which format of email to be sent.', 'rfqtk'),
                'default' => 'html',
                'class' => 'email_type',
                'options' => array(
                    'plain' => __('Plain Text', 'rfqtk'),
                    'html' => __('HTML', 'rfqtk'),
                    'multipart' => __('Multipart', 'rfqtk'),
                )
            )
        );
    }
}

endif;

return new WC_Email_Vendor_New_RFQ();
