<?php
if (!defined('ABSPATH'))
    exit;
/**
 * Main class
 *
 */
if (!class_exists('rfqtk_email_functions'))
{

    class rfqtk_email_functions
    {
        function __construct()
        {

        }
    }

    /**
     * @return array
     */
    function gpls_woo_rfq_plus_get_stock_product_priority()
    {

    }

    $change_order_status  = get_option('settings_gpls_woo_rfq_quote_request_change_order_status', 'no');

    if(isset($GLOBALS['GPLS_WOO_RFQ_PLUS']) && ($change_order_status) != "no") {

        add_action('woocommerce_order_status_changed', 'gplsrfq_change_quote_request_status', 100, 4);
    }

    function gplsrfq_change_quote_request_status($order_id, $from, $to, $order)
    {
        // $order = WC_Order_Factory::get_order($order_id);

        if (strcmp(trim($to), "gplsquote-req") != 0) {
            return;
        }

        $change_order_status  = get_option('settings_gpls_woo_rfq_quote_request_change_order_status', 'no');

        if($change_order_status != "no") {
            $my_post = array(
                'ID' => $order_id,
                'post_status' => $change_order_status,
            );
            wp_update_post($my_post);

            $notify = get_option('settings_gpls_woo_rfq_quote_request_change_order_status_notify','no');

            if($notify=='yes') {
                $np_email = null;

                switch ($change_order_status) {
                    case 'wc-pending':
                        $np_email = WC()->mailer()->emails['WC_Email_Customer_Invoice'];
                    case 'wc-processing':
                        $np_email = WC()->mailer()->emails['WC_Email_Customer_Processing_Order'];
                    case 'wc-completed':
                        $np_email = WC()->mailer()->emails['WC_Email_Customer_Processing_Order'];
                }

                if ($np_email) {

                    $np_email->trigger($order_id);


                }
            }
        }

// Update the post into the database

    }


   if(isset($GLOBALS['GPLS_WOO_RFQ_PLUS']) && (get_option('settings_gpls_woo_rfq_quote_request_change_order_status', 'no') == "no")) {
       add_action('woo_rfq_delay_quote_hours_event', 'gplsrfq_change_to_sent_old', 100, 3);

       add_action('woocommerce_order_status_changed', 'gplsrfq_change_to_sent', 100, 4);
   }

    function gplsrfq_change_to_sent($order_id, $from, $to, $order)
    {
        // $order = WC_Order_Factory::get_order($order_id);

        if (strcmp(trim($to), "gplsquote-req") != 0) {
            return;
        }

        $quote_sent = $order->get_meta('rfqtk_send_quote');

        if ($quote_sent == "yes") {
            return;
        }



        $convert = true;
        $total = floatval($order->get_total());
        $limit = (get_option('settings_gpls_woo_rfq_change_to_sent_limit', ""));

        if ($limit != '') {

            if ($total < floatval($limit)) {

                $message = __("Quote Request below limit for automatic send", "rfqtk");
                $order->add_order_note($message, 0, false);

                $convert = false;
            }

        }


        $convert = apply_filters('gplsrfq_change_to_sent_check', $convert, $order_id, $from, $to, $order);

        if (get_option('settings_gpls_woo_rfq_change_to_sent', "no") == 'yes' && $convert) {

            $delay = get_option('settings_gpls_woo_rfq_delay_quote_hours');

            if ($delay == "") {
                $delay = 0.1;
            }
            if (!wp_next_scheduled('woo_rfq_delay_quote_hours_event')) {
                $args = array($order_id, $from, $to);

                wp_schedule_single_event(time() + $delay * 60 * 60, 'woo_rfq_delay_quote_hours_event', $args);
            }
        }
    }


    function gplsrfq_change_to_sent_old($order_id, $from, $to)
    {
        $order = WC_Order_Factory::get_order($order_id);

        $quote_sent = $order->get_meta('rfqtk_send_quote');

        if ($quote_sent == "yes") {
            return;
        }

        $order = WC_Order_Factory::get_order($order_id);

        if (strcmp(trim($to), "gplsquote-req") != 0) {
            return;
        }

        $ends = gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key), 'D');
        if ($ends != 1) {
            // $order->update_status('wc-gplsquote-sent');
            $order->add_order_note(__("Order status changed from Quote Request to Quote Sent by NP Quote Plugin.", "rfqtk"), 0, false);
            // Update post 37
            $my_post = array(
                'ID' => $order_id,
                'post_status' => 'wc-gplsquote-sent',
            );


// Update the post into the database
            wp_update_post($my_post);

            sleep(1);

            //$mail= new WC_Email_Product_Marketing();
            $email = WC()->mailer()->emails['WC_Email_Customer_RFQ_Sent'];
            $mail = new WC_Email_Customer_RFQ_Sent();
            $mail->trigger($order_id);

            //$order->set_status('wc-gplsquote-sent');
            update_post_meta($order_id, 'rfqtk_send_quote', "yes");

            $message = __("Quote was sent automatically", "rfqtk");
            $order->add_order_note($message, 0, false);
        }
    }


    function gpls_woo_rfq_plus_email_confirmation_stock_messages($order, $sent_to_admin, $plain_text)
    {

        $status = $order->get_status();
        if($status != 'gplsquote-req' &&$status != 'wc-gplsquote-req'
            && $status != 'wc-gplsquote-sent' && $status != 'gplsquote-sent') {
            return;
        }

        $stock_email_confirmation_message = get_option('settings_gpls_woo_rfq_customer_confirmation_message', '');

        // echo '<br />'.$stock_email_confirmation_message ;

       // echo '<br />';
        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">' . $stock_email_confirmation_message, '</div>';
        //echo '<br />';


    }


    function gpls_woo_rfq_plus_email_confirmation_product_messages($order, $sent_to_admin, $plain_text)
    {
        $status = $order->get_status();
        if($status != 'gplsquote-req' &&$status != 'wc-gplsquote-req'
           && $status != 'wc-gplsquote-sent' && $status != 'gplsquote-sent') {
            return;
        }

        $items = $order->get_items();

        $message_array = array();

        foreach ($items as $item) {

            $_product = apply_filters('woocommerce_order_item_product', $item->get_product(), $item);

          //  $product_email_confirmation_message = get_post_meta($_product->get_id(), '_gpls_woo_rfq_plus_product_email_message', true);
        //    $product_email_confirmation_message = apply_filters('gpls_woo_rfq_plus_product_email_message',$product_email_confirmation_message, true);

            $product_email_confirmation_message = gpls_woo_plus_get_product_email_message($_product);

           // $show_product_email_confirmation_message = get_post_meta($_product->get_id(), '_gpls_woo_rfq_plus_show_product_email_message', true);

            $hashed_message = md5($product_email_confirmation_message);
            //echo $hashed_message;
            if (!isset($message_array[$hashed_message]))
            {
                //echo $product_email_confirmation_message;
                $message_array[$hashed_message] = array('_product' => $_product->get_id(), 'content' => $product_email_confirmation_message);
            }


        }

        foreach ($message_array as $key => $val) {


            echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">' . html_entity_decode($val['content']), '</div>';



        }

    }


    function gpls_woo_rfq_plus_thankyou_confirmation_stock_messages($order_id)
    {
        $order=wc_get_order($order_id);
        $status = $order->get_status();

        if($status != 'gplsquote-req' &&$status != 'wc-gplsquote-req'
            && $status != 'wc-gplsquote-sent' && $status != 'gplsquote-sent') {
            return;
        }

        $stock_email_confirmation_message = get_option('settings_gpls_woo_rfq_customer_confirmation_message', '');
     //   echo '<br />';
        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">' . $stock_email_confirmation_message, '</div>';
        //echo '<br />';

    }

    // add_action('woo_rfq_delay_marketing_content_hours_event', 'gplsrfq_send_product_marketing_content', 10, 1);

    function gpls_woo_rfq_plus_thankyou_confirmation_product_messages($order_id)
    {


        $of = new WC_Order_Factory();

        $order = $of::get_order($order_id);

        if (strcmp(trim($order->get_status()), 'gplsquote-req') != 0) {
            return;
        }

        $items = $order->get_items();

        $message_array = array();

        foreach ($items as $item) {

            $_product = apply_filters('woocommerce_order_item_product', $item->get_product(), $item);

          //  $product_email_confirmation_message = get_post_meta($_product->get_id(), '_gpls_woo_rfq_plus_product_email_message', true);
         //   $product_email_confirmation_message = apply_filters('gpls_woo_rfq_plus_product_email_message',$product_email_confirmation_message, true);

            $product_email_confirmation_message = gpls_woo_plus_get_product_email_message($_product);


          //  $show_product_email_confirmation_message = get_post_meta($_product->get_id(), '_gpls_woo_rfq_plus_show_product_email_message', true);

            $hashed_message = md5($product_email_confirmation_message);
            //echo $hashed_message;
            if (!isset($message_array[$hashed_message]))
            {
                //echo $product_email_confirmation_message;
                $message_array[$hashed_message] = array('_product' => $_product->get_id(), 'content' => $product_email_confirmation_message);
            }
        }

        foreach ($message_array as $key => $val) {

            echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">' . html_entity_decode($val['content']), '</div>';
          //  echo '<br />';
        }


    }

    function gpls_woo_rfq_plus_schedule_emails($order_id)
    {


        $delay = get_option('settings_gpls_woo_rfq_delay_product_marketing_hours');

        if ($delay == "") {
            $delay = 0.1;
        }


        if (!wp_next_scheduled('woo_rfq_delay_marketing_content_hours_event')) {

            $args = array($order_id);
            $cronx = wp_schedule_single_event(time() + ($delay) * 60 * 60, 'woo_rfq_delay_marketing_content_hours_event', $args);


        }

    }


    function gpls_woo_rfq_plus_schedule_emails_rfq($order_id, $posted_data, $order)
    {


        $delay = get_option('settings_gpls_woo_rfq_delay_product_marketing_hours');

        if ($delay == "") {
            $delay = 0.1;
        }


        if (!wp_next_scheduled('woo_rfq_delay_marketing_content_hours_event')) {


            $args = array($order_id);
            $cronx = wp_schedule_single_event(time() + ($delay) * 60 * 60, 'woo_rfq_delay_marketing_content_hours_event', $args);


        }

    }


    function gplsrfq_send_product_marketing_content($order_id)
    {


        $of = new WC_Order_Factory();

        $order = $of::get_order($order_id);



        if (strcmp(trim($order->get_status()), 'gplsquote-req') != 0) {
            return;
        }


        $items = $order->get_items();

        $message_array = array();

        foreach ($items as $item) {

            $_product = apply_filters('woocommerce_order_item_product', $item->get_product(), $item);

          //  $product_email_confirmation_message = get_post_meta($_product->get_id(), '_gpls_woo_rfq_plus_product_email_message', true);
          //  $product_email_confirmation_message = apply_filters('gpls_woo_rfq_plus_product_email_message',$product_email_confirmation_message, true);

            $product_email_confirmation_message = gpls_woo_plus_get_product_email_message($_product);

            //$show_product_email_confirmation_message = get_post_meta($_product->get_id(), '_gpls_woo_rfq_plus_show_product_email_message', true);

            $hashed_message = md5($product_email_confirmation_message);
            //echo $hashed_message;
            if (!isset($message_array[$hashed_message]) || $message_array[$hashed_message] == null)
            {
                //echo $product_email_confirmation_message;
                $message_array[$hashed_message] = array('_product' => $_product->get_id(), 'content' => $product_email_confirmation_message);
            }
        }

        foreach ($message_array as $key => $val) {

            //$args = array($order_id,$val['_product'], $val['content']);

            sleep(1);

            $args = array('order_id' => $order_id, '_product' => $val['_product'], 'prod_note' => html_entity_decode($val['content']));

            //$mail= new WC_Email_Product_Marketing();
            $email = WC()->mailer()->emails['WC_Email_Product_Marketing'];
            $mail = new WC_Email_Product_Marketing();
            $mail->trigger($args);

            $order->add_order_note(__("Product Information Sent to Customer by NP Quote Plugin.", "rfqtk"), 0, false);


        }
    }


    function gpls_woo_rfq_plus_email_order_meta_fields($fields, $sent_to_admin, $order)
    {
        $fields['meta_key'] = array(
            'label' => __('Label'),
            'value' => get_post_meta($order->get_id(), 'meta_key', true),
        );
        return $fields;
    }


    function gpls_woo_rfq_plus_customer_email_order_meta_display($order, $sent_to_admin, $plain_text)
    {

        $ninja_data = get_post_meta($order->get_id(), '_ninja_forms_fields', true);


        if ($ninja_data != null && is_array($ninja_data)) {
            // echo '<div  style="page-break-before: always; display:block;">';
            echo '<div  style="display:block;"><br /></div>';

            echo '<h2>' . __('Checkout Fields', 'rfqtk') . '</h2></div>';
            echo '<div style="float:left; ">';
            ?>


            <?php


            foreach ($ninja_data as $key) {
                echo '<strong>' . $key["label"] . '</strong><br />' . $key["value"] . '<br />';
            }
            echo '<br /></div>';
        }

        ?>


        <?php
        $notes = $order->get_customer_order_notes();
        if (count($notes) < 2) return;
        ?>
        <div style="page-break-before: always; "></div>
        <h3><?php echo __('Order Notes History', 'rfqtk') ?></h3>

        <?php
        foreach ($order->get_customer_order_notes() as $note) {
            printf('<span  style=" font-size:8pt ; color:grey"> %1$s at %2$s by %3$s</span>', date_i18n(wc_date_format(), strtotime($note->comment_date)), date_i18n(wc_time_format(), strtotime($note->comment_date)), $note->comment_author);
            echo '<div style="width: 75%; margin-bottom: 10px">' . $note->comment_content . '</div>';

        }


    }

    function gplsrfq_customer_note_response_link($order, $sent_to_admin, $plain_text, $email)
    {
        if ($email->id == "customer_note") {
            wc_get_template('woo-rfq/customer-note-email-respond-link.php',
                array('order' => $order), '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
        }
    }


    function gpls_woo_rfq_plus_email_order_meta_display($order, $sent_to_admin, $plain_text, $email)
    {

        //  ob_start();

        $include_customer_notes = get_option('settings_gpls_woo_rfq_quote_sent_email_customer_notes', 'yes');;

        $include_notes_offer = get_option('settings_gpls_woo_rfq_quote_sent_email_customer_offer', 'yes');;
        ?>


        <?php
        if ($include_customer_notes == 'yes') {
            echo '<div  style="page-break-before: always; "></div>';

            echo "<h4>" . __('Order Notes', 'rfqtk') . "</h4>";
            foreach ($order->get_customer_order_notes() as $note) {
                printf('<span  style=" font-size:8pt ; color:grey"> %1$s at %2$s by %3$s</span>', date_i18n(wc_date_format(), strtotime($note->comment_date)), date_i18n(wc_time_format(), strtotime($note->comment_date)), $note->comment_author);
                echo '<div style="width: 75%; margin-bottom: 10px">' . $note->comment_content . '</div>';

            }
        }

        if ($include_notes_offer == 'yes') {


            $customer_offer_text = __('Customer Bid', 'rfqtk');
            $customer_offer = get_post_meta($order->get_id(), '_woo_rfq_customer_bid', true);


            if (isset($customer_offer) && $customer_offer != '') {

                echo '<div  style="page-break-before: always;clear: both; margin-top:20px; height: 20px; display:block;"></div>';
                echo '<div  style="clear: both; margin-top:20px; display:block;"></div>';
                echo '<div ><h4>' . $customer_offer_text . ':' . wc_price(get_post_meta($order->get_id(), '_woo_rfq_customer_bid', true)) . '</h4></div>';
            }
        }

    }

    function gpls_woo_rfq_plus_show_email_prices($show_prices)
    {
        return true;
    }
}