<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WC_Email_Product_Marketing' ) ) :

/**
 * Product marketing Email.
 *
 * Product marketing emails are sent to customers.

 */
    #[\AllowDynamicProperties]
class WC_Email_Product_Marketing extends WC_Email {

	/**
	 * Customer note.
	 *
	 * @var string
	 */
	public $prod_note;
    public $_product;
    public $content_intro;
    public $email_type;

	/**
	 * Constructor.
	 */
	public function __construct() {


	    $this->id             = 'gpls_prod_marketing';
		$this->title          = __( 'RFQ-Toolkit Product Marketing', 'rfqtk' );
		$this->description    = __( 'Product Marketing emails are sent to to the customer after a customer asks for a quote request.', 'rfqtk' );

		$this->template_html  = 'emails/product-marketing.php';
		$this->template_plain = 'emails/plain/product-marketing.php';

        $this->placeholders   = array(
            '{order_date}'   => '',
            '{order_number}' => '',
            '{product_title}' => '',
        );

        $this->content_intro = $this->format_string($this->get_option( 'content_intro' ));
        $this->email_type='html';
		// Triggers

        if(!has_action('woocommerce_new_product_marketing_notification', array($this, 'trigger'))) {
            add_action('woocommerce_new_product_marketing_notification', array($this, 'trigger'));
        }

        add_filter('woocommerce_template_directory', array($this, 'gpls_rfq_woocommerce_locate_template_dir'), 10, 2);

        $this->customer_email = true;

		parent::__construct();


	}


    public function get_default_subject()
    {
        return __('Information about your request #({order_number}) from {site_title} on {order_date}', 'rfqtk');
    }



    public function gpls_rfq_woocommerce_locate_template_dir($dir, $template)
    {
        return $dir;
    }

    public function get_default_heading() {
        return __('{product_title} from {site_title}. Request #({order_number}) on {order_date}', 'rfqtk');
    }


	/**
	 * Trigger.
	 *
	 * @param array $args
	 */
	public function trigger( $args ) {


        $this->setup_locale();

	    if ( isset( $args ) ) {

			$defaults = array(
				'order_id'      => '',
				'prod_note' => '',
                '_product' => ''
			);

			$args = wp_parse_args( $args, $defaults );


			extract( $args );

            if(defined("WC_Email_Product_Marketing_Email".$order_id))return;
            define("WC_Email_Product_Marketing_Email".$order_id,true);

			if ( $order_id && ( $this->object = wc_get_order( $order_id ) ) ) {
                $this->recipient = $this->object->get_billing_email();
                $this->recipient .= ','.$this->get_option( 'recipient');

				$this->prod_note = $prod_note;
                $this->_product  = $_product;

                $product = wc_get_product($_product);

              //  $this->heading = __('{product_title} from {site_title}. Request #({order_number}) on {order_date}. ', 'rfqtk');

             //   $this->subject = __('{product_title} from {site_title}. Request #({order_number}) - {order_date}', 'rfqtk');

                $this->placeholders['{order_date}']   = wc_format_datetime( $this->object->get_date_created() );
                $this->placeholders['{product_title}'] = $product->get_title();
                $this->placeholders['{order_number}'] = $this->object->get_order_number();

                $order = WC_Order_Factory::get_order($order_id);

                $offer_subject='';



                if ( $this->is_enabled() && $this->get_recipient() ) {
                    $this->send( $this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments() );
                }

                $this->restore_locale();


			}
		}

	}

    function replace_placeholders($order_id)
    {

        if (defined("WC_Email_Product_Marketing_EMAIL" . $order_id)) return;

        define("WC_Email_Product_Marketing_EMAIL" . $order_id, true);

        require_once(WC()->plugin_path() . '/includes/emails/class-wc-email.php');
        require_once(WC()->plugin_path() . '/includes/class-wc-emails.php');
        $WC_Emails = WC_Emails::instance();


        $this->setup_locale();

        if ($order_id) {
            $this->object = wc_get_order($order_id);
            $this->recipient = $this->object->get_billing_email();

            $this->prod_note = $prod_note;
            $this->_product  = $_product;

            $product = wc_get_product($_product);

            $this->placeholders['{order_date}'] = wc_format_datetime($this->object->get_date_created());
            $this->placeholders['{order_number}'] = $this->object->get_order_number();

            $this->placeholders['{product_title}'] = $product->get_title();
        }

        $this->restore_locale();

    }

	/**
	 * Get content html.
	 *
	 * @access public
	 * @return string
	 */
	public function get_content_html() {
		return wc_get_template_html( $this->template_html, array(
			'order'         => $this->object,
			'email_heading' => $this->get_heading(),
            'additional_content' => is_callable(array($this, 'get_additional_content'))?$this->get_additional_content():"",
            'content_intro' => $this->content_intro,
            'prod_note' => $this->prod_note,
			'_product'  => $this->_product,
			'sent_to_admin' => false,
			'plain_text'    => false,
			'email'			=> $this
		),'',gpls_woo_rfq_plus_DIR . 'woocommerce/');
	}

	/**
	 * Get content plain.
	 *
	 * @access public
	 * @return string
	 */
	public function get_content_plain() {
		return wc_get_template_html( $this->template_plain, array(
			'order'         => $this->object,
			'email_heading' => $this->get_heading(),
            'additional_content' => is_callable(array($this, 'get_additional_content'))?$this->get_additional_content():"",
            'content_intro' => $this->content_intro,
            'prod_note' => $this->prod_note,
            '_product'  => $this->_product,
			'sent_to_admin' => false,
			'plain_text'    => true,
			'email'			=> $this
		),'',gpls_woo_rfq_plus_DIR . 'woocommerce/');
	}

    public function init_form_fields()
    {
        $placeholder_text  = sprintf( __( 'Available placeholders: %s', 'rfqtk' ), '<code>' . implode( '</code>, <code>', array_keys( $this->placeholders ) ) . '</code>' );

        $this->form_fields = array(
            'enabled' => array(
                'title' => __('Enable/Disable', 'rfqtk'),
                'type' => 'checkbox',
                'label' => __('Enable this email notification', 'rfqtk'),
                'default' => 'yes'
            ),

            'recipient'  => array(
                'title'       => __( 'Recipient(s)', 'rfqtk' ),
                'type'        => 'text',
                'description' => __( 'Enter additional recipients (comma separated) for this email. Customer is automatically included.', 'rfqtk' ) ,
                'placeholder' => '',
                'default'     => '',
                'desc_tip'    => true,
            ),

            'subject'            => array(
                'title'       => __( 'Subject', 'woocommerce' ),
                'type'        => 'text',
                'desc_tip'    => true,
                'css'         => 'width:600px;',
                'description' => $placeholder_text,
                'placeholder' => $this->get_default_subject(),
                'default'     => '',
            ),
            'heading'            => array(
                'title'       => __( 'Email heading', 'woocommerce' ),
                'type'        => 'text',
                'desc_tip'    => true,
                'css'         => 'width:600px;',
                'description' => $placeholder_text,
                'placeholder' => $this->get_default_heading(),
                'default'     => '',
            ),
            'content_intro' => array(
                'title' => __('Content Intro', 'rfqtk'),
                'type' => 'textarea',
                'description' => sprintf(__('This controls the first paragrah contained within the email notification.', 'rfqtk'), $this->heading),
                'placeholder' => __( 'N/A', 'rfqtk' ),
                'css'         => 'width:400px; height: 75px;',
                'default' => '',
                'desc_tip'    => true,

            ),
            'additional_content' => array(
                'title'       => __( 'Additional content', 'rfqtk' ),
                'description' => __( 'Text to appear below the main email content.', 'rfqtk' ),
                'css'         => 'width:400px; height: 75px;',
                'placeholder' => __( 'N/A', 'rfqtk' ),
                'type'        => 'textarea',
                'default'     => '',
                'desc_tip'    => true,
            ),
            'email_type' => array(
                'title' => __('Email type', 'rfqtk'),
                'type' => 'select',
                'description' => __('Choose which format of email to send.', 'rfqtk'),
                'default' => 'html',
                'class' => 'email_type wc-enhanced-select',
                'options' => $this->get_email_type_options()
            )
        );
    }


}

endif;
$GLOBALS['WC_Email_Product_Marketing']=new WC_Email_Product_Marketing();
return $GLOBALS['WC_Email_Product_Marketing'];
