<?php
if (!defined('ABSPATH'))
    exit;
/**
 * Main class
 *
 */
if (!class_exists('rfqtk_form_functions')) {

    class rfqtk_form_functions
    {

        function __construct()
        {
            if (!class_exists('Ninja_Forms')) {
                return;

            }


            $rfq_check = false;
            $normal_check = false;
            gpls_woo_rfq_get_mode($rfq_check, $normal_check);


            if (get_option('settings_gpls_woo_rfq_allow_custom_form', 'no') === 'yes') {

                if ($rfq_check)
                {

                    $ninja_form_position = get_option('settings_gpls_woo_rfq_ninja_form_position', '1');

                    switch ($ninja_form_position) {

                        case 1:
                            add_action('woocommerce_checkout_billing', 'gpls_woo_rfq_plus_display_ninja_form', -1000);
                            break;
                        case 2:
                            add_action('woocommerce_checkout_shipping', 'gpls_woo_rfq_plus_display_ninja_form', -1000);
                            break;
                        case 3:
                            add_action('woocommerce_checkout_order_review', 'gpls_woo_rfq_plus_display_ninja_form', -1000);
                            break;


                    }

                } else {

                    add_action('gpls_woo_rfq_cart_actions_ninja', 'gpls_woo_rfq_plus_display_request_page_ninja_form', 1);
                }

            }

            if (get_option('settings_gpls_woo_rfq_allow_custom_form_wc', 'no') === 'yes') {
                if ($normal_check)
                {

                    $ninja_form_position = get_option('settings_gpls_woo_rfq_ninja_form_position', '1');

                    switch ($ninja_form_position) {

                        case 1:
                            add_action('woocommerce_checkout_billing', 'gpls_woo_rfq_plus_display_ninja_form', -1000);

                            break;
                        case 2:
                            add_action('woocommerce_checkout_shipping', 'gpls_woo_rfq_plus_display_ninja_form', 1000);
                            break;
                        case 3:
                            add_action('woocommerce_checkout_order_review', 'gpls_woo_rfq_plus_display_ninja_form', -1000);
                            break;

                    }

                }
            }


           // if (!has_action('woocommerce_checkout_update_order_meta', 'gpls_woo_rfq_plus_save_ninja_form'))
            {
                add_action('woocommerce_checkout_update_order_meta', 'gpls_woo_rfq_plus_save_ninja_form', 1000, 2);
            }

            //if (!has_action('wp_load', 'gpls_woo_rfq_plus_save_ninja_form'))
             {
                add_action('wp_load', 'gpls_woo_rfq_plus_save_ninja_form', 100, 2);
            }

            //if (!isset($_REQUEST['respond_to_offer']))
            {
             //  add_action('woocommerce_view_order', 'rfqtk_display_ninja_in_thanky_you_view_order', 999);
             //  add_action('woocommerce_thankyou', 'rfqtk_display_ninja_in_thanky_you_view_order', 1000);
            }

        }

    }


    function gpls_woo_rfq_plus_display_request_page_ninja_form()
    {



         wc_get_template('woo-rfq/form/form-normal.php',array()
             ,'', gpls_woo_rfq_plus_DIR . 'woocommerce/');

    }

    function gpls_woo_rfq_plus_display_ninja_form($checkout)
    {

        $customField = false;
        $specific_gateway = 'gpls-rfq';

        global $woocommerce;

        WC()->initialize_session();

        $chosen_method = WC()->session->get( 'chosen_payment_method' );
        /* we do not need gateway objects, only keys */


        if( $chosen_method == $specific_gateway ) {
            $customField=true;
        }


        $checkout_option=get_option('settings_gpls_woo_rfq_checkout_option');

        $allow_other_options=get_option('settings_gpls_woo_rfq_plus_normal_checkout');

        $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

        $items = WC()->cart->get_cart();

        $has_rfq = false;

        foreach ($items as $item => $values) {


            $_product = wc_get_product($values['product_id']);

           // $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
           // $rfq_enable = apply_filters('gpls_rfq_enable',$rfq_enable,$_product->get_id());

            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);




            if ($rfq_enable === 'yes' ) {
                $has_rfq = true;
                break;
            }
        }


        if ($checkout_option === "rfq" && $allow_other_options === "yes"
            && $settings_gpls_woo_rfq_limit_to_rfq_only === "yes" && $has_rfq == true) {

            if ( !is_admin() ) {
                $customField=true;
            }

        }

        if ($checkout_option === "rfq" && $allow_other_options === "no") {

            if ( !is_admin() ) {
                $customField=true;
            }

        }



        if ($checkout_option === "rfq" ) {

            if ( !is_admin() ) {
                $customField=true;
            }
        }



        if( !$customField && get_option('rfq_cart_sc_section_nf_rfq_only')==="no")
        {
            wc_get_template('woo-rfq/form/form-rfq.php',array(),'',gpls_woo_rfq_plus_DIR . 'woocommerce/');
        }

        if( $customField) {
            wc_get_template('woo-rfq/form/form-rfq.php',array(),'',gpls_woo_rfq_plus_DIR . 'woocommerce/');
        }



    }


    function gpls_woo_rfq_plus_save_ninja_form($order_id, $data)
    {
        if (isset($_POST)) {
            if (function_exists('Ninja_Forms')) {
                $formid = get_option('settings_gpls_woo_ninja_form_option', '');

                $forms = Ninja_Forms();

                if (!isset($forms)) return;

                gpls_woo_rfq_plus_save_ninja30_version($order_id, $formid);
            }
        }
    }

    function gpls_woo_rfq_plus_save_ninja30_version($order_id, $formid)
    {


        if (function_exists('Ninja_Forms')) {

            $form = Ninja_Forms()->form($formid);
            do_action('gpls_woo_ninja_form_start', $order_id, $form);

            if (!isset($form) || !$form) return;

            if (!isset($_POST['rfq_formvalue'])) return;

            $rfq_formvalue = explode('[&&]', $_POST['rfq_formvalue']);


            $rfq_formvalue_1 = array();

            foreach ($rfq_formvalue as $value) {

                array_push($rfq_formvalue_1, explode('[::]', $value));
            }

            array_reverse($rfq_formvalue_1);

            $ninja_fields = array();

            foreach ($rfq_formvalue_1 as $value) {

                if (gpls_woo_rfq_plus_startsWith($value[0], 'nf-field-')) {

                    $value_arr = explode("-", $value[0]);

                    $field_id = -1;

                    foreach ($value_arr as $chunk) {

                        if (is_numeric($chunk) && floor($chunk) == $chunk) {

                            $field_id = $chunk;
                            $value[0] = $field_id;
                            break;
                        }
                    }

                    if ($field_id == -1) {
                        continue;
                    }

                    $form_field = Ninja_Forms()->form($formid)->get_field($field_id);

                    $label = $form_field->get_setting('label');

                    $value[2] = $label;

                    array_push($ninja_fields, $value);
                }
            }

            array_reverse($ninja_fields);

            do_action('gpls_woo_ninja_fields_array', $order_id, $form, $ninja_fields);

            $meta_data_array = array();


            foreach ($ninja_fields as $value) {

                $meta_data_array_element = array('key' => $value[0], 'label' => esc_html($value[2]), 'value' => esc_html($value[1]));

                array_push($meta_data_array, $meta_data_array_element);

            }

            $meta_data_array = apply_filters('ninja_form_meta_data_array', $meta_data_array, $ninja_fields);

            do_action('before_ninja_fields_update_post_meta', $order_id, $form, $meta_data_array, $ninja_fields);

            update_post_meta($order_id, '_ninja_forms_fields', $meta_data_array);
            $order = wc_get_order($order_id);
            $order->save();

            do_action('after_ninja_fields_update_post_meta', $order_id, $form, $meta_data_array, $ninja_fields);


        }
    }


    function rfqtk_display_ninja_in_admin($order)
    {
        $ends=gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key),'D');
        if ($ends==1) {
            return;
        }
        rfqtk_display_ninja_in_ninja30_admin($order);
    }





}