<?php
/*
Plugin Name: NP Quote Request WooCommerce Plus
Description: NP Quote Request WooCommerce Plus adds many features and functionalities to the free version of NP WooCommerce Quote Request.
Version: 1.7.11
Contributors: Neah Plugins
Author: Neah Plugins
Author URI: http://www.neahplugins.com/
Donate link: http://www.neahplugins.com/
Requires at least: 6.0
Tested up to: 6.2
WC tested up to: 7.5.1
Text Domain: rfqtk
Domain Path: /languages/
Copyright: � 2017-2020 Neah Plugins.
License: GNU General Public License v2.0
License URI: http://www.gnu.org/licenses/gpl-2.0.html
*/

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

function gpls_woo_rfq_plus_admin_notice_nobasic()
{
    ?>
    <div id="message" class="error">
        <h3 class="error"><?php _e('NP Quote Request WooCommerce Plus requires <a href="https://downloads.wordpress.org/plugin/woo-rfq-for-woocommerce.latest-stable.zip?utm_source=home&utm_medium=button_2&utm_campaign=Download+Button" >NP Quote Request WooCommerce Free Version.</a>', 'rfqtk'); ?></h3>
    </div>
    <?php
}


if (!defined('gpls_woo_rfq_plus_DIR')) {
    DEFINE('gpls_woo_rfq_plus_DIR', plugin_dir_path(__FILE__));
    DEFINE('gpls_woo_rfq_plus_URL', plugin_dir_url(__FILE__));
    DEFINE('gpls_woo_rfq_plus_FILE_NAME', (__FILE__));
    DEFINE('gpls_woo_rfq_plus_PLUGIN_PATH', untrailingslashit(plugin_basename(__FILE__)));
    DEFINE('gpls_woo_rfq_plus_TEMPLATE_PATH', untrailingslashit(plugin_dir_path(__FILE__)) . '/templates/');
    DEFINE('gpls_woo_rfq_plus_WOO_PATH', untrailingslashit(plugin_dir_path(__FILE__)) . '/woocommerce/');
    DEFINE('gpls_woo_rfq_plus_AME_DATA_KEY', 'RFQ_ToolKit_Plus');
    DEFINE('gpls_woo_rfq_plus_License_URL', plugins_url('/', __FILE__));
}

if (!is_admin()) {
    if (!function_exists('gpls_woo_rfq_get_item')) {
        require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
        require_once(ABSPATH . 'wp-includes/class-phpass.php');
    }
}

if (!function_exists('gpls_woo_rfq_check_base_correct_info_plus')) {
    function gpls_woo_rfq_check_base_correct_info_plus()
    {
        $plugin_data = get_plugin_data(WP_PLUGIN_DIR . '/woo-rfq-for-woocommerce/woo-rfq-for-woocommerce.php');
        $version1 = $plugin_data['Version'];

        ?>
        <?php if (version_compare($version1, '1.8.270') == -1): ?>

        <div id="message" class="error" style="font-size: larger;font-weight: bold;color: red">
            <p>Please upgrade NP Quote Request WooCommerce to version 1.8.270 from <a target="_blank"
                                                                                      href="https://wordpress.org/plugins/woo-rfq-for-woocommerce/">here</a>
                to ensure compatibility with the NP Quote Request WooCommerce Plus plugin.</p>
        </div>


    <?php endif; ?>
        <?php

    }

}
require_once(ABSPATH . 'wp-admin/includes/plugin.php');

//if (is_plugin_active('woo-rfq-for-woocommerce/woo-rfq-for-woocommerce.php'))
{

    // add_action('admin_notices', 'gpls_woo_rfq_check_base_correct_info_plus', 100);


}


/*if (!function_exists('gpls_woo_rfq_get_item')) {
    require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
    require_once(ABSPATH . 'wp-includes/class-phpass.php');
}*/

require_once(plugin_dir_path(__FILE__) . '/woo-rfq-includes/woo-rfq-functions.php');

if (rfqtk_first2()) {
    return;
}


/**
 * Required functions
 */


//add_action('plugins_loaded','gpls_woo_rfq_plus_activate',1000);


if (!function_exists('gpls_woo_rfq_plus_admin_notice_nolicense')) {

    function gpls_woo_rfq_plus_admin_notice_nolicense()
    {
        if (isset($_GET['page']) && 'wc_api_manager_rfqtk_plus_dashboard' == $_GET['page'])
            return; ?>
        <div id="message" class="error" style="font-size: larger;font-weight: bold;color: red">
            <p><?php printf(__('NP Quote Request WooCommerce Plus License Key has not been activated. %sClick here%s to activate the license key to restore full functionality.', 'rfqtk'), '<a href="' . esc_url(admin_url('options-general.php?page=wc_api_manager_rfqtk_plus_dashboard')) . '">', '</a>'); ?></p>
        </div>
        <?php
    }
}


add_action('plugins_loaded', 'GPLS_WOO_RFQ_PLUS', 1000);

GPLS_WOO_RFQ_PLUS();

function GPLS_WOO_RFQ_PLUS()
{
    return GPLS_WOO_RFQ_PLUS::instance();

}


class GPLS_WOO_RFQ_PLUS
{

    public $upgrade_url = 'https://www.neahplugins.com/'; // URL to access the Update API Manager.

    /**
     * @var string
     */
    public $version = '1.7.11';

    /**
     * @var string
     * This version is saved after an upgrade to compare this db version to $version
     */
    public $api_manager_version_name = 'RFQ_ToolKit_Plus_Version';

    /**
     * @var string
     */
    public $plugin_url = gpls_woo_rfq_plus_License_URL;


    public $text_domain = 'rfqtk';

    /**
     * Data defaults
     * @var mixed
     */
    public $ame_software_product_id;

    public $ame_data_key = 'RFQ_ToolKit_Plus';
    public $ame_api_key = 'api_key';
    public $ame_activation_email = 'activation_email';
    public $ame_product_id_key;
    public $ame_instance_key = 'api_manager_rfqtk_plus_instance';
    public $ame_deactivate_checkbox_key;
    public $ame_activated_key = 'api_manager_rfqtk_plus_activated';

    public $ame_deactivate_checkbox;
    public $ame_activation_tab_key;
    public $ame_deactivation_tab_key;
    public $ame_settings_menu_title;
    public $ame_settings_title;
    public $ame_menu_tab_activation_title;
    public $ame_menu_tab_deactivation_title;

    public $ame_options;
    public $ame_plugin_name;
    public $ame_product_id;
    public $ame_renew_license_url;
    public $ame_instance_id;
    public $ame_domain;
    public $ame_software_version;
    public $ame_plugin_or_theme;

    public $ame_update_version;

    public $ame_update_check = 'rfq_toolkit_plus_update_check';

    public $api_manager_key;

    /**
     * Used to send any extra information.
     * @var mixed array, object, string, etc.
     */
    public $ame_extra;
    public $isvalid = true;
    protected static $_instance = null;

    public static function instance()
    {

        if (is_null(self::$_instance))
            self::$_instance = new self();

        return $GLOBALS['GPLS_WOO_RFQ_PLUS'] = self::$_instance;


    }


    public function __construct()
    {


        //$this->gpls_woo_rfq_plus_setup_constants();
        $this->setup_email();
        $this->gpls_woo_rfq_plus_setup_includes();

        if (is_admin()) {
            // $this->license_init();

            if (!has_action('wp_loaded', array($this, 'license_init'))) {
                add_action('wp_loaded', array($this, 'license_init'), 1000);
            }

        }


        // if (!has_action('init', array($this, 'gpls_woo_rfq_plus_wp_init')))
        {
            add_action('init', array($this, 'gpls_woo_rfq_plus_wp_init'), 100);
            add_filter('plugin_row_meta', array(__CLASS__, 'plugin_row_meta'), 10, 2);
        }


        if (get_option($this->ame_activated_key) !== 'Activated') {

            //  add_action('admin_notices', 'GPLS_WOO_RFQ_PLUS::inactive_notice');
            add_action('admin_notices', 'gpls_woo_rfq_plus_admin_notice_nolicense', 1);
        }


        if (!is_admin()) {
            //   if (!has_action('plugins_loaded', array($this, 'gpls_woo_rfq_fields_init')))
            {
                add_action('plugins_loaded', array($this, 'gpls_woo_rfq_fields_init'), 10000);

            }
        } else {
            // if (!has_action('wp_loaded', array($this, 'gpls_woo_rfq_fields_init')))
            {
                add_action('wp_loaded', array($this, 'gpls_woo_rfq_fields_init'), 10000);
            }
        }

        //if (!has_action('plugins_loaded', array($this, 'gpls_woo_rfq_plus_plugins_loaded')))
        {
            add_action('plugins_loaded', array($this, 'gpls_woo_rfq_plus_plugins_loaded'), 100000);
        }

        //  if (!has_action('admin_head', array($this, 'gpls_woo_rfq_plus_enqueue_admin_css')))
        {
            add_action('admin_head', array($this, 'gpls_woo_rfq_plus_enqueue_admin_css'));
        }
        //  if (!has_action('admin_enqueue_scripts', array($this, 'gpls_woo_rfq_plus_enqueue_admin_scripts')))
        {
            add_action('admin_enqueue_scripts', array($this, 'gpls_woo_rfq_plus_enqueue_admin_scripts'), 1000);
        }

        // if (!has_action('wp_loaded', array($this, 'gpls_woo_rfq_plus_wp_loaded')))
        {
            add_action('wp_loaded', array($this, 'gpls_woo_rfq_plus_wp_loaded'), 100000);
        }


        //  if (!has_action('wc_order_statuses', array($this, 'gpls_rfq_add_quote_request_to_order_statuses')))
        {
            add_filter('wc_order_statuses', array($this, 'gpls_rfq_add_quote_request_to_order_statuses'), 1000, 1);
        }

        // if (!has_action('woocommerce_after_dashboard_status_widget', array($this, 'gpls_rfq_add_to_status_widget')))
        {
            add_action('woocommerce_after_dashboard_status_widget', array($this, 'gpls_rfq_add_to_status_widget'), 100, 1);
        }


        add_action('init', array($this, 'gpls_woo_rfq_setup_customer_cookie'), 1000);

        $this->gpls_woo_rfq_load_plus_textdomain();

        if (!has_action('init', array($this, 'gpls_woo_rfq_return_widget'))) {
            add_action('init', array($this, 'gpls_woo_rfq_return_widget'), 1);
        }


        add_shortcode('gpls_woo_rfq_get_customer_response', array($this, 'gpls_woo_rfq_get_customer_response_action'));
        add_action("gpls_rfq_add_to_quote_qty_action", array($this, 'gpls_rfq_add_to_quote_qty'), 100, 6);


    }


    public function gpls_rfq_add_to_quote_qty($rfq_id, $gpls_woo_rfq_file_add_to_quote_styles, $product, $request_quote, $data_var, $rfq_check)
    {

        $template = get_option("gpls_rfq_add_to_quote_qty_template", 1);

        if ($template == 1) {
            wc_get_template('woo-rfq/add-to-quote-qty.php',
                array('rfq_id' => $rfq_id,
                    'product' => $product,
                    'rfq_check' => $rfq_check,
                    'data_var' => $data_var,
                    'request_quote' => $request_quote,
                    'gpls_woo_rfq_file_add_to_quote_styles' => $gpls_woo_rfq_file_add_to_quote_styles,
                ), '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
        } else {
            wc_get_template('woo-rfq/add-to-quote-qty-onerow.php',
                array('rfq_id' => $rfq_id,
                    'product' => $product,
                    'rfq_check' => $rfq_check,
                    'data_var' => $data_var,
                    'request_quote' => $request_quote,
                    'gpls_woo_rfq_file_add_to_quote_styles' => $gpls_woo_rfq_file_add_to_quote_styles,
                ), '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
        }


    }

    public function gpls_woo_rfq_get_customer_response_action()
    {
        global $woocommerce;

        if (is_admin() || $woocommerce == null) {
            return '';
        }

        $of = new WC_Order_Factory();
        $order = $of::get_order($_REQUEST['id']);
        $order_id = $_REQUEST['id'];

        $use_page = get_option('settings_gpls_woo_rfq_customer_note_text_page', 'no');

        if ($use_page == "yes") {
            ob_start();
            wc_get_template('woo-rfq/customer-respond.php', array('order' => $order), '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
            return ob_get_clean();
        }

    }


    public function gpls_woo_rfq_return_widget()
    {


        error_reporting(0);
        ini_set('display_errors', 'Off');


        if (isset($_GET['rfq_widget'])) {

            wc_get_template('woo-rfq/mini-rfq-cart.php', array()
                , '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
            // die;
            //echo mt_rand(10,100000);
            die();
        }
    }


    public function gpls_woo_rfq_setup_customer_cookie()
    {


        if (!is_admin()) {

            require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
            require_once(ABSPATH . 'wp-includes/class-phpass.php');

            add_filter('_rfqtk_wp_session_expiration_variant', array($this, 'gpls_woo_rfq_set_expiration_time'));
            add_filter('_rfqtk_wp_session_expiration', array($this, 'gpls_woo_rfq_set_expiration_variant_time'));

        }


    }


    public function gpls_woo_rfq_set_expiration_variant_time($exp)
    {
        return RFQTK_WP_SESSION_EXPIRATION_VARIANT;
    }


    public function gpls_woo_rfq_set_expiration_time($exp)
    {
        return RFQTK_WP_SESSION_EXPIRATION;
    }


    public function gpls_woo_rfq_plus_wp_init()
    {


        // $this->setup_email();
        $status_label = get_option('settings_gpls_woo_rfq_quote_sent_label', 'Quotes Sent');
        $status_label = __($status_label, 'rfqtk');

        if ($status_label == '') {
            $status_label = __('Quotes Sent', 'rfqtk');
        }

        register_post_status('wc-gplsquote-sent', array(
            'label' => $status_label,
            'public' => true,
            'exclude_from_search' => false,
            'show_in_admin_all_list' => true,
            'show_in_admin_status_list' => true,
            'label_count' => _n_noop($status_label . '<span class="count">(%s)</span>', $status_label . ' <span class="count">(%s)</span>')
        ));


        $status_label = get_option('settings_gpls_woo_rfq_quote_request_label', 'Quote Requests');
        $status_label = __($status_label, 'rfqtk');

        if ($status_label == '') {
            $status_label = __('Quote Requests', 'rfqtk');
        }

        register_post_status('wc-gplsquote-req', array(
            'label' => $status_label,
            'public' => true,
            'exclude_from_search' => false,
            'show_in_admin_all_list' => true,
            'show_in_admin_status_list' => true,
            'label_count' => _n_noop($status_label . '<span class="count">(%s)</span>', $status_label . ' <span class="count">(%s)</span>')
        ));

        add_filter('woocommerce_valid_order_statuses_for_payment', 'gpls_woo_rfq_valid_order_statuses_for_payment', 100, 2);

        $show_prices = get_option('settings_gpls_woo_rfq_show_prices_customer_confirmation_email', 'no');

        if ($show_prices == 'yes') {

            add_filter('gpls_woo_rfq_show_prices_customer_email', 'gpls_woo_rfq_plus_show_email_prices');

        }

        $gpls_4woo_quote_current_url = preg_replace('{/$}', '', gpls_woo_rfq_remove_http(get_site_url() . $_SERVER['REQUEST_URI']));

        $link_to_rfq_page = preg_replace('{/$}', '', gpls_woo_rfq_remove_http(pls_woo_rfq_get_link_to_rfq()));

        if (trim(substr(trim($gpls_4woo_quote_current_url), 0, strlen($link_to_rfq_page))) == trim($link_to_rfq_page) && isset($_REQUEST['order_id'])) {


            add_filter('woocommerce_is_order_received_page', array($this, 'gpls_rfq_woocommerce_is_order_received_page'), 100, 1);

        }


        $checkout_option = "";
        $purchase_or_quote = false;

        if (isset($GLOBALS["gpls_woo_rfq_checkout_option"])) {
            $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];
        }

        $in_role = true;

        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
        if ($roles === '') {
            $enable_roles = 'no';
        }

        if ($enable_roles != "no" && !is_user_logged_in()) {
            $in_role = false;
        }

        if ($enable_roles != "no" && is_user_logged_in()) {

            $in_role = false;

            $user = wp_get_current_user();

            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;

                }
            }

            $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);
            // $in_role=apply_filters('rfqtk_is_in_role',$in_role,$user);

        }


        if ($checkout_option == 'rfq' && $in_role == true
            && get_option('settings_gpls_woo_rfq_plus_normal_checkout', 'no') == 'yes'
            && (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'yes'
                || get_option('settings_gpls_woo_rfq_show_prices_everywhere', 'no') == 'yes')
        ) {
            $purchase_or_quote = true;
        }


        $limit_by_role = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
        if ($roles === '') {
            $limit_by_role = 'no';
        }

        //if ($purchase_or_quote == false && $limit_by_role == "others_purchase_only") {
        if ($purchase_or_quote == false && $limit_by_role == "others_purchase_only") {

            if (!is_admin()) {

                remove_action("woocommerce_add_to_cart", "gpls_woo_rfq_woocommerce_add_to_cart", PHP_INT_MAX - 1, 6);

                remove_filter('woocommerce_product_single_add_to_cart_text', array($GLOBALS["gpls_woo_rfq_cart"], 'woo_custom_cart_button_text'), 100, 2);
                remove_filter('woocommerce_product_add_to_cart_text', array($GLOBALS["gpls_woo_rfq_cart"], 'woo_custom_cart_button_text'), 100, 2);
                remove_filter('woocommerce_loop_add_to_cart_link', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_add_to_cart_link_shop'), -1000, 2);
                remove_action('woocommerce_after_add_to_cart_button', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_add_to_cart_button'), 1000);
                remove_action('woocommerce_before_add_to_cart_button', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_before_add_to_cart_button'), 1000);

                // remove_action('woocommerce_after_shop_loop_item', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_after_shop_loop_item'), 100);

                $hook = get_option('settings_gpls_woo_rfq_normal_checkout_quote_position', 'woocommerce_after_shop_loop_item');

                remove_action($hook, array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_after_shop_loop_item'), 100);

                remove_filter('woocommerce_cart_item_remove_link', 'gpls_woo_rfq_cart_item_remove_link', 100, 2);
                remove_action("woocommerce_after_cart", array($GLOBALS["gpls_woo_rfq_cart"], "gpls_woo_rfq_woocommerce_after_cart"), 1000);
                remove_action("woocommerce_after_cart_totals", array($GLOBALS["gpls_woo_rfq_cart"], "gpls_woo_rfq_woocommerce_after_cart"), 1000);
                remove_filter('woocommerce_product_add_to_cart_text', 'gpls_woo_rfqtk_woo_custom_cart_button_text', 2000, 2);
                remove_filter('woocommerce_product_single_add_to_cart_text', 'gpls_woo_rfqtk_woo_custom_cart_button_text', 2000, 2);

                gpls_woo_rfq_woocommerce_RFQTK_only_add_to_cart();

                if (isset($GLOBALS['GPLS_WOO_RFQ'])) {
                    remove_action('wp_enqueue_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_scripts'), 2000);
                    remove_action('wp_print_footer_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_footer_scripts'), 2000);
                }
            }

        }

        $this->setup_gateway();

        require_once(gpls_woo_rfq_plus_DIR . 'includes/emails/customer-confirm.php');

        $GLOBALS["class_customer_confirmations_rfq_plus"] = new class_customer_confirmations_rfq_plus();

        add_action('woo_rfq_delay_marketing_content_hours_event', 'gplsrfq_send_product_marketing_content', 10, 1);

        $send = get_option('gpls_woo_rfq_email_product_marketing_emails', 'no');

        if ($send == "yes") {

            //do_action( 'woocommerce_checkout_order_processed', $order_id, $posted_data, $order );
            if ($checkout_option == 'rfq') {
                //add_action('woocommerce_thankyou', 'gpls_woo_rfq_plus_schedule_emails', 10, 1);
                add_action('woocommerce_checkout_order_processed', 'gpls_woo_rfq_plus_schedule_emails_rfq', 10, 3);

            } else {
                add_action('gpls_woo_rfq_after_normal_checkout', 'gpls_woo_rfq_plus_schedule_emails', 10, 1);

                //$order_id, $posted_data, $order
            }
        }


        add_filter('woocommerce_default_address_fields', 'gpls_woo_rfq_plus_filter_address_fields', 1000, 1);

        add_filter('woocommerce_checkout_fields', 'gpls_woo_rfq_plus_Woo_checkout', 1000, 1);

        add_filter('woocommerce_billing_fields', 'gpls_woo_rfq_plus_remove_billing_phone_field', 20, 1);

        add_filter('woocommerce_shipping_fields', 'gpls_woo_rfq_plus_remove_shipping_phone_field', 20, 1);


        add_action('wp_footer', 'gpls_woo_rfq_plus_remove_field_on_change');

        do_action('rfqtk_plus_wp_init');


        //  add_action('gpls_woo_rfq_after_normal_checkout', 'gpls_woo_rfq_after_normal_checkout_function', 1);


        //   add_action('template_redirect', 'gpls_woo_rfq_redirect_after_quote_submit');


        if (is_admin()) {
            require_once(gpls_woo_rfq_plus_DIR . 'includes/admin/privacy/gpls_woo_rfq_plus_privacy.php');
        }

    }

    public function gpls_rfq_woocommerce_is_order_received_page($is_order_received)
    {

        return true;
    }


    public function gpls_rfq_add_to_status_widget($reports)
    {
        if (!current_user_can('edit_shop_orders')) {
            return;
        }
        $quote_request_count = 0;
        $quote_request_label = get_option('settings_gpls_woo_rfq_quote_request_label', 'Quote Requests');
        $quote_request_label = __($quote_request_label, 'rfqtk');

        if ($quote_request_label == '') {
            $quote_request_label = __('Quote Requests', 'rfqtk');
        }

        $quote_sent_count = 0;
        $quote_sent_label = get_option('settings_gpls_woo_rfq_quote_sent_label', 'Quotes Sent');
        $quote_sent_label = __($quote_sent_label, 'rfqtk');

        if ($quote_sent_label == '') {
            $quote_sent_label = __('Quotes Sent', 'rfqtk');
        }


        foreach (wc_get_order_types('order-count') as $type) {
            $counts = (array)wp_count_posts($type);
            $quote_request_count += isset($counts['wc-gplsquote-req']) ? $counts['wc-gplsquote-req'] : 0;
            $quote_sent_count += isset($counts['wc-gplsquote-sent']) ? $counts['wc-gplsquote-sent'] : 0;
        }
        ?>
        <li class="gplsquote-sent">
            <a href="<?php echo admin_url('edit.php?post_status=wc-gplsquote-sent&post_type=shop_order'); ?>">
                <?php
                /* translators: %s: order count */
                printf(
                    _n('<strong>%s order</strong> ' . $quote_sent_label, '<strong>%s orders</strong> ' . $quote_sent_label, $quote_sent_count, 'rfqtk'),
                    $quote_sent_count
                );
                ?>
            </a>
        </li>
        <li class="gplsquote-req">
            <a href="<?php echo admin_url('edit.php?post_status=wc-gplsquote-req&post_type=shop_order'); ?>">
                <?php
                /* translators: %s: order count */
                printf(
                    _n('<strong>%s order</strong> ' . $quote_request_label, '<strong>%s orders</strong> ' . $quote_request_label, $quote_request_count, 'rfqtk'),
                    $quote_request_count
                );
                ?>
            </a>
        </li>
        <?php
    }


    // Add to list of WC Order statuses
    public function gpls_rfq_add_quote_request_to_order_statuses($order_statuses)
    {
        $status_label = get_option('settings_gpls_woo_rfq_quote_sent_label', 'Quotes Sent');
        $status_label = __($status_label, 'rfqtk');

        if ($status_label == '') {
            $status_label = __('Quotes Sent', 'rfqtk');
        }

        $order_statuses["wc-gplsquote-sent"] = $status_label;


        $status_label = get_option('settings_gpls_woo_rfq_quote_request_label', 'Quote Request');
        $status_label = __($status_label, 'rfqtk');

        if ($status_label == '') {
            $status_label = __('Quote Request', 'rfqtk');
        }

        $order_statuses["wc-gplsquote-req"] = $status_label;

        // $order_statuses = array_reverse($order_statuses, True);

        return $order_statuses;
    }


    public function gpls_woo_rfq_plus_wp_loaded()
    {

        //add_filter('gpls_woo_rfq_add_to_quote_styles', 'gpls_woo_rfq_add_to_quote_create_styles', 1000, 1);
        if (function_exists('is_cart') && function_exists('is_checkout')) {
            if (is_cart() || is_checkout()) {
                if (!is_admin()) {

                    $hide_shipping = get_option('settings_gpls_woo_rfq_hide_shipping', 'no');

                    if ($hide_shipping === 'yes') {

                        if (!is_admin()) {

                            add_filter('woocommerce_shipping_rate_cost', 'rftk_shipping_rate_cost', 100, 2);
                            add_filter('woocommerce_shipping_rate_taxes', 'rftk_shipping_rate_taxes', 100, 2);

                        }

                    }

                }
            }
        }


        $this->gpls_woo_upgrade_routines();

    }

    public function gpls_woo_upgrade_routines()
    {
        global $wpdb;

        delete_option('settings_gpls_woo_rfq_sessions_table_fixed_rfq1', 'yes');
        delete_option('settings_gpls_woo_rfq_sessions_notable_fix21z', 'yes');
        $table_fixed = get_option('settings_gpls_woo_rfq_sessions_notable_fix2100z', 'no');

        if ($table_fixed == 'no') {

            wp_clear_scheduled_hook('rfqtk_wp_session_daily_garbage_collection');
            update_option('settings_gpls_woo_rfq_sessions_notable_fix2100z', 'yes');

        }
    }

    public function gpls_woo_rfq_fields_init()
    {

        //add_action('plugins_loaded', array($this, 'gpls_woo_rfq_load_plus_textdomain'));

        $this->gpls_woo_rfq_plus_setup_includes();


        if (!is_admin()) {
            $this->gpls_woo_rfq_plus_css_js();
        }

        // $this->setup_gateway();

        $plugin = plugin_basename(__FILE__);

        add_filter("plugin_action_links_$plugin", array($this, 'rfqtk_plugin_settings_link'));

        // $this->gpls_woo_rfq_plus_settings();
    }


    public function gpls_woo_rfq_plus_deactivation()
    {
        // actions to perform once on plugin deactivation go here

    }

    public function gpls_woo_rfq_plus_uninstall()
    {

        //actions to perform once on plugin uninstall go here

        // $this->uninstall();

    }

    public function rfqtk_plugin_settings_link($links)
    {
        if (!defined('setting_link_set')) {
            ////  DEFINE('setting_link_set', true);
            $settings_link = admin_url('admin.php?page=wc-settings&tab=settings_gpls_woo_rfq&section=');
            $settings_link = '<a href="' . $settings_link . '">Settings</a>';
            array_unshift($links, $settings_link);

        }
        return $links;
    }

    public function setup_gateway()
    {
        require_once(gpls_woo_rfq_plus_DIR . 'includes/gateway/rfqtk-gateway.php');
        $GLOBALS["wc_gateway_frq_plus"] = new WC_Gateway_RFQ_Plus();

    }

    public function gpls_woo_rfq_plus_settings()
    {

        if (is_admin()) {
            require_once(gpls_woo_rfq_plus_DIR . 'includes/admin/rfqtk_admin.php');
            gpls_woo_rfq_plus_Admin::init();
        }

    }

    public function gpls_woo_rfq_load_plus_textdomain()
    {
        load_plugin_textdomain('rfqtk', false, dirname(plugin_basename(__FILE__)) . '/languages/');

    }

    public static function plugin_row_meta($links, $file)
    {
        if (gpls_woo_rfq_plus_PLUGIN_PATH === $file) {
            $row_meta = array(
                'trial' => '<a href="' . esc_url('https://www.neahplugins.com/product/rfq-toolkit-plus/') . '" aria-label="' . esc_attr__('Product Page', 'rfqtk') . '">' . esc_html__('Home', 'rfqtk') . '</a>',
                'Support' => '<a href="' . esc_url('https://www.neahplugins.com/contact/') . '" aria-label="' . esc_attr__('Support', 'rfqtk') . '">' . esc_html__('Support', 'rfqtk') . '</a>',
            );

            return array_merge($links, $row_meta);
        }

        return (array)$links;
    }


    public function gpls_woo_rfq_plus_setup_includes()
    {

        if (class_exists('GPLS_WOO_RFQ')) {
            //return;

            if (!function_exists('gpls_woo_rfq_get_item')) {
                require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
                require_once(ABSPATH . 'wp-includes/class-phpass.php');
            }


            require_once(gpls_woo_rfq_plus_DIR . 'includes/rfqtk_functions.php');
            $gpls_woo_rfq_plus_functions = new gpls_woo_rfq_plus_functions();


            require_once(gpls_woo_rfq_plus_DIR . 'includes/form/form_functions.php');
            $GLOBALS["rfqtk_form_functions"] = new rfqtk_form_functions();


            require_once(gpls_woo_rfq_plus_DIR . 'includes/stock/stock_functions.php');
            $GLOBALS["rfqtk_stock_functions"] = new rfqtk_stock_functions();

            require_once(gpls_woo_rfq_plus_DIR . 'includes/notes/notes_functions.php');
            $GLOBALS["rfqtk_notes_functions"] = new rfqtk_notes_functions();

            //   require_once(gpls_woo_rfq_plus_DIR . 'includes/emails/customer-confirm.php');
            //    $GLOBALS["class_customer_confirmations_rfq_plus"] = new class_customer_confirmations_rfq_plus();

            require_once(gpls_woo_rfq_plus_DIR . 'includes/emails/email_functions.php');
            $GLOBALS["rfqtk_email_functions"] = new rfqtk_email_functions();

            require_once(gpls_woo_rfq_plus_DIR . 'includes/rfq_page/class-rfq-page-plus.php');
            $GLOBALS["class_rfq_page_plus"] = new class_rfq_page_plus();

            require_once(gpls_woo_rfq_plus_DIR . 'includes/offer/offer_functions.php');
            $GLOBALS["rfqtk_offer_functions"] = new rfqtk_offer_functions();

            if (class_exists('GPLS_WOO_RFQ')) {
                require_once(gpls_woo_rfq_plus_DIR . 'includes/rfq_page/class-rfq_page-plus-widget.php');
                $rfq_page_plus_Widget = new rfq_page_plus_Widget();
            }

        }
    }

    public function gpls_woo_rfq_plus_email_confirm_includes()
    {

    }


    public function gpls_woo_rfq_plus_plugins_loaded()
    {

        if (!class_exists('GPLS_WOO_RFQ')) {

            add_action('admin_notices', 'gpls_woo_rfq_plus_admin_notice_nobasic');
            return;

        }

        $this->gpls_woo_rfq_plus_settings();
        $this->setup_email();
        // if (class_exists('GPLS_WOO_RFQ'))
        {
            require_once(gpls_woo_rfq_plus_DIR . 'includes/rfq_page/class-rfq_page-plus-widget.php');
            $rfq_page_plus_Widget = new rfq_page_plus_Widget();
        }


    }

    public function gpls_woo_rfq_plus_enqueue_admin_css()
    {
        if (is_admin()) {
            $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk_admin.css';
            $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk_admin.css';
            wp_enqueue_style('gpls_woo_rfq_plus_css_admin', $url_css, array(), rand(10, 100000));

            $url_css = gpls_woo_rfq_plus_URL . 'assets/chosen/chosen.min.css';
            $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/chosen/chosen.min.css';
            wp_enqueue_style('rfqtk_chosen_css', $url_css, array(), rand(10, 100000));

        }
    }

    public function gpls_woo_rfq_plus_enqueue_admin_scripts($hook_suffix)
    {


        if (is_admin()) {

            $gpls_woo_rfq_plus_admin_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk_admin.js';
            $gpls_woo_rfq_plus_admin_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk_admin.js';
            wp_enqueue_script('gpls_woo_rfq_plus_admin_js', $gpls_woo_rfq_plus_admin_js, array('jquery', 'wp-color-picker'), rand(10, 100000), true);

            $gpls_woo_rfq_plus_chosen = gpls_woo_rfq_plus_URL . 'assets/chosen/chosen.jquery.min.js';
            $gpls_woo_rfq_plus_chosen_path = gpls_woo_rfq_plus_DIR . 'assets/chosen/chosen.jquery.min.js';
            wp_enqueue_script('chosen_js', $gpls_woo_rfq_plus_chosen, array('jquery'), rand(10, 100000), true);

        }
    }


    public function gpls_woo_rfq_plus_enqueue_scripts()
    {

        try {
            if (!is_admin()) {


                if (function_exists('is_product')) {
                    // if (is_product() == true )
                    {
                        $url_js = rfqtk_redirect_after_add_quote_script();
                    }
                }


                if (function_exists('is_cart') && function_exists('is_checkout')) {
                    if (is_cart() || is_checkout()) {
                        if (!is_admin()) {
                            $hide_shipping = get_option('settings_gpls_woo_rfq_hide_shipping', 'no');

                            if ($hide_shipping === 'yes') {

                                //if (!is_admin())
                                {
                                    add_filter('woocommerce_shipping_rate_cost', 'rftk_shipping_rate_cost', 100, 2);
                                    add_filter('woocommerce_shipping_rate_taxes', 'rftk_shipping_rate_taxes', 100, 2);

                                }

                            }
                        }
                    }
                }

                // $hide_0=get_option('rfq_cart_sc_section_hide_o_oo','no');

                /* if ($hide_0=="yes")
                 {
                     $url_js = gpls_woo_rfq_plus_URL . 'assets/js/hide_o.js';
                     $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/hide_o.js';
                     wp_enqueue_script('hide_o_js', $url_js, array('jquery'), rand(10, 100000), true);
                 }*/

                $is_quote_page = false;

                //$GLOBALS["gpls_4woo_quote_current_url"] = preg_replace('{/$}', '', $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
                $gpls_4woo_quote_current_url = preg_replace('{/$}', '', gpls_woo_rfq_remove_http(get_site_url() . $_SERVER['REQUEST_URI']));
                // $GLOBALS["gpls_4woo_quote_current_url"] = preg_replace('{/$}', '', $http_host . $_SERVER['REQUEST_URI']);
                $link_to_rfq_page = preg_replace('{/$}', '', gpls_woo_rfq_remove_http(pls_woo_rfq_get_link_to_rfq()));

                if (trim(substr(trim($gpls_4woo_quote_current_url), 0, strlen($link_to_rfq_page))) == trim($link_to_rfq_page)) {
                    $is_quote_page = true;

                }

                global $wp_query;
                $is_checkout = false;
                if (isset($wp_query)) {
                    if (is_checkout()) {
                        $is_checkout = true;
                    }
                }

                if ($is_quote_page == true) {
                    $is_checkout = true;
                }

                if ($is_checkout == true) {
                    $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk_checkout_form.js';
                    $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk_checkout_form.js';
                    wp_enqueue_script('gpls_woo_rfq_plus_checkout_form_js', $url_js, array('jquery'), rand(10, 100000), true);
                }


                $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk.css';
                $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk.css';
                wp_enqueue_style('gpls_woo_rfq_plus_css', $url_css, array(), rand(10, 100000));

                $list = 'enqueued';


                $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk.js';
                $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk.js';
                wp_enqueue_script('gpls_woo_rfq_plus_js', $url_js, array('jquery'), rand(10, 100000), true);


                if (get_option('settings_gpls_woo_rfq_show_notes', 'yes') === "yes") {

                    $url_rfqtk_notes = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk_notes.css';
                    wp_enqueue_style('gpls_rfqtk_notes', $url_rfqtk_notes, array(), rand(10, 100000));
                }


                $custom_js = "";
                $custom_css = "";

                //  rftk_header_css();
                //note begin rftk_header_css

                $hide_shipping = get_option('settings_gpls_woo_rfq_hide_shipping', 'no');

                if ($hide_shipping === 'yes') {


                    if (function_exists('is_account_page')) {
                        if (is_account_page()) return;
                    }

                    if (!function_exists('WC')) return false;

                    WC()->initialize_session();

                    if (!WC()->cart) return false;

                    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');


                    if ((isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

                        if ($hide_all == 'yes') {

                            foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

                                $product = $cart_item['data'];



                                $rfq_enable = gpls_woo_plus_get_rfq_enable($product);



                                if ($rfq_enable == 'yes') {

                                    $custom_js = "jQuery( '.wapf-pricing-hint' ).attr('style','display: none !important');
                    jQuery( '.wapf-product-totals' ).attr('style','display: none !important');
                    jQuery( '.woocommerce-shipping-totals' ).attr('style','display: none !important');
                    jQuery( '.shipping' ).attr('style','display: none !important');jQuery( '.shipping' ).hide();
                    jQuery( '.cart_totals' ).attr('style','display: none !important');jQuery( '.cart_totals' ).hide();
                     jQuery( '.tax-rate' ).attr('style','display: none !important');jQuery( '.tax-rate' ).hide();
                    
                    
                                ";

                                    if ($custom_js != "") {
                                        wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);
                                    }

                                    $custom_css = ".tm-custom-price-totals,.woocommerce-shipping-totals ,.shipping {display:none !important;},
                    .wapf-product-totals{display: none !important;}.wapf-pricing-hint{display:none !important;}
                    .cart_totals{display: none !important;}.tax-rate{display: none !important;}";

                                    wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);

                                    break;
                                    //return;

                                }


                            }


                        } else {

                            $custom_js = "jQuery( '.woocommerce-shipping-totals' ).attr('style','display: none !important')
                                ";

                            if ($custom_js != "") {
                                wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);
                            }

                            $custom_css = ".woocommerce-shipping-totals {display:none !important;}";

                            wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);

                        }
                    }
                }

                //note end

                gpls_woo_rfq_hide_shipping_prices_css();


                if ($is_quote_page == true) {


                    if (get_option('rfq_cart_sc_section_support_for_ultimate', 'no') === "yes") {

                        $url_js_addons_ultimate = gpls_woo_rfq_plus_URL . 'assets/js/addons_ultimate.js';
                        wp_enqueue_script('addons_ultimate_js', $url_js_addons_ultimate, array('jquery'), rand(10, 100000), true);

                        $url_addons_ultimate_css = gpls_woo_rfq_plus_URL . 'assets/css/addons_ultimate.css';
                        wp_enqueue_style('gpls_addons_ultimate_css', $url_addons_ultimate_css, array(), rand(10, 100000));


                    }

                    if (get_option('rfq_cart_sc_section_support_for_wapf', 'no') === "yes") {

                        $url_js_wapf = gpls_woo_rfq_plus_URL . 'assets/js/wapf.js';
                        wp_enqueue_script('gpls_wapf_js', $url_js_wapf, array('jquery'), rand(10, 100000), true);

                        $url_wapf_css = gpls_woo_rfq_plus_URL . 'assets/css/wapf.css';
                        wp_enqueue_style('gpls_wapf_css', $url_wapf_css, array(), rand(10, 100000));
                    }


                    if ($GLOBALS["gpls_woo_rfq_show_prices"] == "yes") {
                        $custom_js =
                            "jQuery(document ).ready( function() { jQuery( '.tm-custom-price-totals' ).show();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt' ).show();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2, .xcp-ctotal .amount,.xcp-totxt,.wc-pao-subtotal-line' ).show();} );";
                    } else {
                        $custom_js = "jQuery(document ).ready( function() { jQuery( '.tm-custom-price-totals').hide();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt' ).hide();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt,.wc-pao-subtotal-line' ).hide();});";
                    }


                    if ($GLOBALS["gpls_woo_rfq_show_prices"] == "yes") {
                        $custom_css = ".tm-custom-price-totals ,.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt' ).show();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt,.wc-pao-subtotal-line {display:block !important;}";
                    } else {
                        $custom_css = ".tm-custom-price-totals ,.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt' ).hide();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt,.wc-pao-subtotal-line {display:none !important;}";
                    }


                    $custom_js = apply_filters('gpls_woo_rfq_plus_custom_js', $custom_js);

                    if ($custom_js != "") {
                        wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);
                    }

                    $custom_css = apply_filters("gpls_woo_rfq_plus_custom_css", $custom_css);

                    wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);
                }

                $addons_ultimate_hide = get_option('rfq_cart_sc_section_hide_prices_for_ultimate', 'no');


                if (($GLOBALS["gpls_woo_rfq_show_prices"] == "no" || $addons_ultimate_hide == 'yes') && is_product()) {

                    global $product;

                    $temp_price = "";
                    if (!is_object($product) && !function_exists('wc_get_product')) return;

                    if (!is_object($product)) {
                        $product = wc_get_product(get_the_ID());
                    }

                    if (!isset($product) || !is_object($product)) {
                        return;
                    }


                    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                        $temp_price = "no";
                    }
                    if (is_account_page()) $temp_price = "no";;

                    // $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
                    //  $hide_price = apply_filters('gpls_hide_product_price',$hide_price, $product->get_id());

                    $hide_price = gpls_woo_plus_get_hide_price($product);

                    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');


                    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


                    if ($rfq_enable == "no") {
                        $hide_all = "no";
                    }

                    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $product->get_id());

                    $in_role = true;
                    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

                    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
                    if ($roles === '') {
                        $enable_roles = 'no';
                    }

                    if ($enable_roles == "purchase") {
                        $in_role = false;
                        $user = wp_get_current_user();
                        $user_roles = $user->roles;

                        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

                        $option_value_list = explode(',', $eligible_roles);

                        foreach ($user_roles as $cat_id) {

                            if (in_array(trim($cat_id), $option_value_list)) {
                                $in_role = true;
                            }
                        }

                        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

                    }


                    if ($in_role == false || $hide_price == 'yes'
                        || ($hide_all === 'yes' && $rfq_enable === 'yes') || ($rfq_enable == 'yes')
                        || ($addons_ultimate_hide === 'yes' && $rfq_enable === 'yes')) {

                        $temp_price = 'yes';
                    }


                    global $wp_query;

                    if (isset($wp_query)) {
                        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

                            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

                            if ($hide_cart_checkout == "yes") {
                                if (function_exists('is_checkout')) {
                                    if (is_checkout() || is_cart()) {
                                        $temp_price = 'yes';
                                    }
                                }
                            }
                        }
                    }

                    if (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] === "rfq") {


                        if (get_option('settings_gpls_woo_rfq_show_prices', 'no') === 'no' || $addons_ultimate_hide === 'yes') {

                            $temp_price = 'yes';

                        }
                    }

                    if (function_exists('wp_get_current_user')) {
                        if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') === 'yes' && !wp_get_current_user()->exists()) {

                            $temp_price = 'yes';

                        }
                    }

                    $temp_price = apply_filters('gpls_woo_rfq_get_price', $temp_price, $product, $rfq_enable);

                    if ($temp_price === 'yes') {


                        if (get_option('rfq_cart_sc_section_support_for_ultimate', 'no') === "yes") {

                            $url_js_addons_ultimate = gpls_woo_rfq_plus_URL . 'assets/js/addons_ultimate.js';
                            wp_enqueue_script('addons_ultimate_js', $url_js_addons_ultimate, array('jquery'), rand(10, 100000), true);

                            $url_addons_ultimate_css = gpls_woo_rfq_plus_URL . 'assets/css/addons_ultimate.css';
                            wp_enqueue_style('gpls_addons_ultimate_css', $url_addons_ultimate_css, array(), rand(10, 100000));


                        }

                        if (get_option('rfq_cart_sc_section_support_for_wapf', 'no') === "yes") {

                            $url_js_wapf = gpls_woo_rfq_plus_URL . 'assets/js/wapf.js';
                            wp_enqueue_script('gpls_wapf_js', $url_js_wapf, array('jquery'), rand(10, 100000), true);

                            $url_wapf_css = gpls_woo_rfq_plus_URL . 'assets/css/wapf.css';
                            wp_enqueue_style('gpls_wapf_css', $url_wapf_css, array(), rand(10, 100000));
                        }

                    }

                }

                if (function_exists('is_cart') && function_exists('is_checkout')) {
                    if ($GLOBALS["gpls_woo_rfq_show_prices"] == "no" && (is_cart() || is_checkout())) {


                        if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                            $temp_price = "no";
                        }

                        $in_role = true;
                        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

                        $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
                        if ($roles === '') {
                            $enable_roles = 'no';
                        }

                        if ($enable_roles == "purchase") {
                            $in_role = false;

                            $user = wp_get_current_user();
                            $user_roles = $user->roles;

                            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

                            $option_value_list = explode(',', $eligible_roles);

                            foreach ($user_roles as $cat_id) {

                                if (in_array(trim($cat_id), $option_value_list)) {
                                    $in_role = true;
                                }
                            }

                            $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

                        }


                        if ($in_role == false) {

                            $temp_price = 'yes';
                        }


                        global $wp_query;

                        if (isset($wp_query)) {
                            if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

                                $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

                                if ($hide_cart_checkout == "yes") {
                                    if (function_exists('is_checkout')) {
                                        if (is_checkout() || is_cart()) {
                                            $temp_price = 'yes';
                                        }
                                    }
                                }
                            }
                        }

                        if (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] === "rfq") {


                            if (get_option('settings_gpls_woo_rfq_show_prices', 'no') === 'no') {

                                $temp_price = 'yes';

                            }
                        }
                        if (function_exists('wp_get_current_user')) {
                            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') === 'yes' && !wp_get_current_user()->exists()) {

                                $temp_price = 'yes';

                            }
                        }
                        $addons_ultimate_hide = get_option('rfq_cart_sc_section_hide_prices_for_ultimate', 'no');

                        if ($in_role == false || $addons_ultimate_hide == 'yes') {

                            $temp_price = 'yes';
                        }


                        if ($temp_price == 'yes') {


                            if (get_option('rfq_cart_sc_section_support_for_ultimate', 'no') === "yes") {

                                $url_js_addons_ultimate = gpls_woo_rfq_plus_URL . 'assets/js/addons_ultimate.js';
                                wp_enqueue_script('addons_ultimate_js', $url_js_addons_ultimate, array('jquery'), rand(10, 100000), true);

                                $url_addons_ultimate_css = gpls_woo_rfq_plus_URL . 'assets/css/addons_ultimate.css';
                                wp_enqueue_style('gpls_addons_ultimate_css', $url_addons_ultimate_css, array(), rand(10, 100000));


                            }

                            if (get_option('rfq_cart_sc_section_support_for_wapf', 'no') === "yes") {

                                $url_js_wapf = gpls_woo_rfq_plus_URL . 'assets/js/wapf.js';
                                wp_enqueue_script('gpls_wapf_js', $url_js_wapf, array('jquery'), rand(10, 100000), true);

                                $url_wapf_css = gpls_woo_rfq_plus_URL . 'assets/css/wapf.css';
                                wp_enqueue_style('gpls_wapf_css', $url_wapf_css, array(), rand(10, 100000));
                            }


                        }

                    }
                }

                if (is_view_order_page()) {

                    global $wp;

                    $order = wc_get_order($wp->query_vars['view-order']);

                    if ($order->get_status() == "gplsquote-req") {

                        if (get_option('rfq_cart_sc_section_support_for_ultimate', 'no') === "yes") {

                            $url_js_addons_ultimate = gpls_woo_rfq_plus_URL . 'assets/js/addons_ultimate.js';
                            wp_enqueue_script('addons_ultimate_js', $url_js_addons_ultimate, array('jquery'), rand(10, 100000), true);

                            $url_addons_ultimate_css = gpls_woo_rfq_plus_URL . 'assets/css/addons_ultimate.css';
                            wp_enqueue_style('gpls_addons_ultimate_css', $url_addons_ultimate_css, array(), rand(10, 100000));


                        }

                        if (get_option('rfq_cart_sc_section_support_for_wapf', 'no') === "yes") {

                            $url_js_wapf = gpls_woo_rfq_plus_URL . 'assets/js/wapf.js';
                            wp_enqueue_script('gpls_wapf_js', $url_js_wapf, array('jquery'), rand(10, 100000), true);

                            $url_wapf_css = gpls_woo_rfq_plus_URL . 'assets/css/wapf.css';
                            wp_enqueue_style('gpls_wapf_css', $url_wapf_css, array(), rand(10, 100000));
                        }


                    }
                }


                $qp_upload = get_option("settings_gpls_woo_rfq_remove_update_cart_in_rfq_cart", "no");

                if ($qp_upload == "yes") {

                    $url_qp_upload_css = gpls_woo_rfq_plus_URL . 'assets/css/qp_upload.css';
                    $url_qp_upload_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/qp_upload.css';
                    wp_enqueue_style('gpls_woo_rfq_qp_upload_css', $url_qp_upload_css, array(), rand(10, 100000));

                    $url_qp_upload_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk_qp_upload.js';
                    $url_qp_upload_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk_qp_upload.js';
                    wp_enqueue_script('gpls_woo_rfq_qp_upload_js', $url_qp_upload_js, array('jquery'), rand(10, 100000), true);

                }


                /*$hide_quote = get_option("settings_gpls_woo_rfq_hide_quote_cart", "no");

                if ($hide_quote === "yes") {

                   //note  $url_js = gpls_woo_rfq_plus_URL . 'assets/js/plus_widget.js';
                   // $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/plus_widget.js';
                   // wp_enqueue_script('plus_widget_js', $url_js, array('jquery'), rand(10, 100000), true);

                }


                $align_quote = get_option("settings_gpls_woo_rfq_align_quote_cart", "yes");


                if ($align_quote === "right") {
                    $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk.css';
                    $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk.css';
                    wp_enqueue_style('gpls_woo_rfq_plus_css', $url_css, array(), rand(10, 100000));
                    $custom_css = ".rfq_page_plus_Widget  {float:right !important;}";
                    wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);
                } else {
                    $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk.css';
                    $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk.css';
                    wp_enqueue_style('gpls_woo_rfq_plus_css', $url_css, array(), rand(10, 100000));
                    $custom_css = ".rfq_page_plus_Widget  {float:left !important;}";
                    wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);
                }*/


            }
        } catch (Exception $ex) {
            np_write_log($ex, __FILE__, __LINE__);
        }

    }


    public function gpls_woo_rfq_plus_css_js()
    {
        if (!is_admin()) {

            add_action('wp_enqueue_scripts', array($this, 'gpls_woo_rfq_plus_enqueue_scripts'), 1000);
        }
    }


    public function gpls_woo_rfq_plus_no_price_enqueue_scripts()
    {

    }


    public function setup_email()
    {
        require_once(gpls_woo_rfq_plus_DIR . 'includes/emails/rfqtk-email.php');
        // $wc_email_rfq_plus = new WC_Email_RFQ_PLUS();

    }

    function footer_action()
    {


    }


//license

    public function plugin_url()
    {

        return $this->plugin_url = gpls_woo_rfq_plus_License_URL;
    }


    /**
     * Deactivates the license on the API server
     * @return void
     */
    public function license_key_deactivation()
    {
        //update_option('api_manager_rfqtk_plus_activated', 'no');

        $activation_status = get_option($this->ame_activated_key);

        $api_email = $this->ame_options[$this->ame_activation_email];
        $api_key = $this->ame_options[$this->ame_api_key];

        $args = array(
            'email' => $api_email,
            'licence_key' => $api_key,
            'api_key' => $api_key,

        );


        //if ($activation_status == 'Activated' && $api_key != '' && $api_email != '') {

        if ($api_key != '' && $api_email != '') {

            $this->api_manager_key = new Api_Manager_Woo_RFQ_Key();
            $this->api_manager_key->deactivate($args); // reset license key activation
        }


        //ini_set('display_errors', 0);


    }

    /**
     * Displays an inactive notice when the software is inactive.
     */
    public static function inactive_notice()
    { ?>
        <?php if (!current_user_can('manage_options')) return; ?>
        <?php if (isset($_GET['page']) && 'wc_api_manager_rfqtk_plus_dashboard' == $_GET['page']) return; ?>
        <div id="message" class="error">
            <p><?php printf(__('NP Quote Request WooCommerce Plus License Key has not been activated. %sClick here%s to activate the license key for automatic updates and full functionality.', 'rfqtk'), '<a href="' . esc_url(admin_url('options-general.php?page=wc_api_manager_rfqtk_plus_dashboard')) . '">', '</a>'); ?></p>
        </div>
        <?php
    }

    public function license_init()
    {

        $this->ame_software_product_id = 'RFQ_ToolKit_Plus';

        /**
         * Set all data defaults here
         */
        $this->ame_data_key = 'RFQ_ToolKit_Plus';
        $this->ame_api_key = 'api_key';
        $this->ame_activation_email = 'activation_email';
        $this->ame_product_id_key = 'RFQ_ToolKit_Plus';
        $this->ame_product_id = 'RFQ_ToolKit_Plus';
        $this->ame_instance_key = 'api_manager_rfqtk_plus_instance';
        $this->ame_deactivate_checkbox_key = 'api_manager_rfqtk_plus_deactivate_checkbox';
        $this->ame_activated_key = 'api_manager_rfqtk_plus_activated';

        /**
         * Set all admin menu data
         */
        $this->ame_deactivate_checkbox = 'api_manager_deactivate_checkbox';
        $this->ame_activation_tab_key = 'wc_api_manager_rfqtk_plus_dashboard';
        $this->ame_deactivation_tab_key = 'api_manager_deactivation';
        $this->ame_settings_menu_title = 'RFQ ToolKit Plus';
        $this->ame_settings_title = 'RFQ_ToolKit_Plus';
        $this->ame_menu_tab_activation_title = __('License Activation', 'rfqtk');
        $this->ame_menu_tab_deactivation_title = __('License Deactivation', 'rfqtk');

        /**
         * Set all software update data here
         */
        $this->ame_options = get_option($this->ame_data_key);
        $this->ame_plugin_name = gpls_woo_rfq_plus_PLUGIN_PATH; // same as plugin slug. if a theme use a theme name like 'twentyeleven'
        //$this->ame_product_id = get_option($this->ame_product_id_key); // Software Title
        $this->ame_renew_license_url = 'https://www.neahplugins.com/my-account'; // URL to renew a license
        $this->ame_instance_id = get_option($this->ame_instance_key); // Instance ID (unique to each blog activation)
        $this->ame_domain = site_url(); // blog domain name
        $this->ame_software_version = $this->version; // The software version
        $this->ame_plugin_or_theme = 'plugin'; // 'theme' or 'plugin'

        // Performs activations and deactivations of API License Keys
        require_once(gpls_woo_rfq_plus_DIR . 'includes/am/classes/class-wc-key-api.php');
        $this->api_manager_key = new Api_Manager_Woo_RFQ_Key();

        // Checks for software updatess
        require_once(gpls_woo_rfq_plus_DIR . 'includes/am/classes/class-wc-plugin-update.php');

        // Admin menu with the license key and license email form
        require_once(gpls_woo_rfq_plus_DIR . 'includes/am/admin/class-wc-api-manager-menu.php');

        //$API_Manager_RFQ_MENU = new API_Manager_RFQ_MENU();


        $options = get_option($this->ame_data_key);

        /**
         * Check for software updates
         */
        if (isset($options) && $options !== false) {

            $API_Manager_Woo_RFQ_Update_API_Check = new API_Manager_Woo_RFQ_Update_API_Check(
                $this->upgrade_url,
                $this->ame_plugin_name,
                $this->ame_product_id,
                $this->ame_options[$this->ame_api_key],
                $this->ame_options[$this->ame_activation_email],
                $this->ame_renew_license_url,
                $this->ame_instance_id,
                $this->ame_domain,
                $this->ame_software_version,
                $this->ame_plugin_or_theme,
                $this->text_domain
            );

            //$API_Manager_Woo_RFQ_Update_API_Check->check_license();


        }

    }

    /**
     * @return void
     */


    /**
     * @return string
     */


}

register_activation_hook(__FILE__, 'rfqtk_activation');

function rfqtk_activation()
{
    $this_plugin = GPLS_WOO_RFQ_PLUS::instance();

    /*  global $wpdb;

      $global_options = array(
          $this_plugin->ame_api_key => '',
          $this_plugin->ame_activation_email => '',
      );

      update_option($this_plugin->ame_data_key, $global_options);

      require_once(gpls_woo_rfq_plus_DIR . 'includes/am/classes/class-wc-api-manager-passwords.php');

      $api_manager_Password_Management = new API_Manager_Woo_RFQ_Password_Management();

      // Generate a unique installation $instance id
      $instance = $api_manager_Password_Management->generate_password(12, false);

      $activation_status = get_option($this_plugin->ame_activated_key);

      if ($activation_status == false || $activation_status == null) {
          $single_options = array(
              $this_plugin->ame_product_id_key => $this_plugin->ame_software_product_id,
              $this_plugin->ame_instance_key => $instance,
              $this_plugin->ame_deactivate_checkbox_key => __('on', 'rfqtk'),
              $this_plugin->ame_activated_key => __('Deactivated', 'rfqtk'),
          );
      } else {
          $single_options = array(
              $this_plugin->ame_product_id_key => $this_plugin->ame_software_product_id,
              $this_plugin->ame_instance_key => $instance,
              $this_plugin->ame_deactivate_checkbox_key => __('on', 'rfqtk'),
              //   $this->ame_activated_key => __('Deactivated', 'rfqtk'),
          );
      }

      foreach ($single_options as $key => $value) {
          update_option($key, $value);
      }
      */

    $curr_ver = get_option($this_plugin->api_manager_version_name);

    // checks if the current plugin version is lower than the version being installed
    if (version_compare($this_plugin->version, $curr_ver, '>')) {
        // update the version
        update_option($this_plugin->api_manager_version_name, $this_plugin->version);
    }

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

    global $wpdb;
    $wpdb_collate = $wpdb->collate;
    $charset = $wpdb->charset;

    $str = "CREATE TABLE IF NOT EXISTS {$wpdb->base_prefix}npxyz2021_sessions (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET {$charset} COLLATE {$wpdb_collate} NOT NULL,
  `option_value` longtext CHARACTER SET {$charset} COLLATE {$wpdb_collate} NOT NULL,
  `expiration` bigint(20) NOT NULL,
  `misc_value` longtext CHARACTER SET {$charset} COLLATE {$wpdb_collate},
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated` timestamp NOT NULL DEFAULT 0,
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET={$charset} COLLATE={$wpdb_collate};";

    $wpdb->query($str);

}


//register_deactivation_hook(__FILE__, 'rfqtk_uninstall');

register_uninstall_hook(__FILE__, 'rfqtk_uninstall');

function rfqtk_uninstall()
{


    $this_plugin = GPLS_WOO_RFQ_PLUS::instance();
    //update_option('api_manager_rfqtk_plus_activated', 'no');
    //ini_set('display_errors', 0);

    global $wpdb, $blog_id;


    $this_plugin->license_key_deactivation();

    // Remove options
    if (is_multisite()) {

        switch_to_blog($blog_id);

        foreach (array(
                     $this_plugin->ame_data_key,
                     $this_plugin->ame_product_id_key,
                     $this_plugin->ame_instance_key,
                     $this_plugin->ame_deactivate_checkbox_key,
                     $this_plugin->ame_activated_key,
                 ) as $option) {

            delete_option($option);
        }

        restore_current_blog();

    } else {

        foreach (array(
                     $this_plugin->ame_data_key,
                     $this_plugin->ame_product_id_key,
                     $this_plugin->ame_instance_key,
                     $this_plugin->ame_deactivate_checkbox_key,
                     $this_plugin->ame_activated_key
                 ) as $option) {

            delete_option($option);

        }


    }
    delete_option('api_manager_rfqtk_plus_instance');
    delete_option('api_manager_rfqtk_plus_activated');

}


?>