<?php
/**
 * Functions used by plugins
 */

if (!function_exists('gpls_woo_plus_is_rfq5c_hidden')) {
    function gpls_woo_plus_is_rfq5c_hidden()
    {

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq"
            && get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'yes') {
            if (get_option('settings_gpls_woo_rfq_limit_to_rfq_only', 'no') == 'yes') {
                if (get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no') == 'yes') {
                    return true;
                }
            }

        }

        return false;
    }
}


if (!function_exists('gpls_woo_plus_is_price_hidden')) {
    function gpls_woo_plus_is_price_hidden()
    {

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq"
            && get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'yes') {
            if (get_option('settings_gpls_woo_rfq_limit_to_rfq_only', 'no') == 'yes') {
                if (get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no') == 'yes') {
                    return true;
                }
            }

        }

        return false;
    }
}


if (!function_exists('np_check_array_element')) {
    function np_check_array_element($array, $key)
    {

        return is_array($array) && isset($array[$key]) && $array[$key] != null;
    }
}


if (!function_exists('gpls_woo_plus_get_rfq_enable')) {
    function gpls_woo_plus_get_rfq_enable($product)
    {

        if (!$product) return "no";

        $product_id = $product->get_id();

        $rfq_enable = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);

        if ($rfq_enable != "yes") {
            $rfq_enable = gpls_woo_plus_get_rfqc_enable($product_id);
        }

        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product_id);

        if (empty($rfq_enable)) {
            $rfq_enable = "no";
        }

        return $rfq_enable;
    }
}


if (!function_exists('gpls_woo_plus_get_rfqc_enable')) {
    function gpls_woo_plus_get_rfqc_enable($product_id)
    {
        $rfq_enable = 'no';

        $cats = get_option('settings_gpls_woo_rfq_bulk_rfq_enable_in_cat', '');

        if ($cats) {

            $terms = explode(',', $cats);

            if (is_array($terms) && count($terms) > 0) {
                foreach ($terms as $term) {
                    if (is_object_in_term($product_id, 'product_cat', $term)) {

                        $rfq_enable = "yes";

                        break;
                    }
                }
            }
        }
        return $rfq_enable;
    }
}


//$no_add_to_cart = get_post_meta($product->get_id(), '_gpls_woo_rfq_no_add_to_cart', true);
//    $no_add_to_cart = apply_filters('gpls_no_add_to_cart', $no_add_to_cart, $product->get_id());

if (!function_exists('gpls_woo_plus_get_no_add_to_cart')) {
    function gpls_woo_plus_get_no_add_to_cart($product)
    {
        if (!$product) return "no";

        $product_id = $product->get_id();

        $no_add_to_cart = get_post_meta($product_id, '_gpls_woo_rfq_no_add_to_cart', true);

        if ($no_add_to_cart != "yes") {
            $no_add_to_cart = gpls_woo_plus_get_gpls_woo_plus_getc_no_add_to_cart($product_id);
        }

        $no_add_to_cart = apply_filters('gpls_no_add_to_cart', $no_add_to_cart, $product_id);

        if (empty($no_add_to_cart)) {
            $no_add_to_cart = "no";
        }

        return $no_add_to_cart;
    }
}


if (!function_exists('gpls_woo_plus_get_gpls_woo_plus_getc_no_add_to_cart')) {
    function gpls_woo_plus_get_gpls_woo_plus_getc_no_add_to_cart($product_id)
    {
        $no_add_to_cart = 'no';

        $cats = get_option('settings_gpls_woo_rfq_bulk_hide_add_to_cart_cat', '');

        if ($cats) {

            $terms = explode(',', $cats);

            if (is_array($terms) && count($terms) > 0) {
                foreach ($terms as $term) {
                    if (is_object_in_term($product_id, 'product_cat', $term)) {

                        $no_add_to_cart = "yes";

                        break;
                    }
                }
            }
        }

        return $no_add_to_cart;
    }
}


//$hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
//$hide_price = apply_filters('gpls_hide_product_price',$hide_price, $product->get_id());


if (!function_exists('gpls_woo_plus_get_hide_price')) {
    function gpls_woo_plus_get_hide_price($product)
    {

        if (!$product) return "no";

        $product_id = $product->get_id();

        $hide_price = get_post_meta($product_id, '_gpls_woo_rfq_hide_price', true);

        if ($hide_price != "yes") {
            $hide_price = gpls_woo_plus_get_gpls_woo_plus_getc_hide_price($product_id);
        }


        $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $product_id);

        if (empty($hide_price)) {
            $hide_price = "no";
        }

        return $hide_price;
    }
}


if (!function_exists('gpls_woo_plus_get_gpls_woo_plus_getc_hide_price')) {
    function gpls_woo_plus_get_gpls_woo_plus_getc_hide_price($product_id)
    {
        $hide_price = "no";

        $cats = get_option('settings_gpls_woo_rfq_bulk_hide_price_cat', '');

        if ($cats) {

            $terms = explode(',', $cats);

            if (is_array($terms) && count($terms) > 0) {
                foreach ($terms as $term) {
                    if (is_object_in_term($product_id, 'product_cat', $term)) {

                        $hide_price = "yes";

                        break;
                    }
                }
            }
        }

        return $hide_price;
    }
}


// $individual_per_order2 = get_post_meta($cart_item['product_id'], '_gpls_woo_individual_per_order', true);
// $individual_per_order2 = apply_filters($individual_per_order, 'gpls_woo_individual_order', true);

if (!function_exists('gpls_woo_plus_get_individual_per_order')) {
    function gpls_woo_plus_get_individual_per_order($product)
    {
        if (!$product) return "no";

        $product_id = $product->get_id();

        $individual_per_order = "no";

        $individual_per_order = get_post_meta($product_id, '_gpls_woo_individual_per_order', true);

        if ($individual_per_order != "yes") {
            $individual_per_order = gpls_woo_plus_get_gpls_woo_plus_getc_individual_per_order($product_id);
        }

        $individual_per_order = apply_filters('gpls_woo_individual_order', $individual_per_order, $product_id);

        if (empty($individual_per_order)) {
            $individual_per_order = "no";
        }


        return $individual_per_order;
    }
}


if (!function_exists('gpls_woo_plus_get_gpls_woo_plus_getc_individual_per_order')) {
    function gpls_woo_plus_get_gpls_woo_plus_getc_individual_per_order($product_id)
    {
        $individual_per_order = "no";

        $cats = get_option('settings_gpls_woo_rfq_bulk_only_one_product_cat', '');

        if ($cats) {

            $terms = explode(',', $cats);

            if (is_array($terms) && count($terms) > 0) {

                foreach ($terms as $term) {

                    if (is_object_in_term($product_id, 'product_cat', $term)) {

                        $individual_per_order = "yes";

                        break;
                    }
                }
            }
        }


        return $individual_per_order;
    }
}


// $product_email_confirmation_message = get_post_meta($_product->get_id(), '_gpls_woo_rfq_plus_product_email_message', true);
// $product_email_confirmation_message = apply_filters('gpls_woo_rfq_plus_product_email_message',$product_email_confirmation_message, true);

if (!function_exists('gpls_woo_plus_get_product_email_message')) {
    function gpls_woo_plus_get_product_email_message($product)
    {

        if (!$product) return "";

        $product_id = $product->get_id();

        $product_email_message = get_post_meta($product_id, '_gpls_woo_rfq_plus_product_email_message', true);

        if (trim($product_email_message) == "") {
            $product_email_message = gpls_woo_plus_get_rfqc_email_message($product_id);
        }

        $product_email_message = apply_filters('gpls_woo_rfq_plus_product_email_message', $product_email_message, $product_id);

        if (empty($product_email_message)) {
            $product_email_message = "";
        }

        return $product_email_message;
    }
}


if (!function_exists('gpls_woo_plus_get_rfqc_email_message')) {
    function gpls_woo_plus_get_rfqc_email_message($product_id)
    {
        $product_email_message = "";

        $cats = get_option('settings_gpls_woo_rfq_cats_new_update_product_messages', '');

        if ($cats) {

            $terms = explode(',', $cats);

            if (is_array($terms) && count($terms) > 0) {
                foreach ($terms as $term) {
                    if (is_object_in_term($product_id, 'product_cat', $term)) {

                        $content = get_option('settings_gpls_woo_rfq_customer_product_message_content', '');
                        if ($content != '') {
                            $product_email_message = $content;
                        }

                        break;
                    }
                }
            }
        }
        return $product_email_message;
    }
}


if (!function_exists('gpls_woo_rfq_get_item')) {
    require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
    require_once(ABSPATH . 'wp-includes/class-phpass.php');

}
require_once(gpls_woo_rfq_plus_DIR . 'includes/notes/notes_functions.php');
$GLOBALS["rfqtk_notes_functions"] = new rfqtk_notes_functions();

//apply_filters( 'woocommerce_valid_order_statuses_for_order_again', array( 'completed' ) )

/*$order_again = get_option('settings_gpls_woo_rfq_allow_order_gain', "no");
//mercurial
if ($order_again == "yes") {
    add_filter('woocommerce_valid_order_statuses_for_order_again', 'rfqtk1_statuses_for_order_again');
}*/

add_filter('woocommerce_valid_order_statuses_for_payment', 'rfqtk1_statuses_for_payment', 100, 2);


add_filter('woocommerce_valid_order_statuses_for_payment_complete', 'rfqtk1_statuses_for_payment', 100, 2);

add_filter('woocommerce_product_get_stock_quantity', 'custom_get_stock_quantity', 1000, 2);
add_filter('woocommerce_product_variation_get_stock_quantity', 'custom_get_stock_quantity', 1000, 2);
add_filter('woocommerce_product_bundle_get_stock_quantity', 'custom_get_stock_quantity', 1000, 2);
add_filter('woocommerce_pay_order_product_in_stock', 'custom_pay_order_product_in_stock', 1000, 3);


if (!is_admin()) {
    add_action('wp_loaded', 'gpls_woo_rfq_check_staff_mode', 1000000);

}

if (!function_exists('gpls_woo_rfq_check_staff_mode')) {
    function gpls_woo_rfq_check_staff_mode()
    {

        gpls_woo_rfq_plus_check_staff_mode();
    }
}


if (!function_exists('custom_pay_order_product_in_stock')) {
    function custom_pay_order_product_in_stock($is_in_stock, $product, $order)
    {

        if (!rfqtk_managing_stock($product) || $order->has_status('gplsquote-sent')
            || !$order->has_status('wc-gplsquote-sent')) {
            $is_in_stock = true;
        }
        return $is_in_stock;
    }
}


if (!function_exists('custom_get_stock_quantity')) {
    function custom_get_stock_quantity($value, $product)
    {
        if (is_wc_endpoint_url('order-pay')) {

            if (isset($_GET['pay_for_order']) && isset($_GET['key'])) {
                $order_key = $_GET['key'];
                $order_id = wc_get_order_id_by_order_key($order_key);
                $order = wc_get_order($order_id);

            }


            if ($order && ($order->has_status('gplsquote-sent')
                    || $order->has_status('wc-gplsquote-sent')
                    || $order->has_status('gplsquote-req')
                    || $order->has_status('wc-gplsquote-req'))) {
                $value = 10000;
            }

        }


        /*if (!rfqtk_managing_stock($product)) {
            $value = 10000;
        }*/
        if (!$product->managing_stock()) {
            $value = 10000;
        }


        return $value;
    }
}

if (!function_exists('rfqtk_managing_stock')) {
    function rfqtk_managing_stock($product)
    {
        $manage = false;

        if ('yes' === get_option('woocommerce_manage_stock')) {
            $manage = true;
        }

        if ('yes' === get_option('woocommerce_manage_stock') && $product->get_manage_stock()) {
            $manage = true;
        }
        return $manage;
    }
}

//note duplicate definition
if (!function_exists('gplsrfqtk_only_purchase')) {
    function gplsrfqtk_only_purchase($available_gateways)
    {

        if (is_admin()) {
            return $available_gateways;
        }

        if (isset($_GET['pay_for_order'])) {
            unset($available_gateways['gpls-rfq']);
            return $available_gateways;
        }

        foreach ($available_gateways as $gateway_id => $gateway) {

            if ($gateway_id == 'gpls-rfq') {
                unset($available_gateways[$gateway_id]);
                return $available_gateways;
            }
        }

        return $available_gateways;
    }
}

if (!function_exists('rfqtk_first2')) {
    function rfqtk_first2()
    {
        //  gpls_woo_rfq_cart_delete('gpls_woo_rfq_purchase_only');


        $staff = gpls_woo_rfq_plus_check_staff_mode();

        if ($staff == "yes" || (isset($_REQUEST['pay_for_order']) && strpos($_REQUEST['key'], 'wc_order_', 0) === 0)) {
            $GLOBALS["gpls_woo_rfq_show_prices"] = "yes";
            $GLOBALS["hide_for_visitor"] = "no";

            return true;
        }

        $url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

        $has_string = strpos($url, 'order-received');

        if ($has_string !== false && strpos($_REQUEST['key'], 'wc_order_', 0) === 0) {

            $GLOBALS["gpls_woo_rfq_show_prices"] = "yes";
            $GLOBALS["hide_for_visitor"] = "no";

            return true;
        }

        return false;
    }
}


if (!function_exists('rfqtk1_statuses_for_payment')) {

    function rfqtk1_statuses_for_payment($array, $order)
    {
        array_push($array, 'gplsquote-sent');
        array_push($array, 'wc-gplsquote-sent');
        return $array;
    }
}

if (!function_exists('rfqtk1_statuses_for_order_again')) {

    function rfqtk1_statuses_for_order_again($array)
    {
        array_push($array, 'gplsquote-sent');
        array_push($array, 'wc-gplsquote-sent');

        array_push($array, 'gplsquote-req');
        array_push($array, 'wc-gplsquote-req');

        return $array;
    }
}


add_action('wp_print_footer_scripts', 'gpls_woo_rfq_addresses_js_print_script', 1000);

function gpls_woo_rfq_addresses_js_print_script()
{
    $home = home_url() . '/quote-request/';

    $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);


    $actual_link = get_site_url() . $_SERVER['REQUEST_URI'];


    if (parse_url(trim($rfq_page))['path'] != parse_url(trim($actual_link))['path']) {
        return;
    }

    ?>
    <script type="application/javascript">

        if (jQuery('#rfq_billing_country').val() != 'US') {
            jQuery('#rfq_state_select').val("");
            jQuery('#rfq_state_select').hide();
            jQuery('#rfq_state_text').show();
            jQuery('#rfq_state_select').attr("required", false);
            jQuery('#rfq_state_text').attr("required", true);
        } else {
            jQuery('#rfq_state_text').val("");
            jQuery('#rfq_state_text').hide();
            jQuery('#rfq_state_select').show();
            jQuery('#rfq_state_select').attr("required", true);
            jQuery('#rfq_state_text').attr("required", false);

        }

        jQuery('.rfq_billing_country').on('change', function () {

            if (jQuery('#rfq_billing_country').val() != 'US') {
                jQuery('#rfq_state_select').val("");
                jQuery('#rfq_state_select').hide();
                jQuery('#rfq_state_select').attr("required", false);
                jQuery('#rfq_state_text').show();
                jQuery('#rfq_state_text').attr("required", true);
            } else {
                jQuery('#rfq_state_text').val("");
                jQuery('#rfq_state_text').hide();
                jQuery('#rfq_state_text').attr("required", false);
                jQuery('#rfq_state_select').show();
                jQuery('#rfq_state_select').attr("required", true);
            }

        });
        jQuery(document).ready(function () {

            jQuery('form.checkout').on('click', function () {
                jQuery('form.checkout').removeAttr('novalidate');
            });
        });


    </script>


    <?php
    if (gpls_woo_rfq_plus_check_staff_mode() === "yes") return;

    $rfq_check = false;
    $normal_check = false;


    if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

        $rfq_check = true;
        $normal_check = false;

        if (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'yes') {
            $rfq_check = false;
            $normal_check = true;

        }
    }

    if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "normal_checkout") {
        $rfq_check = false;
        $normal_check = true;

    }

    if (function_exists('wp_get_current_user')) {
        if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
            $rfq_check = true;
            $normal_check = false;
            echo '$normal_check is false 3';
        }
    }

    if (($normal_check == false)) {
        return;
    }

    if (($normal_check == true && get_option('settings_gpls_woo_rfq_normal_checkout_show_prices', 'no') == 'yes')) {
        //   echo '$normal_check is false 4';
        return;
    }

    ?>

    <script type="application/javascript">

        jQuery(document).ready(function () {

            jQuery(".wc-item-meta li p").each(function (index) {

                text = jQuery(this).text();
                console.log(text);
                text = text.replace(/(?<=\(\+).+?(?=\))/g, "");
                text = text.replace("(+)", "");
                console.log("replaced");
                jQuery(this).text(text);
            });
        });

    </script>

    <?php
}


add_action('woocommerce_before_pay_action', 'gpls_before_pay_action', 1000);

function gpls_before_pay_action($order)
{

    if (isset($_POST['gpls_address_at_payorder'])) {

        if (isset($_POST['rfq_state_select'])) {
            if ($_POST['rfq_state_select'] == "") {
                $billing_state = sanitize_text_field($_POST['rfq_state_text']);
            } else {
                $billing_state = sanitize_text_field($_POST['rfq_state_select']);
            }
        } else {
            $billing_state = "";
        }

        if (isset($_POST['rfq_shipping_state_select'])) {
            if ($_POST['rfq_shipping_state_select'] == "") {
                $shipping_state = sanitize_text_field($_POST['rfq_shipping_state']);
            } else {
                $shipping_state = sanitize_text_field($_POST['rfq_shipping_state_select']);
            }
        } else {
            $shipping_state = '';
        }


        // $order = wc_get_order(1);
        try {
            $order->set_billing_first_name(sanitize_text_field($_POST['billing_fname']));
            $order->set_billing_last_name(sanitize_text_field($_POST['billing_lname']));
            $order->set_billing_company(sanitize_text_field($_POST['rfq_company']));
            $order->set_billing_country(sanitize_text_field($_POST['rfq_billing_country']));
            $order->set_billing_state(sanitize_text_field($billing_state));
            $order->set_billing_city(sanitize_text_field($_POST['rfq_city']));
            $order->set_billing_address_1(sanitize_text_field($_POST['rfq_address']));
            $order->set_billing_address_2(sanitize_text_field($_POST['rfq_address2']));
            $order->set_billing_postcode(sanitize_text_field($_POST['rfq_zip']));

/////////////////////////////////////////////////////////////////////////
///
            if (isset($_POST['rfq_send_to_billing'])) {
                $order->set_shipping_first_name(sanitize_text_field($_POST['billing_fname']));
                $order->set_shipping_last_name(sanitize_text_field($_POST['billing_lname']));
                $order->set_shipping_company(sanitize_text_field($_POST['rfq_company']));
                $order->set_shipping_country(sanitize_text_field($_POST['rfq_billing_country']));
                $order->set_shipping_state(sanitize_text_field($billing_state));
                $order->set_shipping_address_1(sanitize_text_field($_POST['rfq_address']));
                $order->set_shipping_address_2(sanitize_text_field($_POST['rfq_address2']));
                $order->set_shipping_city(sanitize_text_field($_POST['rfq_city']));
                $order->set_shipping_postcode(sanitize_text_field($_POST['rfq_zip']));
            } else {
                $order->set_shipping_first_name(sanitize_text_field($_POST['shipping_fname']));
                $order->set_shipping_last_name(sanitize_text_field($_POST['shipping_lname']));
                $order->set_shipping_company(sanitize_text_field($_POST['rfq_shipping_company']));
                $order->set_shipping_country(sanitize_text_field($_POST['rfq_shipping_country']));
                $order->set_shipping_state(sanitize_text_field($shipping_state));
                $order->set_shipping_address_1(sanitize_text_field($_POST['rfq_shipping_address']));
                $order->set_shipping_address_2(sanitize_text_field($_POST['rfq_shipping_address2']));
                $order->set_shipping_city(sanitize_text_field($_POST['rfq_shipping_city']));
                $order->set_shipping_postcode(sanitize_text_field($_POST['rfq_shipping_zip']));
            }


        } catch (Exception $ex) {

            npwrite_log($ex->getMessage() . ' ' . $ex->getTraceAsString(), __FILE__, __LINE__);
        }
        if (isset($_POST['rfq_phone'])) {
            $order->set_billing_phone(sanitize_text_field($_POST['rfq_phone']));
        }
        if (isset($_POST['rfq_shipping_phone'])) {
            $order->set_shipping_phone(sanitize_text_field($_POST['rfq_shipping_phone']));
        }

        $order->save();

        $update_user_profile = get_option('settings_gpls_woo_rfq_update_user_profile_with_address', 'no');
        $customer_id = get_current_user_id();


        if ($update_user_profile == "yes" && $customer_id > 0) {
            //   $wp_user = new WP_User($customer_id);

            if (isset($_POST['billing_fname']))
                update_user_meta($customer_id, "billing_first_name", sanitize_text_field($_POST["billing_fname"]));

            if (isset($_POST['billing_lname']))
                update_user_meta($customer_id, "billing_last_name", sanitize_text_field($_POST["billing_lname"]));

            if (isset($_POST['rfq_company']))
                update_user_meta($customer_id, "billing_company", sanitize_text_field($_POST["rfq_company"]));

            if (isset($_POST['rfq_address']))
                update_user_meta($customer_id, "billing_address_1", sanitize_text_field($_POST["rfq_address"]));

            if (isset($_POST['rfq_address2']))
                update_user_meta($customer_id, "billing_address_2", sanitize_text_field($_POST["rfq_address2"]));

            if (isset($_POST['rfq_city']))
                update_user_meta($customer_id, "billing_city", sanitize_text_field($_POST["rfq_city"]));


            update_user_meta($customer_id, "billing_state", $billing_state);

            if (isset($_POST['rfq_zip']))
                update_user_meta($customer_id, "billing_postcode", sanitize_text_field($_POST["rfq_zip"]));

            if (isset($_POST['rfq_billing_country']))
                update_user_meta($customer_id, "billing_country", sanitize_text_field($_POST["rfq_billing_country"]));

            if (isset($_POST['rfq_phone'])) {
                update_user_meta($customer_id, "billing_phone", sanitize_text_field($_POST["rfq_phone"]));
            }

            if (isset($_POST['shipping_fname']))
                update_user_meta($customer_id, "shipping_first_name", sanitize_text_field($_POST["shipping_fname"]));

            if (isset($_POST['shipping_lname']))
                update_user_meta($customer_id, "shipping_last_name", sanitize_text_field($_POST["shipping_lname"]));

            if (isset($_POST['rfq_shipping_company']))
                update_user_meta($customer_id, "shipping_company", sanitize_text_field($_POST["rfq_shipping_company"]));

            if (isset($_POST['rfq_shipping_address']))
                update_user_meta($customer_id, "shipping_address_1", sanitize_text_field($_POST["rfq_shipping_address"]));

            if (isset($_POST['rfq_shipping_address2']))
                update_user_meta($customer_id, "shipping_address_2", sanitize_text_field($_POST["rfq_shipping_address2"]));

            if (isset($_POST['rfq_shipping_city']))
                update_user_meta($customer_id, "shipping_city", sanitize_text_field($_POST["rfq_shipping_city"]));


            update_user_meta($customer_id, "shipping_state", $shipping_state);

            if (isset($_POST['rfq_shipping_zip']))
                update_user_meta($customer_id, "shipping_postcode", sanitize_text_field($_POST["rfq_shipping_zip"]));

            if (isset($_POST['rfq_shipping_country']))
                update_user_meta($customer_id, "shipping_country", sanitize_text_field($_POST["rfq_shipping_country"]));

            if (isset($_POST['rfq_shipping_phone'])) {
                update_user_meta($customer_id, "billing_phone", sanitize_text_field($_POST["rfq_shipping_phone"]));
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            /* if (isset($_POST['rfq_send_to_billing'])) {
                 update_user_meta($customer_id, "shipping_first_name", sanitize_text_field($_POST["billing_fname"]));
                 update_user_meta($customer_id, "shipping_last_name", sanitize_text_field($_POST["billing_lname"]));
                 update_user_meta($customer_id, "shipping_company", sanitize_text_field($_POST["rfq_company"]));
                 update_user_meta($customer_id, "shipping_address_1", sanitize_text_field($_POST["rfq_address"]));
                 update_user_meta($customer_id, "shipping_address_2", sanitize_text_field($_POST["rfq_address2"]));
                 update_user_meta($customer_id, "shipping_city", sanitize_text_field($_POST["rfq_city"]));
                 update_user_meta($customer_id, "shipping_state", $billing_state);
                 update_user_meta($customer_id, "shipping_postcode", sanitize_text_field($_POST["rfq_zip"]));
                 update_user_meta($customer_id, "shipping_country", sanitize_text_field($_POST["rfq_billing_country"]));

             } else {
                 update_user_meta($customer_id, "shipping_first_name", sanitize_text_field($_POST["shipping_fname"]));
                 update_user_meta($customer_id, "shipping_last_name", sanitize_text_field($_POST["shipping_lname"]));
                 update_user_meta($customer_id, "shipping_company", sanitize_text_field($_POST["rfq_shipping_company"]));
                 update_user_meta($customer_id, "shipping_address_1", sanitize_text_field($_POST["rfq_shipping_address"]));
                 update_user_meta($customer_id, "shipping_address_2", sanitize_text_field($_POST["rfq_shipping_address2"]));
                 update_user_meta($customer_id, "shipping_city", sanitize_text_field($_POST["rfq_shipping_city"]));
                 update_user_meta($customer_id, "shipping_state", $shipping_state);
                 update_user_meta($customer_id, "shipping_postcode", sanitize_text_field($_POST["rfq_shipping_zip"]));
                 update_user_meta($customer_id, "shipping_country", sanitize_text_field($_POST["rfq_shipping_country"]));

             }*/


        }


    }
}


add_action('after_setup_theme', 'pls_woo_rfq_plus_after_theme_setup', 1);

function pls_woo_rfq_plus_after_theme_setup()
{
    add_action('wp_enqueue_scripts', 'gpls_woo_rfq_plus_panon_pay_order_scripts', 1000);
    add_action('woocommerce_pay_order_before_submit', 'rftk_plus_panon_pay_order', 1000);
}

function gpls_woo_rfq_plus_panon_pay_order_scripts()
{

    $require_address = get_option('settings_gpls_woo_rfq_address_at_pay_order', "no");

    if ($require_address == "no") {
        return;
    }

    if (is_checkout_pay_page()) {

        global $woocommerce;

        global $wp;
        $order_id = $wp->query_vars['order-pay'];
        if ($order_id == false) return;
        $order = wc_get_order($order_id);

        $address_billing = array(
            'first_name' => sanitize_text_field($order->get_billing_first_name()),
            'last_name' => sanitize_text_field($order->get_billing_last_name()),
            'company' => sanitize_text_field($order->get_billing_company()),
            'phone' => sanitize_text_field($order->get_billing_phone()),
            'address_1' => sanitize_text_field($order->get_billing_address_1()),
            'address_2' => sanitize_text_field($order->get_billing_address_2()),
            'city' => sanitize_text_field($order->get_billing_city()),
            'state' => sanitize_text_field($order->get_billing_state()),
            'postcode' => sanitize_text_field($order->get_billing_postcode()),
            'country' => sanitize_text_field($order->get_billing_country())
        );
        $address_shipping = array(
            'first_name' => sanitize_text_field($order->get_shipping_first_name()),
            'last_name' => sanitize_text_field($order->get_shipping_last_name()),
            'company' => sanitize_text_field($order->get_shipping_company()),
            'phone' => sanitize_text_field($order->get_shipping_phone()),
            'address_1' => sanitize_text_field($order->get_shipping_address_1()),
            'address_2' => sanitize_text_field($order->get_shipping_address_2()),
            'city' => sanitize_text_field($order->get_shipping_city()),
            'state' => sanitize_text_field($order->get_shipping_state()),
            'postcode' => sanitize_text_field($order->get_shipping_postcode()),
            'country' => sanitize_text_field($order->get_shipping_country())
        );


        if ($require_address != "no") {

            $url_rfqtk_pay_address_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk_pay_address.js';
            $url_rfqtk_pay_address_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk_pay_address.js';

            wp_enqueue_script('gpls_woo_rfqtk_pay_address_js', $url_rfqtk_pay_address_js, array('jquery'), rand(10, 100000), true);

            wp_localize_script('gpls_woo_rfqtk_pay_address_js', 'order_data',
                array(
                    'order' => $order,
                    'address_billing' => $address_billing,
                    'address_shipping' => $address_shipping,
                    'require_address' => $require_address,
                    'require_phone' => $address_billing,

                )
            );
        }

    }
}


function rftk_plus_panon_pay_order()
{


    $require_address = get_option('settings_gpls_woo_rfq_address_at_pay_order', "no");

    if ($require_address == "yes" || $require_address == "Billing_Shipping") {
        global $woocommerce;

        global $wp;
        $order_id = $wp->query_vars['order-pay'];
        if ($order_id == false) return;
        $order = wc_get_order($order_id);

        $address_billing = array(
            'first_name' => sanitize_text_field($order->get_billing_first_name()),
            'last_name' => sanitize_text_field($order->get_billing_last_name()),
            'company' => sanitize_text_field($order->get_billing_company()),
            'phone' => sanitize_text_field($order->get_billing_phone()),
            'address_1' => sanitize_text_field($order->get_billing_address_1()),
            'address_2' => sanitize_text_field($order->get_billing_address_2()),
            'city' => sanitize_text_field($order->get_billing_city()),
            'state' => sanitize_text_field($order->get_billing_state()),
            'postcode' => sanitize_text_field($order->get_billing_postcode()),
            'country' => sanitize_text_field($order->get_billing_country())
        );
        $address_shipping = array(
            'first_name' => sanitize_text_field($order->get_shipping_first_name()),
            'last_name' => sanitize_text_field($order->get_shipping_last_name()),
            'company' => sanitize_text_field($order->get_shipping_company()),
            'phone' => sanitize_text_field($order->get_shipping_phone()),
            'address_1' => sanitize_text_field($order->get_shipping_address_1()),
            'address_2' => sanitize_text_field($order->get_shipping_address_2()),
            'city' => sanitize_text_field($order->get_shipping_city()),
            'state' => sanitize_text_field($order->get_shipping_state()),
            'postcode' => sanitize_text_field($order->get_shipping_postcode()),
            'country' => sanitize_text_field($order->get_shipping_country())
        );

        wc_get_template('woo-rfq/checkout/pay-address.php',
            array('require_address' => $require_address,
                'require_phone' => $require_address,
                'order' => $order,
                'address_billing' => $address_billing,
                'address_shipping' => $address_shipping
            ), '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
    }


}


if (!function_exists('gpls_woo_rfq_remove_http')) {
    function gpls_woo_rfq_remove_http($url)
    {
        $disallowed = array('http://', 'https://');
        foreach ($disallowed as $d) {
            if (strpos($url, $d) === 0) {
                return str_replace($d, '', $url);
            }
        }
        return $url;
    }
}
if (!function_exists('pls_woo_rfq_get_link_to_rfq')) {
    function pls_woo_rfq_get_link_to_rfq()
    {


        $home = home_url() . '/quote-request/';

        $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);

        if (is_ssl()) {

            $rfq_page = preg_replace("/^http:/i", "https:", $rfq_page);

        }

        return $rfq_page;


    }
}


if (get_option('settings_gpls_plus_allow_anon_at_pay_order', "no") == "yes") {
    //add_action('before_woocommerce_pay', 'rftk_plus_npanon_pay_order', 10000);
    add_filter('user_has_cap', 'rftk_plus_npanon_pay', 9999, 3);
}
function rftk_plus_npanon_pay($allcaps, $caps, $args)
{
    if (isset($caps[0], $_GET['key'])) {
        if ($caps[0] == 'pay_for_order') {
            $order_id = isset($args[2]) ? $args[2] : null;
            $order = wc_get_order($order_id);
            if ($order) {
                $allcaps['pay_for_order'] = true;
            }
        }
    }
    return $allcaps;
}

function rftk_plus_npanon_pay_order()
{
    return;
    // $order_id=0;
    /* $url = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
     $template_name = '/order-pay/';
     if (strpos($url, $template_name) !== false) {
         $start = strpos($url, $template_name);
         $first_part = substr($url, $start + strlen($template_name));
         $order_id = substr($first_part, 0, strpos($first_part, '/'));
     }

     if ($order_id == false) return;

     $order_key = $_GET['key'];
     $order = wc_get_order($order_id);

     if ($order->get_user() == false) {
         return;
     }

     wc_print_notices();


     // Pay for existing order.
     if (isset($_GET['pay_for_order'], $_GET['key']) ) {
         try {

             $url = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
             $template_name = '/order-pay/';
             if (strpos($url, $template_name) !== false) {
                 $start = strpos($url, $template_name);
                 $first_part = substr($url, $start + strlen($template_name));
                 $order_id = substr($first_part, 0, strpos($first_part, '/'));
             }

             if ($order_id == false) return;

             $order_key = $_GET['key'];
             $order = wc_get_order($order_id);
             $order_key = $_GET['key'];
           //  $order = wc_get_order($order_id);

            // if ($order->get_user() == false)
             {
              //   return;
             }

             // Order or payment link is invalid.
             if (!$order || $order->get_id() != $order_id || $order->get_order_key() !== $order_key)
             {
                // throw new Exception(__('Sorry, this order is invalid and cannot be paid for.', 'np_anon'));
                  wc_add_notice(sprintf(__('Sorry, this order is invalid and cannot be paid for.', 'rfqtk')),"error");
                 return;

             }


             if (!is_user_logged_in()) {

                 $options = get_option('np_anon_payorder_settings');

                 $allow_anon = $options['np_anon_payorder_allow_visitor_pay'];

                 if ($allow_anon == false) {
                     return;
                 }
             }


             if (is_user_logged_in()) {
                 return;
             }




             $available_gateways = WC()->payment_gateways->get_available_payment_gateways();

             if (sizeof($available_gateways)) {
                 current($available_gateways)->set_current();
             }
             wc_get_template('checkout/form-pay.php', array(
                 'order' => $order,
                 'available_gateways' => $available_gateways,
                 'order_button_text' => apply_filters('woocommerce_pay_order_button_text', __('Pay for order', 'np_anon')),
             ));

         } catch (Exception $e) {
             wc_add_notice($e->getMessage(), 'error');
         }
     } else {
        // wc_add_notice(__('Invalid order.', 'np_anon'), 'error');
     }*/

    // wc_clear_notices();

    //  rftk_plus_npanon_payorderfor_payment_css_js();

    //  do_action('after_woocommerce_pay');

}

function rftk_plus_npanon_payorderfor_payment_css_js()
{
    if (!is_admin()) {
        add_action('wp_enqueue_scripts', 'rftk_plus_npanon_payorderfor_payment_scripts', -10);
        add_action('wp_print_footer_scripts', 'rftk_plus_npanon_payorderfor_payment_scripts', -10);
        add_action('wp_add_inline_script', 'rftk_plus_npanon_payorderfor_payment_scripts', -10);

    }
}

function rftk_plus_npanon_payorderfor_payment_scripts()
{

    if (!is_admin()) {


        $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk_anonpay.css';
        $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk_anonpay.css';
        wp_enqueue_style('npanon_payordercss', $url_css, array(), rand(10, 100000));

        $list = 'enqueued';


        $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk_anonpay.js';
        $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk_anonpay.js';
        wp_enqueue_script('npanon_payorderjs', $url_js, array('jquery'), rand(10, 100000), true);


        $custom_js = "";

        $custom_js = "jQuery(document ).ready( function() { jQuery( '.woocommerce-info' ).hide();
            jQuery( '.woocommerce-SavedPaymentMethods-saveNew' ).hide();
            jQuery( '#wc-stripe-payment-token-new').click();} );
            jQuery( '.woocommerce-SavedPaymentMethods' ).hide();
            ";

//$("input[name=background][value='some value']").prop("checked",true)
        if ($custom_js != "") {
            wp_add_inline_script('npanon_payorderjs', $custom_js);
        }
        $custom_css = "";

        $custom_css = ".woocommerce-SavedPaymentMethods, .woocommerce-info,.woocommerce-SavedPaymentMethods-saveNew {display:none !important;}";

        wp_add_inline_style('npanon_payordercss', $custom_css);

        if ($custom_js != "") {
            echo '<script>' . $custom_js . '</script>';
        }

        echo '<style>' . $custom_css . '</style>';


    }


}


if (!function_exists('gpls_remove_filters_with_method_name')) {
    function gpls_remove_filters_with_method_name($hook_name = '', $method_name = '', $priority = 0)
    {
        global $wp_filter;

        if (!isset($wp_filter[$hook_name][$priority]) || !is_array($wp_filter[$hook_name][$priority])) {
            return false;
        }

        foreach ((array)$wp_filter[$hook_name][$priority] as $unique_id => $filter_array) {

            if (isset($filter_array['function']) && is_array($filter_array['function'])) {

                if (is_object($filter_array['function'][0]) && get_class($filter_array['function'][0]) && $filter_array['function'][1] == $method_name) {
                    if (is_a($wp_filter[$hook_name], 'WP_Hook')) {
                        unset($wp_filter[$hook_name]->callbacks[$priority][$unique_id]);
                    } else {
                        unset($wp_filter[$hook_name][$priority][$unique_id]);
                    }
                }
            }
        }
        return false;
    }
}


if (!function_exists('gpls_remove_filters_for_anonymous_class')) {
    function gpls_remove_filters_for_anonymous_class($hook_name = '', $class_name = '', $method_name = '', $priority = 0)
    {
        global $wp_filter;
        // Take only filters on right hook name and priority
        if (!isset($wp_filter[$hook_name][$priority]) || !is_array($wp_filter[$hook_name][$priority])) {
            return false;
        }
        // Loop on filters registered
        foreach ((array)$wp_filter[$hook_name][$priority] as $unique_id => $filter_array) {
            // Test if filter is an array ! (always for class/method)
            if (isset($filter_array['function']) && is_array($filter_array['function'])) {
                // Test if object is a class, class and method is equal to param !
                if (is_object($filter_array['function'][0]) && get_class($filter_array['function'][0]) && get_class($filter_array['function'][0]) == $class_name && $filter_array['function'][1] == $method_name) {
                    // Test for WordPress >= 4.7 WP_Hook class (https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/)
                    if (is_a($wp_filter[$hook_name], 'WP_Hook')) {
                        unset($wp_filter[$hook_name]->callbacks[$priority][$unique_id]);
                    } else {
                        unset($wp_filter[$hook_name][$priority][$unique_id]);
                    }
                }
            }
        }
        return false;
    }
}

if (!function_exists('gpls_woo_rfq_get_mode')) {
    function gpls_woo_rfq_get_mode(&$rfq_check, &$normal_check)
    {
        $rfq_check = false;
        $normal_check = false;

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
            add_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_cart_needs_payment', 1000, 2);
            $rfq_check = true;
            $normal_check = false;
        }

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "normal_checkout") {
            $rfq_check = false;
            $normal_check = true;
        }

        if (function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $rfq_check = true;
                $normal_check = false;

            }
        }

    }
}


if (!function_exists('gpls_woo_rfq_woocommerce_empty_price_html')) {
    function gpls_woo_rfq_woocommerce_empty_price_html($html, $product = null)
    {
        if (isset($product) && is_object($product)) {

            if (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {


                $data = $product->get_data();

                $this_price = $data["price"];

                if (trim($data["sale_price"]) != '') {
                    $this_price = $data["sale_price"];
                }
                $type = $product->get_type();
                if ($type == 'simple' || $type == 'variable') {
                    if (trim($this_price) === '') {

                        //return false;
                    }
                }
            }
        }
        return $html;
    }
}


if (!function_exists('gpls_woo_rfq_plus_startsWith')) {
    function gpls_woo_rfq_plus_startsWith($haystack, $needle)
    {
        $length = strlen($needle);
        return (substr($haystack, 0, $length) === $needle);
    }
}

if (!function_exists('gpls_woo_rfq_plus_endsWith')) {
    function gpls_woo_rfq_plus_endsWith($haystack, $needle)
    {
        $length = strlen($needle);
        if (!$length) {
            return true;
        }
        return (substr($haystack, -$length) === $needle);
    }
}

if (!function_exists('gpls_empty')) {
    function gpls_empty($var)
    {
        if (!isset($var) || $var == false) {
            return true;
        } else {
            return false;
        }

    }
}

if (!function_exists('np_write_log')) {
    function np_write_log($log, $file, $line)
    {

        error_log('');
        error_log('*******************************************************************');
        error_log('BEGIN ' . $file . ' ' . $line);
        if (is_array($log) || is_object($log)) {
            error_log(print_r($log, true));
        } else {
            error_log($log);
        }
        error_log('END ' . $file . ' ' . $line);
        error_log('*******************************************************************');
        error_log('');

    }
}

if (!function_exists('np_datetime_note')) {
    function np_datetime_note()
    {
        $datetime_string = "REMOVE ME " . date('m/d/Y h:i:s a', time());


    }
}


if (!function_exists('gpls_woo_rfq_add_notice')) {
    function gpls_woo_rfq_add_notice($message, $type = 'info')
    {

        $notice = array('message' => $message, 'type' => $type, 'expired' => false);

        $gpls_woo_rfq_cart_notices = gpls_woo_rfq_get_item('gpls_woo_rfq_cart_notices');

        if (is_array($gpls_woo_rfq_cart_notices)) {
            array_push($gpls_woo_rfq_cart_notices, $gpls_woo_rfq_cart_notices);
        }

        gpls_woo_rfq_cart_set('gpls_woo_rfq_cart_notices', $notice);

    }
}

if (!function_exists('gpls_woo_rfq_print_notices')) {
    function gpls_woo_rfq_print_notices()
    {

        $notice = gpls_woo_rfq_get_item('gpls_woo_rfq_cart_notices');


        if (isset($notice['type']) && trim($notice['message']) != "") {
            ?>

            <?php if ($notice['type'] == 'error') : ?>
                <div class="woocommerce-error">
                    <?php echo trim(wp_kses_post($notice['message'])); ?>
                </div>
            <?php endif; ?>
            <?php if ($notice['type'] == 'info') : ?>
                <div class="woocommerce-info">
                    <?php echo trim(wp_kses_post($notice['message'])); ?>
                </div>
            <?php endif; ?>
            <?php if ($notice['type'] == 'notice') : ?>
                <div class="woocommerce-notice">
                    <?php echo trim(wp_kses_post($notice['message'])); ?>
                </div>
            <?php endif; ?>


            <?php
        }

        gpls_woo_rfq_cart_delete('gpls_woo_rfq_cart_notices');

        // d($all_notices);
    }
}

function rfqtk_show_prices()
{
    if (!is_admin()) {
        ip_based_options();
    }
}


function ip_based_options()
{
    if (!is_admin()) {


        add_filter("pre_option_settings_gpls_woo_rfq_show_prices", 'gpls_woo_rfq_plus_ip_yes_option', 10000);
        add_filter("pre_option_settings_gpls_woo_rfq_normal_checkout_show_prices", 'gpls_woo_rfq_plus_ip_yes_option', 10000);
        add_filter("pre_option_settings_gpls_woo_rfq_plus_normal_checkout", 'gpls_woo_rfq_plus_ip_yes_option', 10000);


        add_filter("pre_option_settings_gpls_woo_rfq_hide_visitor_prices", 'gpls_woo_rfq_plus_ip_no_option', 10000);

        add_filter("pre_option_settings_gpls_woo_rfq_plus_role_based_visible", 'gpls_woo_rfq_plus_ip_no_option', 10000);
        add_filter("pre_option_settings_gpls_woo_rfq_limit_to_rfq_only", 'gpls_woo_rfq_plus_ip_no_option', 10000);
        add_filter("pre_option_settings_gpls_woo_rfq_global_no_add_to_cart", 'gpls_woo_rfq_plus_ip_no_option', 10000);

        gpls_woo_rfq_woocommerce_RFQTK_only_add_to_cart();

        if (isset($GLOBALS['GPLS_WOO_RFQ'])) {

            //    remove_action('wp_enqueue_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_scripts'), 2000);

            remove_action('wp_print_footer_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_footer_scripts'), 2000);

        }
    }

}


function gpls_woo_rfq_plus_ip_checkout_option($option)
{
    return get_option("sales_staff_checkout_option", "rfq");
}


//settings_gpls_woo_rfq_global_no_add_to_cart

function gpls_woo_rfq_plus_ip_yes_option($option)
{
    return "yes";
}

function gpls_woo_rfq_plus_ip_no_option($option)
{
    return "no";
}

/*
 * Copyright 2008: Paul Gregg <pgregg@pgregg.com>
 * 10 January 2008
 * Version: 1.2
 * Source website: http://www.pgregg.com/projects/php/ip_in_range/
 */


function gpls_woo_rfq_plus_ip_in_range($ip, $range)
{

    if ($ip == $range) {
        return true;
    }

    if (strpos($range, '/') !== false) {

        list($range, $netmask) = explode('/', $range, 2);
        if (strpos($netmask, '.') !== false) {

            $netmask = str_replace('*', '0', $netmask);
            $netmask_dec = ip2long($netmask);
            return ((ip2long($ip) & $netmask_dec) == (ip2long($range) & $netmask_dec));
        } else {

            $x = explode('.', $range);
            while (count($x) < 4) $x[] = '0';
            list($a, $b, $c, $d) = $x;
            $range = sprintf("%u.%u.%u.%u", empty($a) ? '0' : $a, empty($b) ? '0' : $b, empty($c) ? '0' : $c, empty($d) ? '0' : $d);
            $range_dec = ip2long($range);
            $ip_dec = ip2long($ip);


            $wildcard_dec = pow(2, (32 - $netmask)) - 1;
            $netmask_dec = ~$wildcard_dec;

            return (($ip_dec & $netmask_dec) == ($range_dec & $netmask_dec));
        }
    } else {

        if (strpos($range, '*') !== false) { // a.b.*.* format

            $lower = str_replace('*', '0', $range);
            $upper = str_replace('*', '255', $range);
            $range = "$lower-$upper";
        }

        if (strpos($range, '-') !== false) { // A-B format
            list($lower, $upper) = explode('-', $range, 2);
            $lower_dec = (float)sprintf("%u", ip2long($lower));
            $upper_dec = (float)sprintf("%u", ip2long($upper));
            $ip_dec = (float)sprintf("%u", ip2long($ip));
            return (($ip_dec >= $lower_dec) && ($ip_dec <= $upper_dec));
        }


        return false;
    }

}

function gpls_woo_rfq_plus_check_staff_mode($staff = 'no')
{


    if (is_admin()) return "no";

    $ip_enabled = get_option('settings_gpls_woo_rfq_allow_sales_staff_ip_filter', "no");

    if ($ip_enabled == "yes") {

        $ip_list_array = trim(strtolower(get_option('settings_gpls_woo_sales_staff_ips', "")));

        $ip_list_array = explode(',', $ip_list_array);

        if (is_array($ip_list_array)) {
            $ip_list_array = array_map('trim', $ip_list_array);
            $ip_list_array = array_map('strtolower', $ip_list_array);
        } else {
            $ip_list_array = array("");
        }

        /*if (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && !gpls_empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip_address = $_SERVER['REMOTE_ADDR'];
        }*/

        $ip_address = gpls_woo_rfq_get_client_ip();


        foreach ($ip_list_array as $ip_range) {
            if (gpls_woo_rfq_plus_ip_in_range($ip_address, $ip_range)) {

                $staff = "yes";
                break;
            }
        }

    }

    if ($staff == "yes") {
        ip_based_options();
    }

    return $staff;
}


add_filter('gpls_woo_rfq_skip_ajax_add_to_quote', 'gpls_woo_rfq_redirect_add_to_quote', 10, 1);

function gpls_woo_rfq_redirect_add_to_quote($return)
{

    $redirect = get_option('rfq_cart_sc_redirect_to_single', 'no');

    return $redirect;
}

/**
 * @return false|mixed|void
 */
function get_gpls_woo_Redirect($product)
{
    $redirect = get_option('rfq_cart_sc_redirect_to_single', 'no');

    if ($product != null) {
        $simple_types = array('simple', 'subscription');
        if (!in_array($product->get_type(), $simple_types)) {

            $redirect = "yes";
        }
    }

    return $redirect;
}


//$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );

if (!function_exists('gpls_woo_rfqtk_validate_add_item_validation')) {
    function gpls_woo_rfqtk_validate_add_item_validation($passed, $product_id, $quantity)
    {

        if (isset($_REQUEST['rfq_product_formvalue'])) {
            return $passed;
        }

        if (isset($_REQUEST['rfq_files'])) {
            return $passed;
        }

        if (isset($_REQUEST['single'])) {
            //  return $passed;

        }
        if (isset($_REQUEST['add-to-cart']) && !isset($_GET['add-to-cart'])) {
            return $passed;

        }

        $redirect = get_option('rfq_cart_sc_redirect_to_single', 'no');


        if ($redirect == "yes") {

            if (isset($_REQUEST['rfq_id'])) {
                wp_redirect(get_permalink($product_id));
                exit;
            }

            if (isset($_GET['wc-ajax']) && $_GET['wc-ajax'] == "add_to_cart") {
                return false;
            }

        }

        /* $product = wc_get_product($product_id);
         $redirect = get_gpls_woo_Redirect($product);

         if ($redirect == "yes") {

                 wp_redirect(get_permalink($product_id));
                 exit;


         }*/

        return $passed;

    }
}

/**
 * @param array $user_roles
 * @return bool
 */
function gpls_woo_rfq_is_in_role($user, array $user_roles)
{
    $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

    $option_value_list = explode(',', $eligible_roles);

    foreach ($user_roles as $cat_id) {

        if (in_array(trim($cat_id), $option_value_list)) {
            $in_role = true;

        }
    }

    $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    return $in_role;
}


if (!function_exists('gpls_woo_rfq_woocommerce_RFQTK_only_add_to_cart')) {
    function gpls_woo_rfq_woocommerce_RFQTK_only_add_to_cart()
    {
        remove_filter('woocommerce_get_variation_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_cart_product_price', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('gpls_woo_rfq_get_price_hidden_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('gpls_woo_rfq_get_price_hidden_tax', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('gpls_woo_rfq_get_price_hidden_variation_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('gpls_woo_rfq_individual_price_hidden_variation_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('woocommerce_cart_item_subtotal', 'gpls_woo_rfq_hide_subtotal_price_function', 1000, 3);
        remove_filter('woocommerce_cart_item_subtotal', 'gpls_woo_rfq_hide_subtotal_price_function', 1000, 3);
        remove_filter('woocommerce_cart_subtotal', 'gpls_woo_rfqtk_hide_woocommerce_cart_subtotal', 1000, 3);
        remove_filter('woocommerce_cart_subtotal', 'gpls_woo_rfqtk_hide_woocommerce_cart_subtotal', 1000, 3);
        remove_filter('woocommerce_cart_tax_totals', 'gpls_woo_rfqtk_hide_tax_woocommerce_cart_subtotal', 1000, 2);
        remove_filter('woocommerce_cart_total', 'gpls_woo_rfqtk_hide_woocommerce_cart_total', 1000, 1);
        remove_filter('woocommerce_cart_total', 'gpls_woo_rfqtk_hide_woocommerce_cart_total', 1000, 1);
        remove_filter('woocommerce_order_formatted_line_subtotal', 'gpls_woo_rfqtk_order_formatted_line_subtotal', 100, 3);
        remove_filter('woocommerce_get_formatted_order_total', 'gpls_woo_rfqtk_get_formatted_order_total', 100, 2);
        remove_filter('woocommerce_get_order_item_totals', 'gpls_woo_rfqtk_woocommerce_get_order_item_totals', 100, 2);
        remove_filter('woocommerce_checkout_order_processed', 'gpls_woo_rfq_woocommerce_RFQTK_only_add_to_cart', 1000);


        remove_filter('woocommerce_product_addons_price_raw', 'gpls_woo_rfqtk_woocommerce_product_addons_price_raw', 1000, 2);
        remove_filter('woocommerce_product_addons_price', 'gpls_woo_rfqtk_woocommerce_product_addons_price', 1000, 4);

        remove_filter('woocommerce_display_item_meta', 'gpls_woo_rfq_pay_woocommerce_display_item_meta', 1000, 3);

        remove_filter('woocommerce_get_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundle_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundle_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_grouped_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundled_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_variation_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_variable_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_free_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);            //
        remove_filter('woocommerce_get_variation_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);

        remove_filter('woocommerce_product_is_on_sale', 'gpls_woo_rfqtk_product_is_on_sale', 1000, 2);
        remove_filter('woocommerce_bundle_is_on_sale', 'gpls_woo_rfqtk_product_is_on_sale', 1000, 2);

        remove_filter('woocommerce_get_variation_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);
        remove_filter('woocommerce_get_variation_sale_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);
        remove_filter('woocommerce_get_variation_regular_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);

        remove_filter('woocommerce_get_price_excluding_tax', 'gpls_woo_rfqtk_individual_price_hidden_tax', 1000, 3);//remove at checkout
        remove_filter('woocommerce_get_price_including_tax', 'gpls_woo_rfqtk_individual_price_hidden_tax', 1000, 3);//remove at checkout

        remove_filter('woocommerce_product_addons_option_price_raw', 'gpls_woo_rfqtk_product_addons_option_price_raw', 1000, 2);


    }
}


if (!function_exists('gpls_woo_rfq_woocommerce_RFQTK_purchase_only')) {
    function gpls_woo_rfq_woocommerce_RFQTK_purchase_only()
    {


        remove_filter('woocommerce_get_variation_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_cart_product_price', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('gpls_woo_rfq_get_price_hidden_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('gpls_woo_rfq_get_price_hidden_tax', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('gpls_woo_rfq_get_price_hidden_variation_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('gpls_woo_rfq_individual_price_hidden_variation_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('woocommerce_cart_item_subtotal', 'gpls_woo_rfq_hide_subtotal_price_function', 1000, 3);
        remove_filter('woocommerce_cart_item_subtotal', 'gpls_woo_rfq_hide_subtotal_price_function', 1000, 3);
        remove_filter('woocommerce_cart_subtotal', 'gpls_woo_rfqtk_hide_woocommerce_cart_subtotal', 1000, 3);
        remove_filter('woocommerce_cart_subtotal', 'gpls_woo_rfqtk_hide_woocommerce_cart_subtotal', 1000, 3);
        remove_filter('woocommerce_cart_tax_totals', 'gpls_woo_rfqtk_hide_tax_woocommerce_cart_subtotal', 1000, 2);
        remove_filter('woocommerce_cart_total', 'gpls_woo_rfqtk_hide_woocommerce_cart_total', 1000, 1);
        remove_filter('woocommerce_cart_total', 'gpls_woo_rfqtk_hide_woocommerce_cart_total', 1000, 1);
        remove_filter('woocommerce_order_formatted_line_subtotal', 'gpls_woo_rfqtk_order_formatted_line_subtotal', 100, 3);
        remove_filter('woocommerce_get_formatted_order_total', 'gpls_woo_rfqtk_get_formatted_order_total', 100, 2);
        remove_filter('woocommerce_get_order_item_totals', 'gpls_woo_rfqtk_woocommerce_get_order_item_totals', 100, 2);
        remove_filter('woocommerce_checkout_order_processed', 'gpls_woo_rfq_woocommerce_RFQTK_only_add_to_cart', 1000);

        remove_filter('woocommerce_product_addons_price_raw', 'gpls_woo_rfqtk_woocommerce_product_addons_price_raw', 1000, 2);
        remove_filter('woocommerce_product_addons_price', 'gpls_woo_rfqtk_woocommerce_product_addons_price', 1000, 4);

        remove_filter('woocommerce_display_item_meta', 'gpls_woo_rfq_pay_woocommerce_display_item_meta', 1000, 3);

        remove_filter('woocommerce_get_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundle_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundle_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_grouped_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundled_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_variation_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_variable_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_free_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);            //
        remove_filter('woocommerce_get_variation_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);

        remove_filter('woocommerce_product_is_on_sale', 'gpls_woo_rfqtk_product_is_on_sale', 1000, 2);
        remove_filter('woocommerce_bundle_is_on_sale', 'gpls_woo_rfqtk_product_is_on_sale', 1000, 2);

        remove_filter('woocommerce_get_variation_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);
        remove_filter('woocommerce_get_variation_sale_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);
        remove_filter('woocommerce_get_variation_regular_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);

        remove_filter('woocommerce_get_price_excluding_tax', 'gpls_woo_rfqtk_individual_price_hidden_tax', 1000, 3);//remove at checkout
        remove_filter('woocommerce_get_price_including_tax', 'gpls_woo_rfqtk_individual_price_hidden_tax', 1000, 3);//remove at checkout

        remove_filter('woocommerce_product_addons_option_price_raw', 'gpls_woo_rfqtk_product_addons_option_price_raw', 1000, 2);


        remove_action("woocommerce_add_to_cart", "gpls_woo_rfq_woocommerce_add_to_cart", PHP_INT_MAX - 1, 6);
        remove_filter('woocommerce_product_single_add_to_cart_text', array($GLOBALS["gpls_woo_rfq_cart"], 'woo_custom_cart_button_text'), 100, 2);
        remove_filter('woocommerce_product_add_to_cart_text', array($GLOBALS["gpls_woo_rfq_cart"], 'woo_custom_cart_button_text'), 100, 2);
        remove_filter('woocommerce_loop_add_to_cart_link', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_add_to_cart_link_shop'), -1000, 2);
        remove_action('woocommerce_after_add_to_cart_button', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_add_to_cart_button'), 1000);
        remove_action('woocommerce_before_add_to_cart_button', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_before_add_to_cart_button'), 1000);

        //remove_action('woocommerce_after_shop_loop_item', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_after_shop_loop_item'), 100);

        $hook = get_option('settings_gpls_woo_rfq_normal_checkout_quote_position', 'woocommerce_after_shop_loop_item');

        remove_action($hook, array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_after_shop_loop_item'), 100);

        remove_filter('woocommerce_cart_item_remove_link', 'gpls_woo_rfq_cart_item_remove_link', 100, 2);
        remove_action("woocommerce_after_cart", array($GLOBALS["gpls_woo_rfq_cart"], "gpls_woo_rfq_woocommerce_after_cart"), 1000);
        remove_action("woocommerce_after_cart_totals", array($GLOBALS["gpls_woo_rfq_cart"], "gpls_woo_rfq_woocommerce_after_cart"), 1000);
        remove_filter('woocommerce_product_add_to_cart_text', 'gpls_woo_rfqtk_woo_custom_cart_button_text', 2000, 2);
        remove_filter('woocommerce_product_single_add_to_cart_text', 'gpls_woo_rfqtk_woo_custom_cart_button_text', 2000, 2);


        remove_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_cart_needs_payment', 1000, 2);

        remove_filter('woocommerce_is_purchasable', 'gpls_woo_rfq_is_purchasable', 1000, 2);

        remove_filter('woocommerce_variation_is_purchasable', 'gpls_woo_rfq_is_purchasable', 1000, 2);

        remove_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_cart_needs_payment', 1000, 2);
        remove_filter('woocommerce_is_purchasable', 'gpls_woo_rfq_is_purchasable', 1000, 2);

        remove_filter('woocommerce_variation_is_purchasable', 'gpls_woo_rfq_is_purchasable', 1000, 2);

        remove_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_cart_needs_payment', 1000, 2);
        remove_filter('woocommerce_is_purchasable', 'gpls_woo_rfq_normal_is_purchasable', 1000, 2);
        remove_filter('woocommerce_variation_is_purchasable', 'gpls_woo_rfq_normal_is_purchasable', 1000, 2);

        remove_filter('woocommerce_is_purchasable', 'gpls_woo_rfq_is_purchasable', 1000, 2);

        remove_filter('woocommerce_variation_is_purchasable', 'gpls_woo_rfq_is_purchasable', 1000, 2);

        remove_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_cart_needs_payment', 1000, 2);

        remove_filter('woocommerce_is_purchasable', 'gpls_woo_rfq_normal_is_purchasable', 1000, 2);

        remove_filter('woocommerce_variation_is_purchasable', 'gpls_woo_rfq_normal_is_purchasable', 1000, 2);

        remove_filter('woocommerce_coupons_enabled', 'gpls_woo_rfq_woocommerce_coupons_enabled', 10, 1);

        remove_action('woocommerce_archive_description', 'gpls_woo_rfq_before_main_content', 100);

        remove_action('woocommerce_after_main_content', 'gpls_woo_rfq_before_main_content', 100);

        remove_action('woocommerce_before_cart', 'gpls_woo_rfq_before_main_content', 100);

        remove_action('woocommerce_before_single_product', 'gpls_woo_rfq_before_main_content', 100);

        remove_action('woocommerce_thankyou', 'gpls_woo_rfq_woocommerce_thankyou', 100, 1);
        remove_action('woocommerce_cart_emptied', 'gpls_woo_rfq_filter_check', 100);
        remove_action('gpls_woo_rfq_before_thankyou', 'gpls_woo_rfq_filter_check', 100);
        remove_filter('woocommerce_get_price_excluding_tax', 'gpls_woo_rfq_individual_price_hidden_tax', 1000, 3);//remove at checkout
        remove_filter('woocommerce_get_price_including_tax', 'gpls_woo_rfq_individual_price_hidden_tax', 1000, 3);//remove at checkout

        remove_filter('woocommerce_cart_totals_order_total_html', 'gpls_woo_rfq_total_prices', 1000);

        remove_filter('woocommerce_cart_item_price', 'gpls_woo_rfq_hide_cart_prices', 1000, 3);

        remove_filter('woocommerce_cart_product_price', 'gpls_woo_rfq_hide_woocommerce_cart_product_price', 1000, 2);

        remove_filter('woocommerce_cart_product_subtotal', 'gpls_woo_rfq_hide_woocommerce_cart_product_subtotal', 1000, 3);

        remove_filter('woocommerce_cart_item_subtotal', 'gpls_woo_rfq_hide_woocommerce_cart_item_subtotal', 1000, 3);

        remove_filter('woocommerce_cart_subtotal', 'gpls_woo_rfq_hide_woocommerce_cart_subtotal', 1000, 3);
        remove_filter('woocommerce_cart_totals_taxes_total_html', 'gpls_woo_rfq_total_prices');
        remove_filter('woocommerce_cart_totals_fee_html', 'gpls_woo_rfq_woocommerce_cart_totals_fee_html', 1000, 2);
        remove_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_woocommerce_order_needs_payment', 1000, 2);
        remove_filter('wc_add_to_cart_message_html', 'gpls_woo_rfq_remove_cart_notices', 1, 3);

        remove_action('woocommerce_before_calculate_totals', 'gpls_woo_rfq_remove_filters', -1000);

        remove_filter('woocommerce_cart_product_price', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_get_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_sale_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);


        remove_filter('woocommerce_bundle_sale_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundle_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_grouped_free_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundled_free_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);


        remove_filter('woocommerce_variation_free_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_variable_free_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_free_sale_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_free_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);            //
        remove_filter('woocommerce_get_variation_price_html', 'gpls_woo_rfq_individual_price_hidden_html', 1000, 2);

        remove_filter('woocommerce_product_is_on_sale', 'gpls_woo_rfq_product_is_on_sale', 1000, 2);
        remove_filter('woocommerce_bundle_is_on_sale', 'gpls_woo_rfq_product_is_on_sale', 1000, 2);

        remove_filter('woocommerce_get_variation_price', 'gpls_woo_rfq_individual_price_hidden_variation_html', 1000, 4);
        remove_filter('woocommerce_get_variation_sale_price', 'gpls_woo_rfq_individual_price_hidden_variation_html', 1000, 4);
        remove_filter('woocommerce_get_variation_regular_price', 'gpls_woo_rfq_individual_price_hidden_variation_html', 1000, 4);
        remove_filter('woocommerce_order_formatted_line_subtotal', 'gpls_woo_rfq_order_formatted_line_subtotal', 100, 3);
        remove_filter('woocommerce_get_formatted_order_total', 'gpls_woo_rfq_get_formatted_order_total', 100, 2);
        remove_filter('woocommerce_get_order_item_totals', 'gpls_woo_rfq_woocommerce_get_order_item_totals', 100, 2);

        //checkout

        remove_filter('woocommerce_get_order_item_totals', array($GLOBALS["gpls_woo_rfq_checkout"], 'gpls_woo_get_order_item_totals'));

        remove_action('woocommerce_before_checkout_form', array($GLOBALS["gpls_woo_rfq_checkout"], 'gpls_woo_woocommerce_before_checkout_form'), 100);

        remove_action('woocommerce_after_checkout_form', array($GLOBALS["gpls_woo_rfq_checkout"], 'gpls_woo_woocommerce_after_checkout_form'), 1000, 1);

        remove_filter('woocommerce_order_button_html', array($GLOBALS["gpls_woo_rfq_checkout"], 'gpls_woo_woocommerce_order_button_html'), 100, 1);

        remove_filter('woocommerce_thankyou_order_received_text', array($GLOBALS["gpls_woo_rfq_checkout"], 'gpls_woo_woocommerce_thankyou_order_received_text'), 100, 2);

        //remove_action('gpls_woo_create_an_account', 'gpls_woo_create_an_account_function', 10);
        remove_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_cart_needs_payment', 1000, 2);


        remove_action('init', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_setup_custom_css'), 100);
        remove_action('wp_loaded', array($GLOBALS['GPLS_WOO_RFQ'], 'check_for_rfq_checkout'), 1000);
        remove_action('woocommerce_before_checkout_process', 'gpls_woo_rfq_woocommerce_RFQ_only_add_to_cart', 1000);
        remove_action('init', 'gpls_woo_rfq_woocommerce_RFQ_load_payment_gateway', 1000);
        remove_action('wp_loaded', 'gpls_woo_rfq_order_recieved', 1000);

        remove_action('wp_loaded', 'gpls_rfq_update_rfq_cart', 1000);
        remove_action('wp_loaded', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_setup_menu'), 1000);
        remove_action('wp_footer', array($GLOBALS['GPLS_WOO_RFQ'], 'footer_action'), 1000);
        remove_action('wp_logout', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_logout'), 100);
        remove_action('init', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_4woo_quote_wp_init'), 1000);
        remove_action('init', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_setup_custom_css'), 100);
        remove_action('wp_loaded', array($GLOBALS['GPLS_WOO_RFQ'], 'check_for_rfq_checkout'), 1000);
        remove_action('woocommerce_before_checkout_process', 'gpls_woo_rfq_woocommerce_RFQ_only_add_to_cart', 1000);
        remove_action('init', 'gpls_woo_rfq_woocommerce_RFQ_load_payment_gateway', 1000);//
        remove_action('wp_loaded', 'gpls_woo_rfq_order_recieved', 1000);
        // remove_action('wp_loaded', 'gpls_rfq_remove_rfq_cart_item', 1000);
        // remove_action('wp_loaded', 'gpls_rfq_update_rfq_cart', 1000);
        remove_action('wp_footer', array($GLOBALS['GPLS_WOO_RFQ'], 'footer_action'), 1000);
        remove_action('wp_logout', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_logout'), 100);
        remove_action('wp_enqueue_scripts', 'gpls_woo_add_rfq_cart_custom_css', 1000);
        remove_action('wp_enqueue_scripts', 'gpls_woo_add_rfq_mode_remove_subtotals_custom_css', 1000);
        remove_action('wp_enqueue_scripts', 'gpls_woo_add_rfq_cart_custom_js', 1000);
        remove_action('wp_enqueue_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_scripts'), 2000);
        remove_action('wp_print_footer_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_footer_scripts'), 2000);
        remove_action('wp_enqueue_scripts', 'rfq_cart_wordings_ajax_added_to_cart', 1000);
        remove_action('wp_print_scripts', 'rfq_cart_wordings_ajax_added_to_cart', 1000);
        remove_action('wp_print_footer_scripts', 'rfq_cart_wordings_ajax_added_to_cart', 1000);
        //TODO cart
        remove_action("woocommerce_add_to_cart", "gpls_woo_rfq_woocommerce_add_to_cart", PHP_INT_MAX - 1, 6);

        remove_filter('woocommerce_product_single_add_to_cart_text', array($GLOBALS["gpls_woo_rfq_cart"], 'woo_custom_cart_button_text'), 100, 2);
        remove_filter('woocommerce_product_add_to_cart_text', array($GLOBALS["gpls_woo_rfq_cart"], 'woo_custom_cart_button_text'), 100, 2);
        remove_filter('woocommerce_loop_add_to_cart_link', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_add_to_cart_link_shop'), -1000, 2);
        remove_action('woocommerce_after_add_to_cart_button', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_add_to_cart_button'), 1000);
        remove_action('woocommerce_before_add_to_cart_button', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_before_add_to_cart_button'), 1000);

        //remove_action('woocommerce_after_shop_loop_item', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_after_shop_loop_item'), 100);

        $hook = get_option('settings_gpls_woo_rfq_normal_checkout_quote_position', 'woocommerce_after_shop_loop_item');

        remove_action($hook, array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_after_shop_loop_item'), 100);

        remove_filter('woocommerce_cart_item_remove_link', 'gpls_woo_rfq_cart_item_remove_link', 100, 2);
        remove_action("woocommerce_after_cart", array($GLOBALS["gpls_woo_rfq_cart"], "gpls_woo_rfq_woocommerce_after_cart"), 1000);
        remove_action("woocommerce_after_cart_totals", array($GLOBALS["gpls_woo_rfq_cart"], "gpls_woo_rfq_woocommerce_after_cart"), 1000);
        remove_action('wp_print_footer_scripts', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_ajax_add_to_quote_print_script'), 1000);
        remove_action('wp_print_footer_scripts', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_ajax_add_to_rfq_single_page'), 100);
        remove_action('init', 'gpls_woo_rfq_print_script', -1000);
        //remove_filter('woocommerce_add_cart_item_data', array($GLOBALS, 'gpls_woo_rfq_add_cart_item_data'), 1000, 3);
        remove_action("gpls_woo_rfq_before_cart", array($GLOBALS, "gpls_woo_rfq_cart_before_cart"), 1000);
        remove_filter('woocommerce_widget_cart_is_hidden', array($GLOBALS, 'filter_woocommerce_widget_cart_is_hidden'), 1000, 1);
        remove_action('wp_print_footer_scripts', 'gpls_woo_rfq_print_script', 1000);
        remove_action('wp_add_inline_script', 'gpls_woo_rfq_print_script', 1000);
        remove_action('wp_enqueue_script', 'gpls_woo_rfq_print_script', 1000);
        remove_action('woocommerce_after_calculate_totals', 'gplsrfqtk_after_calculate_totals', 1000, 1);
        remove_action('wp_print_footer_scripts', 'gpls_woo_rfq_print_script_show_single_add', 1000);


    }
}


function gpls_woo_rfq_purchase_only_proceed_to_checkout($proceed_to_rfq)
{


    $change_txt = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_cart_alt_label', 'Proceed to Checkout');

    if ($change_txt == '') {
        return $proceed_to_rfq;
    }

    $proceed_to_rfq_alt = __($change_txt, 'rfqtk');

    return $proceed_to_rfq;
}


function gpls_woo_rfq_purchase_only_submit_rfq($order_button_text)
{

    $change_txt = get_option('settings_gpls_woo_rfq_gpls_woo_rfq_purchase_only_checkout_alt_label', '');

    if ($change_txt == '') {
        return $order_button_text;
    }

    $order_button_text_alt = __($change_txt, 'rfqtk');

    return $order_button_text_alt;
}


function gpls_woo_rfq_purchase_only()
{

    if (!is_admin()) {

        gpls_woo_rfq_cart_delete('gpls_woo_rfq_purchase_only');

        ip_based_options();

        gpls_woo_rfq_woocommerce_RFQTK_purchase_only();

        if (isset($GLOBALS['GPLS_WOO_RFQ'])) {
            remove_action('wp_enqueue_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_scripts'), 2000);
            remove_action('wp_print_footer_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_footer_scripts'), 2000);
        }

        remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
        add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_only_purchase', 2000, 1);

        if (!function_exists('gpls_woo_rfq_get_item')) {
            require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
            require_once(ABSPATH . 'wp-includes/class-phpass.php');
            $wp_session = gpls_woo_get_session();


        }


        gpls_woo_rfq_cart_set('gpls_woo_rfq_purchase_only', 'yes');

    }
}

function gpls_woo_rfq_purchase_or_quote()
{
    if (!is_admin()) {

        gpls_woo_rfq_cart_delete('gpls_woo_rfq_purchase_only');

        ip_based_options();

        remove_action("woocommerce_add_to_cart", "gpls_woo_rfq_woocommerce_add_to_cart", PHP_INT_MAX - 1, 6);

        remove_filter('woocommerce_product_single_add_to_cart_text', array($GLOBALS["gpls_woo_rfq_cart"], 'woo_custom_cart_button_text'), 100, 2);
        remove_filter('woocommerce_product_add_to_cart_text', array($GLOBALS["gpls_woo_rfq_cart"], 'woo_custom_cart_button_text'), 100, 2);
        remove_filter('woocommerce_loop_add_to_cart_link', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_add_to_cart_link_shop'), -1000, 2);
        remove_action('woocommerce_after_add_to_cart_button', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_add_to_cart_button'), 1000);
        remove_action('woocommerce_before_add_to_cart_button', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_before_add_to_cart_button'), 1000);


        //remove_action('woocommerce_after_shop_loop_item', array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_after_shop_loop_item'), 100);

        $hook = get_option('settings_gpls_woo_rfq_normal_checkout_quote_position', 'woocommerce_after_shop_loop_item');

        remove_action($hook, array($GLOBALS["gpls_woo_rfq_cart"], 'gpls_woo_rfq_after_after_shop_loop_item'), 100);

        remove_filter('woocommerce_cart_item_remove_link', 'gpls_woo_rfq_cart_item_remove_link', 100, 2);
        remove_action("woocommerce_after_cart", array($GLOBALS["gpls_woo_rfq_cart"], "gpls_woo_rfq_woocommerce_after_cart"), 1000);
        remove_action("woocommerce_after_cart_totals", array($GLOBALS["gpls_woo_rfq_cart"], "gpls_woo_rfq_woocommerce_after_cart"), 1000);
        remove_filter('woocommerce_product_add_to_cart_text', 'gpls_woo_rfqtk_woo_custom_cart_button_text', 2000, 2);
        remove_filter('woocommerce_product_single_add_to_cart_text', 'gpls_woo_rfqtk_woo_custom_cart_button_text', 2000, 2);

        gpls_woo_rfq_woocommerce_RFQTK_purchase_only();


        remove_action('wp_enqueue_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_scripts'), 2000);
        remove_action('wp_print_footer_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_footer_scripts'), 2000);


        remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);

        if (!function_exists('gpls_woo_rfq_get_item')) {
            require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
            require_once(ABSPATH . 'wp-includes/class-phpass.php');
            $wp_session = gpls_woo_get_session();


        }


        gpls_woo_rfq_cart_set('gpls_woo_rfq_purchase_only', 'yes');

    }
}


function is_gpls_woo_rfq_purchase_only()
{

// role based just buy
    $checkout_option = "";


    if (isset($GLOBALS["gpls_woo_rfq_checkout_option"])) {
        $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];
    }

    $in_role = true;

    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "no") return;

    if ($enable_roles != "no" && !is_user_logged_in()) {
        $in_role = false;
    }

    if ($enable_roles != "no" && is_user_logged_in()) {

        $in_role = false;

        $user = wp_get_current_user();

        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;

            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);
        // $in_role=apply_filters('rfqtk_is_in_role',$in_role,$user);

    }


    if ($checkout_option == 'rfq' && $in_role == true
        && get_option('settings_gpls_woo_rfq_plus_normal_checkout', 'no') == 'no'
        && (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'yes'
            || get_option('settings_gpls_woo_rfq_show_prices_everywhere', 'no') == 'yes')
    ) {
        gpls_woo_rfq_purchase_only();
    }
}

add_action('init', 'is_gpls_woo_rfq_purchase_only', 1);


function gpls_woo_rfq_valid_order_statuses_for_payment($array, $order)
{

    array_push($array, 'gplsquote-sent');
    array_push($array, 'wc-gplsquote-req');

    return $array;
}


function gpls_woo_rfq_plus_filter_address_fields($address_fields)
{
    // Only on checkout page

    if (is_admin() || !function_exists('WC') || WC()->cart == null) return $address_fields;

    $gpls_woo_rfq_purchase_only = gpls_woo_rfq_get_item('gpls_woo_rfq_purchase_only');
    if ($gpls_woo_rfq_purchase_only == "yes") {
        return $address_fields;
    }
    global $woocommerce;

    $customField = false;

    $checkout_option = get_option('settings_gpls_woo_rfq_checkout_option');

    $allow_other_options = get_option('settings_gpls_woo_rfq_plus_normal_checkout');

    $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

    $items = WC()->cart->get_cart();

    $has_rfq = false;

    foreach ($items as $item => $values) {

        $_product = wc_get_product($values['product_id']);

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == 'yes') {
            $has_rfq = true;
            break;
        }
    }


    if ($checkout_option == "rfq" && $allow_other_options == "yes" && $settings_gpls_woo_rfq_limit_to_rfq_only == "yes"
        && $has_rfq == true) {

        if (!is_admin()) {
            $customField = true;
        }

    }

    if ($checkout_option == "rfq" && $allow_other_options == "no") {

        if (!is_admin()) {
            $customField = true;
        }

    }

    $specific_gateway = 'gpls-rfq';

    WC()->initialize_session();

    $chosen_method = WC()->session->get('chosen_payment_method');

    if ($chosen_method == $specific_gateway) {
        $customField = true;
    }

    if ($customField) {

        $phone_required = get_option('rfq_cart_sc_section_rfq_page_phone_optional_rfq');

        if ($phone_required != 'yes') {
            $address_fields['phone']['required'] = false;
            unset($address_fields['phone']['required']);

        }

        $rfq_cart_sc_section_rfq_page_company_required = get_option('rfq_cart_sc_section_rfq_page_company_optional_rfq');

        if ($rfq_cart_sc_section_rfq_page_company_required == 'yes') {

            $address_fields['company']['required'] = false;
            unset($address_fields['company']['required']);
        }

        $rfq_cart_sc_section_rfq_page_country_required = get_option('rfq_cart_sc_section_rfq_page_country_optional_rfq');

        if ($rfq_cart_sc_section_rfq_page_country_required == 'yes') {
            $address_fields['country']['required'] = false;
            unset($address_fields['country']['required']);
        }


        $rfq_cart_sc_section_rfq_page_state_required = get_option('rfq_cart_sc_section_rfq_page_state_optional_rfq');

        if ($rfq_cart_sc_section_rfq_page_state_required == 'yes') {

            $address_fields['state']['required'] = false;
            unset($address_fields['state']['required']);

        }

        $rfq_cart_sc_section_rfq_page_address_required = get_option('rfq_cart_sc_section_rfq_page_address_optional_rfq');

        if ($rfq_cart_sc_section_rfq_page_address_required == 'yes') {

            $address_fields['address_1']['required'] = false;
            unset($address_fields['address_1']['required']);

            $address_fields['address_2']['required'] = false;
            unset($address_fields['address_2']['required']);
        }

        $rfq_cart_sc_section_rfq_page_city_required = get_option('rfq_cart_sc_section_rfq_page_city_optional_rfq');

        if ($rfq_cart_sc_section_rfq_page_city_required == 'yes') {

            $address_fields['city']['required'] = false;
            unset($address_fields['city']['required']);
        }


        $rfq_cart_sc_section_rfq_page_zip_required = get_option('rfq_cart_sc_section_rfq_page_zip_optional_rfq');

        if ($rfq_cart_sc_section_rfq_page_zip_required === 'yes') {
            $address_fields['postcode']['required'] = false;
            unset($address_fields['postcode']['required']);

        }

    }

    return $address_fields;
}

function gpls_woo_rfq_plus_Woo_checkout($fields)
{


    if (is_admin() || !function_exists('WC') || WC() == null || WC()->cart == null) return $fields;

    $gpls_woo_rfq_purchase_only = gpls_woo_rfq_get_item('gpls_woo_rfq_purchase_only');

    if ($gpls_woo_rfq_purchase_only == "yes") {
        return $fields;
    }

    $customField = false;


    global $woocommerce;


    $checkout_option = get_option('settings_gpls_woo_rfq_checkout_option');
    $allow_other_options = get_option('settings_gpls_woo_rfq_plus_normal_checkout');

    $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

    $items = WC()->cart->get_cart();

    $has_rfq = false;

    foreach ($items as $item => $values) {


        $_product = wc_get_product($values['product_id']);

        // $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == 'yes') {
            $has_rfq = true;
            break;
        }
    }


    if ($checkout_option == "rfq" && $allow_other_options == "yes" && $settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq == true) {

        if (!is_admin()) {
            $customField = true;
        }

    }

    if ($checkout_option == "rfq" && $allow_other_options == "no") {

        if (!is_admin()) {
            $customField = true;
        }

    }

    $specific_gateway = 'gpls-rfq';

    WC()->initialize_session();

    $chosen_method = WC()->session->get('chosen_payment_method');

    if ($chosen_method == $specific_gateway) {
        $customField = true;
    }


    if ($customField) {
        $phone_required = get_option('rfq_cart_sc_section_rfq_page_phone_hide_rfq');

        if ($phone_required == 'yes') {
//jQuery('#rfq_phone').attr("required",false);

            unset($fields['billing']['billing_phone']);
            unset($fields['shipping']['shipping_phone']);
        }

        $rfq_cart_sc_section_rfq_page_company_required = get_option('rfq_cart_sc_section_rfq_page_company_hide_rfq');

        if ($rfq_cart_sc_section_rfq_page_company_required == 'yes') {

            unset($fields['billing']['billing_company']);
            unset($fields['shipping']['shipping_company']);
        }

        $rfq_cart_sc_section_rfq_page_country_required = get_option('rfq_cart_sc_section_rfq_page_country_hide_rfq');

        if ($rfq_cart_sc_section_rfq_page_country_required == 'yes') {

            unset($fields['billing']['billing_country']);
            unset($fields['shipping']['shipping_country']);
        }


        $rfq_cart_sc_section_rfq_page_state_required = get_option('rfq_cart_sc_section_rfq_page_state_hide_rfq');

        if ($rfq_cart_sc_section_rfq_page_state_required == 'yes') {

            unset($fields['billing']['billing_state']);
            unset($fields['shipping']['shipping_state']);

        }

        $rfq_cart_sc_section_rfq_page_address_required = get_option('rfq_cart_sc_section_rfq_page_address_hide_rfq');

        if ($rfq_cart_sc_section_rfq_page_address_required == 'yes') {

            unset($fields['billing']['billing_address_1']);
            unset($fields['billing']['billing_address_2']);

            unset($fields['shipping']['shipping_address_1']);
            unset($fields['shipping']['shipping_address_2']);

        }

        $rfq_cart_sc_section_rfq_page_city_required = get_option('rfq_cart_sc_section_rfq_page_city_hide_rfq');

        if ($rfq_cart_sc_section_rfq_page_city_required == 'yes') {

            unset($fields['billing']['billing_city']);
            unset($fields['shipping']['shipping_city']);

        }


        $rfq_cart_sc_section_rfq_page_zip_required = get_option('rfq_cart_sc_section_rfq_page_zip_hide_rfq');

        if ($rfq_cart_sc_section_rfq_page_zip_required == 'yes') {
            unset($fields['billing']['billing_postcode']);
            unset($fields['shipping']['shipping_postcode']);

        }

    }
    return $fields;
}


// Remove billing phone (and set email field class to wide)

function gpls_woo_rfq_plus_remove_billing_phone_field($fields)
{


    if (is_admin() || !function_exists('WC') || WC() == null || WC()->cart == null) return $fields;

    global $woocommerce;
    $gpls_woo_rfq_purchase_only = gpls_woo_rfq_get_item('gpls_woo_rfq_purchase_only');
    if ($gpls_woo_rfq_purchase_only == "yes") {
        return $fields;
    }

    $phone_required = get_option('rfq_cart_sc_section_rfq_page_phone_optional_rfq');

    if ($phone_required != 'yes') {
        return $fields;
    }


    $customField = false;


    $checkout_option = get_option('settings_gpls_woo_rfq_checkout_option');
    $allow_other_options = get_option('settings_gpls_woo_rfq_plus_normal_checkout');

    $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

    $items = WC()->cart->get_cart();

    $has_rfq = false;

    foreach ($items as $item => $values) {


        $_product = wc_get_product($values['product_id']);

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == 'yes') {
            $has_rfq = true;
            break;
        }
    }


    if ($checkout_option == "rfq" && $allow_other_options == "yes" && $settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq == true) {

        if (!is_admin()) {
            $customField = true;
        }

    }

    if ($checkout_option == "rfq" && $allow_other_options == "no") {

        if (!is_admin()) {
            $customField = true;
        }

    }


    $specific_gateway = 'gpls-rfq';

    WC()->initialize_session();

    $chosen_method = WC()->session->get('chosen_payment_method');

    if ($chosen_method == $specific_gateway) {
        $customField = true;
    }


    if ($customField) {

        $fields ['billing_phone']['required'] = false; // To be sure "NOT required"

        $fields['billing_email']['class'] = array('form-row-wide'); // Make the field wide

        //      unset($fields ['billing_phone']); // Remove billing phone field
    }
    return $fields;
}

// Remove shipping phone (optional)

function gpls_woo_rfq_plus_remove_shipping_phone_field($fields)
{

    if (is_admin() || !function_exists('WC') || WC() == null || WC()->cart == null) return $fields;

    global $woocommerce;
    $gpls_woo_rfq_purchase_only = gpls_woo_rfq_get_item('gpls_woo_rfq_purchase_only');

    if ($gpls_woo_rfq_purchase_only == "yes") {
        return $fields;
    }

    $phone_required = get_option('rfq_cart_sc_section_rfq_page_phone_optional_rfq');

    if ($phone_required != 'yes') {
        return $fields;
    }

    $customField = false;


    $checkout_option = get_option('settings_gpls_woo_rfq_checkout_option');
    $allow_other_options = get_option('settings_gpls_woo_rfq_plus_normal_checkout');

    $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

    $items = WC()->cart->get_cart();

    $has_rfq = false;

    foreach ($items as $item => $values) {

        $_product = wc_get_product($values['product_id']);

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == 'yes') {
            $has_rfq = true;
            break;
        }
    }


    if ($checkout_option == "rfq" && $allow_other_options == "yes" && $settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq == true) {

        if (!is_admin()) {
            $customField = true;
        }

    }

    if ($checkout_option == "rfq" && $allow_other_options == "no") {

        if (!is_admin()) {
            $customField = true;
        }

    }


    $specific_gateway = 'gpls-rfq';

    WC()->initialize_session();

    $chosen_method = WC()->session->get('chosen_payment_method');

    if ($chosen_method == $specific_gateway) {
        $customField = true;
    }


    if ($customField) {

        $fields ['shipping_phone']['required'] = false; // To be sure "NOT required"

//    unset( $fields ['shipping_phone'] ); // Remove shipping phone field
    }
    return $fields;
}


function gpls_woo_rfq_plus_remove_field_on_change()
{


    echo "<script>
	jQuery(function($){

		$('body').on('change', 'input[name=\"payment_method\"]', function(){		
		      jQuery(document.body).trigger('update_checkout');
		});
		
	});</script>";
}

function gpls_woo_rfq_after_normal_checkout_function($order_id)
{


    require_once(gpls_woo_rfq_plus_DIR . 'includes/emails/email_functions.php');
    $GLOBALS["rfqtk_email_functions"] = new rfqtk_email_functions();

    $order = wc_get_order($order_id);


    $url = get_option('rfq_cart_sc_section_show_link_to_thankyou_page', '');

    if ($url != '' && $order->get_status() == 'gplsquote-req' && !$order->has_status('failed')) {
        wp_safe_redirect($url . '?cthx=gpls & order_id=' . $order_id);
        exit;
    }

    $status = $order->get_status();
    if ($status != 'gplsquote-req' && $status != 'wc-gplsquote-req'
        && $status != 'wc-gplsquote-sent' && $status != 'gplsquote-sent') {
        return;
    }


    $show_stock_thankyou_confirmation = get_option('gpls_woo_rfq_customer_confirmation_stock_thankyou_page', 'no');
    $show_product_thankyou_confirmation = get_option('gpls_woo_rfq_customer_confirmation_product_thankyou_page', 'no');

    if ($show_stock_thankyou_confirmation == 'yes') {

        gpls_woo_rfq_plus_thankyou_confirmation_stock_messages($order_id);

    }
    if ($show_product_thankyou_confirmation == 'yes') {

        gpls_woo_rfq_plus_thankyou_confirmation_product_messages($order_id);

    }


}


if (!function_exists('gpls_woo_rfq_order_needs_shipping')) {
    function gpls_woo_rfq_order_needs_shipping($order_id)
    {

        $order = new WC_Order($order_id);
        foreach ($order->get_items() as $order_item) {

            $product = wc_get_product($order_item->get_product_id());

            if ($product->get_type() == 'variable') {
                $variation_id = $order_item->get_variation_id();

                $variation = new WC_Product_Variation($variation_id);
                if ($variation->needs_shipping() && !$variation->is_virtual() && !$variation->is_downloadable()) {
                    return true;

                }
            } else {
                if ($product->needs_shipping() && !$product->is_virtual() && !$product->is_downloadable()) {
                    return true;
                }
            }

        }

        return false;
    }
}

if (!function_exists('gpls_woo_rfq_is_view_order_page')) {
    function gpls_woo_rfq_is_view_order_page()
    {
        global $wp;

        $current_page = gpls_woo_rfq_remove_http((trim(preg_replace('{/$}', '', (get_site_url()) . $_SERVER['REQUEST_URI']))));
        $page_id = wc_get_page_id('myaccount');
        $perma_link = gpls_woo_rfq_remove_http(wc_get_page_permalink('myaccount'));
        $result = (gpls_woo_rfq_plus_startsWith($current_page, $perma_link) && isset($wp->query_vars['view-order']));

        return $result;
    }
}


if (!function_exists('gpls_woo_rfq_get_client_ip')) {
    function gpls_woo_rfq_get_client_ip()
    {
        if (isset($_SERVER['HTTP_X_REAL_IP'])) {
            return sanitize_text_field(wp_unslash($_SERVER['HTTP_X_REAL_IP']));
        } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            return (string)rest_is_ip_address(trim(current(preg_split('/,/', sanitize_text_field(wp_unslash($_SERVER['HTTP_X_FORWARDED_FOR']))))));
        } elseif (isset($_SERVER['REMOTE_ADDR'])) {
            return sanitize_text_field(wp_unslash($_SERVER['REMOTE_ADDR']));
        }
        return false;
    }

}
if (!function_exists('gpls_woo_rfq_get_rfq_cart_quantity')) {
    function gpls_woo_rfq_get_rfq_cart_quantity()
    {
        $wp_session = gpls_woo_get_session();

        $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');
        $total_quantity = 0;
        if (is_array($gpls_woo_rfq_cart)) {
            foreach ($gpls_woo_rfq_cart as $cart_item_key => $cart_item) {
                $total_quantity = $total_quantity + $cart_item['quantity'];
            }
        }


        return $total_quantity;
    }
}


if (!function_exists('gpls_mini_page_extracted')) {
    function gpls_mini_page_extracted(): array
    {


        $nonce = wp_create_nonce('gpls_woo_rfq_handle_rfq_cart_nonce');

        $hide_quote = get_option("settings_gpls_woo_rfq_hide_quote_cart", "yes");

        if ($hide_quote === "yes") {
            $display = "none";
        } else {
            $display = "block";
        }

        $gpls_woo_rfq_styles['gpls_woo_rfq_page_update_button_background_onmouseover'] = '';
        $gpls_woo_rfq_styles['gpls_woo_rfq_page_update_button_onmouseout'] = '';
        $gpls_woo_rfq_styles['gpls_woo_rfq_page_update_button_background_onmouseout'] = '';
        $gpls_woo_rfq_styles['gpls_woo_rfq_page_update_button_styles'] = '';
        $gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_styles'] = '';
        $gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_background_onmouseover'] = '';
        $gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_onmouseover'] = '';
        $gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_onmouseout'] = '';
        $gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_background_onmouseout'] = '';
        $gpls_woo_rfq_styles['gpls_woo_rfq_page_update_button_onmouseover'] = '';


        $gpls_woo_rfq_styles = apply_filters('gpls_woo_rfq_before_cart_gpls_woo_rfq_styles', $gpls_woo_rfq_styles);
        return array($nonce, $display, $gpls_woo_rfq_styles);
    }
}

if (!function_exists('rfqtk_redirect_after_add_quote_script')) {
    function rfqtk_redirect_after_add_quote_script()
    {
        $url_js = gpls_woo_rfq_plus_URL . 'assets/js/single_product.js';
        $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/single_product.js';
        wp_enqueue_script('gpls_woo_rfq_plus_single_product_js', $url_js, array('jquery'), rand(10, 100000), true);

        global $product;
        //  WC()->init();
        $return = false;

        if (!is_object($product) && !function_exists('wc_get_product')) {
            $return = true;;
        }

        if (!is_object($product)) $product = wc_get_product(get_the_ID());

        if (!isset($product) || !is_object($product) || $product->get_type() == 'external') {
            $return = true;;
        }

        if ($return) {
            wp_localize_script('gpls_woo_rfq_plus_single_product_js', 'gpls_woo_rfq_plus_single_product_js_vars', array(
                    'view_your_cart_text' => '', 'replacetext' => false,
                    'link_to_rfq_page' => '')
            );
            return false;
        }


        $link_to_rfq_page = pls_woo_rfq_get_link_to_rfq();

        //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        $rfq_check = false;
        $normal_check = false;

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
            add_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_cart_needs_payment', 1000, 2);

            $rfq_check = true;
            $normal_check = false;

            if (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'yes') {
                $rfq_check = false;
                $normal_check = true;
            }
        }

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "normal_checkout") {
            $rfq_check = false;
            $normal_check = true;
        }

        if (function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $rfq_check = true;
                $normal_check = false;

            }
        }
        $view_your_cart_text = get_option('rfq_cart_wordings_view_rfq_cart', __('View List', 'rfqtk'));
        $view_your_cart_text = __($view_your_cart_text, 'rfqtk');
        $view_your_cart_text = apply_filters('gpls_woo_rfq_request_quote_text', $view_your_cart_text);

        if ($normal_check && $rfq_enable == 'yes') {


            $replacetext = true;

        } else {

            $replacetext = false;

        }

        wp_localize_script('gpls_woo_rfq_plus_single_product_js', 'gpls_woo_rfq_plus_single_product_js_vars', array(
                'view_your_cart_text' => $view_your_cart_text, 'replacetext' => $replacetext,
                'link_to_rfq_page' => $link_to_rfq_page)
        );
        return true;
    }
}

if (!function_exists('rfqtk_use_stock_status_for_quote_exclusive')) {
    function rfqtk_use_stock_status_for_quote_exclusive()
    {
        add_filter('gpls_rfq_enable', 'rfqtk_use_stock_status_for_quote_function_exclusive', 100, 2);
    }
}


if (!function_exists('rfqtk_use_stock_status_for_quote_function_exclusive')) {
    function rfqtk_use_stock_status_for_quote_function_exclusive($rfq_enable, $product_id)
    {
        try {
            $product = wc_get_product($product_id);

            if ($product->managing_stock() && $product && 'onbackorder' === $product->get_stock_status()) {
                return "yes";
            }

            return "no";
        } catch (Exception $ex) {
            np_write_log($ex, __FILE__, __LINE__);
            return $rfq_enable;
        }

    }
}

if (!function_exists('rfqtk_use_stock_status_for_quote')) {
    function rfqtk_use_stock_status_for_quote()
    {
        add_filter('gpls_rfq_enable', 'rfqtk_use_stock_status_for_quote_function', 100, 2);
    }
}

if (!function_exists('rfqtk_use_stock_status_for_quote_function')) {
    function rfqtk_use_stock_status_for_quote_function($rfq_enable, $product_id)
    {

        try {
            $product = wc_get_product($product_id);

            if ($product && 'onbackorder' === $product->get_stock_status()) {
                return "yes";
            }

            return $rfq_enable;
        } catch (Exception $ex) {
            np_write_log($ex, __FILE__, __LINE__);
            return $rfq_enable;
        }
    }
}

function gpls_woo_rfq_quickview_xoo_qv()
{
    $product_id = get_the_ID();
    $hide = hide_add_to_cart_qv_list($product_id);


    if ($hide) {

        $rfq_product_script_xoo = "<script>

jQuery(document).ajaxComplete(function (event, xhr, options) {
   
     jQuery( '.single_add_to_cart_button' ).hide();
     jQuery( '.single-product div.product p.price' ).hide();
     
     jQuery( '.gpls_rfq_set' ).show();
});
     </script>";

        //echo $rfq_product_script;
        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    } else {
        $rfq_product_script_xoo = "<script>
jQuery(document).ajaxComplete(function (event, xhr, options) {
   
     
     jQuery( '.gpls_rfq_set' ).hide();
     jQuery( '.single-product div.product p.price' ).show();
     jQuery( '.single_add_to_cart_button' ).show();
     
});
     </script>";


        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    }
}

function gpls_woo_rfq_quickview_wcqv_product_data()
{
    $product_id = get_the_ID();
    $hide = hide_add_to_cart_qv_list($product_id);


    if ($hide) {

        $rfq_product_script_xoo = "<script>

jQuery(document).ajaxComplete(function (event, xhr, options) {
   
     jQuery( 'form.cart .button.single_add_to_cart_button' ).hide();
     jQuery( '.product p.price' ).hide();
     
     jQuery( 'form.cart .button.gpls_rfq_set' ).show();
});
     </script>";

        //echo $rfq_product_script;
        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    } else {
        $rfq_product_script_xoo = "<script>
jQuery(document).ajaxComplete(function (event, xhr, options) {
   
    jQuery( 'form.cart .button.single_add_to_cart_button' ).show();
     jQuery( '.product p.price' ).show();
     
     jQuery( 'form.cart .button.gpls_rfq_set' ).hide();
});
     </script>";


        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    }
}

function gpls_woo_rfq_quickview_lightbox()
{
    $product_id = get_the_ID();
    $hide = hide_add_to_cart_qv_list($product_id);


    if ($hide) {

        $rfq_product_script_xoo = "<script>

jQuery('.wpb_wl_preview').on('click',function () {

     jQuery( '.single_add_to_cart_button' ).hide();
     jQuery( '.price' ).hide();
     
     jQuery( '.gpls_rfq_set' ).show();
});
     </script>";

        //echo $rfq_product_script;
        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    } else {
        $rfq_product_script_xoo = "<script>
jQuery(document).ajaxComplete(function (event, xhr, options) {
   
  jQuery( '.single_add_to_cart_button' ).show();
     jQuery( '.price' ).show();
     
     jQuery( '.gpls_rfq_set' ).hide();
});
     </script>";


        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    }
}

function astra_quickview_wc()
{
    $product_id = get_the_ID();
    $hide = hide_add_to_cart_qv_list($product_id);


    if ($hide) {

        $rfq_product_script_xoo = "<style>.single_add_to_cart_button{display:none !important ;}
.gpls_rfq_set{display:block   !important;}</style>";
        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    } else {
        $rfq_product_script_xoo = "<style>.single_add_to_cart_button{display:block   !important;}
.gpls_rfq_set{display:none  !important;}</style>";
        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    }
}

function gpls_woo_rfq_quickview_wc()
{
    $product_id = get_the_ID();
    $hide = hide_add_to_cart_qv_list($product_id);


    if ($hide) {

        $rfq_product_script_xoo = "<style>.single_add_to_cart_button{display:none !important ;}
.gpls_rfq_set{display:block   !important;}</style>";
        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    } else {
        $rfq_product_script_xoo = "<style>.single_add_to_cart_button{display:block   !important;}
.gpls_rfq_set{display:none  !important;}</style>";
        echo "<div class='gpls_script' style='display: none'>" . $rfq_product_script_xoo . "</div>";
    }
}

if (!function_exists('hide_add_to_cart_qv_list')) {
    function hide_add_to_cart_qv_list($product_id)
    {

        $hide_add_to_cart = get_post_meta($product_id, '_gpls_woo_rfq_no_add_to_cart', true);
        $hide_add_to_cart = apply_filters('gpls_no_add_to_cart', $hide_add_to_cart, $product_id);

        $qv = get_option('rfq_cart_sc_section_hide_add_to_cart_quickview', 'no') == 'yes';
        if (!$qv) {
            $qv = 'no';
        } else {
            $qv = "yes";
        };

        //  $rfq_enable = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product_id);

        $product = wc_get_product($product_id);

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if (($qv == "yes" && $rfq_enable == "yes") || (!empty($hide_add_to_cart) && $hide_add_to_cart == "yes")) {
            return true;
        } else {


            return false;
        }
    }
}


if (!function_exists('gpls_woo_rfq_quickview_astra')) {
    function gpls_woo_rfq_quickview_astra($button, $label, $product)
    {

        //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if ($rfq_enable == "yes") {
            return '';
        } else {
            return $button;
        };
    }
}
if (!function_exists('gpls_woo_rfq_quickview_astra_image_click')) {
    function gpls_woo_rfq_quickview_astra_image_click($button, $product)
    {

        //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if ($rfq_enable == "yes") {
            return '';
        } else {
            return $button;
        };
    }
}

if (!function_exists('gpls_woo_rfq_add_to_cart_no_mix_validation')) {
    function gpls_woo_rfq_add_to_cart_no_mix_validation($passed, $product_id, $quantity, $variation_id = null, $variations = null)
    {

        // Set variable
        $cart_is_quote = false;
        $product_is_quote = false;
        $flag = false;


        // $product_is_quote = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);
        // $product_id_title = wc_get_product($product_id)->get_title();

        $_product = wc_get_product($product_id);

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        foreach (WC()->cart->get_cart() as $cart_item) {


            $_product_cart_item = wc_get_product($cart_item['product_id']);
            //   $rfq_enable = get_post_meta($cart_item['product_id'], '_gpls_woo_rfq_rfq_enable', true);

            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product_cart_item);


            if ($rfq_enable == "yes") {
                $cart_is_quote = true; // Set to true
                break; // Stop the loop
            }
        }

        if (!WC()->cart->is_empty()) {
            if ($product_is_quote != $cart_is_quote) {
                $flag = false;
            }
        }
        // True
        if ($flag) {
            // Set error message

            if ($product_is_quote != "yes") {
                wc_add_notice(sprintf(
                    __('Product %s is a purchasable item. Please finish your purchase first.', 'rfqtk'),
                    $product_id_title
                ), 'error');
            }
            if ($product_is_quote == "yes") {
                wc_add_notice(sprintf(
                    __('Product %s is a quote item. Please submit your quote request first.', 'rfqtk'),
                    $product_id_title
                ), 'error');
            }
            // Passed = false
            $passed = false;
        }

        return $passed;
    }
}

if (!function_exists('rfqtk_display_ninja_in_thanky_you_view_order')) {
    function rfqtk_display_ninja_in_thanky_you_view_order($order_id)
    {
        $order = WC_Order_Factory::get_order($order_id);
        rfqtk_display_ninja_in_ninja30_admin($order);
    }

}
if (!function_exists('rfqtk_display_ninja_in_ninja30_admin')) {
    function rfqtk_display_ninja_in_ninja30_admin($order)
    {

        wc_get_template('woo-rfq/form/form-display.php', array('order' => $order)
            , '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
    }
}

if (!function_exists('gpls_woo_payment_status')) {
    function gpls_woo_payment_status($order_id)
    {

        $order = WC_Order_Factory::get_order($order_id);

        if (is_object($order) == false || $order == null || $order == false) {
            return;
        }


        if ($order->get_meta('_gpls_woo_is_quote') == 'yes') {

            $current_date = get_option('settings_gpls_woo_rfq_order_date', 'no');
            if ($order->get_status() == 'processing' || $order->get_status() == 'completed') {
                if ($current_date == 'yes') {
                    try {
                        $order->set_date_created(current_time('mysql', 0));
                    } catch (WC_Data_Exception $e) {
                    }
                    $order->add_order_note(__('Order Date set to payment date by RFQ-ToolKit.', 'rfqtk'), false, true);
                    $order->save();
                }

                $accepted_offer = get_option('settings_gpls_woo_rfq_customer_accepted_offer_label', __('Customer accepted offer of', 'rfqtk') . ' ');
                $accepted_offer = __($accepted_offer, "rfqtk");
                gpls_woo_rfq_add_order_note($order, $accepted_offer . wc_price($order->get_total()), 1, true);

                do_action('woocommerce_new_admin_note', array('order_id' => $order_id, 'customer_note' => $accepted_offer . wc_price($order->get_total())));


            }
        }


    }
}


//brought from main functions in include folder
function gpls_woo_rfq_plus_handle_product_bulk_actions($redirect_to, $action, $ids)
{

    $product_types = array('_gpls_woo_rfq_rfq_enable', '_gpls_woo_rfq_rfq_enable_remove',
        '_gpls_woo_rfq_no_add_to_cart', '_gpls_woo_rfq_no_add_to_cart_remove', '_gpls_woo_rfq_hide_price',
        '_gpls_woo_rfq_hide_price_remove', '_gpls_woo_individual_per_order', '_gpls_woo_individual_per_order_remove');

    if (false === strpos($action, '_gpls_woo_rfq_') && !in_array($action, $product_types)) {
        return $redirect_to;
    }

    foreach ($ids as $id) {

        $product = wc_get_product($id);

        switch ($action) {

            case '_gpls_woo_rfq_rfq_enable':
            {
                update_post_meta($id, '_gpls_woo_rfq_rfq_enable', 'yes');

                $type_array = array('variable-subscription', 'variable');
                if (in_array($product->get_type(), $type_array)) {
                    $product_children = $product->get_available_variations();

                    if (count($product_children) > 0) {
                        foreach ($product_children as $key => $val) {

                            update_post_meta($val["variation_id"], '_gpls_woo_rfq_rfq_enable', 'yes');
                        }
                    }

                }


                break;
            }

            case '_gpls_woo_rfq_rfq_enable_remove':
            {
                update_post_meta($id, '_gpls_woo_rfq_rfq_enable', 'no');

                $type_array = array('variable-subscription', 'variable');
                if (in_array($product->get_type(), $type_array)) {
                    $product_children = $product->get_available_variations();

                    if (count($product_children) > 0) {
                        foreach ($product_children as $key => $val) {

                            update_post_meta($val["variation_id"], '_gpls_woo_rfq_rfq_enable', 'no');
                        }
                    }

                }


                break;
            }

            case '_gpls_woo_rfq_no_add_to_cart':
            {
                update_post_meta($id, '_gpls_woo_rfq_no_add_to_cart', 'yes');

                $type_array = array('variable-subscription', 'variable');

                if (in_array($product->get_type(), $type_array)) {
                    $product_children = $product->get_available_variations();
                    if (count($product_children) > 0) {
                        foreach ($product_children as $key => $val) {

                            update_post_meta($val["variation_id"], '_gpls_woo_rfq_no_add_to_cart', 'yes');
                        }
                    }

                }


                break;
            }

            case '_gpls_woo_rfq_no_add_to_cart_remove':
            {
                update_post_meta($id, '_gpls_woo_rfq_no_add_to_cart', 'no');

                $type_array = array('variable-subscription', 'variable');

                if (in_array($product->get_type(), $type_array)) {
                    $product_children = $product->get_available_variations();
                    if (count($product_children) > 0) {
                        foreach ($product_children as $key => $val) {

                            update_post_meta($val["variation_id"], '_gpls_woo_rfq_no_add_to_cart', 'no');
                        }
                    }

                }


                break;
            }

            case '_gpls_woo_rfq_hide_price':
            {

                update_post_meta($id, '_gpls_woo_rfq_hide_price', 'yes');

                $type_array = array('variable-subscription', 'variable');

                if (in_array($product->get_type(), $type_array)) {
                    $product_children = $product->get_available_variations();
                    if (count($product_children) > 0) {
                        foreach ($product_children as $key => $val) {

                            update_post_meta($val["variation_id"], '_gpls_woo_rfq_hide_price', 'yes');
                        }
                    }

                }

                break;
            }

            case '_gpls_woo_rfq_hide_price_remove':
            {

                update_post_meta($id, '_gpls_woo_rfq_hide_price', 'no');

                $type_array = array('variable-subscription', 'variable');

                if (in_array($product->get_type(), $type_array)) {
                    $product_children = $product->get_available_variations();
                    if (count($product_children) > 0) {
                        foreach ($product_children as $key => $val) {

                            update_post_meta($val["variation_id"], '_gpls_woo_rfq_hide_price', 'no');
                        }
                    }

                }

                break;
            }

            case '_gpls_woo_individual_per_order':
            {

                update_post_meta($id, '_gpls_woo_individual_per_order', 'yes');

                $type_array = array('variable-subscription', 'variable');

                if (in_array($product->get_type(), $type_array)) {
                    $product_children = $product->get_available_variations();
                    if (count($product_children) > 0) {
                        foreach ($product_children as $key => $val) {

                            update_post_meta($val["variation_id"], '_gpls_woo_individual_per_order', 'yes');
                        }
                    }

                }

                break;
            }

            case '_gpls_woo_individual_per_order_remove':
            {

                update_post_meta($id, '_gpls_woo_individual_per_order', 'no');

                $type_array = array('variable-subscription', 'variable');

                if (in_array($product->get_type(), $type_array)) {
                    $product_children = $product->get_available_variations();
                    if (count($product_children) > 0) {
                        foreach ($product_children as $key => $val) {

                            update_post_meta($val["variation_id"], '_gpls_woo_individual_per_order', 'no');
                        }
                    }

                }

                break;
            }

        }

        $changed++;
    }

    $redirect_to = add_query_arg(array(
        'post_type' => 'product',
        'changed' => $changed,
        'ids' => join(',', $ids),
    ), $redirect_to);

    return esc_url_raw($redirect_to);
}

function gpls_woo_rfq_plus_product_bulk_actions($actions)
{

    $actions['_gpls_woo_rfq_rfq_enable'] = __('RFQ: enable RFQ', 'rfqtk');
    $actions['_gpls_woo_rfq_rfq_enable_remove'] = __('RFQ: Undo enable RFQ', 'rfqtk');
    $actions['_gpls_woo_rfq_no_add_to_cart'] = __('RFQ: Hide add to cart button', 'rfqtk');
    $actions['_gpls_woo_rfq_no_add_to_cart_remove'] = __('RFQ: Undo hide add to cart button', 'rfqtk');
    $actions['_gpls_woo_individual_per_order'] = __('RFQ: Product is the only product in the order', 'rfqtk');
    $actions['_gpls_woo_individual_per_order_remove'] = __('RFQ: Undo the only product in the order', 'rfqtk');
    $actions['_gpls_woo_rfq_hide_price'] = __('RFQ: Hide price', 'rfqtk');
    $actions['_gpls_woo_rfq_hide_price_remove'] = __('RFQ: Undo hide price', 'rfqtk');


    return $actions;
}


function gpls_woo_rfq_one_page_rfq()
{
    if (!is_product()) return;

    if (get_option('settings_gpls_woo_rfq_allow_in_single', 'no') !== 'yes' || !is_product()) {
        return;
    }

    global $product;

    //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);

    if ($rfq_enable !== 'yes') {
        return;
    }

    echo gpls_woo_rfq_get_rfq_cart();
}

function gpls_woo_rfq_user_register($user_id)
{

    $session = gpls_woo_get_session();
    $return_qr_page = gpls_woo_rfq_get_item('return to quote request page');
    if ($return_qr_page === "yes") {
        $redirect = pls_woo_rfq_get_link_to_rfq();
        gpls_woo_rfq_cart_delete('return to quote request page');
    }

    return $redirect;
}

function gpls_woo_rfq_woocommerce_redirect_after_login($redirect, $user)
{

    $session = gpls_woo_get_session();
    $return_qr_page = gpls_woo_rfq_get_item('return to quote request page');
    if ($return_qr_page === "yes") {
        $link = pls_woo_rfq_get_link_to_rfq();
        gpls_woo_rfq_cart_delete('return to quote request page');
        wp_safe_redirect($link);
        exit;
    }
    // return $redirect;

}


function gpls_create_product_extra($order_id)
{

    //based on code from WooCommerce Product Add-Ons Ultimate by  Plugin Republic
    if (get_option('rfq_cart_sc_section_support_for_ultimate', 'no') === 'yes') {
        $order = wc_get_order($order_id);
        $payment_method = is_callable(array($order, 'get_payment_method')) ? $order->get_payment_method() : $order->payment_method;


        if ($order->has_status('processing') && 'cod' === $payment_method) {
            //  return;
        }


        $order_items = $order->get_items('line_item');

        if ($order_items) {

            foreach ($order_items as $order_item_id => $order_item) {


                $product_extras = $order_item->get_meta('product_extras');


                if (!empty($product_extras['groups']) || !empty($product_extras['products'])) {


                    $product_extra_id = wp_insert_post(array(
                        'post_title' => $product_extras['title'],
                        'post_type' => 'pewc_product_extra',
                        'post_status' => 'publish'
                    ));
                    if (!is_wp_error($product_extra_id)) {
                        wp_update_post(
                            array(
                                'ID' => $product_extra_id,
                                'post_title' => $product_extras['title'] . ' #' . $product_extra_id
                            )
                        );
                        // User data
                        $user_id = $order->get_user_id();
                        $user = get_userdata($user_id);
                        if ($user && !is_wp_error($user)) {
                            update_post_meta($product_extra_id, 'pewc_user_id', absint($user_id));
                        }
                        update_post_meta($product_extra_id, 'pewc_order_id', absint($order_id));
                        update_post_meta($product_extra_id, 'pewc_item_cost', $order->get_item_total($order_item));
                        update_post_meta($product_extra_id, 'pewc_order_total', $order->get_total());


                        update_post_meta($product_extra_id, 'pewc_product_id', absint($product_extras['product_id']));

                        update_post_meta($product_extra_id, 'pewc_user_name', sanitize_text_field($order->get_formatted_billing_full_name()));
                        update_post_meta($product_extra_id, 'pewc_user_email', sanitize_email($order->get_billing_email()));
                        update_post_meta($product_extra_id, 'pewc_user_phone', sanitize_text_field($order->get_billing_phone()));

                        // Save the product_extra ID to the order as well
                        update_post_meta($order_id, 'pewc_product_extra_id', absint($product_extra_id));

                    }

                    $fields = array();

                    if (!empty($product_extras['groups'])) {


                        // Rename any uploads if appropriate
                        $product_extras['groups'] = pewc_rename_uploaded_files_item_meta($order_item);

                        foreach ($product_extras['groups'] as $groups) {

                            if ($groups) {

                                foreach ($groups as $group) {


                                    if (isset($group['type'])) {

                                        $group_id = $group['group_id'];
                                        $field_id = $group['field_id'];
                                        $fields[$group_id][$field_id] = array(
                                            'id' => sanitize_text_field($group['id']),
                                            'type' => sanitize_text_field($group['type']),
                                            'label' => sanitize_text_field($group['label'])
                                        );

                                        if (isset($group['price'])) {
                                            $fields[$group_id][$field_id]['price'] = $group['price'];
                                        }

                                        if ($group['type'] == 'upload') {

                                            $fields[$group_id][$field_id]['files'] = $group['files'];
                                            // $fields[$group_id][$field_id]['url'] = esc_url( $group['url'] );
                                            // $fields[$group_id][$field_id]['display'] = sanitize_text_field( $group['display'] );
                                            // Delete uploaded image in product_extras folder (tidy up time)
                                            // unlink( $group['file'] );

                                        } else {

                                            $fields[$group_id][$field_id]['value'] = sanitize_text_field($group['value']);

                                        }

                                        // Use this for fancy stuff, like sending custom emails
                                        do_action('pewc_after_create_product_extra', $product_extra_id, $order, $group);

                                    }
                                }
                            }
                        }
                        if (!empty($fields)) {

                            update_post_meta($product_extra_id, 'pewc_product_extra_fields', $fields);

                        }
                    }
                }
            }

        }
    }

    //based on advanced product fields for WooCommerce plugin.
    if (get_option('rfq_cart_sc_section_support_for_wapf', 'no') === 'yes') {
        $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];

        if ($checkout_option === "normal_checkout") {
            if ($order_items) {
                foreach ($order_items as $order_item_id => $order_item) {
                    $wapf = $order_item->get_meta('wapf');
                    if (!empty($wapf) && is_array($wapf) && count($wapf) > 0) {
                        foreach ($wapf as $field) {

                            if (!empty($field['value'])) {

                                $total_price = 0;
                                foreach ($field['price'] as $key => $price_arr) {

                                    $total_price = $total_price + $price_arr["value"];
                                }

                                // preg_replace('/CROPSTART[\s\S]+?CROPEND/', '', $string);

                                $value = preg_replace('/\(\+[\s\S]+?\)/',
                                    '(+' . get_woocommerce_currency_symbol() . $total_price . ")", $field['value']);


                                //  $order_item->update_meta_data($field['label'], $field['value']);
                                $order_item->update_meta_data($field['label'], $value);

                                //  $order_item->update_meta_data($field['label'], '(+$12.12)');
                                $order_item->get_meta($field['label'], true);
                                $getit = $order_item->get_meta($field['label']);


                                // $order_item->add_meta_data($field['label'], preg_replace("/\([^)]+\)/","",$field['value']));
                                // 'value' => preg_replace("/\([^)]+\)/","",$field['value'])
                            }

                            $order_item->save();
                        }
                    }
                }

            }
        }
    }

}

function gpls_woo_rfqtk_normal_checkout_template_redirect()
{


    $link_to_rfq_page = pls_woo_rfq_get_link_to_rfq();

    $parsed = parse_url($link_to_rfq_page);

    if (is_page(str_replace("/", "", $parsed['path']))) {
        wp_redirect(get_permalink(get_option('woocommerce_myaccount_page_id')) . '?nc=1');
        exit;
    }

}

function gpls_woo_rfqtk_login_message()
{
    if (isset($_GET['nc'])) {
        if ($_GET['nc'] === '1') {

            $text = get_option('settings_gpls_woo_rfq_plus_normal_checkout_redirect_anon_text');

            if (trim($text) === "") return;

            $text = __($text, 'rfqtk');
            ?>

            <div class="woocommerce-info">
                <?php echo $text; ?>
            </div>

            <?php
        }
    }
}

function gpls_woo_rfqtk_login_redirect($redirect, $user)
{
    if (isset($_GET['nc'])) {
        if ($_GET['nc'] === '1') {
            $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');


            if (($gpls_woo_rfq_cart == false)) {
                return $redirect;
            }

            return pls_woo_rfq_get_link_to_rfq();
        }
    }
    return $redirect;

}

function gpls_woo_rfqtk_reg_redirect($redirect)
{
    if (isset($_GET['nc'])) {
        if ($_GET['nc'] === '1') {
            $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');

            if (($gpls_woo_rfq_cart == false)) {
                return $redirect;
            }

            return pls_woo_rfq_get_link_to_rfq();
        }
    }
    return $redirect;

}


function gpls_woo_rfqtk_async_defer($tag, $handle)
{
    if ('gpls_woo_rfqtk_recaptcha' !== $handle)
        return $tag;
    return str_replace(' src', ' async defer src', $tag);
}


function gpls_woo_rfqtk_refresh_rfq_captcha()
{


    $specific_gateway = 'gpls-rfq';

    WC()->initialize_session();

    $chosen_method = WC()->session->get('chosen_payment_method');

    $always_show_ninja = get_option('rfq_cart_sc_section_nf_rfq_only');

    if ($always_show_ninja === "yes") {

        $rfq_product_script = "<script>
   try{ 
        
         
       jQuery( '.gpls_woo_ninja' ).hide();
         jQuery( '.gpls_woo_ninja' ).attr('style','display: none !important; margin-right: 10%;margin-left: 10%;');
         
       }catch (e){}
       
 </script>";
        //  echo $rfq_product_script;

    } else {

        $rfq_product_script = "<script>
   try{
       
       
         jQuery( '.gpls_woo_ninja' ).show(); 
         jQuery( '.gpls_woo_ninja' ).attr('style','display: block !important;margin-right: 10%;margin-left: 10%;');
         
       }catch (e){}
 
 </script>";
        echo $rfq_product_script;

    }


    if ($chosen_method != $specific_gateway) {

        $rfq_product_script = "<script>
   try{ 
         jQuery( '.rfq-captcha-div' ).hide();
         jQuery( '.rfq-captcha-div' ).attr('style','display: none !important; margin-right: 10%;margin-left: 10%;');
         
       }catch (e){}
       
 </script>";
        echo $rfq_product_script;

    } else {

        $rfq_product_script = "<script>
   try{
       
       jQuery( '.rfq-captcha-div' ).show();
       jQuery( '.rfq-captcha-div' ).attr('style','display: block !important;margin-right: 10%;margin-left: 10%;');
         
       }catch (e){}
 
 </script>";
        echo $rfq_product_script;
    }


}


function gpls_woo_rfq_check_rfq_captcha_proceed($fields, $errors)
{

    $settings_gpls_woo_rfq_use_captcha = get_option('settings_gpls_woo_quote_use_captcha', 'no');

    if ($settings_gpls_woo_rfq_use_captcha === 'yes') {
        if (gpls_woo_quote_check_captcha() == false) {
            $errors->add('validation', __('Captcha Error. Please try again', 'rfqtk'));
        }
    }


}


function gpls_woo_rfq_check_captcha_proceed($proceed)
{

    $settings_gpls_woo_rfq_use_captcha = get_option('settings_gpls_woo_quote_use_captcha', 'no');

    if ($settings_gpls_woo_rfq_use_captcha === 'yes') {
        if (gpls_woo_quote_check_captcha() == false) {
            return false;
        }
    }


    return $proceed;

}

function gpls_woo_quote_check_captcha()
{
    if (is_admin()) {
        return true;
    }


    $settings_gpls_woo_rfq_use_captcha = get_option('settings_gpls_woo_quote_use_captcha', 'no');
    $settings_gpls_woo_rfq_file_sitekey = get_option('settings_gpls_woo_rfq_file_sitekey', '');
    $settings_gpls_woo_rfq_file_secret_key = get_option('settings_gpls_woo_rfq_file_secret_key', 'no');


    if ($settings_gpls_woo_rfq_use_captcha === 'no') {
        return true;
    }


    if (isset($_POST['g-recaptcha-response'])) {
        $recaptcha_secret = get_option('settings_gpls_woo_rfq_file_secret_key');
        $response = wp_remote_get("https://www.google.com/recaptcha/api/siteverify?secret=" . $recaptcha_secret . "&response=" . $_POST['g-recaptcha-response']);
        $response = json_decode($response["body"], true);

        if (true == $response["success"]) {
            return true;
        } else {
            wc_clear_notices();
            gpls_woo_rfq_add_notice(__('Captcha Error. Please try again', 'rfqtk'), 'error');
            return false;
        }
    } else {

        return false;
    }
}


function gpls_woo_rfq_frontend_quote_recaptcha_script()
{
    if (is_admin()) {
        return;
    }

    $settings_gpls_woo_rfq_use_captcha = get_option('settings_gpls_woo_quote_use_captcha', 'no');


    if ($settings_gpls_woo_rfq_use_captcha === 'no') {
        return;
    }


    wp_register_script("gpls_woo_rfqtk_recaptcha",
        "https://www.google.com/recaptcha/api.js?onload=gpls_onloadCallback&render=explicit");
    wp_enqueue_script("gpls_woo_rfqtk_recaptcha");

    //  $plugin_url = plugin_dir_url(__FILE__);
    //  wp_enqueue_style("no-captcha-recaptcha", $plugin_url . "style.css");
}

function gpls_woo_rfq_frontend_quote_recaptcha_script_callback()
{
    $settings_gpls_woo_rfq_use_captcha = get_option('settings_gpls_woo_quote_use_captcha', 'no');

    if ($settings_gpls_woo_rfq_use_captcha !== 'yes') {
        return;
    }

    $sitekey = get_option('settings_gpls_woo_rfq_file_sitekey');
    $sitetheme = get_option('settings_gpls_woo_rfq_file_sitetheme', 'light');

    ?>

    <script type="text/javascript">
        var verifyCallback = function (response) {

        };


        var widgetId1;
        var widgetId2;
        var gpls_onloadCallback = function () {

            if (document.getElementById('rfq-captcha') != null) {
                widgetId1 = grecaptcha.render('rfq-captcha', {
                    'sitekey': '<?php echo $sitekey ?>',
                    'theme': '<?php echo $sitetheme ?>',
                });
            }

            if (document.getElementById('normal-captcha') != null) {
                widgetId2 = grecaptcha.render('normal-captcha', {
                    'sitekey': '<?php echo $sitekey ?>',
                    'theme': '<?php echo $sitetheme ?>',
                });
            }

        };
    </script>
    <?php
}


function gpls_woo_rfq_display_quote_recaptcha()
{


    if (is_admin()) {
        return;
    }

    $use_captcha = get_option('settings_gpls_woo_quote_use_captcha', 'no');

    if ($use_captcha === 'no') {
        return;
    }

    $sitekey = get_option('settings_gpls_woo_rfq_file_sitekey');
    $secret_key = get_option('settings_gpls_woo_rfq_file_secret_key');

    $instruction = get_option('settings_gpls_woo_quote_captcha_text');
    $instruction = __($instruction, 'rfqtk');

    if ($use_captcha === 'no' || !isset($sitekey) || !isset($secret_key)) return '';

    ?>

    <div class="normal-captcha-div">
        <div class="woo_rfq_recapcha_html_desc"><?php echo $instruction; ?></div>
        <div id="normal-captcha" style="margin-right: 10%;margin-left: 10%;"
             data-sitekey="<?php echo get_option('settings_gpls_woo_rfq_file_sitekey'); ?>"></div>
    </div>


<?php }


function gpls_woo_rfq_display_rfq_recaptcha()
{


    if (is_admin()) {
        return;
    }

    $specific_gateway = 'gpls-rfq';

    WC()->initialize_session();

    $chosen_method = WC()->session->get('chosen_payment_method');

    if ($chosen_method != $specific_gateway) {
//            return;
    }

    $use_captcha = get_option('settings_gpls_woo_quote_use_captcha', 'no');

    if ($use_captcha === 'no') {
        return;
    }

    $sitekey = get_option('settings_gpls_woo_rfq_file_sitekey');
    $secret_key = get_option('settings_gpls_woo_rfq_file_secret_key');

    $instruction = get_option('settings_gpls_woo_quote_captcha_text');
    $instruction = __($instruction, 'rfqtk');


    if ($use_captcha === 'no' || !isset($sitekey) || !isset($secret_key)) return '';

    ?>
    <div class="rfq-captcha-div">
        <div class="woo_rfq_recapcha_html_desc"><?php echo $instruction; ?></div>
        <div id="rfq-captcha" style="margin-right: 10%;margin-left: 10%;"
             data-sitekey="<?php echo get_option('settings_gpls_woo_rfq_file_sitekey'); ?>"></div>
    </div>


<?php }


function rftk_add_recaptcha_normal()
{
    if (is_admin()) {
        return;
    }


    if (!is_admin()) {

        $specific_gateway = 'gpls-rfq';

        WC()->initialize_session();

        $chosen_method = WC()->session->get('chosen_payment_method');

        $always_show_ninja = get_option('rfq_cart_sc_section_nf_rfq_only', 'no');

        if ($always_show_ninja === "yes") {

            if ($chosen_method != $specific_gateway) {

                $rfq_product_script = "<script>
   try{
       
       jQuery( 'form.checkout' ).on( 'checkout_place_order', function() {
           
       jQuery( '.rfq-captcha-div' ).remove();
    
    // allow the submit AJAX call
    return true;
});    
       
       }catch (e){}
       
 </script>";
                echo $rfq_product_script;

            }
        }


        $settings_gpls_woo_rfq_use_captcha = get_option('settings_gpls_woo_quote_use_captcha', 'no');

        if ($settings_gpls_woo_rfq_use_captcha === 'yes') {

            $sitekey = get_option('settings_gpls_woo_rfq_file_sitekey');
            $secret_key = get_option('settings_gpls_woo_rfq_file_secret_key');

            $error_message = get_option('settings_gpls_woo_quote_captcha_error');
            $error_message = __($error_message, 'rfqtk');

            $message = get_option('settings_gpls_woo_quote_captcha_text');
            $message = __($message, 'rfqtk');


            if (isset($sitekey) && isset($secret_key)) {

                $rfq_product_script = "<script>
   try{
       
       jQuery( 'form.checkout' ).on( 'checkout_place_order', function(e) {
           
      // jQuery( '#upload-captcha-contain' ).hide();
      // jQuery( '#upload-captcha-contain' ).attr('style','display: none !important; margin-right: 10%;margin-left: 10%;');    
           
    var payment_method = jQuery( 'form.checkout input[name=\"payment_method\"]:checked' ).val();        
     
    if ( payment_method === 'gpls-rfq' && grecaptcha.getResponse(widgetId1).length === 0) {
        
       
        e.preventDefault();  
        
        jQuery('.woo_rfq_recapcha_html_desc').html('<ul class=\"woocommerce-error\" role=\"alert\">" . $error_message . "</ul>');
        
        return false;
        
    }else{
      //  jQuery('.woo_rfq_recapcha_html_desc').text('" . $message . "');
    }
    
    // allow the submit AJAX call
    return true;
});
       
       }catch (e){}
       
       try {
       
               
               
               
               jQuery('#update_rfq_cart').on('click', function (e) {

               jQuery('.rfqform').off('submit');     
                  
                    });
               
               
       

                jQuery('.rfqform').on('submit', function (e) {
                    
                    var fileinput = jQuery('.rfqform input[type=file]').val();

                    if (fileinput !== '' && grecaptcha.getResponse(widgetId2).length === 0) {

                        e.preventDefault();

                    jQuery('.woo_rfq_recapcha_html_desc').html('<ul class=\"woocommerce-error\" role=\"alert\">" . $error_message . "</ul>');

                    return false;

                    } else {

               //     jQuery('.woo_rfq_recapcha_html_desc').text('" . "');
                    return true;

                    }
                  
                    });
                     
                    } catch (e) {
                    }

 </script>";
                echo $rfq_product_script;
            }

        }


    }
}

function rfqtk_add_to_cart_redirect($url, $adding_to_cart)
{

    $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];

    if ($checkout_option === "rfq") {

        $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

        if ($settings_gpls_woo_rfq_limit_to_rfq_only === "no") return $url;

        $items = WC()->cart->get_cart();

        $has_rfq = false;

        foreach ($items as $item => $values) {

            $_product = wc_get_product($values['product_id']);

            //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


            if ($rfq_enable === 'yes') {
                $has_rfq = true;
                break;
            }
        }


        if ($has_rfq == true) {

            // wp_safe_redirect(wc_get_checkout_url());
            return wc_get_checkout_url();
        }
    }

    return $url;
}


function rfqtk_add_to_cart($cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data)
{
    $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];

    if ($checkout_option === "rfq") {

        $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

        if ($settings_gpls_woo_rfq_limit_to_rfq_only === "no") return;

        $items = WC()->cart->get_cart();

        $has_rfq = false;

        foreach ($items as $item => $values) {

            $_product = wc_get_product($values['product_id']);

            //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


            if ($rfq_enable === 'yes') {
                $has_rfq = true;
                break;
            }
        }


        if ($has_rfq == true) {
            if (defined('DOING_AJAX') && DOING_AJAX) {


                $data = array(
                    'location' => wc_get_checkout_url(), 'rfq_single_product' => 'no', 'ajax' => 'yes');
                wp_send_json_success($data);
                exit;


            } else {
                wp_safe_redirect(wc_get_checkout_url());

            }
        }
    }
}


function rfqtk_add_to_cart_purchase($cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data)
{
    $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];


    if ($checkout_option === "rfq") {

        $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

        if ($settings_gpls_woo_rfq_limit_to_rfq_only === "no") return;

        $items = WC()->cart->get_cart();

        $has_rfq = false;

        foreach ($items as $item => $values) {

            $_product = wc_get_product($values['product_id']);

            $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());


            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


            if ($rfq_enable === 'yes') {
                $has_rfq = true;
                break;
            }
        }

        if ($has_rfq == false) {


            if (defined('DOING_AJAX') && DOING_AJAX) {
                $data = array(
                    'location' => wc_get_checkout_url(), 'rfq_single_product' => 'no', 'ajax' => 'yes');


                wp_send_json_success($data);
                exit;


            } else {


                wp_safe_redirect(wc_get_checkout_url());

            }


        }
    }
}


function gpls_woo_rfq_pay_woocommerce_display_item_meta($html, $item, $args)
{


    //    if (gpls_woo_rfq_plus_check_staff_mode() === "yes") return $html;

    global $post;

    if (isset($post) && $post->post_type === 'shop_order' && $post->post_status === 'wc-gplsquote-req') {

        $show_prices = get_option('settings_gpls_woo_rfq_show_prices_customer_confirmation_email', 'no');

        if ($show_prices === 'yes') {
            return $html;
        }
    }

    $remove_price = false;


    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles === "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($in_role == false) {

        $remove_price = true;
    }

    global $wp_query;

    if (isset($wp_query)) {

        if (function_exists('is_checkout')) {
            if (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] === "rfq" &&
                get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no') === 'yes'
                && (is_cart() || is_checkout())) {

                $remove_price = true;
            }
        }
    }


    $home = home_url() . '/quote-request/';
    $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);
    $actual_link = get_site_url() . $_SERVER['REQUEST_URI'];


    if (
        (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] === "rfq" && get_option('settings_gpls_woo_rfq_show_prices', 'no') !== 'yes')
        || (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] === "normal_checkout"
            && get_option('settings_gpls_woo_rfq_normal_checkout_show_prices', 'no') !== 'yes')
        || (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') === 'yes' && !wp_get_current_user()->exists())
        || $remove_price == true
        || parse_url(trim($rfq_page))['path'] === parse_url(trim($actual_link))['path']

    ) {
        $strings = array();

        foreach ($item->get_formatted_meta_data() as $meta_id => $meta) {
            $value = $args['autop'] ? wp_kses_post($meta->display_value) : wp_kses_post(make_clickable(trim($meta->display_value)));

            $strings[] = $args['label_before'] . preg_replace("/\([^)]+\)/", "", wp_kses_post($meta->display_key)) . $args['label_after'] . $value;
        }

        if ($strings) {
            $html = $args['before'] . implode($args['separator'], $strings) . $args['after'];
        }

    }

    return $html;

}


function rfqtk_rfq_submit_rfq($order_button_text)
{

    if (WC()->cart != null) {


        if (WC()->cart != null) {

            $totals = WC()->cart->get_totals();

            if (get_option('settings_gpls_woo_rfq_plus_skip_zero_cart') === "yes"
                && floatval($totals['total']) == 0) {

                $label = __(get_option('rfq_cart_wordings_proceed_to_rfq_zero_cart', ''), 'rfqtk');

                return __($label, 'rfqtk');
            }
        }
    }

    $split_cart_option = get_option('settings_gpls_woo_rfq_5j', 'no');

    if ($split_cart_option == "yes") {
        WC()->initialize_cart();
        wc()->cart->set_session();
        $items = WC()->cart->get_cart();

        $includes_purchase = false;

        foreach ($items as $key => $values) {

            $_product = wc_get_product($values['product_id']);

            // $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


            if ($rfq_enable != 'yes') {
                $includes_purchase = true;
                break;
            }

        }

        if ($includes_purchase) {
            $place_order = get_option('rfq_cart_wordings_submit_your_rfq_text', 'Place Order');

            $place_order = __($place_order, 'rfqtk');
            return $place_order;
        } else {
            $submit_quote = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_checkout_alt_label', 'Submit Quote');

            $submit_quote = __($submit_quote, 'rfqtk');
            return $submit_quote;
        }


    }


    $limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', 'no');

    $change_txt = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_checkout_alt_label', '');

    if ($change_txt == '') {
        return $order_button_text;
    }

    $order_button_text_alt = __($change_txt, 'rfqtk');

    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

        $product = $cart_item['data'];

        if ($product->get_type() === 'external') {
            return $order_button_text;
        }

        //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if ($limit_to_rfq_only === "yes" && $rfq_enable === "yes"
            && isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] === "rfq") {

            return $order_button_text_alt;

        }
    }


    if (is_checkout()) {
        $message = __('There are no shipping options available. Please submit your quote request and we will respond as soon as possible.', 'rfqtk');

        WC()->initialize_session();

        if (WC()->session != null) {


            // Mandatory to make it work with shipping methods
            foreach (WC()->cart->get_shipping_packages() as $package_key => $package) {
                WC()->session->set('shipping_for_package_' . $package_key, $bool);
            }

            $methods = WC()->cart->calculate_shipping();

            if (empty($methods)) {

                return $order_button_text_alt;
            }
        }

    }


    $in_role = true;

    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles !== "no" && !is_user_logged_in()) {
        $in_role = false;
    }

    if ($enable_roles !== "no" && is_user_logged_in()) {

        $in_role = false;

        $user = wp_get_current_user();

        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;

            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);
        // $in_role=apply_filters('rfqtk_is_in_role',$in_role,$user);

    }

    if ($in_role == false) {
        return $order_button_text_alt;
    }


    if (function_exists('wp_get_current_user')) {

        if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') === 'yes' && !wp_get_current_user()->exists()) {
            return $order_button_text_alt;

        }
    }

    if (WC()->cart != null) {

        $plus_normal_checkout = get_option('settings_gpls_woo_rfq_plus_normal_checkout', 'no');

        if ($plus_normal_checkout === 'yes') {


            $specific_gateway = 'gpls-rfq';

            global $woocommerce;

            WC()->initialize_session();

            $chosen_method = WC()->session->get('chosen_payment_method');
            /* we do not need gateway objects, only keys */


            if ($chosen_method == $specific_gateway) {
                return $order_button_text_alt;
            }
        }


    }


    return $order_button_text;
}


function rfqtk_rfq_proceed_to_rfq($proceed_to_rfq)
{

    $limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', 'no');

    $change_txt = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_cart_alt_label', '');

    if ($change_txt == '') {
        return $proceed_to_rfq;
    }

    $proceed_to_rfq_alt = __($change_txt, 'rfqtk');

    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

        $product = $cart_item['data'];

        if ($product->get_type() === 'external') {
            return $proceed_to_rfq;
        }

        //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if ($limit_to_rfq_only == "yes" && $rfq_enable == "yes" && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {

            return $proceed_to_rfq_alt;

        }
    }

    $in_role = true;

    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles != "no" && !is_user_logged_in()) {
        $in_role = false;
    }

    if ($enable_roles != "no" && is_user_logged_in()) {

        $in_role = false;

        $user = wp_get_current_user();

        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;

            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);
        // $in_role=apply_filters('rfqtk_is_in_role',$in_role,$user);

    }

    if ($in_role == false) {
        return $proceed_to_rfq_alt;
    }


    if (function_exists('wp_get_current_user')) {

        if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
            return $proceed_to_rfq_alt;

        }
    }

    return $proceed_to_rfq;
}


function gpls_woo_rfq_column($columns_array)
{

    if (!$columns_array) return $columns_array;
    return array_slice($columns_array, 0, 11, true)
        + array('_gpls_woo_rfq_rfq_enable' => 'RFQ')
        + array('_gpls_woo_rfq_no_add_to_cart' => 'Hide Add2Cart')
        + array('_gpls_woo_rfq_hide_price' => 'Hide price')
        + array('_gpls_woo_individual_per_order' => 'Only product in the order')
        + array_slice($columns_array, 11, NULL, true);


}


function gpls_woo_rfq_values($column_name)
{

    if ($column_name == '_gpls_woo_rfq_rfq_enable') {
        // if you suppose to display multiple brands, use foreach();

        $col = get_post_meta(get_the_ID(), '_gpls_woo_rfq_rfq_enable', true);
        if ($col == "yes") {
            echo "Y";
        } else {
            echo "N";
        }

    }

    if ($column_name == '_gpls_woo_rfq_no_add_to_cart') {
        // if you suppose to display multiple brands, use foreach();


        $product_id = get_the_ID();
        $col = get_post_meta($product_id, '_gpls_woo_rfq_no_add_to_cart', true);
        $col = apply_filters('gpls_no_add_to_cart', $col, $product_id);

        if ($col == "yes") {
            echo "Y";
        } else {
            echo "N";
        }


    }
    if ($column_name == '_gpls_woo_rfq_hide_price') {
        // if you suppose to display multiple brands, use foreach();


        $product_id = get_the_ID();
        $col = get_post_meta($product_id, '_gpls_woo_rfq_hide_price', true);
        $col = apply_filters('gpls_hide_product_price', $col, $product_id);


        if ($col == "yes") {
            echo "Y";
        } else {
            echo "N";
        }

    }
    if ($column_name == '_gpls_woo_individual_per_order') {
        // if you suppose to display multiple brands, use foreach();


        $product_id = get_the_ID();
        $col = get_post_meta($product_id, '_gpls_woo_individual_per_order', true);
        $col = apply_filters('_gpls_woo_individual_per_order', $col, $product_id);


        if ($col == "yes") {
            echo "Y";
        } else {
            echo "N";
        }

    }

}

function gpls_woo_rfqtk_order_needs_shipping_address($needs_address, $hide, $order)
{

    if (get_option('settings_gpls_woo_rfq_show_shipping_email', 'no') == 'yes') {
        if ($order->get_status() == "gplsquote-req" || $order->get_status() == "wc-gplsquote-req") {
            return true;
        }
    }

    return $needs_address;

}


function gpls_woo_rfqtk_needs_shipping($needs_shipping)
{

    $payment_method = 'gpls-rfq';

    if (!WC()->session) {
        WC()->initialize_session();
    }

    if (WC()->session != null) {

        $chosen_payment_method = WC()->session->get('chosen_payment_method');

        if ($payment_method == $chosen_payment_method) {
            return false;
        }
    }


    return $needs_shipping;

}

function gpls_woo_rfqtk_show_hide_shipping_methods($rates, $package)
{
    // HERE Define your targeted shipping method ID
    $payment_method = 'gpls-rfq';

    if (!WC()->session) {
        WC()->initialize_session();
    }

    if (WC()->session != null) {
        $chosen_payment_method = WC()->session->get('chosen_payment_method');

        if ($payment_method == $chosen_payment_method) {

            $rates = array();

        }
    }

    return $rates;
}


function gpls_woo_rfqtk_payment_methods_trigger_update_checkout()
{
    // jQuery code
    ?>
    <script type="text/javascript">
        (function ($) {
            $('form.checkout').on('change', 'input[name^="payment_method"]', function () {

                $(document.body).trigger('update_checkout');
            });
        })(jQuery);
    </script>
    <?php

}


function gpls_woo_rfqtk_refresh_shipping_methods($post_data)
{

    WC()->initialize_session();

    if (WC()->session != null) {

        $payment_method = 'gpls-rfq';

        $bool = true;

        if (WC()->session->get('chosen_payment_method') === $payment_method)
            $bool = false;

        // Mandatory to make it work with shipping methods
        foreach (WC()->cart->get_shipping_packages() as $package_key => $package) {
            WC()->session->set('shipping_for_package_' . $package_key, $bool);
        }

    }

    WC()->cart->calculate_shipping();
}


function rfqtk_cart_rfq_advanced_product_get_item_data_action($item_data, $cart_item)
{

    // if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $item_data;


    //based on Advanced Product Fields plugin
    $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];
    if ($checkout_option === "normal_checkout") {

        $home = home_url() . '/quote-request/';
        $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);
        $actual_link = get_site_url() . $_SERVER['REQUEST_URI'];


        if (parse_url(trim($rfq_page))['path'] == parse_url(trim($actual_link))['path']) {


            if (!empty($cart_item['wapf']) || is_array($cart_item['wapf'])) {
                foreach ($cart_item['wapf'] as $field) {

                    if (empty($field['value_cart']))
                        continue;

                    $item_data[] = [
                        'key' => $field['label'],
                        //'value' => preg_replace("/\([^)]+\)/","",$field['value_cart'])
                        'value' => $field['value_cart']
                    ];

                }

            }
        }
    }

    return $item_data;
}


function rfqtk_cart_rfq_get_item_data_action($item_data, $cart_item)
{

    // if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $item_data;

    foreach ($item_data as $key => $data) {
        // Set hidden to true to not display meta on cart.
        if (isset($data['hidden'])) {
            // unset($item_data[$key]);
            continue;
        }


        $item_data[$key]['key'] = isset($data['key']) && $data['key'] != "" ? $data['key'] : $data['name'];

        $item_data[$key]['display'] = isset($data['display']) && $data['display'] != "" ? $data['display'] : $data['value'];


        if (isset($cart_item['addons']) && is_array($cart_item['addons']) && count($cart_item['addons']) > 0) {

            $strip = false;

            if (!is_admin() && $GLOBALS["gpls_woo_rfq_checkout_option"] != "rfq") {

                if ((get_option('settings_gpls_woo_rfq_normal_checkout_show_prices', 'no') == 'no')) {
                    $strip = true;
                }
            }
            if (!is_admin() && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {

                if ((get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'no')) {
                    $strip = true;
                }
            }


            $in_role = true;
            $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

            $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
            if ($roles === '') {
                $enable_roles = 'no';
            }

            if ($enable_roles == "purchase") {
                $in_role = false;

                $user = wp_get_current_user();
                $user_roles = $user->roles;

                $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

                $option_value_list = explode(',', $eligible_roles);

                foreach ($user_roles as $cat_id) {

                    if (in_array(trim($cat_id), $option_value_list)) {
                        $in_role = true;
                    }
                }

                $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

            }


            if ($in_role == false) {

                $strip = true;
            }

            global $wp_query;

            if (isset($wp_query)) {
                if (function_exists('is_checkout')) {

                    if ($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq" && get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no') == 'yes'
                        && (is_cart() || is_checkout())) {
                        $strip = true;

                    }

                }
            }

            $home = home_url() . '/quote-request/';

            $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);


            $actual_link = get_site_url() . $_SERVER['REQUEST_URI'];

            if (
                ($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq" && get_option('settings_gpls_woo_rfq_show_prices', 'no') != 'yes')
                || ($GLOBALS["gpls_woo_rfq_checkout_option"] == "normal_checkout" && get_option('settings_gpls_woo_rfq_normal_checkout_show_prices', 'no') != 'yes')
                || (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists())
                || $strip == true
                || parse_url(trim($rfq_page))['path'] === parse_url(trim($actual_link))['path']
            ) {

                $item_data[$key]['key'] = preg_replace("/\([^)]+\)/", "", wp_kses_post($item_data[$key]['key']));
                $item_data[$key]['key'] = str_replace(')', '', $item_data[$key]['key']);
                $item_data[$key]['key'] = str_replace('(', '', $item_data[$key]['key']);

            }
        }

    }


    //based on Advanced Product Fields plugin
    $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];
    if ($checkout_option === "normal_checkout") {

        $home = home_url() . '/quote-request/';
        $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);
        $actual_link = get_site_url() . $_SERVER['REQUEST_URI'];


        if (parse_url(trim($rfq_page))['path'] == parse_url(trim($actual_link))['path']) {


            if (!empty($cart_item['wapf']) || is_array($cart_item['wapf'])) {
                foreach ($cart_item['wapf'] as $field) {

                    if (empty($field['value_cart']))
                        continue;

                    $item_data[] = [
                        'key' => $field['label'],
                        //'value' => preg_replace("/\([^)]+\)/","",$field['value_cart'])
                        'value' => $field['value_cart']
                    ];

                }

            }
        }
    }

    return $item_data;
}


function rfqtk_prod_advanced_product_get_item_data($other_data, $cart_item)
{


    return $other_data;
}


function rfqtk_prod_add_on_get_item_data($other_data, $cart_item)
{
    if (!empty($cart_item['addons'])) {
        foreach ($cart_item['addons'] as $addon) {


            $price = isset($cart_item['addons_price_before_calc']) ? $cart_item['addons_price_before_calc'] : $addon['price'];
            $name = $addon['name'];

            if (0 == $addon['price']) {
                $name .= '';
            } elseif ('percentage_based' === $addon['price_type'] && 0 == $price) {
                $name .= '';
            } elseif ('percentage_based' !== $addon['price_type'] && $addon['price'] && apply_filters('woocommerce_addons_add_price_to_name', '__return_true')) {
                $name .= '<span class="woocommerce-Price-amount" style="inline-block !important"> (' . wc_price(rfqtk_prod_add_on_get_product_addon_price_for_display($addon['price'], $cart_item['data'])) . ')</span>';
            } else {
                $_product = new WC_Product($cart_item['product_id']);
                $_product->set_price($price * ($addon['price'] / 100));
                $name .= '<span class="woocommerce-Price-amount" style="inline-block !important"> (' . WC()->cart->get_product_price($_product) . ')</span>';
            }

            $other_data[] = array(
                'name' => $name,
                'value' => $addon['value'],
                'display' => isset($addon['display']) ? $addon['display'] : '',
            );
        }
    }

    return $other_data;
}


function rfqtk_prod_add_on_order_line_item($item, $cart_item_key, $values, $item_id, $cart_item)
{

    if (!empty($cart_item['addons'])) {

        foreach ($cart_item['addons'] as $addon) {
            $key = $addon['name'];
            $price_type = $addon['price_type'];

            if (!$item || !is_callable(array($item, 'get_product'))) continue;

            $product = $item->get_product();

            $price = '';
            $product_price = 0;

            if ($product && is_callable(array($product, 'get_price'))) {

                $product_price = $product->get_price();

                $price = html_entity_decode(strip_tags(wc_price(rfqtk_prod_add_on_get_product_addon_price_for_display($addon['price'], $cart_item['data']))));

                if ($addon['price'] && 'percentage_based' === $price_type && 0 != $product_price) {
                    $price = html_entity_decode(strip_tags(wc_price(rfqtk_prod_add_on_get_product_addon_price_for_display(($product_price * ($addon['price'] / 100))))));
                }
            }


            if ($addon['price'] && apply_filters('woocommerce_addons_add_price_to_name', true)) {
                $key .= '<span class="woocommerce-Price-amount" style="inline-block !important"> (' . $price . ')</span>';
            }

            if ('custom_price' === $addon['field_type']) {
                $addon['value'] = $addon['price'];
            }

            try {

                wc_add_order_item_meta($item_id, $key, $addon['value']);
            } catch (Exception $e) {
                error_log($e);
            }

        }
    }


    //TMXPO
    //$values = $cart_item;
    try {
        do_action('wc_epo_order_item_meta_before', $item, $cart_item_key, $values);

        if (!empty($values['tmcartepo'])) {

            wc_add_order_item_meta($item_id, '_tmcartepo_data', $values['tmcartepo']);
            wc_add_order_item_meta($item_id, '_tm_epo_product_original_price', array($values['tm_epo_product_original_price']));
            wc_add_order_item_meta($item_id, '_tm_epo', array(1));
        }
        if (!empty($values['tmsubscriptionfee'])) {
            wc_add_order_item_meta($item_id, '_tmsubscriptionfee_data', array($values['tmsubscriptionfee']));
            wc_add_order_item_meta($item_id, __("Options Subscription fee", 'woocommerce-tm-extra-product-options'), $values['tmsubscriptionfee']);
        }
        if (!empty($values['tmcartfee'])) {
            wc_add_order_item_meta($item_id, '_tmcartfee_data', array($values['tmcartfee']));
        }

        do_action('wc_epo_order_item_meta', $item, $cart_item_key, $values);
    } catch (Exception $e) {
    }
    if (!empty($values['wapf'])) {
        foreach ($values['wapf'] as $field) {

            if (!empty($field['value']))
                $item->add_meta_data($field['label'], $field['value']);
        }
    }

    if (isset($values['pricing_item_meta_data'])) {


        $display_data = rfqtk_measurement_humanize_cart_item_data($values, $values['pricing_item_meta_data']);

        // set any user-input fields to the order item meta data (which can be displayed on the frontend)
        foreach ($display_data as $name => $value) {
            $item->add_meta_data($name, $value);
        }

        // persist the configured item measurement data such that the exact same item could be re-configured at a later date
        $measurement_data = rfqtk_get_measurement_cart_item_data($values, $values['pricing_item_meta_data']);

        $item->add_meta_data('_measurement_data', $measurement_data);

        if (isset($values['pricing_item_meta_data']['_quantity'])
            && \WC_Price_Calculator_Product::pricing_calculator_inventory_enabled($item->get_product())) {
            // set the actual unit quantity (ie *2* fabrics at 3 ft each, rather than '6')
            add_action('woocommerce_new_order_item', 'rfqtk_save_actual_unit_quantity', 10, 2);
        }

        // $item = new WC_Order_Item_Product();

        if (!empty($values['pricing_item_meta_data']['_price'])) {
            $price_measurement = floatval($values['pricing_item_meta_data']['_price']);
        } else {
            // $price_measurement = $item->get_subtotal();

        }

        if (!empty($values['pricing_item_meta_data']['_price_overage'])) {
            $price_measurement_overage = floatval($values['pricing_item_meta_data']['_price_overage']);
        } else {
            $price_measurement_overage = 0;
        }
        //$total = floatval($price_measurement)+floatval($price_measurement_overage);
        //$item->set_subtotal($total);
        // $item->set_total($total);
        //$item->save();
        //$order = $item->get_order();
        //$order->calculate_totals();
        // $order->save();
    }

    $item->save();
}


function rfqtk_save_actual_unit_quantity($_, $item)
{

    if (!$item instanceof \WC_Order_Item_Product) {
        return;
    }

    $measurement_data = $item->get_meta('_measurement_data');

    if (!empty($measurement_data['_quantity'])) {
        $item->set_quantity($measurement_data['_quantity']);
        $item->save();
    }
}

function rfqtk_get_measurement_cart_item_data($item, $cart_item_data)
{

    $measurement_data = array();

    // always need the actual parent product, not the useless variation product
    $product = isset($item['variation_id']) && $item['variation_id'] ? wc_get_product($item['product_id']) : $item['data'];

    $settings = new \WC_Price_Calculator_Settings($product);

    foreach ($settings->get_calculator_measurements() as $measurement) {

        if (isset($cart_item_data[$measurement->get_name()])) {

            $measurement_data[$measurement->get_name()] = array(
                'value' => $cart_item_data[$measurement->get_name()],
                'unit' => $measurement->get_unit(),
            );
        }
    }

    // save the total measurement/unit
    $measurement_data['_measurement_needed'] = $cart_item_data['_measurement_needed'];
    $measurement_data['_measurement_needed_unit'] = $cart_item_data['_measurement_needed_unit'];

    // special case for calculated inventory products: the actual quantity (ie *1* item 10 feet long)
    //  is held in _quantity while $item['quantity'] would be '10' in this example
    if (isset($cart_item_data['_quantity']) && \WC_Price_Calculator_Product::pricing_calculator_inventory_enabled($product)) {
        $measurement_data['_quantity'] = $cart_item_data['_quantity'];
    }

    return $measurement_data;
}


function rfqtk_measurement_humanize_cart_item_data($item, $cart_item_data)
{

    $new_cart_item_data = array();

    // always need the actual parent product, not the useless variation product
    $product = isset($item['variation_id']) && $item['variation_id'] ? wc_get_product($item['product_id']) : $item['data'];

    $settings = new \WC_Price_Calculator_Settings($product);

    $calculator_measurements = $settings->get_calculator_measurements();
    foreach ($calculator_measurements as $measurement) {

        $measurement_name = $measurement->get_name();
        if (isset($cart_item_data[$measurement_name])) {

            // if the measurement has a set of available options, get the option label for display, if we can determine it
            //  (this way we display "1/8" rather than "0.125", etc)
            $measurement_options = $measurement->get_options();
            if (count($measurement_options) > 0) {
                foreach ($measurement_options as $value => $label) {
                    if ($cart_item_data[$measurement_name] === $value) {
                        $cart_item_data[$measurement_name] = $label;
                    }
                }
            }

            $label = $measurement->get_unit_label() ?
                sprintf('%1$s (%2$s)', $measurement->get_label(), __($measurement->get_unit_label(), 'woocommerce-measurement-price-calculator')) :
                __($measurement->get_label(), 'woocommerce-measurement-price-calculator');

            $new_cart_item_data[$label] = $cart_item_data[$measurement_name];
        }
    }

    // render calculator single measurement overage
    if (isset($cart_item_data['_measurement_needed_overage']) && 1 === count($calculator_measurements)) {
        $measurement = array_shift($calculator_measurements);

        $new_cart_item_data[sprintf(__('Overage Estimate (%s)', 'woocommerce-measurement-price-calculator'), $measurement->get_unit_label())] = $cart_item_data['_measurement_needed_overage'];
    }

    // render the total measurement if this is a derived calculator (ie "Area (sq. ft.): 10" if the calculator is Area (LxW))
    if (isset($cart_item_data['_measurement_needed'])
        && $settings->is_calculator_type_derived()
        && ($product_measurement = \WC_Price_Calculator_Product::get_product_measurement($product, $settings))) {

        $product_measurement->set_unit($cart_item_data['_measurement_needed_unit']);
        $product_measurement->set_value($cart_item_data['_measurement_needed']);

        $total_amount_text = apply_filters(
            'wc_measurement_price_calculator_total_amount_text',
            $product_measurement->get_unit_label() ?
                /* translators: Placeholders: %1$s - measurement label, %2$s - measurement unit label */
                sprintf(__('Total %1$s (%2$s)', 'woocommerce-measurement-price-calculator'), $product_measurement->get_label(), __($product_measurement->get_unit_label(), 'woocommerce-measurement-price-calculator')) :
                /* translators: Placeholders: %s - measurement label */
                sprintf(__('Total %s', 'woocommerce-measurement-price-calculator'), $product_measurement->get_label()),
            $item
        );

        if (isset($cart_item_data['_measurement_needed_overage'])) {
            $overage_amount_text = apply_filters(
                'wc_measurement_price_calculator_overage_amount_text',
                $product_measurement->get_unit_label() ?
                    /* translators: Placeholders: %1$s - measurement label, %2$s - measurement unit label */
                    sprintf(__('Overage %1$s (%2$s)', 'woocommerce-measurement-price-calculator'), $product_measurement->get_label(), __($product_measurement->get_unit_label(), 'woocommerce-measurement-price-calculator')) :
                    /* translators: Placeholders: %s - measurement label */
                    sprintf(__('Overage %s', 'woocommerce-measurement-price-calculator'), $product_measurement->get_label()),
                $item
            );

            $new_cart_item_data[$overage_amount_text] = $cart_item_data['_measurement_needed_overage'];
        }

        $new_cart_item_data[$total_amount_text] = apply_filters('wc_measurement_price_calculator_cart_item_data_total_amount_value', $product_measurement->get_value());
    }

    // render pricing overage estimate
    if (isset($cart_item_data['_price_overage'], $cart_item_data['_overage_percentage'])) {
        $new_cart_item_data[sprintf(__('Overage Cost (%s%%)', 'woocommerce-measurement-price-calculator'), $cart_item_data['_overage_percentage'] * 100)] = wc_price($cart_item_data['_price_overage']);
    }

    return $new_cart_item_data;
}

function rfqtk_prod_add_on_get_product_addon_price_for_display($price, $cart_item = null)
{


    $product = !empty($GLOBALS['product']) && is_object($GLOBALS['product']) ? clone $GLOBALS['product'] : null;

    if ('' === $price || '0' == $price) {
        return $price;
    }

    $neg = false;

    if ($price < 0) {
        $neg = true;
        $price *= -1;
    }

    global $wp_query;

    if (isset($wp_query)) {

        if ((is_cart() || is_checkout()) && null !== $cart_item) {
            $product = wc_get_product($cart_item->get_id());
        }

        if (is_object($product)) {
            // Support new wc_get_price_excluding_tax() and wc_get_price_excluding_tax() functions.
            if (function_exists('wc_get_price_excluding_tax')) {
                $display_price = rfqtk_prod_add_on_get_product_addon_tax_display_mode() === 'incl' ? wc_get_price_including_tax($product, array('qty' => 1, 'price' => $price)) : wc_get_price_excluding_tax($product, array('qty' => 1, 'price' => $price));
            } else {
                //wc_get_price_including_tax( $product, array( 'qty' => $qty, 'price' => $price ) );
                $display_price = rfqtk_prod_add_on_get_product_addon_tax_display_mode() === 'incl' ? wc_get_price_including_tax($product, array('qty' => 1, 'price' => $price)) : wc_get_price_excluding_tax($product, array('qty' => 1, 'price' => $price));
            }
        } else {
            $display_price = $price;
        }

        if ($neg) {
            $display_price = '-' . $display_price;
        }

        $price = $display_price;
    }

    return $price;
}

/**
 * Return tax display mode depending on context.
 *
 * @return string
 */
function rfqtk_prod_add_on_get_product_addon_tax_display_mode()
{
    global $wp_query;

    if (isset($wp_query)) {
        if (function_exists('is_checkout')) {
            if (is_cart() || is_checkout()) {
                return get_option('woocommerce_tax_display_cart');
            }
        }
    }

    return get_option('woocommerce_tax_display_shop');
}


function rfqtk_get_proposal_order_items($order_id, $data)
{


    $the_order = WC()->order_factory->get_order($order_id);

    if (get_option("settings_gpls_woo_rfq_import_order_items_table", 'no') == "no"
        || $the_order->get_meta("settings_gpls_woo_rfq_order_table_imported", true) == "yes"
    ) {
        return;
    }


    $args = array(
        'the_order' => $the_order,
        'data' => $data,
        'plain_text' => false,

    );

    $template = $args['plain_text'] ? 'woo-rfq/rfqtk-proposal_order_detail.php' : 'woo-rfq/rfqtk-proposal_order_detail.php';

    wc_get_template($template, array('the_order' => $the_order, 'data' => $data),
        '', gpls_woo_rfq_plus_DIR . 'woocommerce/');


}


function rftk_add_to_quote_single_css()
{


    //$gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_styles']
    global $product;

    if (!is_object($product) && !function_exists('wc_get_product')) return;

    if (!is_object($product)) {
        $product = wc_get_product(get_the_ID());
        if ($product == false) return;
    }

    if ($product == false || !is_product()) {
        return;
    }

    $gpls_woo_rfq_page_update_button_styles = '';


    $rfq_cart_sc_section_rfq_page_update_cart_button_background = get_option('rfq_cart_sc_section_rfq_page_add_to_quote_button_background', '');

    if (($rfq_cart_sc_section_rfq_page_update_cart_button_background) != '') {

        $gpls_woo_rfq_page_update_button_styles .= "background-color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . " !important;";

    }


    $rfq_cart_sc_section_rfq_page_update_cart_button_color = get_option('rfq_cart_sc_section_rfq_page_add_to_quote_button_color', '');

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_color) != '') {

        $gpls_woo_rfq_page_update_button_styles .= "color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . " !important;";

    }

//!important  str_replace("world","Peter","Hello world!");
    //    echo "<style>.gpls_rfq_css{" . $gpls_woo_rfq_page_update_button_styles . "}</style>";


    //  $no_add_to_cart = get_post_meta($product->get_id(), '_gpls_woo_rfq_no_add_to_cart', true);
    //  $no_add_to_cart = apply_filters('gpls_no_add_to_cart', $no_add_to_cart, $product->get_id());

    $no_add_to_cart = gpls_woo_plus_get_no_add_to_cart($product);


    $no_add_to_cart_global = get_option('settings_gpls_woo_rfq_global_no_add_to_cart', '');
    $no_add_to_cart_global = apply_filters('gpls_global_no_add_to_cart', $no_add_to_cart_global, $product->get_id());


    if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
        $no_add_to_cart = "no";
        $no_add_to_cart_global = "no";
    }


    // $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($no_add_to_cart == "yes" || ($no_add_to_cart_global == 'yes' && $rfq_enable == 'yes')) {
        echo "<style>.single_add_to_cart_button {display:none !important;}#woo_pp_ec_button_product {display:none !important;}.gpls_rfq_set{display:block !important;}</style>";
    }


//$("p").css({"background-color": "yellow", "font-size": "200%"});

    $rfq_product_script = "<script> 
jQuery(document).ready( function() {
    jQuery( '.gpls_rfq_set' ).addClass('gpls_rfq_css');
    jQuery( '.gpls_rfq_set' ).css({'color':'" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . "'});
    jQuery( '.gpls_rfq_set' ).css({'background-color':'" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . "'});
    
    jQuery( '.gpls_rfq_set' ).mouseover(function(){
        jQuery( '.gpls_rfq_set' ).removeClass('gpls_rfq_css');  
})
jQuery( '.gpls_rfq_set' ).mouseover(function(){
       // jQuery( '.gpls_rfq_set' ).addClass('gpls_rfq_css');  
});


} ); </script>";


    echo $rfq_product_script;


}


if (!function_exists('gpls_woo_rfq_hide_shipping_prices_css')) {
    function gpls_woo_rfq_hide_shipping_prices_css()
    {


        $hide_shipping_prices = get_option('settings_gpls_woo_rfq_hide_shipping_prices');

        if ((isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

            if ($hide_shipping_prices == 'yes') {

                foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

                    $product = $cart_item['data'];

                    //   $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
                    //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

                    //   $rfq_enable = gpls_woo_plus_get_rfq_enable($product);
                    $hide_array = gpls_woo_rfq_check_cart();

                    if (is_array($hide_array) && count($hide_array) > 0) {
                        if (isset($hide_array['rfq_enable']) && $hide_array['rfq_enable'] == 'yes') {
                            $custom_js = "jQuery('.cart-subtotal' ).attr('style','display: none !important');jQuery( '.cart-subtotal' ).hide();
                                jQuery( '.tax-total' ).attr('style','display: none !important');jQuery( '.tax-total' ).hide();
                                jQuery( '.order-total' ).attr('style','display: none !important');jQuery( '.order-total' ).hide();
                                 jQuery( '.tax-rate' ).attr('style','display: none !important');jQuery( '.tax-rate' ).hide();
                                ";

                            if ($custom_js != "") {
                                wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);
                            }

                            // $url_js = gpls_woo_rfq_plus_URL . 'assets/js/hide_shipping_price.js';
                            // $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/hide_shipping_price.js';
                            // wp_enqueue_script('hide_shipping_price_js', $url_js, array('jquery'), rand(10, 100000), true);


                            $custom_css = ".cart-subtotal{display: none !important;},.wapf-pricing-hint{display:none !important;.tax-total {
                                display: none !important}.order-total {display: none !important}
                                .cart_totals{display: none !important;}.tax-rate{display: none !important;}";

                            wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);

                            break;

                        }
                    }


                    //   break;

                }

            }
        }

    }

}


if (function_exists('rftk_header_css')) {
    function rftk_header_css()
    {

        $hide_shipping = get_option('settings_gpls_woo_rfq_hide_shipping', 'no');

        if ($hide_shipping === 'yes') {


            if (function_exists('is_account_page')) {
                if (is_account_page()) return;
            }

            if (!function_exists('WC')) return false;

            WC()->initialize_session();

            if (!WC()->cart) return false;

            $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');


            if ((isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

                if ($hide_all == 'yes') {

                    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

                        $product = $cart_item['data'];

                        //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
                        //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

                        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


                        if ($rfq_enable == 'yes') {

                            $custom_js = "jQuery( '.wapf-pricing-hint' ).attr('style','display: none !important');
                    jQuery( '.wapf-product-totals' ).attr('style','display: none !important');
                    jQuery( '.woocommerce-shipping-totals' ).attr('style','display: none !important');
                    jQuery( '.shipping' ).attr('style','display: none !important');jQuery( '.shipping' ).hide();
                    jQuery( '.cart_totals' ).attr('style','display: none !important');jQuery( '.cart_totals' ).hide();
                                ";

                            if ($custom_js != "") {
                                wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);
                            }

                            $custom_css = ".tm-custom-price-totals,.woocommerce-shipping-totals ,.shipping {display:none !important;},
                    .wapf-product-totals{display: none !important;}.wapf-pricing-hint{display:none !important;}
                    .cart_totals{display: none !important;}";

                            wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);

                            break;
                            //return;

                        }


                    }


                } else {

                    $custom_js = "jQuery( '.woocommerce-shipping-totals' ).attr('style','display: none !important')
                                ";

                    if ($custom_js != "") {
                        wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);
                    }

                    $custom_css = ".woocommerce-shipping-totals {display:none !important;}";

                    wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);

                }
            }
        }

    }
}

function rftk_shipping_rate_cost($cost, $rate)
{
    if (is_account_page()) return true;
    if ((isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        if ($hide_all == 'yes') {

            foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

                $product = $cart_item['data'];

                //   $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
                //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

                $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


                if ($rfq_enable == 'yes') {
                    return false;
                }

            }
            return $cost;

        } else {
            return false;
        }
    }

    return $cost;
}


function rftk_shipping_rate_taxes($cost, $rate)
{


    if (is_account_page()) return $cost;

    if ((isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        if ($hide_all == 'yes') {

            foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

                $product = $cart_item['data'];

                //   $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
                //    $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

                $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


                if ($rfq_enable == 'yes') {
                    return array();
                }
            }
            return $cost;

        } else {
            return array();
        }
    }

    return $cost;
}


function rfqtk_Plus_sortable_columns($columns)
{


    $columns['_gpls_woo_rfq_rfq_enable'] = 'RFQ';
    $columns['_gpls_woo_rfq_no_add_to_cart'] = 'Hide Add2Cart';
    $columns['_gpls_woo_rfq_hide_price'] = 'Hide price';
    $columns['_gpls_woo_individual_per_order'] = 'Only product in the order';
    return $columns;
}

function rfqtk_Plus_columns_head($defaults)
{
    if (!isset($_GET['post_type']) || $_GET['post_type'] != 'shop_order') {
        return $defaults;
    }
    if (get_query_var('post_type')) {
        $defaults['_gpls_woo_rfq_rfq_enable'] = 'RFQ';
    }

    return $defaults;
}

function rfqtk_Plus_column_orderby($query)
{

    $orderby = $query->get('orderby');


    if ('RFQ' == $orderby) {

        $meta_query = array(
            'relation' => 'OR',
            array(
                'key' => '_gpls_woo_rfq_rfq_enable',
                'compare' => 'EXISTS'
            ),
            array(
                'key' => '_gpls_woo_rfq_rfq_enable',
                'compare' => 'NOT EXISTS'
            ),
        );

        $query->set('meta_query', $meta_query);
        $query->set('orderby', 'meta_value');

    }

    if ('Hide Add2Cart' == $orderby) {

        $meta_query = array(
            'relation' => 'OR',
            array(
                'key' => '_gpls_woo_rfq_no_add_to_cart',
                'compare' => 'EXISTS'
            ),
            array(
                'key' => '_gpls_woo_rfq_no_add_to_cart',
                'compare' => 'NOT EXISTS'
            ),
        );

        $query->set('meta_query', $meta_query);
        $query->set('orderby', 'meta_value');

    }

    if ('Hide price' == $orderby) {

        $meta_query = array(
            'relation' => 'OR',
            array(
                'key' => '_gpls_woo_rfq_hide_price',
                'compare' => 'EXISTS'
            ),
            array(
                'key' => '_gpls_woo_rfq_hide_price',
                'compare' => 'NOT EXISTS'
            ),
        );

        $query->set('meta_query', $meta_query);
        $query->set('orderby', 'meta_value');

    }

    if ('Only product in the order' == $orderby) {

        $meta_query = array(
            'relation' => 'OR',
            array(
                'key' => '_gpls_woo_individual_per_order',
                'compare' => 'EXISTS'
            ),
            array(
                'key' => '_gpls_woo_individual_per_order',
                'compare' => 'NOT EXISTS'
            ),
        );

        $query->set('meta_query', $meta_query);
        $query->set('orderby', 'meta_value');

    }

}


function rfqtk_Plus_columns_content($column_name, $post_ID)
{

    if (!isset($_GET['post_type']) || $_GET['post_type'] != 'shop_order') {
        return $column_name;
    }

    if ($column_name == '_gpls_woo_rfq_rfq_enable') {
        $size = get_post_meta($post_ID, '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = get_post_meta($post_ID, '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $post_ID);
        $size = !isset($size) ? '' : $rfq_enable;
        if ($size == 'yes') {
            $size = 'X';
        } else {
            $size = '';
        }

        echo $size;
    }
}


function gpls_woo_woocommerce_plus_thankyou_order_received_text($message, $order)
{

    if (is_object($order) == false || $order == null || $order == false) {
        return $message;
    }

    if ($order->get_status() == 'gplsquote-sent') {
        $confirmation_message = __('Your quote for request #' . $order->get_id(), 'rfqtk');

        return $confirmation_message;
    } else {
        return $message;
    }
}


function filter_woocommerce_loop_add_to_cart_args($args, $product)
{

    //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    $args['attributes']['data-rfq-mode'] = $GLOBALS["gpls_woo_rfq_checkout_option"];
    $args['attributes']['data-rfq-enabled'] = $rfq_enable;
    return $args;
}


function gpls_woo_rfqtk_woocommerce_product_addons_price_raw($product_price, $addon)
{

    global $product;

    if (is_account_page()) return $product_price;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $product_price;

    $temp_price = $product_price;

    // $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
    //  $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($product);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');


    //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }
    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $product->get_id());

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($in_role == false || $hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes')) {

        $temp_price = '';
    }


    global $wp_query;

    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    $temp_price = apply_filters('gpls_woo_rfq_get_price', $temp_price, $product, $rfq_enable);

    return $temp_price;
}

//$price_raw     = apply_filters( 'woocommerce_product_addons_price_raw', '1' == $adjust_price && $price ? $price : '', $addon );
//$price_display = apply_filters( 'woocommerce_product_addons_price',
//	'1' == $adjust_price && $price_raw ? WC_Product_Addons_Helper::get_product_addon_price_for_display( $price_raw ) : '',
//	$addon,
//	0,
//	'custom_textarea'
//)
function gpls_woo_rfqtk_woocommerce_product_addons_price($html, $addon, $i, $addon_type)
{

    global $product;

    if (is_account_page()) return $html;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $html;

    $temp_price = $html;

    // $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
    //  $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($product);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');


    // $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }
    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $product->get_id());

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($in_role == false || $hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes')) {

        $temp_price = '';
    }

    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    $temp_price = apply_filters('gpls_woo_rfq_get_price', $temp_price, $product, $rfq_enable);

    return $temp_price;


}


function gpls_woo_rfqtk_individual_price_hidden_html($product_price, $product)
{
    if (is_account_page()) return $product_price;

    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $product_price;

    $temp_price = $product_price;

    //  $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
    //  $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($product);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');


    // $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }
    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $product->get_id());

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($in_role == false || $hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes')) {

        $temp_price = '';
    }


    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    $temp_price = apply_filters('gpls_woo_rfq_get_price', $temp_price, $product, $rfq_enable);

    return $temp_price;
}


function gpls_woo_rfqtk_product_addons_option_price_raw($product_price, $option)
{

    if (is_account_page()) return $product_price;

    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $product_price;

    global $product;

    if (!is_object($product) && !function_exists('wc_get_product')) return;
    if (!is_object($product)) $product = wc_get_product(get_the_ID());
    if (!is_object($product)) $product = WC()->product_factory->get_product(get_the_ID());

    if (!isset($product) || !is_object($product)) {
        return $product_price;
    }

    $temp_price = $product_price;
    $p = '';

    $rfq_enable = false;

    if (isset($product) && is_object($product)) {

        $data = $product->get_data();

        $this_price = $data["price"];

        if (trim($data["sale_price"]) != '') {
            $this_price = $data["sale_price"];
        }

        $type = $product->get_type();

        if ($type == 'simple' || $type == 'variable') {
            if (trim($this_price) === '') {
                //  $temp_price = $p;
            }
        }

        //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] != "rfq") {

            switch ($rfq_enable) {
                case 'no':
                    break;
                case '':
                    break;
                case 'yes':
                    if (get_option('settings_gpls_woo_rfq_normal_checkout_show_prices', 'no') == 'no') {
                        // echo 'individual_price_hidden $price = 0'.'<br />';
                        $temp_price = $p;

                    } else {
                        if (!isset($price) || trim($price) == '' || $price == 0) {
                            //  $temp_price = $p;
                        }
                    }

                    break;
            }
        }


    }


    if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq"
        || (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

        if (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'no') {
            // echo 'individual_price_hidden $price = 0'.'<br />';
            $temp_price = $p;
        } else {

        }

    }

    if (function_exists('wp_get_current_user')) {
        if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
            $temp_price = $p;

        }
    }


    //  $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
    //  $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($product);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');


    // $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }

    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $product->get_id());

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase" && function_exists('wp_get_current_user')) {
        $in_role = false;

        $user = wp_get_current_user();

        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }
        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($in_role == false || $hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes')) {

        $temp_price = false;
    }


    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    // $temp_price = apply_filters('gpls_woo_rfq_get_price', $temp_price,$product, $rfq_enable);


    return $temp_price;


}


function gpls_woo_rfqtk_individual_price_hidden_variation_html($price, $product, $min_or_max, $display)
{
    if (is_account_page()) return $price;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $price;

    if ($product->get_type() == 'external') {
        return $price;
    }

    $temp_price = $price;

    //   $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
//    $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($product);


    if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
        $hide_price = "no";
    }


    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

    //$rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //$rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }
    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $product->get_id());


    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }
    if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

        $temp_price = '';
    }

    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    $temp_price = apply_filters('gpls_woo_rfq_get_price', $temp_price, $product, $rfq_enable);
    return $temp_price;


}


function gpls_woo_rfqtk_product_is_on_sale($is_on_sale, $product)
{
    if (is_account_page()) return $is_on_sale;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $is_on_sale;

    if ($product->get_type() == 'external') {
        return $is_on_sale;
    }

    $temp_price = $is_on_sale;

    //   $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
    //   $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($product);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

    // $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }
    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $product->get_id());

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

        $temp_price = '';
    }

    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    // $temp_price = apply_filters('gpls_woo_rfq_get_price', $temp_price,$product, $rfq_enable);
    return $temp_price;
}


function gpls_woo_rfqtk_woo_custom_cart_button_text($product_add_to_cart_text, $product)
{


    if ($product->get_type() == 'external') {
        return $product_add_to_cart_text;
    }

    global $wp_query;
    $is_product = false;
    if (isset($wp_query)) {
        if (is_product()) {
            $is_product = true;
        }
    }

    if (($product->get_type() == 'variable') && $is_product == false) {

        return $product_add_to_cart_text;//"In RFQ"

    }


    $limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', 'no');

    //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    $default_text = __('Add to Quote', 'rfqtk');


    if ($limit_to_rfq_only == "yes" && $rfq_enable == "yes" && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {

        $add_txt = get_option('rfq_cart_wordings_add_to_rfq', $default_text);

        $product_add_to_cart_text = __($add_txt, 'rfqtk');

        add_filter('gpls_woo_rfq_proceed_to_rfq', 'rfqtk_rfq_proceed_to_rfq', 100);

    }


    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    $in_role = false;

    if ($enable_roles != "no" && is_user_logged_in()) {


        $user = wp_get_current_user();

        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;

            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);
    }


    if (!$in_role && $enable_roles == "purchase") {
        {
            $product_add_to_cart_text = get_option('rfq_cart_wordings_add_to_rfq', $default_text);
            $product_add_to_cart_text = __($product_add_to_cart_text, 'rfqtk');

            $in_txt = get_option('rfq_cart_wordings_in_rfq', $default_text);
            $in_txt = __($in_txt, 'rfqtk');
        }

        global $woocommerce;

        if (isset($woocommerce) && $woocommerce->cart != null) {
            $product_cart_id = WC()->cart->generate_cart_id($product->get_id());
            if (WC()->cart->find_product_in_cart($product_cart_id)) {

                $product_add_to_cart_text = $in_txt;
                return $product_add_to_cart_text;


            }

        }
    }

    return $product_add_to_cart_text;

}


function gpls_woo_rfqtk_woocommerce_get_order_item_totals($total_rows, $order)
{
    if (is_account_page()) return $total_rows;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $total_rows;

    $temp_price = $total_rows;

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }

    foreach ($order->get_items() as $item_id => $item_product) {
        //Get the product ID
        $product_id = $item_product->get_product_id();
        //Get the WC_Product object
        $_product = $item_product->get_product();
        //Get the product SKU (using WC_Product method)
        if (!$_product) continue;

        //     $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);
        //     $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $_product->get_id());

        $hide_price = gpls_woo_plus_get_hide_price($_product);

        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == "no") {
            $hide_all = "no";
        }
        $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $_product->get_id());

        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {
            $temp_price = array();
            break;
        }

    }

    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = array();
                    }
                }
            }
        }
    }


    return $temp_price;
}


//
function gpls_woo_rfqtk_get_formatted_order_total($formatted_total, $order)
{
    if (is_account_page()) return $formatted_total;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $formatted_total;

    $temp_price = $formatted_total;

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }

    foreach ($order->get_items() as $item_id => $item_product) {
        //Get the product ID
        $product_id = $item_product->get_product_id();
        //Get the WC_Product object
        $_product = $item_product->get_product();
        //Get the product SKU (using WC_Product method)

        if (!$_product) continue;

        //      $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);
        //      $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $_product->get_id());

        $hide_price = gpls_woo_plus_get_hide_price($_product);

        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == "no") {
            $hide_all = "no";
        }
        $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $_product->get_id());

        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {
            $temp_price = '';
            break;
        }

    }

    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes" && $order->get_status() == "gplsquote-req") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart() || is_account_page()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    return $temp_price;

}

//
function gpls_woo_rfqtk_order_formatted_line_subtotal($subtotal, $item, $order)
{
    if (is_account_page()) return $subtotal;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $subtotal;

    $temp_price = $subtotal;

    //Get the product ID
    $product_id = $item->get_product_id();
    //Get the WC_Product object
    $_product = $item->get_product();
    //Get the product SKU (using WC_Product method)
    if (!$_product) return $subtotal;

//    $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);
    //   $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $_product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($_product);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

    //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }
    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $_product->get_id());

    //  echo $_product->get_id().' '.$hide_price.' '.$hide_all.' '.$rfq_enable.'<br />';

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }

    if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

        $temp_price = '';

    }

    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    return $temp_price;


}


function gpls_woo_rfqtk_hide_woocommerce_cart_total($price)
{

    if (is_account_page()) return $price;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $price;

    $temp_price = $price;

    $items = WC()->cart->get_cart();
    $product_names = array();

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }

    foreach ($items as $item => $values) {

        $_product = wc_get_product($values['product_id']);

        //  $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);
        //  $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $_product->get_id());

        $hide_price = gpls_woo_plus_get_hide_price($_product);


        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == "no") {
            $hide_all = "no";
        }
        $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $_product->get_id());

        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

            $temp_price = '';
            break;
        }

    }

    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    return $temp_price;

}


function gpls_woo_rfqtk_hide_tax_woocommerce_cart_subtotal($tax_totals, $cart)
{
    if (is_account_page()) return $tax_totals;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $tax_totals;

    $temp_price = $tax_totals;

    $items = WC()->cart->get_cart();
    $product_names = array();

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    foreach ($items as $item => $values) {


        $_product = wc_get_product($values['product_id']);

        //    $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);
        //    $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $_product->get_id());

        $hide_price = gpls_woo_plus_get_hide_price($_product);

        if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
            $hide_price = "no";
        }

        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == "no") {
            $hide_all = "no";
        }
        $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $_product->get_id());

        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

            $temp_price = array();
            break;
        }

    }

    global $wp_query;
    if (isset($wp_query)) {
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    return $temp_price;
}

function gpls_woo_rfqtk_hide_woocommerce_cart_subtotal($cart_subtotal, $compound, $cart)
{
    if (is_account_page()) return $cart_subtotal;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $cart_subtotal;

    $temp_price = $cart_subtotal;

    $items = WC()->cart->get_cart();
    $product_names = array();

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }

    foreach ($items as $item => $values) {


        $_product = wc_get_product($values['product_id']);

        //   $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);
        //    $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $_product->get_id());

        $hide_price = gpls_woo_plus_get_hide_price($_product);

        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == "no") {
            $hide_all = "no";
        }

        $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $_product->get_id());

        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

            $temp_price = '';
            break;
        }

    }

    global $wp_query;
    if (isset($wp_query)) {

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    return $temp_price;
}


function gpls_woo_rfq_hide_price_total($subtotal, $item, $order)
{
    if (is_account_page()) return $subtotal;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == 'yes') return $subtotal;

    $temp_price = $subtotal;

    //   $hide_price = get_post_meta($item->get_id(), '_gpls_woo_rfq_hide_price', true);
    //   $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $item->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($item);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

    // $rfq_enable = get_post_meta($item->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $item->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($item);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }

    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $item->get_id());


    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

        $temp_price = '';
    }

    global $wp_query;
    if (isset($wp_query)) {

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    return $temp_price;
}


function gpls_woo_rfq_hide_price_function($temp_price, $price, $product, $rfq_enable)
{
    if (is_account_page()) return $temp_price;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $temp_price;

//    $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
    //   $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($product);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

    // $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }

    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $product->get_id());

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }
        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

        $temp_price = '';
    }

    global $wp_query;
    if (isset($wp_query)) {

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    return $temp_price;
}


function gpls_woo_rfq_hide_subtotal_price_function($subtotal, $cart_item, $cart_item_key)
{
    if (is_account_page()) return $subtotal;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $subtotal;

    $temp_price = $subtotal;

    $_product = wc_get_product($cart_item['data']->get_id());

    //   $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);
    //   $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $_product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($_product);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

    // $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }
    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $_product->get_id());

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }
        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {
        $temp_price = '';
    }

    global $wp_query;
    if (isset($wp_query)) {

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    return $temp_price;
}


//apply_filters( 'woocommerce_get_price_including_tax', $return_price, $qty, $product );


function gpls_woo_rfqtk_individual_price_hidden_tax($product_price, $qty, $product)
{
    if (is_account_page()) return $product_price;
    if (is_admin() || gpls_woo_rfq_plus_check_staff_mode() == "yes") return $product_price;

    $temp_price = $product_price;

//    $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);
    //   $hide_price = apply_filters('gpls_hide_product_price', $hide_price, $product->get_id());

    $hide_price = gpls_woo_plus_get_hide_price($product);

    $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

    //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($rfq_enable == "no") {
        $hide_all = "no";
    }

    $hide_all = apply_filters('gpls_limit_to_rfq_only_hide_prices', $hide_all, $product->get_id());

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles == "purchase") {
        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }
        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    if ($in_role == false || $hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes')) {

        $temp_price = false;
    }

    global $wp_query;
    if (isset($wp_query)) {

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {

            $hide_cart_checkout = get_option('gpls_woo_rfq_hide_price_cart_checkout', 'no');

            if ($hide_cart_checkout == "yes") {
                if (function_exists('is_checkout')) {
                    if (is_checkout() || is_cart()) {
                        $temp_price = '';
                    }
                }
            }
        }
    }

    return $temp_price;
}


function gplsrfq_add_to_rfq_cart_finished($product_id, $is_set)
{


    if ($is_set == "no" || !$is_set) {
        return;
    }

    $is_quote_page = false;
    //$GLOBALS["gpls_4woo_quote_current_url"] = preg_replace('{/$}', '', $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
    $gpls_4woo_quote_current_url = preg_replace('{/$}', '', gpls_woo_rfq_remove_http(get_site_url() . $_SERVER['REQUEST_URI']));

    // $GLOBALS["gpls_4woo_quote_current_url"] = preg_replace('{/$}', '', $http_host . $_SERVER['REQUEST_URI']);
    $link_to_rfq_page = preg_replace('{/$}', '', gpls_woo_rfq_remove_http(pls_woo_rfq_get_link_to_rfq()));

    if (trim(substr(trim($gpls_4woo_quote_current_url), 0, strlen($link_to_rfq_page))) == trim($link_to_rfq_page)) {

        $is_quote_page = true;

    }


    if ($is_quote_page == true) {
        if (function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_logged_in_only', 'no') == 'yes'
                && !wp_get_current_user()->exists()) {

                $link = get_permalink(get_option('woocommerce_myaccount_page_id'));

                $session = gpls_woo_get_session();


                gpls_woo_rfq_cart_set('return to quote request page', 'yes');

                $message = get_option('settings_gpls_woo_rfq_logged_in_only_message', '');
                if ($message != '') {
                    // wc_add_notice($message);
                }


                wp_safe_redirect($link);
                exit;

            }
        }
    }


    $product = wc_get_product($product_id);

    $redirect = 'no';


    if (get_option('rfq_cart_sc_redirect_after_add') == 'yes') {
        $redirect = 'yes';
    }

    $home = home_url() . '/quote-request/';

    $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);

    $actual_link = get_site_url() . $_SERVER['REQUEST_URI'];

    if (parse_url(trim($rfq_page))['path'] === parse_url(trim($actual_link))['path']) {
        $redirect = 'no';
    }

    //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($rfq_enable != "yes") {
        $redirect = 'no';
    }

    if ($redirect === 'yes') {

        set_transient('redirect_to_quote_request', 'yes', 0);


        $url_new = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);

        if ($url_new != '') {

            $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');

            if (count($gpls_woo_rfq_cart) > 0) {


                $ajax_cart_en = get_option('woocommerce_enable_ajax_add_to_cart', 'no');
                $rfq_single_product = !empty($_POST["rfq_single_product"]) ? $_POST["rfq_single_product"] : false;

                if ($ajax_cart_en === "no") {

                    wp_safe_redirect($url_new);
                    exit;

                }

                if ($ajax_cart_en === "yes"
                    && !isset($_POST["rfq_single_product"])
                ) {
                    $data = array(
                        'location' => $url_new, 'rfq_single_product' => 'no', 'ajax' => 'yes');
                    wp_send_json_success($data);
                    exit;
                }
                if ($ajax_cart_en === "yes"
                    && defined('DOING_AJAX') && DOING_AJAX) {

                    $data = array(
                        'location' => $url_new, 'rfq_single_product' => $rfq_single_product, 'ajax' => 'yes');
                    wp_send_json_success($data);
                    exit;

                }
                if ($ajax_cart_en === "yes"
                    && !defined('DOING_AJAX')) {

                    wp_safe_redirect($url_new);
                    exit;

                }


            }
        }
    } else {

        delete_transient('redirect_to_quote_request');
    }


}

function gplsrfq_add_to_cart_button_text_action($add_txt, $product, $rfq_checkout_mode)
{

}


function gpls_woo_rfq_shop_order_bulk_actions($actions)
{
    $ends = gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key), 'D');
    if ($ends == 1) {
        return;
    }

    if (isset($actions['edit'])) {
        unset($actions['edit']);
    }

    $actions['mark_gplsquote-sent'] = __('Mark quote sent', 'rfqtk');

    return $actions;
}

function gpls_woo_rfq_handle_shop_order_bulk_actions($redirect_to, $action, $ids)
{

    $ends = gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key), 'D');
    if ($ends == 1) {
        return $redirect_to;
    }

    // Bail out if this is not a status-changing action.
    if (false === strpos($action, 'mark_')) {
        return $redirect_to;
    }

    $order_statuses = wc_get_order_statuses();
    $new_status = substr($action, 5); // Get the status name from action.
    $report_action = 'marked_' . $new_status;

    // Sanity check: bail out if this is actually not a status, or is
    // not a registered status.
    if (!isset($order_statuses['wc-' . $new_status])) {
        return $redirect_to;
    }

    $changed = 0;
    $ids = array_map('absint', $ids);

    foreach ($ids as $id) {
        $order = wc_get_order($id);
        $order->update_status($new_status, __('Order status changed by bulk edit:', 'rfqtk'), true);
        do_action('woocommerce_order_edit_status', $id, $new_status);
        $changed++;
    }

    $redirect_to = add_query_arg(array(
        'post_type' => 'shop_order',
        $report_action => true,
        'changed' => $changed,
        'ids' => join(',', $ids),
    ), $redirect_to);

    return esc_url_raw($redirect_to);
}


function gpls_woo_rfq_bulk_admin_notices()
{
    global $post_type, $pagenow;

    // Bail out if not on shop order list page
    if ('edit.php' !== $pagenow || 'shop_order' !== $post_type) {
        return;
    }

    $order_statuses = wc_get_order_statuses();

    // Check if any status changes happened
    foreach ($order_statuses as $slug => $name) {

        if (isset($_REQUEST['marked_gplsquote-sent'])) {

            $number = isset($_REQUEST['changed']) ? absint($_REQUEST['changed']) : 0;
            /* translators: %s: orders count */
            $message = sprintf(_n('Order status changed.', '%s order statuses changed.', $number, 'rfqtk'), number_format_i18n($number));
            echo '<div class="updated"><p>' . $message . '</p></div>';

            break;
        }
    }
}


function gpls_woo_rfq_change_posted_date($order_id, $old_status, $new_status, $order)
{

    $order = wc_get_order($order_id);
    $order = WC_Order_Factory::get_order($order_id);

    if ($new_status == "completed" && ($old_status == "gplsquote-sent" || $old_status == "gplsquote-req")) {

        $order->set_date_created(current_time('mysql', 0));
        $order->add_order_note(__('Order Date set to date order completed by RFQ-ToolKit.', 'rfqtk'), false, true);
        $order->save();

    }
    return;
}


function gpls_woo_rfq_after_shop_loop_item_rftk($proceed)
{
    if (get_option('gpls_woo_rfq_after_after_shop_loop_item_proceed', 'yes') == 'no') {
        $proceed = false;
    } else {
    }
    return $proceed;
}


function gpls_rfq_sanitize_text_field($filtered, $str)
{
    return sanitize_textarea_field($str);
}


function gpls_woo_rfq_custom_add_to_cart_button_text_rftk($add_txt, $product, $checkout)
{

    if (function_exists('wp_get_current_user')) {

        if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {

            $default_text = __('Add to Quote', 'rtfk');

            $add_txt = get_option('rfq_cart_wordings_add_to_rfq', $default_text);

            $add_txt = __($add_txt, 'rtfk');
        }
    }
    return $add_txt;

}


function gpls_woo_rfq_is_an_rfq_add_to_cart_rftk($is_an_rfq, $REQUEST, $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data, $rfq_enable)
{

    if (function_exists('wp_get_current_user')) {
        if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
            $is_an_rfq = true;
        }
    }

    return $is_an_rfq;

}


function gpls_woo_rfq_after_after_shop_loop_item_filter_rftk($is_an_rfq, $product)
{

    if (function_exists('wp_get_current_user')) {
        if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
            $is_an_rfq = true;
        }
    }


    return $is_an_rfq;

}


function gpls_woo_rfq_hide_after_shop_loop_item_filter($hide, $product)
{
    $show_all_in_single = get_option('settings_gpls_woo_rfq_only_on_single_page_normal', 'no');
    $show_quotes_in_single = get_option('settings_gpls_woo_quote_only_on_single_page_normal', 'no');

    if ($show_all_in_single == 'yes' || $show_quotes_in_single == 'yes') {

        global $wp_query;
        $is_product = false;

        if (isset($wp_query) && function_exists('is_product')) {
            if (is_product()) {
                $is_product = true;
            }
        }

        if ($is_product == false) {
            $hide = true;
        }
    }

    return $hide;

}


function gpls_woorfq_save_post_update_callback($post_id, $post, $update)
{

    $is_new = $post->post_date === $post->post_modified;


    if ($is_new) {


        if ($post->post_type == 'product') {


            //if (!$update)
            {

                /*  $option_value1 = get_option('settings_gpls_woo_rfq_bulk_rfq_enable_in_cat');

                  $option_value_list1 = explode(',', $option_value1);

                  if (has_term($option_value_list1, 'product_cat', $post_id)) {

                      update_post_meta($post_id, '_gpls_woo_rfq_rfq_enable', 'yes');

                  }*/

                /////////////////////////////////////////////////////////////////////////////////////////////////

                /* $option_value2 = get_option('settings_gpls_woo_rfq_bulk_hide_add_to_cart_cat');


                 $option_value_list2 = explode(',', $option_value2);


                 if (has_term($option_value_list2, 'product_cat', $post_id)) {

                     update_post_meta($post_id, '_gpls_woo_rfq_no_add_to_cart', 'yes');

                 }*/

                /////////////////////////////////////////////////////////////////////////////////////////////////

                /*  $option_value3 = get_option('settings_gpls_woo_rfq_bulk_hide_price_cat');

                  $option_value_list3 = explode(',', $option_value3);


                  if (has_term($option_value_list3, 'product_cat', $post_id)) {
                      update_post_meta($post_id, '_gpls_woo_rfq_hide_price', 'yes');

                  }*/

                /////////////////////////////////////////////////////////////////////////////////////////////////
                /*$cats = isset($_POST['tax_input']['product_cat']) ? $_POST['tax_input']['product_cat'] : array();

                $exclude_array = isset($GLOBALS['gpls_woo_rfq_excluded_cats_no_quote']) ?
                    $GLOBALS['gpls_woo_rfq_excluded_cats_no_quote'] : array();*/

                $settings_gpls_woo_rfq_rfq_enable_default = get_option('settings_gpls_woo_rfq_rfq_enable_default');


                if ($settings_gpls_woo_rfq_rfq_enable_default == 'yes' && !empty($_POST)) {

                    delete_post_meta($post_id, '_gpls_woo_rfq_rfq_enable');
                    update_post_meta($post_id, '_gpls_woo_rfq_rfq_enable', 'yes');
                }

                /*if (count(array_intersect($cats, $exclude_array)) === 0) {

                    update_post_meta($post_id, '_gpls_woo_rfq_rfq_enable', 'yes');
                } else {

                    delete_post_meta($post_id, '_gpls_woo_rfq_rfq_enable');
                }*/


                /////////////////////////////////////////////////////////////////////////////////////////////////

                /* $option_value4 = get_option('settings_gpls_woo_rfq_cats_new_enable_product_messages');

                 $option_value_list4 = explode(',', $option_value4);

                 if (has_term($option_value_list4, 'product_cat', $post_id)) {

                     update_post_meta($post_id, "_gpls_woo_rfq_plus_show_product_email_message", "yes");


                 }*/

                /////////////////////////////////////////////////////////////////////////////////////////////////

                /* $option_value5 = get_option('settings_gpls_woo_rfq_bulk_hide_price_cat');

                 $option_value_list5 = explode(',', $option_value5);

                 if (has_term($option_value_list5, 'product_cat', $post_id)) {
                     update_post_meta($post_id, '_gpls_woo_rfq_rfq_enable', 'yes');

                 }*/

                ///////////////////////////////////////////////////////////////////////////////////////////


            }

        }


    }

}


function gpls_woorfq_save_post_callback($post_id, $post, $update)
{

    if ($update) {
        //return;
    }

    if (wp_is_post_revision($post_id)) {
        // return;
    }


    if ('product' != $post->post_type && 'shop_order' != $post->post_type)
        return;

//Grab our initial meta value, if set will return true else wordpress will return and empty string(falsey)

    if ($post->post_type == 'product') {
//
    }


    if ($post->post_type == 'shop_order') {

        $settings_gpls_woo_rfq_pay_default = get_option('settings_gpls_woo_rfq_pay_default');
        if ($settings_gpls_woo_rfq_pay_default == 'yes') {

            if (!metadata_exists('post', $post_id, '_include_proposal_pay_link')) {
                update_post_meta($post_id, '_include_proposal_pay_link', 'yes');
            }
        }


        $settings_gpls_woo_rfq_respond_default = get_option('settings_gpls_woo_rfq_respond_default');
        if ($settings_gpls_woo_rfq_respond_default == 'yes') {

            if (!metadata_exists('post', $post_id, '_include_respond_link')) {
                update_post_meta($post_id, '_include_respond_link', 'yes');
            }
        }

        $settings_gpls_woo_rfq_accept_default = get_option('settings_gpls_woo_rfq_accept_default');
        if ($settings_gpls_woo_rfq_accept_default == 'yes') {

            if (!metadata_exists('post', $post_id, '_include_accept_link')) {
                update_post_meta($post_id, '_include_accept_link', 'yes');
            }
        }

        $settings_gpls_woo_rfq_multiple_offers_default = get_option('settings_gpls_woo_rfq_multiple_offers_default');
        if ($settings_gpls_woo_rfq_multiple_offers_default == 'yes') {

            if (!metadata_exists('post', $post_id, '_allow_multiple_offers')) {
                update_post_meta($post_id, '_allow_multiple_offers', 'yes');
            }
        }


        $settings_gpls_woo_rfq_default_proposal = get_option('settings_gpls_woo_rfq_default_proposal_content');

        if (!metadata_exists('post', $post_id, '_quote_sent_note')) {
            update_post_meta($post_id, '_quote_sent_note', $settings_gpls_woo_rfq_default_proposal . '<br/>');

        }

        if (isset($_POST['gpls_woo_rfq_email_sender'])) {
            update_post_meta($post_id, '_gpls_woo_rfq_email_sender', $_POST['gpls_woo_rfq_email_sender']);
        }

        if (isset($_POST['gpls_woo_rfq_email_cc'])) {
            update_post_meta($post_id, '_gpls_woo_rfq_email_cc', $_POST['gpls_woo_rfq_email_cc']);
        }

        if (isset($_POST['gpls_woo_rfq_email_reply'])) {
            update_post_meta($post_id, '_gpls_woo_rfq_email_reply', $_POST['gpls_woo_rfq_email_reply']);
        }

    }

}


function gpls_woo_rfq_plus_order_item_meta($item_id, $cart_item, $cart_item_key)
{

    if (isset($cart_item['ppom']['fields'])) {
        $extra_options = ($cart_item['ppom']['fields']);

        if ($extra_options) {
            foreach ($extra_options as $name => $data) {

                if ($name != "id") {
                    wc_add_order_item_meta($item_id, $name, trim(stripslashes($data)));
                }
            }
        }
    }

}


function gpls_woo_rfq_no_add_to_cart($remove, $product, $normal_check)
{


    //  $no_add_to_cart = get_post_meta($product->get_id(), '_gpls_woo_rfq_no_add_to_cart', true);
    //  $no_add_to_cart = apply_filters('gpls_no_add_to_cart', $no_add_to_cart, $product->get_id());

    $no_add_to_cart = gpls_woo_plus_get_no_add_to_cart($product);


    $no_add_to_cart_global = get_option('settings_gpls_woo_rfq_global_no_add_to_cart', '');
    $no_add_to_cart_global = apply_filters('gpls_global_no_add_to_cart', $no_add_to_cart_global, $product->get_id());


    if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
        $no_add_to_cart = "no";
        $no_add_to_cart_global = "no";
    }


    //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    $result = "no";


    if ($no_add_to_cart == "yes" || ($no_add_to_cart_global == 'yes' && $rfq_enable == 'yes')) {
        //  $result = "yes";
    }

    //new 1/29/22

    return $result;

}


function gpls_woo_rfq_plus_add_to_cart_link_shop($link, $product)
{


    //   $no_add_to_cart = get_post_meta($product->get_id(), '_gpls_woo_rfq_no_add_to_cart', true);
    //  $no_add_to_cart = apply_filters('gpls_no_add_to_cart', $no_add_to_cart, $product->get_id());

    $no_add_to_cart = gpls_woo_plus_get_no_add_to_cart($product);


    $no_add_to_cart_global = get_option('settings_gpls_woo_rfq_global_no_add_to_cart', '');
    $no_add_to_cart_global = apply_filters('gpls_global_no_add_to_cart', $no_add_to_cart_global, $product->get_id());


    if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
        $no_add_to_cart = "no";
        $no_add_to_cart_global = "no";
    }


    //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    $no_archive = get_option('settings_gpls_woo_rfq_only_on_single_page_rfq', 'no');

    if ($no_add_to_cart == 'yes' || $no_archive == 'yes' || ($no_add_to_cart_global == 'yes' && $rfq_enable == 'yes')) {
        return '';
    }

    return $link;
}

function gpls_woo_rfq_plus_after_add_to_cart_button()
{

    global $product;

    if (!is_object($product)) {
        $product = wc_get_product(get_the_ID());
        if ($product == false) return;
    }

    if ($product->get_type() == 'external') {
        return;
    }
    if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
        return;
    }


    $proceed = true;

    $proceed = apply_filters('proceed_to_add_to_quote_button', $proceed, $product);


    if ($proceed == false) return;


    //  $no_add_to_cart = get_post_meta($product->get_id(), '_gpls_woo_rfq_no_add_to_cart', true);
    //   $no_add_to_cart = apply_filters('gpls_no_add_to_cart', $no_add_to_cart, $product->get_id());

    $no_add_to_cart = gpls_woo_plus_get_no_add_to_cart($product);

    $no_add_to_cart_global = get_option('settings_gpls_woo_rfq_global_no_add_to_cart', '');
    $no_add_to_cart_global = apply_filters('gpls_global_no_add_to_cart', $no_add_to_cart_global, $product->get_id());


    if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
        $no_add_to_cart = "no";
        $no_add_to_cart_global = "no";
    }


    // $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
    //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    if ($no_add_to_cart == 'yes' || ($no_add_to_cart_global == 'yes' && $rfq_enable == 'yes')) {

        if (!is_admin()) {

            add_action('wp_print_footer_scripts', 'gpls_woo_rfq_print_script_hide_single_add', 9);
            add_action('wp_add_inline_script', 'gpls_woo_rfq_print_script_hide_single_add', 9);
            add_action('wp_enqueue_script', 'gpls_woo_rfq_print_script_hide_single_add', 9);

            $rfq_product_script = "<script> jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '#woo_pp_ec_button_product' ).hide();jQuery( '#woo_pp_ec_button_product' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');
jQuery(window ).on('load', function() { jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');
} ); </script>";

            echo $rfq_product_script;


            echo "<style>.single_add_to_cart_button {display:none !important;}#woo_pp_ec_button_product {display:none !important;}.gpls_rfq_set{display:block !important;}</style>";
        }

    }


}


function gpls_woo_rfq_print_script_hide_single_add()
{
    if (!is_admin()) {


        $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk.js';
        $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk.js';
        wp_enqueue_script('gpls_woo_rfq_plus_js', $url_js, array('jquery'), rand(10, 100000), true);


        $custom_js = " jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '#woo_pp_ec_button_product' ).hide();jQuery( '#woo_pp_ec_button_product' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');
jQuery(window ).on('load', function() { jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important')});";

        wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);

        $rfq_product_script = "<script> jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '#woo_pp_ec_button_product' ).hide();jQuery( '#woo_pp_ec_button_product' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');
jQuery(window ).on('load', function() { jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');}); </script>";


        echo $rfq_product_script;

        $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk.css';
        $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk.css';
        wp_enqueue_style('gpls_woo_rfq_plus_css', $url_css, array(), rand(10, 100000));


        $custom_css = ".single_add_to_cart_button {display:none !important;}#woo_pp_ec_button_product {display:none !important;}.gpls_rfq_set{display:block !important;} ";
        wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);
    }

}

function gpls_woo_rfq_add_to_order_custom_products_action($_product, $cart_item, $cart_item_key, $item_id, $item, $order)
{

    if (isset($cart_item['bundled_items'])) {


        // global $gpls_woo_rfq_cart;
        $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');

        $order_items = $_product->get_bundled_items();

        $temp_items = array();

        $add_order = false;

        foreach ($order_items as $item) {


            $bundled_item_id = $item->item_id;

            $_product_bundle = wc_get_product($item->item_data['product_id']);

            $product_id_bundle = $bundled_item_id;

            if (!$item->is_priced_individually()) {
                $_product_bundle->set_price(0);
            } else {
                //wc_add_order_item_meta($item_id, '_price', $_product_bundle->product->get_price());
            }

            $cart_bundled_items = $gpls_woo_rfq_cart[$cart_item_key]['bundled_items'];


            $add_order = false;

            foreach ($cart_bundled_items as $cart_bundled_item) {
                $tmp_bundled_item_id = ($gpls_woo_rfq_cart[$cart_bundled_item]['bundled_item_id']);
                if ($bundled_item_id == $tmp_bundled_item_id) {
                    $add_order = true;
                    break;
                }

            }


            if ($add_order == true) {
                $item_bundle_id = $order->add_product($_product_bundle, $cart_item['quantity']);

                wc_add_order_item_meta($_product->get_id(), '_bundled_by', 'yes');

                if (!$_product->contains('priced_individually')) {
                    wc_add_order_item_meta($item_bundle_id, '_per_product_pricing', $_product->contains('priced_individually'));
                    wc_add_order_item_meta($item_bundle_id, '_per_product_shipping', $_product_bundle->is_sold_individually());
                }
            }

        }
        $temp_items['bundled_items'] = $order_items;
        wc_add_order_item_meta($item_id, '_bundled_items', $temp_items['bundled_items']);
        wc_add_order_item_meta($item_id, '_bundle_cart_key', $cart_item_key);

    }

    if (isset($cart_item['product_extras'])) {
        $item->update_meta_data('product_extras', $cart_item['product_extras']);
    }

    if (isset($cart_item['wapf'])) {
        $item->add_meta_data('wapf', $cart_item['wapf']);
    }

    $item->save();
}


function gpls_woo_rfq_delete_custom_products_action()
{

    //global $gpls_woo_rfq_cart;
    $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');

    if (isset($gpls_woo_rfq_cart[$_REQUEST['man-deleted']]['bundled_items'])) {

        foreach ($gpls_woo_rfq_cart as $key => $values) {

            if (isset($values['bundled_by']) && $values['bundled_by'] == $_REQUEST['man-deleted']) {

                unset($gpls_woo_rfq_cart[$key]['data']);
                unset($gpls_woo_rfq_cart[$key]);

            }

        }

    }
}


function gpls_woo_rfq_add_custom_products_action($product, $cart_item_key)
{

    //global $gpls_woo_rfq_cart;
    $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');

    if (isset(WC()->cart->cart_contents[$cart_item_key]['product_extras']) && is_array(WC()->cart->cart_contents[$cart_item_key]['product_extras'])) {
        $product_extras = array();
        $product_extras = array_merge($product_extras, WC()->cart->cart_contents[$cart_item_key]['product_extras']);
    }

    if (isset(WC()->cart->cart_contents[$cart_item_key]['wapf']) && is_array(WC()->cart->cart_contents[$cart_item_key]['wapf'])) {
        $product_advanced = array();
        $product_advanced = array_merge($product_advanced, WC()->cart->cart_contents[$cart_item_key]['wapf']);
    }

    if (is_array($product_extras) && count($product_extras) > 0) {
        $gpls_woo_rfq_cart[$cart_item_key]['product_extras'] = $product_extras;
    }

    if (is_array($product_advanced) && count($product_advanced) > 0) {
        $gpls_woo_rfq_cart[$cart_item_key]['wapf'] = $product_advanced;
    }


    if ($product->get_type() == 'bundle') {

        foreach (WC()->cart->cart_contents as $key => $values) {

            if (isset($values['bundled_by']) && $values['bundled_by'] == $cart_item_key) {
                //$gpls_woo_rfq_cart[$cart_item_key] = WC()->cart->cart_contents[$cart_item_key];

                if (isset($gpls_woo_rfq_cart[$key])) {
                    $old_bundled_qty = $gpls_woo_rfq_cart[$key]['quantity'];
                } else {
                    $old_bundled_qty = 0;
                }

                $new_bundled_item_quantity = $old_bundled_qty + WC()->cart->cart_contents[$key]['quantity'];

                $gpls_woo_rfq_cart[$key] = WC()->cart->cart_contents[$key];
                $gpls_woo_rfq_cart[$key]['quantity'] = $new_bundled_item_quantity;

            }

        }
    }


}


if (!function_exists('gpls_woo_rfq_plus_override_woo_frontend_scripts')) {
    function gpls_woo_rfq_plus_override_woo_frontend_scripts()
    {
        //  wp_deregister_script('wc-checkout');

        //  $url_js = gpls_woo_rfq_plus_DIR . 'assets/js/checkout.js';
        //   $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/checkout.js';

        //    wp_enqueue_script('wc-checkout', $url_js, array('jquery', 'rfqtk', 'wc-country-select', 'wc-address-i18n'), filemtime($url_js_path), true);
    }
}


function gpls_woo_rfq_show_atts_in_admin_order($product, $item, $item_id)
{
    //    function gpls_woo_rfq_show_atts_in_admin_order( $item_id, $item, $product ) {

    $show_weight = null;
    if (get_option('wcsa_weight_admin_order_details') == 'yes') {
        $show_weight = true;
    }
    $show_dimensions = null;
    if (get_option('wcsa_dimensions_admin_order_details') == 'yes') {
        $show_dimensions = true;
    }

    if (get_option('wcsa_admin_order_details') != 'no') {
        $skip_atts = null;
    } else {
        $skip_atts = true;
    }


    if (is_object($product)) {
        echo '<td><div class="view">' . wp_kses_post(gpls_woo_rfq_get_selected_attributes($product, 'span', $show_weight, $show_dimensions, $skip_atts)) . '</div></td>';
    }
}


function gpls_woo_rfq_admin_order_item_header()
{
    if (get_option('wcsa_admin_order_details') != 'no') {
        echo '<th class="wsa-custom-attributes">' . __('Attributes', 'woocommerce-show-attributes') . '</th>';
    }
}

function gpls_woo_rfq_get_selected_attributes($product, $element, $show_weight = null, $show_dimensions = null, $skip_atts = null, $single_product = null)
{

    $attribute_array = trim(get_option('settings_gpls_woo_rfq_product_attributes', ''));

    if (!isset($attribute_array)) return;

    $attribute_array = explode(',', $attribute_array);

    $out = '';
    $out_middle = '';

    if (isset($product)) {
        if (is_object($product)) {

            if ($show_weight) {
                if ($product->has_weight()) {
                    $weight = $product->get_weight();
                    $unit = esc_attr(get_option('woocommerce_weight_unit'));
                }
            }

            if ($show_dimensions) {
                if ($product->has_dimensions()) {
                    $dimensions = wc_format_dimensions($product->get_dimensions(false));
                }
            }

            $colon = get_option('wcsa_remove_semicolon') == 'yes' ? ' ' : ': ';
            $hide_labels = get_option('woocommerce_show_attributes_hide_labels');
            // check if they choose span element over li
            if (get_option('woocommerce_show_attributes_span') == 'yes') {
                $element = 'span';
            }

            if (!$skip_atts) {

                $attributes = $product->get_attributes();


                if (!$attributes) {
                    return;
                }

                foreach ($attributes as $attribute) {
                    if (!is_a($attribute, 'WC_Product_Attribute')) {
                        continue;
                    }

                    if (!in_array(wc_attribute_label($attribute->get_name()), $attribute_array) && !in_array(($attribute->get_name()), $attribute_array)) continue;


                    // skip variations
                    if ($attribute->get_variation()) {
                        continue;
                    }

                    // honor the visibility setting
                    if (!$attribute->get_visible()) {
                        continue;
                    }

                    $name = $attribute->get_name();

                    if ($attribute->is_taxonomy()) {

                        $product_id = $product->get_id();
                        $terms = wp_get_post_terms($product_id, $name, 'all');

                        if (isset($terms)) {
                            if (!is_wp_error($terms)) {

                                // get the taxonomy
                                $tax = $terms[0]->taxonomy;
                                // get the tax object
                                $tax_object = get_taxonomy($tax);
                                // get tax label
                                if (isset ($tax_object->labels->singular_name)) {
                                    $tax_label = $tax_object->labels->singular_name;
                                } elseif (isset($tax_object->label)) {
                                    $tax_label = $tax_object->label;
                                    // Trim label prefix
                                    $label_prefix = __('Product', 'woocommerce-show-attributes') . ' ';
                                    if (0 === strpos($tax_label, $label_prefix)) {
                                        $tax_label = substr($tax_label, strlen($label_prefix));
                                    }
                                }
                                $out_middle .= '<' . esc_attr($element) . ' class="' . esc_attr($name) . '">';
                                // Hide labels if they want to
                                if ($hide_labels != 'yes') {
                                    // PolyLang translation support
                                    if (function_exists('pll__')) {
                                        $translation = pll__($tax_label);
                                        $tax_label = (isset($translation)) ? $translation : $tax_label;
                                    }

                                    $out_middle .= '<span class="attribute-label"><span class="attribute-label-text">' . sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($tax_label)) . '</span>' . $colon . ' </span> ';
                                }
                                $out_middle .= '<span class="attribute-value">';

                                $tax_terms = array();
                                foreach ($terms as $term) {

                                    $single_term = sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($term->name));

                                    // Show terms as links?

                                    if ($single_product) {

                                        if (get_option('wcsa_terms_as_links') == 'yes') {
                                            $term_link = get_term_link($term);
                                            if (!is_wp_error($term_link)) {
                                                $single_term = '<a href="' . esc_url($term_link) . '">' . sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($term->name)) . '</a>';
                                            }
                                        }
                                    }
                                    array_push($tax_terms, $single_term);
                                }
                                $out_middle .= implode(', ', $tax_terms);
                                $out_middle .= '</span></' . esc_attr($element) . '>';

                                if ('span' == $element) {
                                    $out_middle .= '<br />';
                                }
                            }
                        }

                    } else {
                        $value_string = implode(', ', $attribute->get_options());
                        $out_middle .= '<' . esc_attr($element) . ' class="' . sanitize_title($name) . ' ' . sprintf(__('%s', 'woocommerce-show-attributes'), sanitize_title($value_string)) . '">';

                        // Hide labels if they want to
                        if ($hide_labels != 'yes') {

                            // PolyLang translation support
                            if (function_exists('pll__')) {
                                $translation = pll__($name);
                                $name = (isset($translation)) ? $translation : $name;
                            }

                            $out_middle .= '<span class="attribute-label"><span class="attribute-label-text">' . sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($name)) . '</span>' . $colon . ' </span> ';
                        }
                        $out_middle .= '<span class="attribute-value">' . sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($value_string)) . '</span></' . esc_attr($element) . '>';
                        if ('span' == $element) {
                            $out_middle .= '<br />';
                        }

                    }

                } // ends foreach attribute
            }

            // Add weight and dimensions if they opted in

            if (isset($weight)) {
                $unit = !isset($unit) ? '' : $unit;
                // weight
                $out_middle .= '<' . esc_attr($element) . ' class="show-attributes-weight">';
                // Hide labels if they want to
                if ($hide_labels != 'yes') {
                    $out_middle .= '<span class="attribute-label">' . __('Weight', 'woocommerce-show-attributes') . $colon . ' </span> ';
                }
                $out_middle .= '<span class="attribute-value">' . esc_html($weight) . ' ' . esc_html($unit) . ' </span></' . esc_attr($element) . '>';
                if ('span' == $element) {
                    $out_middle .= '<br />';
                }
            }

            if (isset($dimensions)) {
                // dimensions
                $out_middle .= '<' . esc_attr($element) . ' class="show-attributes-dimensions">';
                // Hide labels if they want to
                if ($hide_labels != 'yes') {
                    $out_middle .= '<span class="attribute-label">' . __('Dimensions', 'woocommerce-show-attributes') . $colon . ' </span> ';
                }
                $out_middle .= '<span class="attribute-value">' . esc_html($dimensions) . '</span></' . esc_attr($element) . '>';
                if ('span' == $element) {
                    $out_middle .= '<br />';
                }
            }

            if ($out_middle) {
                $out = ('li' == $element) ? '<ul ' : '<span ';
                $out .= 'class="custom-attributes">' . $out_middle;
                $out .= ('li' == $element) ? '</ul>' : '</span>';
            }

        }
    }

    $attribute_array = trim(get_option('settings_gpls_woo_rfq_product_custom_fields', ''));

    if (!isset($attribute_array)) return;

    $attribute_array = explode(',', $attribute_array);

    if (count($attribute_array) == 0 || !is_array($attribute_array)) return;

    $out .= '<ul>';

    foreach ($attribute_array as $attrib) {

        $tmp = get_post_meta($product->get_id(), $attrib, true);


        if ($tmp != '' && !is_array($tmp)) {
            $out .= '<li>' . $attrib . ': ' . $tmp . '</li>';
        }


    }
    $out .= '</ul>';
    return $out;
}


function gpls_woo_rfq_set_order_item_attributes($item_id, $item, $order_id)
{

    $attribute_array = trim(get_option('settings_gpls_woo_rfq_product_attributes', ''));

    if (!isset($attribute_array)) return;

    $attribute_array = explode(',', $attribute_array);

    if (count($attribute_array) == 0 || !is_array($attribute_array)) return;

    $pf = new WC_Product_Factory();

    $of = new WC_Order_Factory();

    $order = $of::get_order($order_id);


    if (!is_callable(array($item, 'get_product'))) return;


    $_product = apply_filters('woocommerce_order_item_product', $item->get_product(), $item);

    if (!is_object($_product)) $_product = wc_get_product(get_the_ID());


    if (!isset($_product) || !is_object($_product)) {
        return;
    }


    $attributes = $_product->get_attributes();

    if (!isset($attributes)) return;

    // echo '<br /><br />';

    if (!$attributes) {
        return;
    }

    foreach ($attributes as $attribute) {
        if (!is_a($attribute, 'WC_Product_Attribute')) {
            continue;
        }

        //echo wc_attribute_label($attribute->get_name()).' '.$attribute->get_name().'<br />';
        if (!is_a($attribute, 'WC_Product_Attribute')) continue;
        if (!in_array(wc_attribute_label($attribute->get_name()), $attribute_array) && !in_array(($attribute->get_name()), $attribute_array)) continue;

        $values = array();

        if ($attribute->is_taxonomy()) {
            $attribute_taxonomy = $attribute->get_taxonomy_object();
            $attribute_values = wc_get_product_terms($_product->get_id(), $attribute->get_name(), array('fields' => 'all'));

            foreach ($attribute_values as $attribute_value) {
                $value_name = esc_html($attribute_value->name);

                if ($attribute_taxonomy->attribute_public) {
                    $values[] = '<a href="' . esc_url(get_term_link($attribute_value->term_id, $attribute->get_name())) . '" rel="tag">' . $value_name . '</a>';
                } else {
                    $values[] = $value_name;
                }
            }
        } else {
            $values = $attribute->get_options();

            foreach ($values as &$value) {
                $value = esc_html($value);
            }
        }
        wc_add_order_item_meta($item_id, '_' . $attribute->get_name(), $values);

    }


}


if (!function_exists('add_gpls_rfq_toolkit_meta_boxes')) {
    function add_gpls_rfq_toolkit_meta_boxes()
    {

        add_meta_box('woocommerce-gpls_woo_rfq_plus_display_in_admin', __('RFQ-ToolKit'), 'gpls_woo_rfq_plus_display_in_admin', 'shop_order', 'normal', 'default');

    }
}


if (!function_exists('gpls_woo_rfq_plus_display_in_admin')) {
    function gpls_woo_rfq_plus_display_in_admin($object)
    {


        wp_nonce_field('meta-box-nonce', "meta-box-nonce");

        $post = $object;
        $order = wc_get_order($post->ID);

        echo '<div style="width:auto">';

        if (function_exists('rfqtk_display_proposal_in_admin')) {
            rfqtk_display_proposal_in_admin($order);
        }


        if (function_exists('rfqtk_display_offer_in_admin')) {
            rfqtk_display_offer_in_admin($order);
        }


        if (function_exists('rfqtk_display_ninja_in_admin')) {
            rfqtk_display_ninja_in_admin($order);
        }

        if (function_exists('rfqtk_display_files_in_admin')) {
            rfqtk_display_files_in_admin($order);
        }

        if (function_exists('gpls_woo_rfq_pdf_display_in_admin')) {
            gpls_woo_rfq_pdf_display_in_admin($order);
        }
        echo '</div>';

    }

}


function gpls_woo_rfq_add_custom_order_status_icon()
{

    $url_quote_image = gpls_woo_rfq_plus_URL . 'assets/img/gplsquote_req.png';
    $url_sent_image = gpls_woo_rfq_plus_URL . 'assets/img/gplsquote_sent.png';
    $custom_css = <<<TAG
<style> 

 
.widefat .column-order_status mark.gplsquote-sent{
font-size: 1.1em !important;
background: 0 0;
}

.widefat .column-order_status mark.gplsquote-sent:after {
content: '\\e008';

color: #ffba00;
font-family: WooCommerce;
speak: none;
font-weight: 400;
font-size: 1.1em;
font-variant: normal;
text-transform: none;
line-height: 1;
-webkit-font-smoothing: antialiased;
margin: 0;
text-indent: 0;
position: absolute;
top: 0;
left: 0;
width: 100%;
height: 100%;
text-align: center;
font-size: 1.1em;
}

.widefat .column-order_status mark.gplsquote-req{
 
background: 0 0;
font-size: 1.1em !important;
}
.widefat .column-order_status mark.gplsquote-req:after {
 
 content: '\\e018';
   color: #1E7790;
   font-family: WooCommerce,serif;
speak: none;
font-weight: 400;
font-variant: normal;
text-transform: none;
line-height: 1;
-webkit-font-smoothing: antialiased;
margin: 0;
text-indent: 0;
position: absolute;
top: 0;
left: 0;
width: 100%;
height: 100%;
text-align: center;
font-size: 1.1em !important;
}

</style>
TAG;


    echo $custom_css;
}


function gpls_woo_rfq_quote_button_shortcode($atts, $content = null)
{

    if (count($_POST) != 0) {
        return '';
    }

//'shop_thumbnail', 'shop_catalog', 'shop_single'
    // Attributes
    extract(shortcode_atts(array(
        'product_id' => '',
        'show_image' => 'no',
        'image_size' => 'thumbnail',
        'div_style' => 'auto',
        'show_title' => 'yes',
        'button_style' => '',
        'button_class' => '',
        'include_quantity' => 'no'

    ), $atts));

    if ($product_id == null) return '';

    $pf = new WC_Product_Factory();

    $product = $pf->get_product($product_id);

    if (gpls_empty($product)) return;

    $form_label = gpls_woo_rfq_INQUIRE_TEXT;

    $rfq_product_script = "";

    // $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);

    $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


    ?>
    <?php if ($rfq_enable == 'yes' && $GLOBALS["gpls_woo_rfq_checkout_option"] != "rfq") : ?>

    <?php

    $rfq_check = false;
    $normal_check = false;

    if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
        if (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'no') {
            $rfq_check = true;
            $normal_check = false;
        }
    }


    if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "normal_checkout") {
        //  if (get_option('settings_gpls_woo_rfq_normal_checkout_show_prices','no') == 'no' )
        {
            $normal_check = true;
            $rfq_check = false;
        }
    }

    if (function_exists('wp_get_current_user')) {
        if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
            $rfq_check = true;
            $normal_check = false;
        }
    }

    if ($rfq_check) {
        $rfq_product_script = "";
    }


    $rfq_id = $product->get_id();

    global $rfq_cart;

    global $rfq_variations;

    $in_rfq = false;


    $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');

    if (($gpls_woo_rfq_cart != false)) {

        foreach ($gpls_woo_rfq_cart as $cart_item_key => $values) {
            $product_id = $values['product_id'];


            if (get_the_ID() == $product_id) {
                $in_rfq = true;
            }
        }

    }

    if (($in_rfq == true && $product->get_type() != 'variable' && $product->get_type() != 'bundle')) {

        $request_quote = get_option('rfq_cart_wordings_in_rfq', __('In Quote List', 'rfqtk'));//"In RFQ"
        $request_quote = __($request_quote, 'rfqtk');

        $request_quote = apply_filters('gpls_woo_rfq_in_rfq_text', $request_quote);

    } else {
        $request_quote = get_option('rfq_cart_wordings_add_to_rfq', __('Add To Quote', 'rfqtk'));// "Request Quote"
        $request_quote = __($request_quote, 'rfqtk');

        $request_quote = apply_filters('gpls_woo_rfq_request_quote_text', $request_quote);

    }


    if ($normal_check) {

        $gpls_woo_rfq_file_add_to_quote_styles = array();

        $gpls_woo_rfq_file_add_to_quote_styles = apply_filters('gpls_woo_rfq_add_to_quote_styles', $gpls_woo_rfq_file_add_to_quote_styles);

    }


    $link_to_rfq_page = pls_woo_rfq_get_link_to_rfq();

    $view_your_cart_text = get_option('rfq_cart_wordings_view_rfq_cart', __('View List', 'rfqtk'));
    $view_your_cart_text = __($view_your_cart_text, 'rfqtk');
    $proceed = apply_filters('gpls_woo_rfq_after_after_shop_loop_item_proceed', true);

    if ($proceed == false) return;
    ?>


    <?php


    $thumbnail = "";
    $product_permalink = false;
    $prod_title = "";

    if ($show_title == 'yes') {
        $prod_title = $product->get_title();
    }

    if ($show_image == 'yes') {

        //  $thumbnail = $product->get_image();
        $thumbnail = $product->get_image($image_size);

        $product_permalink = $product->is_visible() ? $product->get_permalink() : '';
    }

    $data_var = "no";
    $rfq_variation_id = 0;

    //   if ($product->get_type() == 'variable' )
    {
        $data_var = $product->get_type();

    }

    $product_parent = $product->get_parent_id();

    if ($product_parent != 0) {
        //  $data_var = "yes";
        $rfq_variation_id = $rfq_id;
    }

    ?>

    <?php
    ob_start();
    wc_get_template('woo-rfq/add-to-quote-short.php',
        array('rfq_id' => $rfq_id,
            'product' => $product,
            'rfq_check' => $rfq_check,
            'data_var' => $data_var,
            'request_quote' => $request_quote,
            'button_style' => $button_style,
            'button_class' => $button_class,
            'gpls_woo_rfq_file_add_to_quote_styles' => $gpls_woo_rfq_file_add_to_quote_styles,
            'include_quantity' => $include_quantity,
            'rfq_variation_id' => $rfq_variation_id
        ), '', gpls_woo_rfq_plus_DIR . 'woocommerce/');

    $add_to_cart_button = ob_get_clean();

    $hook = get_option('settings_gpls_woo_rfq_normal_checkout_quote_position', 'woocommerce_after_shop_loop_item');

    ?>


    <?php ob_start(); ?>

    <div class="add_to_quote_sc" style="text-align: center;width:<?php echo $div_style ?> !important">
        <div id="sc_template" style="display:inline-block;">

            <form class="woo_rfq_after_shop_loop_button"
                  data-rfq-product-id='<?php echo $rfq_id; ?>'
                  action='<?php echo esc_url($product->add_to_cart_url()) ?>' method='post'>
                <?php
                if ($hook == "woocommerce_before_shop_loop_item") {
                    echo $add_to_cart_button;
                }
                ?>
                <?php
                $image = $thumbnail;
                if (!$product_permalink) {
                    echo $image;
                } else {
                    printf('<a class="woocommerce-LoopProduct-link woocommerce-loop-product__link" href="%s">%s</a>', esc_url($product_permalink), $image);
                }

                if ($hook == "woocommerce_before_shop_loop_item_title") {
                    echo $add_to_cart_button;
                }

                echo '<h2 class="woocommerce-loop-product__title">' . $product->get_title() . '</h2>';

                if ($hook == "woocommerce_shop_loop_item_title") {
                    echo $add_to_cart_button;
                }

                ?>
                <?php
                $gpls_woo_rfq_file_add_to_quote_styles = array();
                $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_styles'] = '';
                $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_onmouseover'] = '';
                $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_background_onmouseover'] = '';
                $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_onmouseout'] = '';
                $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_background_onmouseout'] = '';

                $gpls_woo_rfq_file_add_to_quote_styles = apply_filters('gpls_woo_rfq_add_to_quote_styles', $gpls_woo_rfq_file_add_to_quote_styles);
                ?>


                <?php
                if ($hook == "woocommerce_after_shop_loop_item") {
                    echo $add_to_cart_button;
                }
                ?>

            </form>
        </div>
    </div>

    <?php

    $single_add_to_cart_after_shop_loop_button = ob_get_clean();

    $single_add_to_cart_after_shop_loop_button = apply_filters('gpls_woo_rfq_after_shop_loop_button', $single_add_to_cart_after_shop_loop_button, $in_rfq, $rfq_check, $normal_check, $rfq_enable, $product);
    return $single_add_to_cart_after_shop_loop_button;

    ?>


<?php endif; ?>


    <?php
    // Return code


}


function gpls_woo_rfq_plus_capture_order_id($order_id)
{
    global $wp_session;
    $wp_session['cart_items'] = $order_id;

}


function rfqtk_display_proposal_in_admin($order)
{
    $ends = gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key), 'D');
    if ($ends == 1) {
        return;
    }


    $content = html_entity_decode(get_post_meta($order->get_id(), '_quote_sent_note', true));

    $setting = array('textarea_rows' => 10, 'textarea_name' => 'quote_sent_note_editor');

    echo '<div  style="clear: both; margin-top:5px; display:block;;font-weight: bold"><h1>Proposal To Customer</h1></div>';

    wp_editor($content, 'quote_sent_note_editor', $setting);

    echo '<div style="clear: both"></div>';

    $include_pay_link = get_post_meta($order->get_id(), '_include_proposal_pay_link', true);
    $include_pay_link_checked = "";
    if ($include_pay_link == 'yes') {
        $include_pay_link_checked = "checked";
    }
    echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Insert a "Pay" link in the proposal email <input type="checkbox" name="include_proposal_pay_link" id="include_proposal_pay_link" ' . $include_pay_link_checked . '></h2></span>';

    $include_respond_link = get_post_meta($order->get_id(), '_include_respond_link', true);
    $include_respond_link_checked = "";
    if ($include_respond_link == 'yes') {
        $include_respond_link_checked = "checked";
    }
    echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Insert a "Respond to Offer" link in the proposal email <input type="checkbox" name="include_respond_link" id="include_respond_link" ' . $include_respond_link_checked . '></h2></span>';


    $include_accept_link = get_post_meta($order->get_id(), '_include_accept_link', true);
    $include_accept_link_checked = "";
    if ($include_accept_link == 'yes') {
        $include_accept_link_checked = "checked";
    }
    echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Insert an "Accept" link in the proposal email <input type="checkbox" name="include_accept_link" id="include_accept_link" ' . $include_accept_link_checked . '></h2></span>';


    $allow_multiple_offers = get_post_meta($order->get_id(), '_allow_multiple_offers', true);
    $allow_multiple_offers_checked = "";
    if ($allow_multiple_offers == 'yes') {
        $allow_multiple_offers_checked = "checked";
    }
    echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Allow customer to accept multiple offers<input type="checkbox" name="allow_multiple_offers" id="allow_multiple_offers" ' . $allow_multiple_offers_checked . '></h2></span>';


    $gpls_woo_rfq_no_expire = get_post_meta($order->get_id(), '_gpls_woo_rfq_no_expire', true);
    $gpls_woo_rfq_no_expire_checked = "";
    if ($gpls_woo_rfq_no_expire == 'yes') {
        $gpls_woo_rfq_no_expire_checked = "checked";
    }
    echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Don\'t expire this quote <input type="checkbox" name="gpls_woo_rfq_no_expire" id="gpls_woo_rfq_no_expire" ' . $gpls_woo_rfq_no_expire_checked . '></h2></span>';


    $gpls_woo_rfq_email_sender = get_post_meta($order->get_id(), '_gpls_woo_rfq_email_sender', true);

    echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Change "From" in the email <input style="width:300px" name="gpls_woo_rfq_email_sender" id="gpls_woo_rfq_email_sender" value="' . $gpls_woo_rfq_email_sender . '"></h2></span>';


    $gpls_woo_rfq_email_reply = get_post_meta($order->get_id(), '_gpls_woo_rfq_email_reply', true);

    echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Change "Reply To" in the email <input style="width:300px" name="gpls_woo_rfq_email_reply" id="gpls_woo_rfq_email_reply" value="' . $gpls_woo_rfq_email_reply . '"></h2></span>';


    $gpls_woo_rfq_email_cc = get_post_meta($order->get_id(), '_gpls_woo_rfq_email_cc', true);

    echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">CC this email to <input style="width:600px" name="gpls_woo_rfq_email_cc" id="gpls_woo_rfq_email_cc" value="' . $gpls_woo_rfq_email_cc . '"></h2>You can put multiple emails speperated by commas</span>';


}


if (!function_exists('gpls_woo_rfq_plus_startsWith')) {
    function gpls_woo_rfq_plus_startsWith($haystack, $needle)
    {
        $length = strlen($needle);
        return (substr($haystack, 0, $length) === $needle);
    }
}

if (!function_exists('gpls_woo_rfq_plus_endsWith')) {
    function gpls_woo_rfq_plus_endsWith($haystack, $needle)
    {
        $length = strlen($needle);
        if (!$length) {
            return true;
        }

        return (substr($haystack, -$length) === $needle);
    }
}


function gpls_woo_rfq_request_page_output_top_html()
{

    $settings_gpls_woo_rfq_enabled_page_desc_top = get_option('settings_gpls_woo_rfq_enabled_page_desc_top', 'no');
    $settings_gpls_woo_rfq_enabled_page_desc_top = __($settings_gpls_woo_rfq_enabled_page_desc_top, 'rfqtk');

    if ($settings_gpls_woo_rfq_enabled_page_desc_top === 'yes') {

        $settings_gpls_woo_rfq_page_desc_top = get_option('settings_gpls_woo_rfq_page_desc_top', '');
        $settings_gpls_woo_rfq_page_desc_top = __($settings_gpls_woo_rfq_page_desc_top, 'rfqtk');

        echo '<div style="padding:10px; margin-top:25px;margin-bottom:25px;">' . $settings_gpls_woo_rfq_page_desc_top . '</div>';
    }


}


function gpls_woo_rfq_request_page_output_bottom_html()
{

    $settings_gpls_woo_rfq_page_desc_bottom = get_option('settings_gpls_woo_rfq_page_desc_bottom', '');
    $settings_gpls_woo_rfq_page_desc_bottom = __($settings_gpls_woo_rfq_page_desc_bottom, 'rfqtk');

    echo '<div style="padding:10px; margin-top:25px;margin-bottom:25px;">' . $settings_gpls_woo_rfq_page_desc_bottom . '</div>';
}


function gpls_woo_add_rfq_custom_rfq_page_css_js()
{

    if (!is_admin()) {

        $home = home_url() . '/quote-request/';

        $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);

        $actual_link = get_site_url() . $_SERVER['REQUEST_URI'];

        if (parse_url(trim($rfq_page))['path'] != parse_url(trim($actual_link))['path']) {
            return;
        }


        $enable = get_option('rfq_cart_sc_section_rfq_page_apply_style', 'no');

        $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk.js';
        $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk.js';
        wp_enqueue_script('gpls_woo_rfq_plus_js', $url_js, array('jquery'), rand(10, 100000), true);


        if ($enable == 'yes') {
            $gpls_woo_rfq_page_add_js = '';

            $gpls_woo_rfq_page_add_js .= 'jQuery(".gpls_woo_rfq_request_page td.actions").css({"border-top-width": "1px"});';
            $value0 = get_option('gpls_woo_rfq_request_page_background', '');

            if ($value0 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".gpls_woo_rfq_request_page").css({"background-color": "' . $value0 . '"});';
                $gpls_woo_rfq_page_add_js .= 'jQuery(".gpls_woo_rfq_request_page td.actions").css({"border-top-color": "' . $value0 . '"});';
            }


            $value1 = get_option('rfq_cart_sc_section_rfq_page_cart_header_background', '');

            if ($value1 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_th").css({"background-color": "' . $value1 . '"});';
            }


            $value2 = get_option('rfq_cart_sc_section_rfq_page_cart_header_color', '');

            if ($value2 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_th").css({"color": "' . $value2 . '"});';
            }

            $value3 = get_option('rfq_cart_sc_section_rfq_page_cart_row_background', '');


            if ($value3 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_td,.cart_tr").css({"background-color": "' . $value3 . '"});';

            }

            $value4 = get_option('rfq_cart_sc_section_rfq_page_cart_font_color', '');

            if ($value4 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_td").css({"color": "' . $value4 . '"});';
            }

            $value5 = get_option('rfq_cart_sc_section_rfq_page_cart_link_color', '');

            if ($value5 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_td a").css({"color": "' . $value5 . '"});';
                $gpls_woo_rfq_page_add_js .= 'jQuery(".remove").css({"color": "' . $value5 . '"});';
                // $gpls_woo_rfq_page_add_js .= 'jQuery("a.remove::before").css({"color": "' . $value5 . '"});';
                $style = "<style>a.remove::before{color:" . $value5 . " !important;}</style>";

                $gpls_woo_rfq_page_add_js .= 'jQuery("head").append("' . $style . '");';


                //a.remove::before {


            }


            $value6 = get_option('rfq_cart_sc_section_rfq_page_cart_background', '');

            if ($value6 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_th,.cart_td,.cart_tr").css({"color": "' . $value6 . '"});';

            }

            $value7 = get_option('rfq_cart_sc_section_rfq_page_cart_image_size', '');

            if ($value7 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_td img").css({"max-width": "' . $value7 . '"});';
            }


            $value8 = get_option('rfq_cart_sc_section_rfq_cust_info_header_background', '');

            if ($value8 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_th").css({"background": "' . $value8 . '"});';
            }


            $value9 = get_option('rfq_cart_sc_section_rfq_cust_info_header_color', '');

            if ($value9 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_th").css({"color": "' . $value9 . '"});';

            }

            $value10 = get_option('rfq_cart_sc_section_rfq_cust_info_row_background', '');

            if ($value10 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_td,.info_tr").css({"background-color": "' . $value10 . '"});';

            }


            $value11 = get_option('rfq_cart_sc_section_rfq_cust_info_font_color', '');

            if ($value11 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_td").css({"color": "' . $value11 . '"});';
            }


            $value12 = get_option('rfq_cart_sc_section_rfq_woo_rfq_customer_info_header_color', '');

            if ($value12 != '') {


                $gpls_woo_rfq_page_add_js .= 'jQuery(".woo-rfq-customer-info-header").css({"color": "' . $value12 . '"});';

            }

            $value13 = get_option('rfq_cart_sc_section_rfq_woo_rfq_customer_info_header_color', '');

            if ($value13 != '') {


                $gpls_woo_rfq_page_add_js .= 'jQuery(".woo-rfq-customer-info-header").css({"color": "' . $value13 . '"});';
            }


            $value14 = get_option('rfq_cart_sc_section_rfq_cust_info_background', '');

            if ($value14 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_th,.info_td,.info_tr").css({"color": "' . $value14 . '"});';
            }


            $value15 = get_option('rfq_cart_sc_section_rfq_woo_rfq_customer_info_input_background', '');

            if ($value15 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_td .input-text, input[type=text], input[type=email], input[type=url], input[type=password], input[type=search], textarea").css({"background": "' . $value15 . '"});';
            }


            $value16 = get_option('rfq_cart_sc_section_rfq_woo_rfq_customer_info_border_color', '');

            if ($value16 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".rfq-shop-table_customer_info td").css({"border-color": "' . $value16 . '"});';
            }


            $value17 = get_option('rfq_cart_sc_section_rfq_page_cart_border_size', '');

            if ($value17 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".rfq-shop-table_customer_info td").css({"border-width": "' . $value17 . '"});';

            }


            $value18 = get_option('rfq_cart_sc_section_rfq_page_cart_border_style', '');

            if ($value18 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".rfq-shop-table_customer_info td").css({"border-style": "' . $value18 . '"});';
            }


            if ($gpls_woo_rfq_page_add_js != '') {


                wp_add_inline_script('gpls_woo_rfq_plus_js', $gpls_woo_rfq_page_add_js);

            }
        }

//required
        $custom_js_load = gpls_woo_on_load_custom_js();
        $custom_js_click = gpls_woo_on_click_custom_js();

        wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js_load . ' ' . $custom_js_click);

        // echo '<script> ' . $custom_js_load . ' ' . $custom_js_click . ' </script>';
        if ((is_wc_endpoint_url('order-received')) && (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

            if ((get_option('settings_gpls_woo_rfq_show_prices', 'no') != 'yes')) {

                $rfq_product_script = "<script>jQuery(document ).ready( function() {

jQuery( '.wc-item-meta-label' ).hide();
jQuery( '.wc-item-meta-label' ).attr('style','display: none !important'); 

} ); </script>";
                //   echo $rfq_product_script;
            }


        }


    }//end of not admin

}

/**
 * @return string
 */


function gpls_woo_add_rfq_custom_rfq_page_css()
{


    if (!is_admin()) {


        $gpls_woo_rfq_page_custom_css = get_option('rfq_cart_sc_section_rfq_page_custom_css');

        if ($gpls_woo_rfq_page_custom_css != '') {
            $gpls_woo_rfq_page_custom_css = '<style>' . $gpls_woo_rfq_page_custom_css . '</style>';

            echo $gpls_woo_rfq_page_custom_css;

        }


    }

}


function gpls_woo_on_click_custom_js()
{

    $home = home_url() . '/quote-request/';

    $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);


    $actual_link = get_site_url() . $_SERVER['REQUEST_URI'];


    if (parse_url(trim($rfq_page))['path'] != parse_url(trim($actual_link))['path']) {
        return;
    }

    $custom_js = "jQuery('.gpls-woo-rfq_checkout_button').on('click', function(){";

    $phone_required = get_option('rfq_cart_sc_section_rfq_page_phone_required');

    if ($phone_required == 'yes') {
//jQuery('#rfq_phone').attr("required",false);
        $custom_js .=
            "if ( jQuery( '#rfq_phone' ).length && jQuery( '#rfq_phone' ).is(':visible')) {jQuery('#rfq_phone').attr('required',true);}";

    }

    $rfq_cart_sc_section_rfq_page_company_required = get_option('rfq_cart_sc_section_rfq_page_company_required');

    if ($rfq_cart_sc_section_rfq_page_company_required == 'yes') {

        $custom_js .=
            "if ( jQuery( '#rfq_company' ).length && jQuery( '#rfq_company' ).is(':visible')) {jQuery('#rfq_company').attr('required',true);};jQuery('#rfq_company').attr('required',true);";

    }

    $rfq_cart_sc_section_rfq_page_country_required = get_option('rfq_cart_sc_section_rfq_page_country_required');

    if ($rfq_cart_sc_section_rfq_page_country_required == 'yes') {

        $custom_js .=
            "if ( jQuery( '#rfq_billing_country' ).length && jQuery( '#rfq_billing_country' ).is(':visible')) {jQuery('#rfq_billing_country').attr('required',true);}
                 try {
    if (jQuery('#rfq_billing_country').val() != 'US') {
        jQuery('#rfq_state_select').val('');
        jQuery('#rfq_state_select').hide();
        jQuery('#rfq_state_text').show();
        jQuery('#rfq_state_select').attr('required', false);
        jQuery('#rfq_state_text').attr('required', true);
    } else {
        jQuery('#rfq_state_text').val('');
        jQuery('#rfq_state_text').hide();
        jQuery('#rfq_state_select').show();
        jQuery('#rfq_state_select').attr('required', true);
        jQuery('#rfq_state_text').attr('required', false);
    }
}catch(err){}
                ";


    }


    $rfq_cart_sc_section_rfq_page_state_required = get_option('rfq_cart_sc_section_rfq_page_state_required');

    if ($rfq_cart_sc_section_rfq_page_state_required == 'yes') {

        $custom_js .=
            "if ( jQuery( '#rfq_state_select' ).length && jQuery( '#rfq_state_select' ).is(':visible')) {jQuery('#rfq_state_select').attr('required',true);}";


    }

    $rfq_cart_sc_section_rfq_page_address_required = get_option('rfq_cart_sc_section_rfq_page_address_required');

    if ($rfq_cart_sc_section_rfq_page_address_required == 'yes') {

        $custom_js .=
            "if ( jQuery( '#rfq_address' ).length && jQuery( '#rfq_address' ).is(':visible')) {jQuery('#rfq_address').attr('required',true);}";

    }

    $rfq_cart_sc_section_rfq_page_city_required = get_option('rfq_cart_sc_section_rfq_page_city_required');

    if ($rfq_cart_sc_section_rfq_page_city_required == 'yes') {

        $custom_js .=
            "if ( jQuery( '#rfq_city' ).length && jQuery( '#rfq_city' ).is(':visible')) {jQuery('#rfq_city').attr('required',true);}";

    }


    $rfq_cart_sc_section_rfq_page_zip_required = get_option('rfq_cart_sc_section_rfq_page_zip_required');

    if ($rfq_cart_sc_section_rfq_page_zip_required == 'yes') {

        $custom_js .=
            "if ( jQuery( '#rfq_zip' ).length && jQuery( '#rfq_zip' ).is(':visible')) {jQuery('#rfq_zip').attr('required',true);}";

    }

    $rfq_cart_sc_section_rfq_page_comment_required = get_option('rfq_cart_sc_section_rfq_page_comment_required');

    if ($rfq_cart_sc_section_rfq_page_comment_required == 'yes') {

        $custom_js .=
            "if ( jQuery( '#rfq_message' ).length && jQuery( '#rfq_message' ).is(':visible')) {jQuery('#rfq_message').attr('required',true);}";

    }

    $custom_js .= " });";

    return $custom_js;
}

function gpls_woo_on_load_custom_js()
{
    $custom_js = "jQuery( document ).ready( function() {";

    $phone_required = get_option('rfq_cart_sc_section_rfq_page_phone_required');

    if ($phone_required == 'yes') {

        $custom_js .=
            "jQuery('#rfq_phone_label').addClass('required');";

    }

    $rfq_cart_sc_section_rfq_page_company_required = get_option('rfq_cart_sc_section_rfq_page_company_required');

    if ($rfq_cart_sc_section_rfq_page_company_required == 'yes') {

        $custom_js .=
            "jQuery('#rfq_company_label').addClass('required');";

    }

    $rfq_cart_sc_section_rfq_page_country_required = get_option('rfq_cart_sc_section_rfq_page_country_required');

    if ($rfq_cart_sc_section_rfq_page_country_required == 'yes') {

        $custom_js .=
            "jQuery('#rfq_billing_country_label').addClass('required');
                
                try {
    if (jQuery('#rfq_billing_country').val() != 'US') {
        jQuery('#rfq_state_select').val('');
        jQuery('#rfq_state_select').hide();
        jQuery('#rfq_state_text').show();
        jQuery('#rfq_state_select').attr('required', false);
        jQuery('#rfq_state_text').attr('required', true);
    } else {
        jQuery('#rfq_state_text').val('');
        jQuery('#rfq_state_text').hide();
        jQuery('#rfq_state_select').show();
        jQuery('#rfq_state_select').attr('required', true);
        jQuery('#rfq_state_text').attr('required', false);
    }
}catch(err){}
                ";


    }


    $rfq_cart_sc_section_rfq_page_country_required = get_option('rfq_cart_sc_section_rfq_page_country_required');

    if ($rfq_cart_sc_section_rfq_page_country_required == 'yes') {

        $custom_js .=
            "jQuery('#rfq_billing_country_label').addClass('required');
                 try {
    if (v) {
        jQuery('#rfq_state_select').val('');
        jQuery('#rfq_state_select').hide();
        jQuery('#rfq_state_text').show();
        jQuery('#rfq_state_select').attr('required', false);
        jQuery('#rfq_state_text').attr('required', true);
    } else {
        jQuery('#rfq_state_text').val('');
        jQuery('#rfq_state_text').hide();
        jQuery('#rfq_state_select').show();
        jQuery('#rfq_state_select').attr('required', true);
        jQuery('#rfq_state_text').attr('required', false);
    }
}catch(err){}
                ";


    }

    $rfq_cart_sc_section_rfq_page_state_required = get_option('rfq_cart_sc_section_rfq_page_state_required');

    if ($rfq_cart_sc_section_rfq_page_state_required == 'yes') {

        $custom_js .=
            "jQuery('#rfq_state_select_label').addClass('required');";


    }

    $rfq_cart_sc_section_rfq_page_address_required = get_option('rfq_cart_sc_section_rfq_page_address_required');

    if ($rfq_cart_sc_section_rfq_page_address_required == 'yes') {

        $custom_js .=
            "jQuery('#rfq_address_label').addClass('required');";

    }

    $rfq_cart_sc_section_rfq_page_city_required = get_option('rfq_cart_sc_section_rfq_page_city_required');

    if ($rfq_cart_sc_section_rfq_page_city_required == 'yes') {

        $custom_js .=
            "jQuery('#rfq_city_label').addClass('required');";

    }


    $rfq_cart_sc_section_rfq_page_zip_required = get_option('rfq_cart_sc_section_rfq_page_zip_required');

    if ($rfq_cart_sc_section_rfq_page_zip_required == 'yes') {

        $custom_js .=
            "jQuery('#rfq_zip_label').addClass('required');";

    }

    $rfq_cart_sc_section_rfq_page_comment_required = get_option('rfq_cart_sc_section_rfq_page_comment_required');

    if ($rfq_cart_sc_section_rfq_page_comment_required == 'yes') {

        $custom_js .=
            "jQuery('#rfq_message_label').addClass('required');";
    }

    $custom_js .= "} );";
    return $custom_js;
}


function gpls_woo_add_rfq_custom_rfq_page_js()
{

    if (!is_admin()) {

        $gpls_woo_rfq_page_custom_js = get_option('rfq_cart_sc_section_rfq_page_custom_js');

        if ($gpls_woo_rfq_page_custom_js != '') {

            echo '<script type="application/javascript">' . $gpls_woo_rfq_page_custom_js . '</script>';

        }
    }

}


function gpls_woo_rfq_my_account_my_orders_actions($actions, $order)
{

    return $actions;
}


function gpls_woo_rfq_before_cart_gpls_woo_rfq_create_styles($gpls_woo_rfq_styles)
{
    $home = home_url() . '/quote-request/';

    $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);


    $actual_link = get_site_url() . $_SERVER['REQUEST_URI'];


    if (parse_url(trim($rfq_page))['path'] != parse_url(trim($actual_link))['path']) {
        return $gpls_woo_rfq_styles;
    }


    $enable = get_option('rfq_cart_sc_section_rfq_page_apply_style', 'no');

    if ($enable != 'yes') {
        return $gpls_woo_rfq_styles;
    }

    $gpls_woo_rfq_page_update_button_styles = '';


    $gpls_woo_rfq_page_update_button_onmouseover = '';
    $gpls_woo_rfq_page_update_button_background_onmouseover = '';

    $gpls_woo_rfq_page_update_button_onmouseout = '';
    $gpls_woo_rfq_page_update_button_background_onmouseout = '';


    $gpls_woo_rfq_page_submit_button_styles = '';

    $gpls_woo_rfq_page_submit_button_onmouseover = '';
    $gpls_woo_rfq_page_submit_button_background_onmouseover = '';

    $gpls_woo_rfq_page_submit_button_onmouseout = '';
    $gpls_woo_rfq_page_submit_button_background_onmouseout = '';


    $rfq_cart_sc_section_rfq_page_update_cart_button_background = get_option('rfq_cart_sc_section_rfq_page_update_cart_button_background', '');

    if (($rfq_cart_sc_section_rfq_page_update_cart_button_background) != '') {

        $gpls_woo_rfq_page_update_button_styles .= "background-color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . " ;";

    }


    $rfq_cart_sc_section_rfq_page_update_cart_button_color = get_option('rfq_cart_sc_section_rfq_page_update_cart_button_color', '');

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_color) != '') {

        $gpls_woo_rfq_page_update_button_styles .= "color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . " ;";

    }

    $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background = get_option('rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background', '');

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background) != '') {

        $gpls_woo_rfq_page_update_button_background_onmouseover .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background . "';";
        $gpls_woo_rfq_page_update_button_background_onmouseout .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . "';";

    }

    $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color = get_option('rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color', '');

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color) != '') {

        $gpls_woo_rfq_page_update_button_onmouseover .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color . "';";
        $gpls_woo_rfq_page_update_button_onmouseout .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . "';";

    }


//////////////////////////////////////////////////////////////////////////////////


    $rfq_cart_sc_section_rfq_page_submit_cart_button_background = get_option('rfq_cart_sc_section_rfq_page_submit_quote_button_background', '');


    if (trim($rfq_cart_sc_section_rfq_page_submit_cart_button_background) != '') {

        $gpls_woo_rfq_page_submit_button_styles .= "background-color:" . $rfq_cart_sc_section_rfq_page_submit_cart_button_background . " !important;";

    }

    $rfq_cart_sc_section_rfq_page_submit_cart_button_color = get_option('rfq_cart_sc_section_rfq_page_submit_quote_button_color', '');

    if (trim($rfq_cart_sc_section_rfq_page_submit_cart_button_color) != '') {

        $gpls_woo_rfq_page_submit_button_styles .= "color:" . $rfq_cart_sc_section_rfq_page_submit_cart_button_color . " !important;";

    }


    $rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_background = get_option('rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_background', '');

    if (trim($rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_background) != '') {


        $gpls_woo_rfq_page_submit_button_background_onmouseover .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_background . "';";
        $gpls_woo_rfq_page_submit_button_background_onmouseout .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_submit_cart_button_background . "';";

    }

    $rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_color = get_option('rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_color', '');

    if (trim($rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_color) != '') {

        $gpls_woo_rfq_page_submit_button_onmouseover .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_color . "';";
        $gpls_woo_rfq_page_submit_button_onmouseout .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_submit_cart_button_color . "';";

    }


    $gpls_woo_rfq_styles = array(

        'gpls_woo_rfq_page_update_button_styles' => $gpls_woo_rfq_page_update_button_styles,


        'gpls_woo_rfq_page_update_button_onmouseover' => $gpls_woo_rfq_page_update_button_onmouseover,
        'gpls_woo_rfq_page_update_button_onmouseout' => $gpls_woo_rfq_page_update_button_onmouseout,

        'gpls_woo_rfq_page_update_button_background_onmouseover' => $gpls_woo_rfq_page_update_button_background_onmouseover,
        'gpls_woo_rfq_page_update_button_background_onmouseout' => $gpls_woo_rfq_page_update_button_background_onmouseout,


        'gpls_woo_rfq_page_submit_button_styles' => $gpls_woo_rfq_page_submit_button_styles,

        'gpls_woo_rfq_page_submit_button_onmouseover' => $gpls_woo_rfq_page_submit_button_onmouseover,
        'gpls_woo_rfq_page_submit_button_onmouseout' => $gpls_woo_rfq_page_submit_button_onmouseout,

        'gpls_woo_rfq_page_submit_button_background_onmouseover' => $gpls_woo_rfq_page_submit_button_background_onmouseover,
        'gpls_woo_rfq_page_submit_button_background_onmouseout' => $gpls_woo_rfq_page_submit_button_background_onmouseout,


    );

    return $gpls_woo_rfq_styles;

}


function gpls_woo_rfqtk_recursive($array)
{
    foreach ($array as $key => $value) {
        //If $value is an array.
        if (is_array($value)) {
            //We need to loop through it.
            gpls_woo_rfqtk_recursive($value);
        } else {
            //It is not an array, so print it out.
            echo $key . ": " . $value, '<br>';
        }
    }
}


/**
 */
function rfqtk_quotes_rfqtk_quotes_cleanup()
{
    if (defined('WP_SETUP_CONFIG')) {
        return;
    }

    if (!defined('WP_INSTALLING')) {
        /**
         * Determine the size of each batch for deletion.
         *
         * @param int
         */

        // Delete a batch of old sessions
        $expire_days = get_option('settings_gpls_woo_rfq_expire_days', 30);
        $option = get_option('settings_gpls_woo_rfq_expire_method', 'wc-cancelled');


        if ($expire_days == "" || (string)$expire_days < 1) {
            return;
        }

        if ($option == 'no') {
            return;
        }


        global $wpdb;


        $pageposts = $wpdb->get_results(" SELECT * FROM " . $wpdb->posts . "   
      WHERE post_type='shop_order' AND post_status IN('wc-gplsquote-req','wc-gplsquote-sent')       
       AND DATEDIFF(NOW(), post_date) > " . $expire_days);

        if ($pageposts == null) {

            return;
        }

        foreach ($pageposts as $post) {

            $postid = $post->ID;
            $order = WC_Order_Factory::get_order($postid);

            $no_expire = $order->get_meta('_gpls_woo_rfq_no_expire', true);


            if ($no_expire == 'yes') {
                continue;
            }


            if ($option == "wc-cancelled") {
                if ($order != false) {
                    $order->update_status($option, __('Order status changed by RFQ-ToolKit:', 'rfqtk'), true);
                    $order->save();
                }
            }

            if ($option == "trash") {
                $order->add_order_note(__("Order moved to trash by RFQ-ToolKit", "rftk"));
                wp_trash_post($postid, true);
            }
        }
    }

    // Allow other plugins to hook in to the garbage collection process.
    do_action('rfqtk_quotes_cleanup');
}


function RFQTK_quotes_register_garbage_collection()
{
    if (!wp_next_scheduled('rfqtk_quotes_garbage_collection')) {
        wp_schedule_event(current_time('timestamp'), 'daily', 'rfqtk_quotes_garbage_collection');
    }
}

add_action('wp', 'RFQTK_quotes_register_garbage_collection');


function rftk_cat_has_meta($product_id, $meta_key, $single = true)
{
    $meta_value = get_post_meta($product_id, $meta_key, true);
    // $product = wc_get_product($product_id);
    //  $meta_value = apply_filters('rftk_cat_has_meta_filter',$meta_value,$product, $meta_key);

    return $meta_value;
}


function gpls_woo_rfqtk_woocommerce_product_is_on_sale($on_sale, $product)
{

    $show_badge = get_option("settings_gpls_woo_rfq_rfq_show_sales_badge", "no");
    if ($show_badge == "no") {
        return $on_sale;
    }

    $context = 'view';
    if ('' !== (string)$product->get_sale_price($context) && $product->get_regular_price($context) > $product->get_sale_price($context)) {
        $on_sale = true;

        if ($product->get_date_on_sale_from($context) && $product->get_date_on_sale_from($context)->getTimestamp() > current_time('timestamp', true)) {
            $on_sale = false;
        }

        if ($product->get_date_on_sale_to($context) && $product->get_date_on_sale_to($context)->getTimestamp() < current_time('timestamp', true)) {
            $on_sale = false;
        }
    } else {
        $on_sale = false;
    }
    return $on_sale;
}


function gpls_woo_rfq_get_cart_item($cart_item, $quantity, $ids, $product_id, $_product, $variation_id, $variations)
{

    $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];

    if ($checkout_option === "normal_checkout") {
        //based on code from WooCommerce Product Add-Ons Ultimate by  Plugin Republic
        if (isset($cart_item['product_extras']['price_with_extras'])) {

            //$new_price = pewc_get_adjusted_product_addon_price( $value, $key ); // original, no longer needed for 3.9.5?
            $new_price = $cart_item['product_extras']['price_with_extras']; // no need to adjust here, because tax is adjusted by WC later if needed
            $cart_item['data']->set_price(floatval($new_price));

        }

        //based on advanced product fields for WooCommerce plugin.

        if (isset($cart_item['wapf'])) {
            $base = floatval($_product->get_price());
            $options_total = 0;

            foreach ($cart_item['wapf'] as $field) {
                if (!empty($field['price'])) {
                    foreach ($field['price'] as $price) {

                        if ($price['value'] === 0)
                            continue;

                        $options_total = $options_total + (float)($price['value'] / $quantity);

                    }
                }

            }

            if ($options_total > 0) {
                $cart_item['data']->set_price($base + $options_total);


            }
        }
    }


    return $cart_item;
}

function rv_redirect_on_add_to_cart($url, $adding_to_cart)
{

    //Get product ID
    if (isset($_POST['add-to-cart']) && get_option('rfq_cart_sc_redirect_after_add') != 'yes') {
        //Check if product ID is in the proper taxonomy and return the URL to the redirect product

        $product_id = (int)apply_filters('woocommerce_add_to_cart_product_id', $_POST['add-to-cart']);

        $product = wc_get_product($product_id);
        // $rfq_enable = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product_id);
        switch ($rfq_enable) {
            case 'yes':
                return get_permalink($product_id);
                break;
        }

    }

    return $url;

}

function gpls_woo_rfq_rfqtk_after_setup_theme()
{

    add_action('gpls_woo_rfq_woocommerce_after_add_to_rfq_cart_finished', 'gplsrfq_add_to_rfq_cart_finished', PHP_INT_MAX, 2);
    add_action('gpls_woo_rfq_after_normal_checkout', 'gpls_woo_rfq_after_normal_checkout_function', 1, 1);
    add_action('woocommerce_thankyou', 'gpls_woo_rfq_after_normal_checkout_function', 100);
    add_action('woocommerce_thankyou', 'gpls_woo_payment_status', 100, 1);
    add_action('woocommerce_thankyou', 'rfqtk_display_ninja_in_thanky_you_view_order', 1000, 1);
    add_action('woocommerce_view_order', 'rfqtk_display_ninja_in_thanky_you_view_order', 999, 1);

    add_filter('woocommerce_add_to_cart_validation', 'gpls_woo_rfq_only_one_product', 1000, 3);


    $settings_gpls_combine_cart_checkout = get_option('settings_gpls_woo_rfq_combine_cart_checkout', 'no');


    if ($settings_gpls_combine_cart_checkout == "yes") {


        function gpls_cart_on_checkout_page()
        {
            echo do_shortcode('[woocommerce_cart]');
        }

        add_action('woocommerce_before_checkout_form', 'gpls_cart_on_checkout_page', 11);


        add_action("template_redirect", 'redirection_function');
        function redirection_function()
        {
            global $woocommerce;

            if (is_cart()) {
                wp_safe_redirect(wc_get_checkout_url());
            }
        }
    }


    function gpls_woo_rfq_only_one_product($passed, $product_id, $quantity)
    {
        // Loop through cart items
        $product1 = wc_get_product($product_id);

        // $individual_per_order = get_post_meta($product_id, '_gpls_woo_individual_per_order', true);
        // $individual_per_order = apply_filters($individual_per_order, 'gpls_woo_individual_order', true);

        $individual_per_order1 = gpls_woo_plus_get_individual_per_order($product1);


        if ($individual_per_order1 == "yes") {

            $title = wc_get_product($product_id)->get_title();
        }

        //if ($individual_per_order == "yes")
        {

            $title = wc_get_product($product_id)->get_title();


            foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {


                if ($cart_item['product_id'] != $product_id) {


                    $product2 = wc_get_product($cart_item['product_id']);


                    $individual_per_order2 = gpls_woo_plus_get_individual_per_order($product2);


                    $exclusive = false;


                    if (($individual_per_order2 == "yes")) {
                        $title = wc_get_product($cart_item['product_id'])->get_title();


                        $exclusive = true;
                    }


                    if (($individual_per_order2 == "yes" | $individual_per_order1 == "yes")
                        && ($product1->get_id() != $product2->get_id())) {

                        $exclusive = true;
                    }

                    if (($individual_per_order2 == "no" && $individual_per_order1 == "no")) {

                        $exclusive = false;
                    }

                    if ($exclusive == true) {

                        $notice_txt = __(get_option('settings_gpls_woo_rfq_bulk_only_one_message', ''), 'rfqtk');
                        $notice_txt = __($notice_txt, 'rfqtk');

                        wc_add_notice($title . ' ' . $notice_txt, 'error');

                        return false;
                    }
                }
            }
        }

        return $passed;
    }


    add_filter('woocommerce_add_to_cart_validation', 'gpls_woo_rfq_only_no_mixing', 1000, 3);
    function gpls_woo_rfq_only_no_mixing($passed, $product_id, $quantity)
    {
        // Loop through cart items
        $settings_gpls_woo_rfq_checkout_option = get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout');
        $settings_gpls_woo_rfq_show_prices = get_option('settings_gpls_woo_rfq_show_prices', 'no');
        $settings_gpls_woo_rfq_plus_normal_checkout = get_option('settings_gpls_woo_rfq_plus_normal_checkout', 'no');
        $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', 'no');
        $settings_gpls_woo_rfq_limit_no_mixing_quote_with_purchase = get_option('settings_gpls_woo_rfq_limit_no_mixing_quote_with_purchase', 'no');

        if ($settings_gpls_woo_rfq_checkout_option == 'normal_checkout'
            || $settings_gpls_woo_rfq_show_prices == 'no'
            || $settings_gpls_woo_rfq_plus_normal_checkout == 'no'
            || $settings_gpls_woo_rfq_limit_to_rfq_only == 'no'
            || $settings_gpls_woo_rfq_limit_no_mixing_quote_with_purchase == 'no') {

            return $passed;
        }


        $rfq_enable_product_added_q_enabled = "no";

        $product = wc_get_product($product_id);

        //   $rfq_enable_product_added_q_enabled = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);
        //   $rfq_enable_product_added_q_enabled = apply_filters('gpls_rfq_enable', $rfq_enable_product_added_q_enabled, $product_id);

        $rfq_enable_product_added_q_enabled = gpls_woo_plus_get_rfq_enable($product);

        // if ($rfq_enable_product_added_q_enabled == "yes")
        {

            foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

                if ($cart_item['product_id'] != $product_id) {


                    $cart_item_product = wc_get_product($cart_item['product_id']);

                    // $individual_per_order_q_enabled2 = get_post_meta($cart_item['product_id'], '_gpls_woo_rfq_rfq_enable', true);
                    // $individual_per_order_q_enabled2 = apply_filters('gpls_rfq_enable', $individual_per_order_q_enabled2, $cart_item['product_id']);

                    $individual_per_order_q_enabled2 = gpls_woo_plus_get_rfq_enable($cart_item_product);

                    if ($individual_per_order_q_enabled2 !== $rfq_enable_product_added_q_enabled) {

                        $notice_txt = __(get_option('settings_gpls_woo_rfq_limit_no_mixing_quote_with_purchase_message', ''), 'rfqtk');// "Request Quote"

                        if ($notice_txt != "") {
                            $notice_txt = __($notice_txt, 'rfqtk');
                            wc_add_notice($notice_txt, 'error');
                        }

                        return false;
                    }
                }
            }
        }
        return $passed;
    }


    add_filter('woocommerce_add_to_cart_validation', 'gpls_woo_rfqtk_validate_add_item_validation', 1000, 3);

    if (is_plugin_active('advanced-product-fields-for-woocommerce/advanced-product-fields-for-woocommerce.php')) {
        add_filter('rfq_cart_get_item_data', 'rfqtk_cart_rfq_advanced_product_get_item_data_action', 100, 2);

        add_filter('woocommerce_get_item_data', 'rfqtk_prod_advanced_product_get_item_data', 100, 2);

    }

    add_action('rfqtk_woocommerce_checkout_create_order_line_item', 'rfqtk_prod_add_on_order_line_item', 1000, 5);
    add_filter('woocommerce_get_item_data', 'rfqtk_cart_rfq_get_item_data_action', 100, 2);


    if (is_plugin_active('quick-view-woocommerce/xoo-quickview-main.php')) {
        add_action('xoo-qv-summary', 'gpls_woo_rfq_quickview_xoo_qv', 1000);
    }
    if (is_plugin_active('woocommerce-quick-view/woocommerce-quick-view.php')) {
        add_action('wc_quick_view_before_single_product', 'gpls_woo_rfq_quickview_wc', 1000);
    }

    if (is_plugin_active('woo-quick-view/woo-quick-view.php')) {
        add_action('wcqv_product_data', 'gpls_woo_rfq_quickview_wcqv_product_data', 1000);
    }

    //if (is_plugin_active('woocommerce-lightbox/main.php'))
    {

        //  add_action( 'woocommerce_before_shop_loop_item', 'gpls_woo_rfq_quickview_wc' );
    }
    // if (is_plugin_active('woo-smart-quick-view/wpc-smart-quick-view.php'))
    {

        //      add_action( 'woocommerce_after_shop_loop_item', 'gpls_woo_rfq_quickview_lightbox' );
    }


    $theme = wp_get_theme();
    if (('Astra' == $theme->name || 'Astra' == $theme->parent_theme)) {
        add_action('astra_woo_quick_view_product_summary', 'astra_quickview_wc', 1000);
    }


    $qv = get_option('rfq_cart_sc_section_hide_astra_quickview', 'no') == 'yes';
    if (!$qv) {
        $qv = 'no';
    } else {
        $qv = "yes";
    };

    if ($qv == "yes" && ('Astra' == $theme->name || 'Astra' == $theme->parent_theme)) {

        add_filter('astra_woo_add_quick_view_text_html', 'gpls_woo_rfq_quickview_astra', 100, 3);
        add_filter('astra_woo_add_quick_view_button_html', 'gpls_woo_rfq_quickview_astra', 100, 3);
        add_filter('astra_woo_add_quick_view_data_html', 'gpls_woo_rfq_quickview_astra_image_click', 100, 2);

    }

    $url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

    if (isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] != "rfq") {
        add_filter('woocommerce_add_to_cart_redirect', 'rv_redirect_on_add_to_cart', 100, 2);
    }
    $show_prices = get_option('settings_gpls_woo_rfq_show_prices_customer_confirmation_email', 'no');

    if ($show_prices == 'yes') {

        add_filter('gpls_woo_rfq_show_prices_customer_email', 'gpls_woo_rfq_plus_show_email_prices');

    }

    function gpls_woocommerce_shipping_rate_cost($cost, $rate)
    {

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') != "rfq") {
            return $cost;
        }
        $hide_shipping_prices = get_option('settings_gpls_woo_rfq_hide_shipping_prices');

        if ($hide_shipping_prices != "yes") {
            return $cost;
        }

        $has_quote = gpls_woo_rfq_check_cart();

        if ($has_quote != false && is_array($has_quote) && count($has_quote) > 0) {

            if ($has_quote['rfq_enable'] == "yes") {
                return 0;
            }
        }

        return $cost;

    }


    add_filter('woocommerce_shipping_rate_cost', 'gpls_woocommerce_shipping_rate_cost', 1000, 2);


    function gpls_no_shipping_available_html($message)
    {
        // return __('Shipping options on request.', 'rfqtk');
        /*    echo '<script>jQuery.ajax({
            type: "POST",
            url: "",

            success: function() {
                location.reload();
            }
        });</script>';*/

        $message_option = __(get_option('settings_gpls_woo_rfq_limit_to_rfq_only_no_shipping_message'), 'rfqtk');

        if (!empty($message_option)) {
            return __($message_option, 'rfqtk');
        }

        return $message;
    }

    function gpls_no_available_payment_methods_html($message)
    {
        /* echo '<script>jQuery.ajax({
         type: "POST",
         url: "",
          success: function() {
             location.reload();
         }
     });</script>';*/

        $message_option = __(get_option('settings_gpls_woo_rfq_limit_to_rfq_only_no_shipping_message'), 'rfqtk');

        if (!empty($message_option)) {
            return __($message_option, 'rfqtk');
        }

        return $message;
    }


    function gpls_after_checkout_validation($data, $errors)
    {

        np_write_log($errors, __FILE__, __LINE__);


        if (isset($errors['payment']))
            echo '<script>jQuery.ajax({
   type: "POST",
   url: "",
    success: function() {
       location.reload();
   }
});</script>';
    }


    if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == 'rfq'
        && get_option('settings_gpls_woo_rfq_limit_to_rfq_only_no_shipping', 'no') == 'yes') {

        add_filter('woocommerce_no_shipping_available_html', 'gpls_no_shipping_available_html', 100);

        add_filter('woocommerce_no_available_payment_methods_message', 'gpls_no_available_payment_methods_html', 100);

        //add_action('woocommerce_checkout_update_order_review', 'gpls_woo_rfq_is_it_quote_method', 1000);

        // add_action( 'woocommerce_after_checkout_validation','gpls_after_checkout_validation',100,2  );


    }


    function gpls_woo_rfq_before_thankyou_action($order_id)
    {

        $order = wc_get_order($order_id);
        if ($order->get_status() == "gplsquote-req" || $order->get_status() == "wc-gplsquote-req") {
            return;
        }


        $GLOBALS["gpls_woo_rfq_show_prices"] = "yes";
        $GLOBALS["hide_for_visitor"] = "no";

        gpls_woo_rfq_woocommerce_RFQTK_purchase_only();

        if (isset($GLOBALS['GPLS_WOO_RFQ'])) {
            remove_action('wp_enqueue_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_scripts'), 2000);
            remove_action('wp_print_footer_scripts', array($GLOBALS['GPLS_WOO_RFQ'], 'gpls_woo_rfq_enqueue_footer_scripts'), 2000);
        }

        remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
        add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_only_purchase', 2000, 1);
    }

    add_action('woocommerce_before_thankyou', 'gpls_woo_rfq_before_thankyou_action', 100000, 1);

    function gpls_woo_rfq_woocommerce_thankyou2($order_id)
    {

        $order = wc_get_order($order_id);
        $quote_payment_method = $order->get_payment_method() === 'gpls-rfq';

        if ($quote_payment_method && get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == 'normal_checkout') {
            //echo 'testing thankyou';
            echo $order->get_customer_note();
        }

    }

//
    function gplsrfq_after_shop_loop_item_badge()
    {
        //

        $enable_badge = get_option('rfq_cart_sc_section_rfq_page_rfq_badge_use', 'no');
        $disable_in_product = get_option('rfq_cart_sc_section_rfq_page_rfq_badge_no_use_product', 'yes');

        if ($enable_badge == "no") {
            return;
        }

        if ($disable_in_product == "yes" && is_product()) {
            return;
        }

        global $product;

        if (!is_object($product) && !function_exists('wc_get_product')) return;
        if (!is_object($product)) $product = wc_get_product(get_the_ID());


        if (!isset($product) || !is_object($product)) {
            return;
        }

        {

            //  $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

            //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

            $rfq_enable = gpls_woo_plus_get_rfq_enable($product);

            $show_badge = false;

            if ((isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

                if ($rfq_enable == "yes") {
                    $show_badge = true;
                } else {
                    return;

                }
            }

            if ((isset($GLOBALS["gpls_woo_rfq_checkout_option"]) && $GLOBALS["gpls_woo_rfq_checkout_option"] == "normal_checkout")) {
                if ($rfq_enable == "yes") {
                    $show_badge = true;
                }

            }
            if ($show_badge) {

                $bg_color = get_option('rfq_cart_sc_section_rfq_page_rfq_badge_background', '');
                $color = get_option('rfq_cart_sc_section_rfq_page_rfq_badge_color', '');
                $font = get_option('rfq_cart_sc_section_rfq_page_rfq_badge_bold', 'no');
                if ($font == "no") {
                    $font = "";
                } else {
                    $font = "bold";
                }

                $quote_badge_text = get_option('rfq_cart_sc_section_rfq_page_rfq_badge_text', __('Request Price', 'rfqtk'));

                wc_get_template('woo-rfq/quote-badge/quote-badge.php',
                    array('bg_color' => $bg_color,
                        'quote_badge_text' => $quote_badge_text, 'color' => $color, 'font' => $font,
                        'product' => $product), '', gpls_woo_rfq_plus_DIR . 'woocommerce/');


            }


        }
    }

    $hook = get_option('rfq_cart_sc_section_rfq_page_rfq_badge_use_position', 'woocommerce_after_shop_loop_item');
    add_action($hook, 'gplsrfq_after_shop_loop_item_badge', 100);
    add_action('woocommerce_after_add_to_cart_button', 'gplsrfq_after_shop_loop_item_badge', 1000);


    function gplsrfq_add_css_to_emails($css, $email)
    {


        try {

            $ids = array('new_rfq', 'customer_rfq', 'new_pdf_request', 'admin_note'
            , 'new_vendor_rfq', 'gpls_prod_marketing', 'customer_rfq_sent', 'gpls_admin_upload');

            if (!in_array($email->id, $ids)) {
                return $css;
            }

            $email_css = get_option('settings_gpls_woo_rfq_email_css', '');

            if ($email_css != '') {
                $extra = $css . ' ' . $email_css;
            }

            return $extra;


        } catch (Exception $ex) {

            np_write_log($ex, __FILE__, __LINE__);
            return $css;

        }

        return $css;
    }

   // add_filter('woocommerce_email_styles', 'gplsrfq_add_css_to_emails', 9999, 2);


}


//add_action('after_setup_theme', 'gpls_woo_rfq_rfqtk_after_setup_theme');
add_action('wp_loaded', 'gpls_woo_rfq_rfqtk_after_setup_theme');


function gpls_rfq_enable_at_checkout_function($rfq_enable, $_product_id, $item, $values)
{


    $split_cart_option = get_option('settings_gpls_woo_rfq_5j', 'no');


    $items = WC()->cart->get_cart();
    gpls_woo_rfq_cart_set('is_quote_request', 'yes');

    foreach ($items as $item => $values) {

        if ($split_cart_option == "yes") {
            $_product = wc_get_product($values['product_id']);

            //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


            if ($rfq_enable != 'yes') {
                gpls_woo_rfq_cart_set('is_quote_request', 'no');
                $rfq_enable = false;
                break;
            }
        }
    }

    return $rfq_enable;
}


if (!is_admin() && !wp_doing_cron() && is_array($_REQUEST) && count($_REQUEST) > 0) {


    function gpls_woo_rfq_5j_purchase_items()
    {
        do_action('before_gpls_woo_rfq_5j_process_purchases');

        $is_quote_request = gpls_woo_rfq_get_item('is_quote_request');
        if ($is_quote_request == "yes") {
            return;
        }

        gpls_woo_rfq_cart_delete('temp_cart');

        $items = WC()->cart->get_cart();

        $temp_array = array();
        $cart_content = WC()->cart->get_cart_contents();

        foreach ($items as $key => $values) {

            $_product = wc_get_product($values['product_id']);

            //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


            if ($rfq_enable == 'yes') {

                $temp_array[$key] = $values;
                unset($cart_content[$key]);

            }

        }

        WC()->cart->set_cart_contents($cart_content);
        gpls_woo_rfq_cart_set('temp_cart', $temp_array);


        do_action('after_gpls_woo_rfq_5j_process_purchases', $is_quote_request);

    }

    // function my_test124($order_id, $transaction_id)
    //function my_test124()
    function gpls_woo_rfq_5j_quote_items($order_id)
    {
        do_action('before_gpls_woo_rfq_5j_process_quotes', $order_id);

        $temp_cart = gpls_woo_rfq_get_item('temp_cart');


        if ($temp_cart) {


            $is_quote_request = gpls_woo_rfq_get_item('is_quote_request');

            if (!$is_quote_request) {
                return;
            }


            WC()->initialize_cart();
            wc()->cart->set_session();
            wc()->cart->set_cart_contents($temp_cart);
            wc()->cart->calculate_totals();

            $split_the_cart_redirect = get_option('settings_gpls_woo_rfq_5j_redirect');
            if ($split_the_cart_redirect == 'cart') {
                wp_safe_redirect(wc_get_cart_url());
            } elseif ($split_the_cart_redirect == 'checkout') {
                wp_safe_redirect(wc_get_checkout_url());
            }


            $split_the_cart_message_after_purchase = get_option('settings_gpls_5j_after_purchase_thankyou_message');
            $split_the_cart_message_after_purchase = __($split_the_cart_message_after_purchase, 'rfqtk');
            $split_the_cart_message_after_purchase = apply_filters('settings_gpls_5j_after_purchase_message_filter', $split_the_cart_message_after_purchase, $order_id);
            if ($split_the_cart_message_after_purchase) {
                // echo wp_kses_post(wpautop(wptexturize($split_the_cart_message_after_purchase)));
                if (!WC()->cart->is_empty()) {
                    echo '<div class="woocommerce">
	<div class="woocommerce-info">' . $split_the_cart_message_after_purchase . '</div></div>';
                }
            }


            $split_the_cart_notice_after_purchase = get_option('settings_gpls_5j_after_purchase_notice');
            $split_the_cart_notice_after_purchase = __($split_the_cart_notice_after_purchase, 'rfqtk');
            $split_the_cart_notice_after_purchase = apply_filters('settings_gpls_5j_after_purchase_notice_filter', $split_the_cart_notice_after_purchase, $order_id);

            if ($split_the_cart_notice_after_purchase) {


                wc_clear_notices();

                if (!WC()->cart->is_empty()) {

                    wc_add_notice($split_the_cart_notice_after_purchase, 'notice');
                }
            }


        }

        do_action('after_gpls_woo_rfq_5j_process_quotes', $order_id);
    }


}
function gpls_woo_rfq_5j_order_status_changed($order_id, $status_from, $status_to)
{

    $order = wc_get_order($order_id);

    {

        $gpls_temp_cart_deleted = $order->get_meta('_gpls_temp_cart_deleted');

        if ('yes' === $gpls_temp_cart_deleted) {
            return;
        }


        if (in_array($status_to, array('wc-gplsquote-req', 'gplsquote-req'))) {

            gpls_woo_rfq_cart_delete('is_quote_request');

            update_post_meta($order_id, '_gpls_temp_cart_deleted', 'yes');

        }
    }

}

function gpls_woo_rfq_5j_needs_shipping($needs_shipping, $product)
{

    $split_cart_option = get_option('settings_gpls_woo_rfq_5j', 'no');

    if ($split_cart_option == "no" || !function_exists('WC')) {
        return $needs_shipping;
    }
    WC()->initialize_cart();
    wc()->cart->set_session();
    $items = WC()->cart->get_cart();

    $includes_purchase = false;

    foreach ($items as $key => $values) {

        $_product = wc_get_product($values['product_id']);

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable != 'yes') {
            $includes_purchase = true;
            break;
        }

    }


    if ($includes_purchase == true) {

        //   $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if ($rfq_enable != 'yes') {
            $needs_shipping = false;
        }
    }

    return $needs_shipping;
}

function gpls_woo_rfq_5j_cart_item_visible($visible, $cart_item, $cart_item_key)
{

    $split_cart_option = get_option('settings_gpls_woo_rfq_5j', 'no');

    if ($split_cart_option == "no") {
        return $visible;
    }

    WC()->initialize_cart();
    wc()->cart->set_session();
    $items = WC()->cart->get_cart();

    $includes_purchase = false;

    foreach ($items as $key => $values) {

        $_product = wc_get_product($values['product_id']);

        //   $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable != 'yes') {
            $includes_purchase = true;
            break;
        }

    }


    if ($includes_purchase == true) {

        $product = isset($cart_item['variation_id']) && $cart_item['variation_id'] ? wc_get_product($cart_item['product_id']) : $cart_item['data'];

        //  $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if ($rfq_enable == 'yes') {
            return false;
        }
    }

    return $visible;
}

function gpls_woo_rfq_5j_checkout_notice($checkout)
{

    $split_cart_option = get_option('settings_gpls_woo_rfq_5j', 'no');

    if ($split_cart_option == "no") {
        return;
    }


    $cart_check = gpls_woo_rfq_check_cart();


    if (is_array($cart_check) && count($cart_check) > 0) {


        if (isset($cart_check['rfq_enable']) && $cart_check['rfq_enable'] == "yes" && isset($cart_check['has_purchase']) && $cart_check['has_purchase'] == 1) {

            $split_the_cart_notice_before_purchase = get_option('settings_gpls_5j_before_purchase_checkout_notice');
            $split_the_cart_notice_before_purchase = __($split_the_cart_notice_before_purchase, 'rfqtk');
            $split_the_cart_notice_before_purchase = apply_filters('settings_gpls_5j_before_purchase_checkout_notice_filter', $split_the_cart_notice_before_purchase);

            if ($split_the_cart_notice_before_purchase != '') {
                echo '<div class="woocommerce">	<div class="woocommerce-info">' . $split_the_cart_notice_before_purchase . '</div></div>';
            }

        }
    }

}


function gpls_woo_rfq_5j_cart_notice($checkout)
{

    $split_cart_option = get_option('settings_gpls_woo_rfq_5j', 'no');

    if ($split_cart_option == "no") {
        return;
    }

    $items = WC()->cart->get_cart();

    $rfq_enable = false;

    $has_purchase = false;

    foreach ($items as $item => $values) {

        $_product = wc_get_product($values['product_id']);

        //  $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $cart_check = gpls_woo_rfq_check_cart();

        if ($rfq_enable == 'yes') {
            //   gpls_woo_rfq_cart_set('is_quote_request', 'yes');
            $rfq_enable = true;
            break;

        }
    }

    foreach ($items as $item => $values) {

        $_product = wc_get_product($values['product_id']);

        if (is_array($cart_check) && count($cart_check) > 0) {

            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


            if ($rfq_enable != 'yes') {
                //gpls_woo_rfq_cart_set('is_quote_request', 'yes');
                $has_purchase = true;
                break;

            }
        }


        if (isset($cart_check['rfq_enable']) && $cart_check['rfq_enable'] == "yes" && isset($cart_check['has_purchase']) && $cart_check['has_purchase'] == 1) {

            $split_the_cart_notice_before_purchase = get_option('settings_gpls_5j0_before_purchase_checkout_notice');
            $split_the_cart_notice_before_purchase = __($split_the_cart_notice_before_purchase, 'rfqtk');
            $split_the_cart_notice_before_purchase = apply_filters('settings_gpls_5j0_before_purchase_checkout_notice', $split_the_cart_notice_before_purchase);

            if ($split_the_cart_notice_before_purchase != '') {
                echo '<div class="woocommerce">	<div class="woocommerce-info">' . $split_the_cart_notice_before_purchase . '</div></div>';
            }

        }
    }
}

function gpls_woo_rfq_5j_process_woo_rfq_5j()
{

    add_filter('gpls_rfq_enable_at_checkout', 'gpls_rfq_enable_at_checkout_function', 100, 4);
    add_action('woocommerce_before_checkout_process', 'gpls_woo_rfq_5j_purchase_items', 100, 1);
    add_action('woocommerce_before_thankyou', 'gpls_woo_rfq_5j_quote_items', 1, 1);
    add_action('woocommerce_before_cart', 'gpls_woo_rfq_5j_cart_notice', 100, 1);
    add_action('woocommerce_order_status_changed', 'gpls_woo_rfq_5j_order_status_changed', 101, 3);
    add_filter('woocommerce_product_needs_shipping', 'gpls_woo_rfq_5j_needs_shipping', 1000, 2);

    add_filter('woocommerce_checkout_cart_item_visible', 'gpls_woo_rfq_5j_cart_item_visible', 1000, 3);


}

$woo_rfq_5j = get_option('settings_gpls_woo_rfq_5j', 'no');


if ($woo_rfq_5j == "yes") {
    add_action('wp_loaded', 'gpls_woo_rfq_5j_process_woo_rfq_5j');

    add_action("woocommerce_before_checkout_form", "gpls_woo_rfq_5j_checkout_notice", 100, 1);
}


if (!function_exists('gpls_woo_rfq_check_cart')) {
    function gpls_woo_rfq_check_cart()
    {
        if (!function_exists('WC')) return false;

        WC()->initialize_session();

        if (!WC()->cart) return false;

        $items = WC()->cart->get_cart();

        $rfq_enable = "no";

        $has_purchase = false;

        foreach ($items as $item => $values) {

            $_product1 = wc_get_product($values['product_id']);

            //   $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            $rfq_enable_local1 = gpls_woo_plus_get_rfq_enable($_product1);


            if ($rfq_enable_local1 == 'yes') {
                //   gpls_woo_rfq_cart_set('is_quote_request', 'yes');
                $rfq_enable = "yes";

                break;

            }
        }

        foreach ($items as $item => $values) {

            $_product2 = wc_get_product($values['product_id']);

            //    $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            //    $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            $rfq_enable_local2 = gpls_woo_plus_get_rfq_enable($_product2);


            if ($rfq_enable_local2 == 'no') {
                //gpls_woo_rfq_cart_set('is_quote_request', 'yes');

                $has_purchase = true;
                break;

            }
        }


        return array('rfq_enable' => $rfq_enable, 'has_purchase' => $has_purchase);
    }

}





