<?php
/**
 * Customer Notes
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/woo-rfq/myacct/cust-notes.php.
 * @author  Neah Plugins
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<?php

//echo '<br /> dashboard-cust-notes.php';
echo '<ul class="dashboard-cust-notes">';

$order_fact = new WC_Order_Factory();

foreach ($comments as $comment) {

    $order = $order_fact::get_order($comment->ID);
    $wp_post = new WP_Post(get_post($comment->ID));

    if($wp_post->post_status=='trash')
    {
     continue;
    }


    $order_status = $order->get_status();
    // echo $order_status;

    $ends=gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key),'D');
    if ($ends!=1) {

        if ($order_status == 'gplsquote-sent' || $order_status == 'wc-gplsquote-sent') {

            $order_status = get_option('settings_gpls_woo_rfq_quote_sent_label');
            $order_status = __($order_status, 'rfqtk');

            if (!isset($order_status)) {
                $order_status = __('Quote Sent', 'rfqtk');
            }
        }
    }
    if ($order_status == 'gplsquote-req'|| $order_status == 'wc-gplsquote-req')
    {

        $order_status = get_option('settings_gpls_woo_rfq_quote_request_label');
        $order_status = __($order_status, 'rfqtk');

        if (!isset($order_status)) {
            $order_status = __('Quote Requests', 'rfqtk');
        }
    }

    echo '<li >';

    $avatar = get_avatar($comment->comment_author, '32');

    if (isset($avatar)) {
        $avatar;
    }

    /* translators: %s: review author */
    //echo '<h4 class="meta"><a href="' . get_permalink( $comment->ID ) . '#comment-' . absint( $comment->ID ) . '">' . esc_html( apply_filters( 'rfktoolkit_dashboard_recent_notes', $comment->post_title, $comment ) ) . '</a> ' . sprintf( __( ' %s', 'rfqtk' ), esc_html( $comment->comment_author ) ) . '</h4>';
    $comment_date=date_create($comment->comment_date);
    ?>
    <h5><a class="link"
           href="<?php echo admin_url('post.php?post=' . $order->get_id() . '&action=edit'); ?>"><?php printf(__('Order #%s', 'rfqtk'), $order->get_order_number() . ' ' . $order_status); ?></a>
        (<?php printf('<time datetime="%s">%s</time>', date_format($comment_date,"m/d/Y h:i:s g A"), date_format($comment_date,"m/d/Y h:i:s A")); ?>
        )<?php printf(__(' %s', 'rfqtk'), esc_html($comment->comment_author)) ?></h5>
    <?php
    echo '<blockquote style="background: #f6f2ec; padding:5px">' . wp_kses_data($comment->comment_excerpt) . '</blockquote></li>';

}
echo '</ul>';
