<?php
/**
 * Proposal Detail
 * @author  Neah Plugins

 * @author  Neah Plugins
 * This template can be overridden by copying it to yourtheme/woocommerce/woo-rfq/rfqtk-proposal-order-details.php.php
 */



if (!defined('ABSPATH')) {
    exit;

}



ob_start();


?>
<table class="td" cellspacing="0" cellpadding="6"
       style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
    <thead>
    <tr>
        <th class="td" scope="col" style="text-align:left;"><?php _e('Product', 'rfqtk'); ?></th>
        <th class="td" scope="col" style="text-align:left;"><?php _e('Quantity', 'rfqtk'); ?></th>
        <th class="td" scope="col" style="text-align:left;"><?php _e('Price', 'rfqtk'); ?></th>

    </tr>
    </thead>
    <tbody>
    <?php
    $args = array(
        'show_sku' => true,
        'show_image' => true,
        'image_size' => array(32, 32),
        'plain_text' => false,
        'sent_to_admin' => false,

    );


    $template = $args['plain_text'] ? 'woo-rfq/rfqtk-proposal-order-items.php' : 'woo-rfq/rfqtk-proposal-order-items.php';

    $show_desc = get_option("settings_gpls_woo_rfq_import_order_items_table_desc", 'no');

    wc_get_template($template, apply_filters('woocommerce_email_order_items_args', array(
        'order' => $the_order,
        'items' => $the_order->get_items(),
        'show_download_links' => $the_order->is_download_permitted() && !$args['sent_to_admin'],
        'show_sku' => $args['show_sku'],
        'show_purchase_note' => $the_order->is_paid() && !$args['sent_to_admin'],
        'show_image' => $args['show_image'],
        'image_size' => $args['image_size'],
        'plain_text' => $args['plain_text'],
        'sent_to_admin' => $args['sent_to_admin'],
        'show_desc' => $show_desc,
    )),'',gpls_woo_rfq_plus_DIR . 'woocommerce/'); ?>
    </tbody>
    <tfoot>
    <?php
    $totals = $the_order->get_order_item_totals();
    $text_align="center";


    if ( $totals ) {
        $i = 0;
        foreach ( $totals as $total ) {
            $i++;
            if(strcmp(trim($total['label']),"Payment method:")!=0) {
                ?>
                <tr>

                    <th class="td" scope="row" colspan="2"
                        style="<?php echo (1 === $i) ? 'border-top-width: 4px;' : ''; ?>"><?php echo wp_kses_post($total['label']); ?></th>
                    <td class="td"
                        style="<?php echo (1 === $i) ? 'border-top-width: 4px;' : ''; ?>"><?php echo wp_kses_post($total['value']); ?></td>
                </tr>
                <?php
            }
        }
    }
    if ( $the_order->get_customer_note() ) {
        ?>
        <tr>
            <th class="td" scope="row" colspan="2" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Note:', 'rfqtk' ); ?></th>
            <td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php echo wp_kses_post( wptexturize( $the_order->get_customer_note() ) ); ?></td>
        </tr>
        <?php
    }
    ?>
    </tfoot>
    <?php


    ?>

</table>

<?php

$table = apply_filters('woocommerce_email_order_items_table', ob_get_clean(), $the_order);

$content = html_entity_decode(get_post_meta($the_order->get_id(),'_quote_sent_note',true));

update_post_meta($the_order->get_id(),'_quote_sent_note',esc_html($content).'<div style="clear:both">'.$table);


?>

