<?php

class WPLA_FeedDataBuilder {

	var $account;
	var $logger;
	public $result;
	static $locale = array();

	/**
	 * New products feed
	 */

	static function return_csv_object( $csv_body = '', $csv_header = '', $template_type = false ) {

		$csvObj = new stdClass();
		$csvObj->data          = $csv_header . $csv_body;
		$csvObj->template_type = $template_type;
		$csvObj->line_count    = substr_count( $csv_body, "\n" );

		return $csvObj;
	}

	// generate csv feed for prepared products
	static function buildNewProductsFeedData( $items, $account_id, $profile, $append_feed = false ) {

		if ( ! $profile || ! $profile->id ) {
			WPLA()->logger->info('no profile found, falling back to ListingLoader (Offer)');
			return self::buildListingLoaderFeedData( $items, $account_id, $append_feed );
		}

		$template = new WPLA_AmazonFeedTemplate( $profile->tpl_id );
		if ( ! $template || ! $template->id ) {
			WPLA()->logger->info('no template, falling back to ListingLoader (Offer) - tpl_id: '.$profile->tpl_id);
			return self::buildListingLoaderFeedData( $items, $account_id, $append_feed );
		}

		$columns = $template->getFieldNames();
		$profile_fields = maybe_unserialize( $profile->fields );
		$profile_details = maybe_unserialize( $profile->details );

		// echo "<pre>";print_r($items);echo"</pre>";#die();
		// echo "<pre>";print_r($template);echo"</pre>";#die();
		// echo "<pre>";print_r($profile);echo"</pre>";#die();
		// echo "<pre>";print_r($columns);echo"</pre>";#die();
		// echo "<pre>";print_r($profile_fields);echo"</pre>";#die();

		if ( ! $columns ) {
			WPLA()->logger->error('no columns found in template - tpl_id: '.$profile->tpl_id);
			WPLA()->logger->info('profile: '.print_r($profile,1));
			WPLA()->logger->info('template: '.print_r($template,1));
			WPLA()->logger->info('columns: '.print_r($columns,1));
			WPLA()->logger->info('items: '.print_r($items,1));
			return '';
		}

		// add variation columns
		// (not really needed - if the template doesn't already have them, variations are probably not allowed or the template is outdated)
		// if ( $template->name != 'Offer' ) {

			// $profile_details = maybe_unserialize( $profile->details );
			// $variations_mode = isset( $profile_details['variations_mode'] ) ? $profile_details['variations_mode'] : 'default';

			// if ( $variations_mode != 'flat' ) {
			// 	$columns[] = 'parent-sku';
			// 	$columns[] = 'parentage';
			// 	$columns[] = 'relationship-type';
			// 	$columns[] = 'variation-theme';
			// }

		// }

		// adjust template name (fptcustom)
		$template_name = $template->name;
		if ( substr( $template_name, 0, 10 )       == 'fptcustom-' ) {			// 'fptcustom-health' -> 'fptcustom'
			$template_name = 'fptcustom';
		} elseif ( substr( $template_name, 0, 16 ) == 'fptcustomcustom-' ) {	// 'fptcustomcustom-Wirelessdownloads' -> 'fptcustomcustom'
			$template_name = 'fptcustomcustom';
		}

		// header - 1st row
		$csv_header  =        'TemplateType='      . $template_name;
		$csv_header .= "\t" . 'Version='           . $template->version;
		$csv_header .= "\t" . 'Category='          . $template->category;
		$csv_header .= "\t" . 'TemplateSignature=' . $template->signature;
		$csv_header .= str_repeat("\t", sizeof($columns) - 4 ) . "\n";

		// 2nd row
		$csv_header .= join( "\t", $columns ) . "\n";

		// 3rd row
		if ( $template->name != 'Offer' || $template->version != '1.4' ) // this is not obsolete - Amazon expects v1.4 to have only two rows reserved!
			$csv_header .= join( "\t", $columns ) . "\n";
		$csv_body = '';

        $max_feed_size = get_option( 'wpla_max_feed_size', 1000 );
        $feed_size = 0;

		// loop products
		foreach ( $items as $item ) {
            if ( $feed_size >= $max_feed_size ) {
                WPLA()->logger->info( 'max_feed_size reached. Breaking.');
                break;
            }

			// get WooCommerce product data
			$product_id = $item['post_id'];
			$product = WPLA_ProductWrapper::getProduct( $product_id );
			if ( ! $product ) continue;
			if ( ! $item['sku'] ) continue;
			WPLA()->logger->debug('processing item '.$item['sku'].' - ID '.$product_id);

			// Skip listing parent variables if profile variations mode is FLAT #53534
			if ( $profile_details && $profile_details['variations_mode'] == 'flat' && $product->is_type( 'variable' ) ) {
                WPLA()->logger->debug('flat variations mode. skipping variable (parent)');
			    continue;
            }

			if ( apply_filters( 'wpla_filter_skip_listing_feed_item', false, $item, $product, $profile ) === true ) {
                WPLA()->logger->info('Skipping adding listing to the feed - wpla_filter_skip_listing_feed_item returned TRUE');
                continue;
            }

			// reset row cache
			WPLA()->memcache->clearColumnCache();

			// process product
			foreach ( $columns as $col ) {
				$value = self::parseProductColumn( $col, $item, $product, $profile );
				$value = apply_filters( 'wpla_filter_listing_feed_column', $value, $col, $item, $product, $profile, $template->name );
				$value = str_replace( array("\t","\n","\r"), ' ', $value );	// make sure there are no tabs or line breaks in any field
				$csv_body .= $value . "\t";
				WPLA()->memcache->setColumnValue( wpla_get_product_meta( $product, 'sku' ), $col, $value );
			}
			$csv_body .= "\n";

            $feed_size++;
		}

		// check if any rows were created
		if ( ! $csv_body ) return self::return_csv_object();

		// only return body when appending feed
		if ( $append_feed ) return self::return_csv_object( $csv_body, '', $template->name );

		// return csv object
		return self::return_csv_object( $csv_body, $csv_header, $template->name );

	} // buildNewProductsFeedData()


	static function parseProductColumn( $column, $item, $product, $profile ) {
		wpla_logger_start_timer('parseProductColumn');

		$profile_fields  = $profile ? maybe_unserialize( $profile->fields )  : array();
		$profile_details = $profile ? maybe_unserialize( $profile->details ) : array();
		$variations_mode = isset( $profile_details['variations_mode'] ) ? $profile_details['variations_mode'] : 'default';
		$value           = '';
		$product_id      = wpla_get_product_meta( $product, 'id' );
		$product_type    = wpla_get_product_meta( $product, 'product_type' );
		$product_sku     = wpla_get_product_meta( $product, 'sku' );
		$fba_enabled     = false;

		// handle FBA mode / fallback
        if ( get_option( 'wpla_fba_enabled', 0 ) ) {
            if ( get_option('wpla_fba_enable_fallback') == 1 ) {
                // fallback enabled
                // if there is no FBA qty, FBA will be disabled
                $fba_enabled = $item['fba_quantity'] > 0 ? true : false; // if there is FBA qty, always enable FBA
            } else {
                // fallback disabled
                $fba_enabled = $item['fba_fcid'] && ( $item['fba_fcid'] != 'DEFAULT' ) ; // regard fba_fcid column - ignore stock
            }
        }

		// if fulfillment_center_id / fulfillment-center-id is forced to AMAZON_NA / AMAZON_EU in the listing profile,
		// make sure to set $fba_enabled to regard this overwrite in ListingLoader feeds as well
		if ( isset( $profile_fields['fulfillment_center_id'] ) && ! empty( $profile_fields['fulfillment_center_id'] ) ) {
			$fba_enabled = $profile_fields['fulfillment_center_id'] == 'DEFAULT' || $profile_fields['fulfillment_center_id'] == '[---]' ? false : true;
		}
		if ( isset( $profile_fields['fulfillment-center-id'] ) && ! empty( $profile_fields['fulfillment-center-id'] ) ) {
			$fba_enabled = $profile_fields['fulfillment-center-id'] == 'DEFAULT' || $profile_fields['fulfillment-center-id'] == '[---]' ? false : true;
		}

		// handle FBA only mode - force FBA enabled if set
        // FBA needs to be enabled as well #29966
		$fba_only_mode = get_option( 'wpla_fba_only_mode', 0 );
        if ( get_option( 'wpla_fba_enabled', 0 ) && $fba_only_mode ) $fba_enabled = true;

        // handle FBA on product / variation level
		// $fba_overwrite = wpla_get_product_meta( $product_id, 'amazon_fba_overwrite' );	// works as well but no good performance
		$fba_overwrite = get_post_meta( $product_id, '_amazon_fba_overwrite', true );		// better performance than the line above
		if ( $fba_overwrite == 'FBA' ) {
			$fba_enabled = true;
		} elseif ( $fba_overwrite == 'FBM' ) {
			$fba_enabled = false;
		}


        // set correct post_id for variations
        $post_id = $product_id;
        if ( $product_type == 'variation' || $product_type == 'product-part-variation' ) {
            if ( version_compare( WC_VERSION, '3.0', '<' ) ) {
                $post_id = $product->variation_id;
                $product_id = $product->id;
            } else {
                // set the $product_id to the parent's ID
                $product_id = WPLA_ProductWrapper::getVariationParent( $post_id );
            }
        }

        WPLA()->logger->debug('parseProductColumn ('. $column .') #'. $product_id .'/'. $post_id );

		// get custom product level feed columns - and merge with profile columns
		$custom_feed_columns = get_post_meta( $product_id, '_wpla_custom_feed_columns', true );
		if ( $custom_feed_columns && is_array( $custom_feed_columns ) && ! empty( $custom_feed_columns ) ) {
			$profile_fields = array_merge( $profile_fields, $custom_feed_columns );
		}

		// process multi-marketplace columns
        $feed_marketplace = isset( WPLA()->accounts[ $item['account_id'] ] ) ? WPLA()->accounts[ $item['account_id'] ]->marketplace_id : '';

		if ( $feed_marketplace ) {
            preg_match( '/marketplace_id=([0-9A-Z]+)]/', $column, $match );
            if ( !empty( $match ) ) {
                $column_marketplace_id = $match[1];
            }
        }

		// process hard coded fields
		switch ( $column ) {

			case 'external_product_id':
				$value = get_post_meta( $post_id, '_amazon_product_id', true );
				break;

			case 'external_product_id_type':
				$value = get_post_meta( $post_id, '_amazon_id_type', true );
				// // leave id type empty if there is no product id (parent variations) (incompatible with amazon.in)
				// $external_product_id = WPLA()->memcache->getColumnValue( $product->sku, 'external_product_id' );
				// if ( empty( $external_product_id ) ) $value = '[---]';
				break;

			case 'sku':			// update feed
			case 'item_sku':    // new items feed
				// $value = $product->sku;
				$value = $item['sku']; // we have to use the item SKU - or feed processing would fail if SKU is different in WooCommerce and WP-Lister
				break;

			case 'price':		// update feed
            case 'standard_price':
                // Stop the Price Based on Country plugin from modifying these prices #55996
                add_filter( 'wc_price_based_country_stop_pricing', function() {
                    return true; // True to do not load the frontend pricing.
                });

				// $value = $product->get_price();			// WC2.1+
				$value = wpla_get_product_meta( $post_id, 'regular_price' );			// WC2.0
				$value = $profile ? $profile->processProfilePrice( $value ) : $value;
				$value = apply_filters( 'wpla_filter_product_price', $value, $post_id, $product, $item, $profile );
				if ( ( $post_id != $product_id ) && ( $product_value = get_post_meta( $product_id, '_amazon_price', true ) ) ) {	// parent price
					if ( $product_value > 0 ) $value = $product_value;
				}
				if ( $product_value = get_post_meta( $post_id, '_amazon_price', true ) ) {											// variation price
					if ( $product_value > 0 ) $value = $product_value;
				}

				if ( $value ) {
                    // Deduct the shipping fee from the min/max prices
                    if ( $shipping_fee = get_option( 'wpla_repricing_shipping', false ) ) {
                        $value -= $shipping_fee;

                        // remove the shipping fee from the min/max prices
                        $item['min_price'] -= $shipping_fee;
                        $item['max_price'] -= $shipping_fee;
                    }

                    // Format the value so it has the correct decimal character #51029
                    $value  = str_replace( ',', '.', $value ); // covert to a dot decimal character - will get converted to comma later if necessary in self::convertCurrencyFormat()
                    $value = number_format( floatval( $value ), 2, null, '' );

                    // make sure price stays within min/max boundaries - prevent errors in PNQ feed
                    if ( $item['min_price'] > 0 ) $value = max( $value, $item['min_price'] );
                    if ( $item['max_price'] > 0 ) $value = min( $value, $item['max_price'] );
                }

				###
                # 05/19/23: Only apply the profile value if there's no _amazon_price set in the product #60955
                ###
                // Ugh, we've gone full circle now.
                // Revising again because apparently, profile fields need to have the highest priority #20404 #20390
                // So now, the regular price can be overridden by _amazon_price, and that too can be overridden by the profile field
                if ( !$product_value && ! empty( $profile_fields[$column] ) ) {
					$value = $profile_fields[$column];

					if (is_numeric( $value )) {
						// Format the value so it has the correct decimal character #51029
						$value = str_replace( ',', '.', $value ); // covert to a dot decimal character - will get converted to comma later if necessary in self::convertCurrencyFormat()
						$value = number_format( floatval( $value ), 2, null, '' );
					}
                }

                // Use profile price if value is empty
				//if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) $value = $profile_fields[$column];

                // Use profile price only if it exists and _amazon_price is not set #18878 (revised #17624)
                //if ( ! empty( $profile_fields[ $column ] ) && ! $product_value ) {
                //    $value = $profile_fields[ $column ];
                //}

                // send empty price if external_repricer flag is set
           		$x_repricer = get_post_meta( $product_id, '_amazon_external_repricer', true );
                $y_repricer = get_option( 'wpla_external_repricer_mode', false );
           		if ( $x_repricer == '1' || $y_repricer == '1' ) $value = '';
           		if ( $x_repricer == '1' || $y_repricer == '1' ) $value = '';

				break;

            // Add support for B2B pricing
            case 'business_price':
            case 'business-price':
                $value = get_post_meta( $product_id, '_amazon_b2b_price', true );
                $value = $profile ? $profile->processProfilePrice( $value ) : $value;

                if ( ( $post_id != $product_id ) && ( $product_value = get_post_meta( $post_id, '_amazon_b2b_price', true ) ) ) {	// parent price
                    if ( $product_value > 0 ) $value = $product_value;
                }
                $value = apply_filters( 'wpla_filter_b2b_price', $value, $product_id, $product, $item, $profile );

                $value = $value ? number_format( $value, 2, null, '' ) : $value;

                if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) $value = $profile_fields[$column];
                break;

			case 'sale-price':			// update feed
			case 'sale_price':			// new items feed
                // Stop the Price Based on Country plugin from modifying these prices #55996
                add_filter( 'wc_price_based_country_stop_pricing', function() {
                    return true; // True to do not load the frontend pricing.
                });

				// $value = $product->get_sale_price();		// WC2.1+
				$value = wpla_get_product_meta( $post_id, 'sale_price' );				// WC2.0
				$value = $profile ? $profile->processProfilePrice( $value ) : $value;
				$value = apply_filters( 'wpla_filter_sale_price', $value, $post_id, $product, $item, $profile );
				$value = $value ? number_format($value,2, null, '' ) : $value;

				// make sure sale_price is not higher than standard_price / price - Amazon might silently ignore price updates otherwise
				$standard_price = self::getStandardPriceForRow( $product_sku );
				if ( $standard_price && ( $value > $standard_price ) ) $value = '';

				// if no sale price is set, send regular price with sale end date in the past to remove previously sent sale prices
				if ( empty($value) ) $value = $standard_price;

				// if sale price is disabled, use standard price here
                if ( get_option( 'wpla_disable_sale_price', 0 ) ) {
                    $value = $standard_price;
                }

                // Deduct the shipping fee from the min/max prices
                if ( $value && $shipping_fee = get_option( 'wpla_repricing_shipping', false ) ) {
                    $value -= $shipping_fee;

                    // remove the shipping fee from the min/max prices
                    $item['min_price'] -= $shipping_fee;
                    $item['max_price'] -= $shipping_fee;
                }

                // make sure price stays within min/max boundaries - prevent Amazon from throwing price alert / validation error (would make listing inactive)
                if ( $item['min_price'] > 0 ) $value = max( $value, $item['min_price'] );
                if ( $item['max_price'] > 0 ) $value = min( $value, $item['max_price'] );

                // Use profile price if set
                if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) $value = $profile_fields[$column];

                // send empty price if external_repricer flag is set
                $x_repricer = get_post_meta( $product_id, '_amazon_external_repricer', true );
                $y_repricer = get_option( 'wpla_external_repricer_mode', false );
                if ( $x_repricer == '1' || $y_repricer == '1' ) $value = '';
                if ( $x_repricer == '1' || $y_repricer == '1' ) $value = '';

				break;

			case 'sale_from_date':		// new items feed
			case 'sale-start-date':		// update feed

				$date = get_post_meta( $post_id, '_sale_price_dates_from', true );
				if ( $date ) $value = date( 'Y-m-d', $date );

                $has_sale_price = self::hasActiveSalePrice( $product_sku );

				if ( ! $value && $has_sale_price ) {
                    // check for profile shortcodes/values before using filler dates
                    if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) {
                        $value = $profile_fields[$column];
                    }
                }

				// if sale price exists but no start date, fill in 2011-01-01
				if ( ! $value && $has_sale_price ) $value = '2011-01-01';

				// fall back to default past date if standard price is set
				$standard_price = self::getStandardPriceForRow( $product_sku );
				if ( ! $value && $standard_price ) $value = '2000-01-01';  // default past date

                // if sale price is intentionally left blank by [---] shortcode, leave sale date blank as well
                $sale_price = self::getSalePriceForRow( $product_sku );

                // Sometimes, sale_from_date will be processed first before sale_price so sale_price
                // will never have a value in self::getSalePriceForRow. Run self::parseProductColumn for the 'sale_price' column once
                // to get the real sale price
                // #18443
                if ( ! $sale_price ) {
                    // try to get the quantity in case it hasn't been processed yet
                    $sale_price = self::parseProductColumn( 'sale_price', $item, $product, $profile );

                    // if it is still FALSE, leave empty
                    if ( ! $sale_price ) $value = '';
                }

				break;

			case 'sale_end_date':		// new items feed
			case 'sale-end-date':		// update feed

				$date = get_post_meta( $post_id, '_sale_price_dates_to', true );
				if ( $date ) $value = date( 'Y-m-d', $date );

                $has_sale_price = self::hasActiveSalePrice( $product_sku );

                if ( ! $value && $has_sale_price ) {
                    // check for profile shortcodes/values before using filler dates
                    if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) {
                        $value = $profile_fields[$column];
                    }
                }

				// if sale price exists but no end date, fill in 2029-12-31
				if ( ! $value && $has_sale_price ) $value = '2029-12-31';

				// fall back to default past date if standard price is set
				$standard_price = self::getStandardPriceForRow( $product_sku );
				if ( ! $value && $standard_price ) $value = '2000-01-02';  // default past date

				// if sale price is intentionally left blank by [---] shortcode, leave sale date blank as well
                $sale_price = self::getSalePriceForRow( $product_sku );

                // Sometimes, sale_end_date will be processed first before sale_price so sale_price
                // will never have a value in self::getSalePriceForRow. Run self::parseProductColumn for the 'sale_price' column once
                // to get the real sale price
                // #18443
                if ( ! $sale_price ) {
                    // try to get the quantity in case it hasn't been processed yet
                    $sale_price = self::parseProductColumn( 'sale_price', $item, $product, $profile );

                    // if it is still FALSE, leave empty
                    if ( ! $sale_price ) $value = '';
                }

				break;

			case 'minimum-seller-allowed-price':
				$value = get_post_meta( $post_id, '_amazon_minimum_price', true );

				// Deduct the shipping fee from the min/max prices
				if ( $value && $shipping_fee = get_option( 'wpla_repricing_shipping', false ) ) {
                    $value  = str_replace( ',', '.', $value ); // covert to a dot decimal character - will get converted to comma later if necessary in self::convertCurrencyFormat()
				    $value -= $shipping_fee;
                }
				break;
			case 'maximum-seller-allowed-price':
				$value = get_post_meta( $post_id, '_amazon_maximum_price', true );

                // Deduct the shipping fee from the min/max prices
                if ( $value && $shipping_fee = get_option( 'wpla_repricing_shipping', false ) ) {
                    $value  = str_replace( ',', '.', $value ); // covert to a dot decimal character - will get converted to comma later if necessary in self::convertCurrencyFormat()
                    $value -= $shipping_fee;
                }
				break;

			case 'quantity':
            // case 'number_of_items': // added for #30269 // disabled again - number_of_items is very different from quantity
				if ( ! $fba_enabled ) {
				    $parent_id = WPLA_ProductWrapper::getVariationParent( $post_id );
					if ( ($product_type == 'variation' || $product_type == 'product-part-variation' ) && empty( $parent_id ) ) {
						wpla_show_message('<b>Warning: The parent product for variation #'.$post_id.' (SKU '.$item['sku'].') does not exist!</b><br>Please remove that item from WP-Lister and check the integrity of your WooCommerce database.','warn');
						$value = '';
					} else {
					    $value = '';
					    if ( $product_type != 'variable' && $product_type != 'variable-product-part' ) {
					        $value = intval( WPLA_ProductWrapper::getStock( $product ) );
                        }
					}

					WPLA()->logger->info( 'Current quantity: '. $value );

					// regard WooCommerce's Out Of Stock Threshold option - if enabled
					if ( $out_of_stock_threshold = get_option( 'woocommerce_notify_no_stock_amount' ) ) {
						if ( $value && 1 == get_option( 'wpla_enable_out_of_stock_threshold' ) ) {
							$value = intval($value) - intval($out_of_stock_threshold);
						}
					}

					WPLA()->logger->info( 'Value after OOS threshold: '. $value );

					if ( $value < 0 ) $value = 0; // amazon doesn't allow negative values

					// allow custom profile value to overwrite WooCommerce quantity
					if ( isset( $profile_fields[$column] ) && ( !empty( $profile_fields[$column] ) || $profile_fields[$column] == 0 ) ) {
					    $value = $profile_fields[$column];
					    WPLA()->logger->info( 'Value from profile: '. $value );
                    }

                    // If the Hide on Amazon checkbox is checked, simply send a stock quantity of 0 to make this unsellable #38320
                    if ( get_post_meta( $post_id, '_amazon_is_disabled', true ) ) {
                        WPLA()->logger->info( 'Product #'. $post_id .' is hidden/disabled. Setting the stock quantity to 0' );
                        $value = 0;
                    }
				}
				break;

            case 'leadtime-to-ship': // For Price & Quantity feed
                if ( $handling_time = get_post_meta( $post_id, '_amazon_handling_time', true ) ) {
                    $value = intval( $handling_time );
                }

                // Also check for handling-time from the profile
                if ( empty( $value ) ) {
                    $value = !empty( $profile_fields['handling-time'] ) ? $profile_fields['handling-time'] : '';
                }

            	// if empty, check if there is a value set for fulfillment_latency in the profile
				if ( empty($value) ) {
                    // $value = self::parseProductColumn( 'fulfillment_latency', $item, $product, $profile );
					$value = isset($profile_fields['fulfillment_latency']) ? $profile_fields['fulfillment_latency'] : '';
				}
            	// then continue processing exactly like fulfillment_latency
            case 'fulfillment_latency':
                // ignore if FBA listing #29337
                if ( ! $fba_enabled ) {
                    // if qty is empty, make sure fulfillment_latency is empty as well (prevent error 99006)
                    // similarly, unset leadtime-to-ship as well if qty is empty #19125
                    $quantity = WPLA()->memcache->getColumnValue( $product_sku, 'quantity' );

                    // Sometimes, fulfillment_latency will be processed first before quantity so quantity
                    // will never have a value. Run self::parseProductColumn for the 'quantity' column once
                    // to get the real quantity
                    // #11781
                    if ( $quantity === false ) {
                        // try to get the quantity in case it hasn't been processed yet
                        $quantity = self::parseProductColumn( 'quantity', $item, $product, $profile );

                        // if it is still FALSE, leave empty
                        if ( $quantity === false || $quantity === '' ) $value = '[---]';
                    } elseif ( $quantity === '' ) {
                        $value = '[---]';
                    } else {
                        if ( $handling_time = get_post_meta( $post_id, '_amazon_handling_time', true ) ) {
                            $value = intval( $handling_time );
                        }
                    }
                }
				break;

			case 'bullet_point1':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_bullet_point1', true ), $profile->account_id ) ); break;
			case 'bullet_point2':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_bullet_point2', true ), $profile->account_id ) ); break;
			case 'bullet_point3':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_bullet_point3', true ), $profile->account_id ) ); break;
			case 'bullet_point4':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_bullet_point4', true ), $profile->account_id ) ); break;
			case 'bullet_point5':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_bullet_point5', true ), $profile->account_id ) ); break;

			case 'generic_keywords1':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_generic_keywords1', true ), $profile->account_id ) ); break;
			case 'generic_keywords2':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_generic_keywords2', true ), $profile->account_id ) ); break;
			case 'generic_keywords3':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_generic_keywords3', true ), $profile->account_id ) ); break;
			case 'generic_keywords4':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_generic_keywords4', true ), $profile->account_id ) ); break;
			case 'generic_keywords5':
				$value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_generic_keywords5', true ), $profile->account_id ) ); break;

            case 'generic_keywords': // Single search keywords field
                $value = self::htmlEntityDecode( self::doTranslate( get_post_meta( $product_id, '_amazon_search_term', true ), $profile->account_id ) ); break;

			// case 'standard_price':
			// 	$value = $product->get_price();
			// 	break;

			// case 'sale_price':
			// 	$value = $product->get_sale_price();
			// 	break;

			case 'main_image_url':
			case 'main_offer_image': // BookLoader template
			case 'main-offer-image': // ListingLoader template

                // if gallery mode is set to ignore images, skip this process
                if ( get_option( 'wpla_product_gallery_fallback', 'none' ) == 'ignore' ) {
			        $value = '';
			        break;
                }

                // if offer images are disabled, skip this column
                if ( strstr($column,'offer-image') && get_option( 'wpla_enable_product_offer_images', 0 ) == 0 ) {
                    break;
                }

                // check if custom post meta field 'amazon_image_url' exists
                if ( get_post_meta( $post_id, 'amazon_image_url', true ) ) {
                    return self::convertImageUrl( get_post_meta( $post_id, 'amazon_image_url', true ) );
                }

				// $value      = $product->get_image('full');
                $attachment_id = get_post_thumbnail_id( $post_id );
                $image_url     = wp_get_attachment_image_src( $attachment_id, 'full' );
                $value         = is_array( $image_url ) ? $image_url[0] : '';

                WPLA()->logger->info( 'wpla_variation_main_image_fallback: '. get_option('wpla_variation_main_image_fallback','parent') );
                if ( empty($value) && ( $product_type == 'variation' || $product_type == 'product-part-variation' ) && get_option('wpla_variation_main_image_fallback','parent') == 'parent' ) {
                    $attachment_id = get_post_thumbnail_id( $product_id );
                    $image_url     = wp_get_attachment_image_src( $attachment_id, 'full' );
                    $value         = @$image_url[0];
                    WPLA()->logger->info( 'found '. $value .' for '. $product_id );
                }

                // if main image is disabled, use first enabled gallery image
                $disabled_images = array_filter( explode( ',', get_post_meta( $product_id, '_wpla_disabled_gallery_images', true ) ) );

                if ( ! $value || in_array( $attachment_id, $disabled_images ) ) {
                    // $gallery_images = $product->get_gallery_attachment_ids();
                    $gallery_images = WPLA_ProductWrapper::getGalleryAttachmentIDs( $product );
                    $gallery_images = array_values( array_diff( $gallery_images, $disabled_images ) );
                    $gallery_images = apply_filters( 'wpla_product_gallery_attachment_ids', $gallery_images, $post_id );
                    if ( isset( $gallery_images[0] ) ) {
                        $image_url = wp_get_attachment_image_src( $gallery_images[0], 'full' );
                        $value = @$image_url[0];
                    }
                }

                // custom amazon image
				// 10/24/23 - Do not use overwrite the variation image even if a custom gallery is found #63403
				if ( empty( $value ) && $product_type != 'variation' ) {
					$custom_images = get_post_meta( $product_id, '_amazon_image_gallery', true );
					if ( !empty( $custom_images ) ) {
						$custom_images = array_filter( array_map( 'trim', explode( ',', $custom_images ) ) );
						$image_url = wp_get_attachment_image_src( $custom_images[ 0 ], 'full' );
						$value = @$image_url[0];
					}
				}

                // custom product level column overwrites WooCommerce image
                if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) $value = $profile_fields[$column];

                // maybe fall back to parent variation featured image (disable to avoid the same swatch image for all child variations - ticket #6662)
                WPLA()->logger->info( 'variation_main_image for '. $item['sku'] );
                WPLA()->logger->info( 'product type: '. $product_type );
                WPLA()->logger->info( 'current value: '. $value );

                WPLA()->logger->info( 'new value: '. $value );

	            $value = apply_filters( 'wpla_product_main_image_url', $value, $post_id );
				$value = self::convertImageUrl( $value );
				break;

			case 'other_image_url1':
			case 'other_image_url2':
			case 'other_image_url3':
			case 'other_image_url4':
			case 'other_image_url5':
			case 'other_image_url6':
			case 'other_image_url7':
			case 'other_image_url8':
			case 'offer_image1': // BookLoader template
			case 'offer_image2':
			case 'offer_image3':
			case 'offer_image4':
			case 'offer_image5':
			case 'offer-image1': // ListingLoader template
			case 'offer-image2':
			case 'offer-image3':
			case 'offer-image4':
			case 'offer-image5':
            case 'pt1_image_url': // handmade template
            case 'pt2_image_url':
            case 'pt3_image_url':
            case 'pt4_image_url':
            case 'pt5_image_url':
            case 'pt6_image_url':
            case 'pt7_image_url':
            case 'pt8_image_url':

                // if gallery mode is set to ignore images, skip this process
                if ( get_option( 'wpla_product_gallery_fallback', 'none' ) == 'ignore' ) {
                    WPLA()->logger->info( 'product_gallery_fallback is set to ignore. Setting value to ""' );
                    $value = '';
                    break;
                }

                // if offer images are disabled, skip this column
                if ( strstr($column,'offer-image') && get_option( 'wpla_enable_product_offer_images', 0 ) == 0 ) {
                    WPLA()->logger->info( 'product_offer_images disabled. Skipping' );
                    break;
                }

                if ( strpos( $column, 'pt') === 0 ) {
                    $image_index = substr($column, 2, 1);
                } else {
                    $image_index = substr($column, -1);        // skip first image
                }
                WPLA()->logger->info( 'image_index: '. $image_index );

                if ( 'skip' != get_option( 'wpla_product_gallery_first_image' )) {
                    $image_index -= 1;	// include first image
                    WPLA()->logger->info( 'Skipping first image. New index: '. $image_index);
                }

				// build list of enabled gallery images (attachment_ids)
				$disabled_images = explode( ',', get_post_meta( $product_id, '_wpla_disabled_gallery_images', true ) );
	            // $gallery_images = $product->get_gallery_attachment_ids();
	            $gallery_images = WPLA_ProductWrapper::getGalleryAttachmentIDs( $product );
	            $gallery_images = array_values( array_diff( $gallery_images, $disabled_images ) );
	            $gallery_images = apply_filters( 'wpla_product_gallery_attachment_ids', $gallery_images, $post_id );


	            if ( isset( $gallery_images[ $image_index ] ) ) {
					$image_url = wp_get_attachment_image_src( $gallery_images[ $image_index ], 'full' );
					$value = @$image_url[0];
					$value = self::convertImageUrl( $value );
	            } else {
	                WPLA()->logger->info( 'gallery_images['. $image_index .'] does not exist.' );
                }

                // custom amazon image
				// 10/24/23 - Do not use overwrite the variation image even if a custom gallery is found #63403
				if ( empty( $value ) && $product_type != 'variation' ) {
					$custom_images = get_post_meta( $product_id, '_amazon_image_gallery', true );
					if ( ! empty( $custom_images ) ) {
						// if using custom images, always skip the first image because it is already being used as
						// the listing's primary image
						$image_index = substr( $column, - 1 );

						$custom_images = array_filter( array_map( 'trim', explode( ',', $custom_images ) ) );

						if ( ! empty( $custom_images[ $image_index ] ) ) {
							$image_url = wp_get_attachment_image_src( $custom_images[ $image_index ], 'full' );
							$value     = @$image_url[0];
						}
					}
				}

				// custom product level column overwrites WooCommerce image
				if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) $value = $profile_fields[$column];
				break;


			/* Inventory Loader (delete) feed columns */
			case 'add-delete':
				$value = $item['status'] == 'trash' ? 'x' : 'a';
				break;

			/* Listing Loader feed columns */
			case 'product-id':
				$value = get_post_meta( $post_id, '_wpla_asin', true );
				break;
			case 'product-id-type':
				if ( $matched_asin = get_post_meta( $post_id, '_wpla_asin', true ) ) {
					$value = 'ASIN';
				} elseif ( $custom_id_type = get_post_meta( $post_id, '_amazon_id_type', true ) ) {
					$value = $custom_id_type;
				} else {
					$value = '';
				}
				break;
            case 'item-condition':
			case 'condition-type': // update feed (ListingLoader - no profile)
				$value = get_post_meta( $post_id, '_amazon_condition_type', true );

                // fallback to parent's condition type
                if ( ! $value ) {
                    $value = get_post_meta( $product_id, '_amazon_condition_type', true );
                }

				// if this item was imported but has no product level condition, use original report value
				if ( ! $value && $item['source'] == 'imported' ) {
					$report_row = json_decode( $item['details'], true );
					if ( is_array($report_row) && isset( $report_row['item-condition'] ) ) {
						$value = WPLA_ImportHelper::convertNumericConditionIdToType( $report_row['item-condition'] );
					}
				}

				if ( ! $value && ! isset( $profile_fields[$column] ) ) {
					$value = 'New';	// avoid an empty value for Offer feeds without profile
				}
				break;
			case 'condition_type': // new items feed
				$value = get_post_meta( $post_id, '_amazon_condition_type', true );

			    // fallback to parent's condition type
			    if ( ! $value ) {
                    $value = get_post_meta( $product_id, '_amazon_condition_type', true );
                }
				// if ( ! $value ) $value = 'New';
				break;
			case 'condition-note':
			case 'condition_note': // new items feed
				$value = get_post_meta( $post_id, '_amazon_condition_note', true );

			    // fallback to parent's condition note
                if ( ! $value ) {
                    $value = get_post_meta( $product_id, '_amazon_condition_note', true );
                }

                //$value = self::doTranslate( $value, $profile->account_id );
                // decode charset to prevent getting invalid characters #51609
                $value = self::htmlEntityDecode( self::doTranslate( $value, $profile->account_id ) );
				break;

			/* FBA */
			case 'fulfillment-center-id': // ListingLoader
			case 'fulfillment_center_id': // Category Feed
				if ( $fba_enabled ) {
					$value = $item['fba_fcid'];
					// with neither FBA only nor FBA overwrite enabled, we need to allow leaving fcid empty so seller fallback can work:
					if ( ! $value && ( $fba_only_mode || $fba_overwrite ) ) {
						$value = get_option( 'wpla_fba_fulfillment_center_id' );
					}

					// But check again for an explicit override because the code above will always return the default FCID
                    // in cases where $value is empty and the override is set to FBM #29337
                    if ( $fba_overwrite == 'FBM' ) {
					    $value = '';
                    }
				}
				break;

			/* variation columns */
			case 'parent-sku':
			case 'parent_sku':
				if ( $item['parent_id'] ) {
					$parent_product = WPLA_ProductWrapper::getProduct( $item['parent_id'] );
					if ( $parent_product )
						$value = wpla_get_product_meta( $parent_product, 'sku' );
				}
				if ( $variations_mode == 'flat' ) $value = '';
				break;
			case 'parentage':
			case 'parent_child':
				if ( $product_type == 'variable' || $product_type == 'variable-product-part' ) {
					$value = 'parent';
				} elseif ( $product_type == 'variation' || $product_type == 'product-part-variation' ) {
					$value = 'child';
				}
				if ( $variations_mode == 'flat' ) $value = '';
				break;
			case 'relationship-type':
			case 'relationship_type':
				if ( $product_type == 'variation' || $product_type == 'product-part-variation' )
					$value = 'Variation';
				if ( $variations_mode == 'flat' ) $value = '';
				break;
			case 'variation-theme':
			case 'variation_theme':
				$value = $item['vtheme'];

				// handle empty vtheme for legacy items
				if ( empty( $value ) && in_array( $product_type, array( 'variation', 'variable', 'variable-product-part', 'product-part-variation' ) ) ) {
					$parent_id = $item['parent_id'] ? $item['parent_id'] : $item['post_id'];
					$value     = WPLA_ListingsModel::getVariationThemeForPostID( $parent_id );
				}

				if ( $value ) {
                    $value = str_replace('-', '', $value);


                    $value = self::convertToEnglishAttributeLabel($value);
                    if (strtolower($value) == 'colour') $value = 'Color';
                    if (strtolower($value) == 'colorsize') $value = 'SizeColor';
                    if (strtolower($value) == 'coloursize') $value = 'SizeColor';
                    if (strtolower($value) == 'materialcolor') $value = 'Color-Material';
                    if ($variations_mode == 'flat') $value = '';
                }
				
				if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) $value = $profile_fields[$column];

				// Set to empty on simple products #19914
                if ( $product->is_type( 'simple' ) ) {
                    $value = '[---]';
                }
				break;
			case 'color-map':
			case 'color_map':
				if ( $product_type == 'variation' || $product_type == 'product-part-variation' ) {
					$color_name = WPLA()->memcache->getColumnValue( $product_sku, 'color_name' );

                    if ( ! $color_name ) {
                        // try to get the color_name in case it hasn't been processed yet
                        $color_name = self::parseProductColumn( 'color_name', $item, $product, $profile );
                    }

					$color_name = strtolower( $color_name );
					$variation_color_map = get_option( 'wpla_variation_color_map', array() );
					if ( $color_name && array_key_exists( $color_name, $variation_color_map ) ) {
						$value = $variation_color_map[ $color_name ];
					}
				}
				break;

            case 'size-map':
			case 'size_map':
            if ( $product_type == 'variation' || $product_type == 'product-part-variation' ) {
                $size_name = WPLA()->memcache->getColumnValue( $product_sku, 'size_name' );

                if ( ! $size_name ) {
                    // try to get the color_name in case it hasn't been processed yet
                    $size_name = self::parseProductColumn( 'size_name', $item, $product, $profile );
                }

                $size_name = strtolower( $size_name );
                $variation_size_map = get_option( 'wpla_variation_size_map', array() );

                if ( !empty( $variation_size_map ) ) {
                    $excluded_markets = get_option( 'wpla_sizemap_excluded_markets', array() );
                    $item_market = WPLA()->accounts[ $item['account_id'] ]->market_code;

                    if ( in_array( $item_market, $excluded_markets ) ) {
                        WPLA()->logger->info( 'Item is in the excluded markets sizemap array. Skipping mapping.' );
                    } else {
                        WPLA()->logger->info( 'Mapping size_name: '. $size_name );
                        if ( $size_name ) {
                            $lowered_size_name = strtolower( $size_name );
                            WPLA()->logger->info( 'Lowered size_name'. $lowered_size_name );
                            WPLA()->logger->info( 'Size Map'. print_r( $variation_size_map,1 ) );
                            if ( array_key_exists( $lowered_size_name, $variation_size_map ) ) {
                                $value = $variation_size_map[ $lowered_size_name ];
                                WPLA()->logger->info( 'Found value: '. $value );
                            }
                        }
                    }
                }

            }
            break;

            /*case 'shirt-size':
            case 'shirt_size':
            case 'apparel_size':
            case 'apparel-size':
            case 'footwear_size':
            case 'footwear-size':
            case 'shapewear_size':
            case 'shapewear-size':
				if ( $product_type == 'variation' ) {
					$size_name = WPLA()->memcache->getColumnValue( $product_sku, 'size_name' );

                    if ( ! $size_name ) {
                        // try to get the size_name in case it hasn't been processed yet
                        $size_name = self::parseProductColumn( 'size_name', $item, $product, $profile );
                    }

                    $value      = $size_name; // Store the value before transforming the size_name to lowercase #48738
                    $size_name  = strtolower( $size_name );

                    $custom_size_map = get_option( 'wpla_custom_size_map', array() );

                    if ( !empty( $custom_size_map[ $column ] ) ) {

					    $excluded_markets = get_option( 'wpla_sizemap_excluded_markets', array() );
					    $item_market = WPLA()->accounts[ $item['account_id'] ]->market_code;

					    if ( in_array( $item_market, $excluded_markets ) ) {
					        WPLA()->logger->info( 'Item is in the excluded markets sizemap array. Skipping mapping.' );
                        } else {
                            if ( $size_name && array_key_exists( $size_name, $custom_size_map[ $column ] ) ) {
                                $value = $custom_size_map[ $column ][ $size_name ];
                            }
                        }
                    }

				}
				break;*/

			/* new LiLo/FBA required columns 2018 */
			case 'batteries_required':
				if ( ! $value && $fba_enabled ) {
					$value = 'FALSE';	// set default value to false for FBA enabled items
				}
                // custom product level column overwrites default value
                if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) $value = $profile_fields[$column];
				break;
			case 'supplier_declared_dg_hz_regulation1':
			case 'supplier_declared_dg_hz_regulation2':
			case 'supplier_declared_dg_hz_regulation3':
			case 'supplier_declared_dg_hz_regulation4':
			case 'supplier_declared_dg_hz_regulation5':
				if ( ! $value && $fba_enabled ) {
					$value = 'not_applicable';	// set default value to 'not_applicable' for FBA enabled items
				}
                // custom product level column overwrites default value
                if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) $value = $profile_fields[$column];
				break;

            case 'restock_date':
                WPLA()->logger->info( 'getting restock_date for '. $post_id );
                $value = get_post_meta( $post_id, '_amazon_restock_date', true );
                WPLA()->logger->info( 'found '. $value );

                // fallback to parent's restock date
                if ( ! $value ) {
                    $value = get_post_meta( $product_id, '_amazon_restock_date', true );
                }

                // format the date to YYYY-MM-DD
                if ( $value ) {
                    $value = date( 'Y-m-d', strtotime( $value ) );
                }

                break;

			default:
				# code...
				break;
		}

		WPLA()->logger->debug( 'value after switch statement: '. $value );

		// handle variation attribute values / attribute columns
		if ( in_array( $product_type, array('variation','variable', 'variable-product-part', 'product-part-variation') ) ) {
			// if ( ( strpos( $column, '_name') > 0 ) || ( strpos( $column, '_type') > 0 ) ) {
			if ( substr( $column, -5 ) == '_name' || substr( $column, -5 ) == '_type' ) {
				wpla_logger_start_timer('parseVariationAttributeColumn');
				$value = self::parseVariationAttributeColumn( $value, $column, $item, $product, $profile );
				wpla_logger_end_timer('parseVariationAttributeColumn');
			}
		}

        WPLA()->logger->debug( 'value after parseVariationAttributeColumn: '. $value );

		// forced empty value (fulfillment_latency)
		// (why is '[---]' == 0 true? should be false - be careful...)
		if ( '[---]' === $value )
			return '';

		// process profile fields - if not empty
        // add an exception for the leadtime-to-ship column because it uses the value of the fulfillment-latency profile field #28997
		if ( $column != 'leadtime-to-ship' && (! isset( $profile_fields[$column] ) || empty( $profile_fields[$column] ) ) ) {
            WPLA()->logger->debug( 'empty profile field. returning.');
            return $value;
        }

        //WPLA()->logger->debug( 'profile field value: '. $profile_fields[$column] );


		// empty shortcode overrides default value
		if ( isset( $profile_fields[ $column ] ) && '[---]' === $profile_fields[$column] )
			return '';

		// use profile value as it is - if $value is still empty (ie. there is no product level value for this column)
		if ( empty($value) && $value !== 0 )
			$value = isset( $profile_fields[ $column ] ) ? $profile_fields[$column] : '';

		// find and parse all placeholders
		if ( preg_match_all( '/\[([^\]]+)\]/', $value, $matches ) ) {
			foreach ($matches[0] as $placeholder) {
				// echo "<pre>processing ";print_r($placeholder);echo"</pre>";
				wpla_logger_start_timer('parseProfileShortcode');
				$value = self::parseProfileShortcode( $value, $placeholder, $item, $product, $post_id, $profile );
				wpla_logger_end_timer('parseProfileShortcode');
				// echo "<pre>";print_r($value);echo"</pre>";#die();
			}
		}
        WPLA()->logger->debug( 'value after parseProfileShortcode: '. $value );

        /**
         * Handle size columns and their size map conversions
         */
        if ( $value ) {
            $custom_size_map = get_option( 'wpla_custom_size_map', array() );
            WPLA()->logger->info( 'Handling size columns: '. $column );
            //if ( isset( $profile_fields[$column] ) && ! empty( $profile_fields[$column] ) ) $value = $profile_fields[$column];
            WPLA()->logger->info( 'Current value: '. $value );

            if ( !empty( $custom_size_map[ $column ] ) ) {
                WPLA()->logger->info( 'Found size map for column' );

                $excluded_markets = get_option( 'wpla_sizemap_excluded_markets', array() );
                $item_market = WPLA()->accounts[ $item['account_id'] ]->market_code;

                if ( in_array( $item_market, $excluded_markets ) ) {
                    WPLA()->logger->info( 'Item is in the excluded markets sizemap array. Skipping mapping.' );
                } else {
                    if ( $value && array_key_exists( $value, $custom_size_map[ $column ] ) ) {
                        $value = $custom_size_map[ $column ][ $value ];
                        WPLA()->logger->info( 'Found replacement for value. New value: '. $value );

                        /**
                         * Got a report from #50550 that this is causing feeds to fail
                         * Same is true for #50656 - strtolower() causes an error
                         * @todo Watch out for similar reports
                         */
                        // all size values need to be lowercase #49324
                        //$value = strtolower( $value );
                    }
                }
            }
        }

		// parent variations should only have certain columns
		// these three seem to work on Amazon CA / Automotive: item_sku, parent_child, variation_theme
		// but on US and DE, more columns are required:
		// $parent_var_columns = array('item_sku','parent_child','variation_theme'); // CA
		$parent_var_columns = apply_filters( 'wpla_allowed_parent_var_columns', array(
			'item_sku',
			'parent_child',
			'variation_theme',
			'brand_name',
			'item_name',
			'department_name', // Removed in #34637 -- Added again in #34834
			'department_name1',
			'department_name2',
			'department_name3',
			'department_name4',
			'department_name5',
			'product_description',
			'item_type',
			//'feed_product_type', # Removed in #51833
			'bullet_point1',		// bullet points should be set for parent variations (confirmed by amazon)
			'bullet_point2',
			'bullet_point3',
			'bullet_point4',
			'bullet_point5',
			'special_features1',
			'special_features2',
			'special_features3',
			'special_features4',
			'special_features5',
			'main_image_url',
			'manufacturer',
			'mfg_minimum', // #33998
			'mfg_minimum_unit_of_measure', // #33998
			'style_name',
			'closure_type',
			'lifestyle',
			'material_type',
			'material_type1',
			'pattern_type',
			'model_year',
			'shoe_dimension_unit_of_measure',
			'target_audience_keyword',
			'target_audience_keywords1',
			'target_audience_keywords2',
			'target_audience_keywords3',
            'binding',
            //'condition_type', // removed as noted by AMZ in #34078
            'publication_date',
            'author',
            'part_number',
            'ingredients',			// as requested in #27654
            'ingredients1',
            'ingredients2',
            'ingredients3',
            //'batteries_required', // as requested in #28584 and removed in #34637
            //'supplier_declared_dg_hz_regulation1', // from #30269 and removed in #34637
            //'supplier_declared_dg_hz_regulation2',
            //'supplier_declared_dg_hz_regulation3',
            //'supplier_declared_dg_hz_regulation4',
            //'supplier_declared_dg_hz_regulation5',
            'update_delete', // added as instructed by AMZ in #34078
            'alcohol_content', // added for #34632
            'alcohol_content_unit_of_measure',
            'unit_count',
            'unit_count_type', // added unit_count and unit_count_type #37866
            //'external_product_id', # Removed in #51833
            //'external_product_id_type', # Removed in #51833 (added for #37997)
            'display_type', // added for 40982
            'watch_movement_type', // added for 40982
            'target_gender', // added for 41962
            //'size_name', # Removed in #51833 (added for 41418)
            //'size_map', # Removed in #51833 (added for 41418)
            'gem_type', // added for 42127
            'outer_material_type', // added for 43975
            'recommended_browse_nodes',
            'material_composition', // added for 47870
            //'color_map', # Removed in #51833 (added for 47870)
            'lifestyle1', // added for 47870
            'feed_product_type', // added for 51943
            'country_of_origin', // added for 52180
            'age_range_description', // added for 52839
            'fabric_type', // added for 52839
            //'shirt_size_class', // added for 52839
            //'shirt_size_system', // added for 52839
            //'shirt_size', // added for 52839
		), $column, $item, $profile );
		if ( ($product_type == 'variable' || $product_type == 'variable-product-part') && ! in_array( $column, $parent_var_columns ) ) {
			$value = '';
		}

		wpla_logger_end_timer('parseProductColumn');
		return $value;
	} // parseProductColumn()


	static public function parseVariationAttributeColumn( $value, $column, $item, $product, $profile ) {
        $profile_fields  = $profile ? maybe_unserialize( $profile->fields )  : array();

		// skip if this is not an actual attribute column (like size_name or color_name)
		if ( in_array( $column, array( 'item_name', 'external_product_id_type', 'feed_product_type', 'brand_name' ) ) ) return $value;

		// Skip overriding the variation attribute if there's a profile value for it #55702
		if ( !empty( $profile_fields[ $column ] ) && apply_filters( 'wpla_override_variation_attribute_with_profile', false, $item, $column, $value, $profile ) ) {
		    return $value;
        }

		// adjust some incompatible vtheme values
		$vtheme = $item['vtheme'];
		$vtheme = str_replace( 'Name', '', $vtheme ); 							// ColorName -> Color
		$vtheme = strtolower($vtheme) == 'sizecolor' ? 'Size-Color' : $vtheme; 	// sizecolor -> Size-Color
		$vtheme = strtolower($vtheme) == 'colorsize' ? 'Color-Size' : $vtheme; 	// colorsize -> Color-Size

		$vtheme_array   = explode( '-', $vtheme );
		$col_slug       = str_replace('_name', '', $column);
		$col_slug       = str_replace('_type', '', $col_slug);
		$attribute_name = false;

		// filter attributes used in variation-theme - maybe this should be moved to parseProductColumn() above...
		foreach ($vtheme_array as $vtheme_attribute) {
			$vtheme_attribute = self::convertToEnglishAttributeLabel( $vtheme_attribute );
			if ( $col_slug == strtolower($vtheme_attribute) )
				$attribute_name = $vtheme_attribute;
		}
		if ( ! $attribute_name ) return $value;

		// parent product should have empty attributes
        if ( $product->get_type() == 'variable' || $product->get_type() == 'variable-product-part' ) return '';

		// find variation
		// $variations = WPLA_ProductWrapper::getVariations( $product->id );
        $parent_id = WPLA_ProductWrapper::getVariationParent( wpla_get_product_meta( $product, 'id' ) );
        $variations = WPLA()->memcache->getProductVariations( $parent_id );

		foreach ($variations as $var) {
			if ( $var['sku'] == $item['sku'] ) {
				// find attribute value
				foreach ( $var['variation_attributes'] as $attribute_label => $attribute_value ) {
					$translated_label = self::convertToEnglishAttributeLabel( $attribute_label );
					if ( $translated_label == $attribute_name ) {
						// $value = utf8_decode( $attribute_value ); // Amazon is supposed to use UTF, but de facto accepts only ISO-8859-1/15
						$value = $attribute_value;
					}
				}
				// // find attribute value - doesn't work for non-english attributes
				// if ( isset( $var['variation_attributes'][$attribute_name] ) ) {
				// 	$value = $var['variation_attributes'][$attribute_name];
				// }
			}
		}

		return $value;
	} // parseVariationAttributeColumn()

    static public function doTranslate( $value, $account_id = null ) {
        // qTranslate support
        if ( is_null( $account_id ) ) {
            return $value;
        }

        if ( function_exists( 'qtranxf_use' ) ) {
            if ( !isset( self::$locale[ $account_id ] ) ) {
                $lang = WPLA_AmazonAccount::getAccountLocale( $account_id );
                self::$locale[ $account_id ] = $lang;
            }
            $lang  = self::$locale[ $account_id ];

            $value = qtranxf_use( $lang, $value );
        }

        return $value;
    }


	static public function convertToEnglishAttributeLabel( $value ) {

		// process variation attributes map
		$variation_attribute_map = get_option( 'wpla_variation_attribute_map', array() );
		if ( is_array($variation_attribute_map) ) {
			foreach ( $variation_attribute_map as $woocom_attribute => $amazon_attribute ) {
				$value = str_replace( $woocom_attribute, $amazon_attribute, $value );
			}
		}

		if ( !is_null( $value ) ) {
            // translate common attributes
            $value = str_replace('Farbe',  		'Color', $value ); // amazon.de
            $value = str_replace('Größe',  		'Size',  $value );
            $value = str_replace('Grösse', 		'Size',  $value );
            $value = str_replace('Colore', 		'Color', $value ); // amazon.it
            $value = str_replace('Dimensione', 	'Size',  $value );
            $value = str_replace('Misura', 		'Size',  $value );
        }

		return $value;
	} // convertToEnglishAttributeLabel()


	static public function parseProfileShortcode( $original_value, $placeholder, $item, $product, $post_id, $profile ) {
	    // set correct post_id for variations
        $product_id = $post_id;
        $product_type = wpla_get_product_meta( $product, 'product_type' );
        if ( $product_type == 'variation' || $product_type == 'product-part-variation' ) {
            if ( version_compare( WC_VERSION, '3.0', '<' ) ) {
                $post_id = $product->variation_id;
                $product_id = $product->id;
            } else {
                // set the $product_id to the parent's ID
                $product_id = WPLA_ProductWrapper::getVariationParent( $post_id );
            }
        }

		switch ( $placeholder ) {
			case '[product_sku]':
				$value = wpla_get_product_meta( $post_id, 'sku' );
				break;

			case '[amazon_product_id]':
				$value = get_post_meta( $post_id, '_amazon_product_id', true );
				break;

			case '[product_title]':
				$value = $product->get_title();
				if ( $product_value = get_post_meta( $product_id, '_amazon_title', true ) ) {
					$value = str_replace( '%%%', '', $product_value );
				}
				if ( $product_type == 'variation' || $product_type == 'product-part-variation' ) {
					$value = $item['listing_title'];
					if ( 'parent' == get_option('wpla_variation_title_mode') ) {
						$value = $product->get_title();

                        if ( $product_value ) {
                            $value = str_replace( '%%%', '', $product_value );
                        }
					}
				}

				$value = self::doTranslate( self::htmlEntityDecode( strip_tags( $value ) ), $profile->account_id ); // fix some special characters
				break;

			case '[product_price]':
				// $value = $product->get_price();			// WC2.1+
				$value = wpla_get_product_meta( $product, 'regular_price' );			// WC2.0
				$value = $profile ? $profile->processProfilePrice( $value ) : $value;
				$value = apply_filters( 'wpla_filter_product_price', $value, $post_id, $product, $item, $profile );

                $value  = str_replace( ',', '.', $value ); // covert to a dot decimal character - will get converted to comma later if necessary in self::convertCurrencyFormat()

                // Repricing shipping fee for _amazon_price
                $shipping_fee = get_option( 'wpla_repricing_shipping', 0 );

                if ( ( $post_id != wpla_get_product_meta( $product, 'id' ) ) && ( $product_value = get_post_meta( wpla_get_product_meta( $product, 'id' ), '_amazon_price', true ) ) ) {	// parent price
                    if ( !empty( $product_value ) ) {
                        $value = $product_value;
                    }
                }
                if ( $product_value = get_post_meta( $post_id, '_amazon_price', true ) ) {											// variation price
                    if ( !empty( $product_value ) ) {
                        $value = $product_value;
                    }
                }

                if ( !empty( $shipping_fee ) ) {
                    // make sure both values are floats #51107
                    $value = floatval( $value ) - floatval( $shipping_fee );
                    //$value -= $shipping_fee;
                }
                
                // make sure $value is a float type #52209
                $value = $value ? number_format( floatval($value),2, null, '' ) : $value;

				// make sure price stays within min/max boundaries - prevent errors in PNQ feed
				if ( $item['min_price'] > 0 ) $value = max( $value, $item['min_price'] );
				if ( $item['max_price'] > 0 ) $value = min( $value, $item['max_price'] );

                // send empty price if external_repricer flag is set
           		$x_repricer = get_post_meta( $product_id, '_amazon_external_repricer', true );
                $y_repricer = get_option( 'wpla_external_repricer_mode', false );
           		if ( $x_repricer == '1' || $y_repricer == '1' ) $value = '';

				break;

			case '[product_sale_price]':
				// $value = $product->get_sale_price();		// WC2.1+
				$value = wpla_get_product_meta( $product, 'sale_price' );				// WC2.0
				$value = $profile ? $profile->processProfilePrice( $value ) : $value;
				$value = apply_filters( 'wpla_filter_sale_price', $value, $post_id, $product, $item, $profile );
				$value = $value ? number_format( floatval($value),2, null, '' ) : $value;

				// make sure sale_price is not higher than standard_price / price - Amazon might silently ignore price updates otherwise
				$standard_price = self::getStandardPriceForRow( wpla_get_product_meta( $product, 'sku' ) );
				if ( $standard_price && ( $value > $standard_price ) ) $value = '';

				// if no sale price is set, send regular price with sale end date in the past to remove previously sent sale prices
				if ( empty($value) ) $value = $standard_price;

				// make sure price stays within min/max boundaries - prevent Amazon from throwing price alert / validation error (would make listing inactive)
				if ( $item['min_price'] > 0 ) $value = max( $value, $item['min_price'] );
				if ( $item['max_price'] > 0 ) $value = min( $value, $item['max_price'] );

                // send empty price if external_repricer flag is set
                $x_repricer = get_post_meta( $product_id, '_amazon_external_repricer', true );
                $y_repricer = get_option( 'wpla_external_repricer_mode', false );
                if ( $x_repricer == '1' || $y_repricer == '1' ) $value = '';

				break;

			case '[product_sale_start]':
				$date = get_post_meta( $post_id, '_sale_price_dates_from', true );
				$value = $date ? date( 'Y-m-d', $date ) : '';

				// if sale price exists but no start date, fill in 2010-01-01
				$has_sale_price = self::hasActiveSalePrice( wpla_get_product_meta( $product, 'sku' ) );
				if ( ! $value && $has_sale_price ) $value = '2010-01-01';
				break;
			case '[product_sale_end]':
				$date = get_post_meta( $post_id, '_sale_price_dates_to', true );
				$value = $date ? date( 'Y-m-d', $date ) : '';

				// if sale price exists but no end date, fill in 2029-12-31
				$has_sale_price = self::hasActiveSalePrice( wpla_get_product_meta( $product, 'sku' ) );
				if ( ! $value && $has_sale_price ) $value = '2029-12-31';
				break;

			case '[product_msrp]':
				$value = '';
				if ( $product_value = get_post_meta( $post_id, '_msrp_price', true ) )	// simple product
					$value = floatval( $product_value );
				if ( $product_value = get_post_meta( $post_id, '_msrp', true ) )	// variation
					$value = floatval($product_value);
				$value = $value ? number_format($value,2, null, '' ) : $value;
				break;

			case '[product_content]':
				$the_post = get_post( $product_id );
				$value = $the_post->post_content;
				if ( $product_value = trim( get_post_meta( $product_id, '_amazon_product_description', true ) ) ) {
					$value = $product_value;
				}

				$value = self::doTranslate( self::convertContent( $value, 'content' ), $profile->account_id );
				break;

			case '[product_excerpt]':
				$the_post = get_post( $product_id );
				$value = $the_post->post_excerpt;

                $value = self::doTranslate( self::convertContent( $value, 'content' ), $profile->account_id );
				break;

			case '[product_weight]':
				$value = wpla_get_product_meta( $post_id, 'weight' );
				$value = $value ? number_format($value,2, null, '' ) : $value;
				break;

			case '[product_length]':
				$value = wpla_get_product_meta( $post_id, 'length' );
                $value  = str_replace( ',', '.', $value );
				break;
			case '[product_width]':
				$value = wpla_get_product_meta( $post_id, 'width' );
                $value  = str_replace( ',', '.', $value );
				break;
			case '[product_height]':
				$value = wpla_get_product_meta( $post_id, 'height' );
                $value  = str_replace( ',', '.', $value );
				break;

			case '[---]':
				$value = '';
				break;


			default:

				// check for attributes
				if ( substr( $placeholder, 0, 11 ) == '[attribute_' ) {
					wpla_logger_start_timer('processAttributeShortcodes');
					// $value = self::processAttributeShortcodes( $product->id, $placeholder );
					$value = apply_filters( 'wpla_processed_attribute_shortcode', self::processAttributeShortcodes( $product, $placeholder ), $placeholder, $product );
					wpla_logger_end_timer('processAttributeShortcodes');
					// $value = utf8_decode( $value ); 						// convert WP UTF-8 to Amazon ISO...
				// check for custom meta shortcodes
				} elseif ( substr( $placeholder, 0, 5 ) == '[meta' ) {
					wpla_logger_start_timer('processCustomMetaShortcodes');
					$value = self::processCustomMetaShortcodes( $product_id, $placeholder, $post_id );
					wpla_logger_end_timer('processCustomMetaShortcodes');
					// $value = utf8_decode( $value ); 						// convert WP UTF-8 to Amazon ISO...
				} else {

					// unregognized shortcodes will use their value
					$value = $placeholder;

					// handle custom shortcodes
					foreach (WPLA()->getShortcodes() as $key => $custom_shortcode) {
						if ( $placeholder != "[$key]") continue;

						if ( isset($custom_shortcode['callback']) && is_callable( $custom_shortcode['callback'] ) ) {

							// handle callback shortcodes registered by wpla_register_profile_shortcode()
							$value = call_user_func( $custom_shortcode['callback'], $post_id, $product, $item, $profile, $custom_shortcode );

						} elseif ( isset($custom_shortcode['content']) && $custom_shortcode['content'] ) {

							// handle custom shortcodes created in advanced settings
							$value = self::convertContent( $custom_shortcode['content'] );

						}
					}

				}
				$value = self::doTranslate( $value, $profile->account_id );
				break;
		}

		// replace placeholder with value
		$value = str_replace( $placeholder, $value, $original_value );

		return $value;
	} // parseProfileShortcode()


	// get the standard price for current row (by SKU)
	static public function getStandardPriceForRow( $product_sku ) {

		// listing data feed
		$standard_price = WPLA()->memcache->getColumnValue( $product_sku, 'standard_price' );
		if ( $standard_price ) return $standard_price;

		// ListingLoader feed
		$standard_price = WPLA()->memcache->getColumnValue( $product_sku, 'price' );
		if ( $standard_price ) return $standard_price;

		return '';
	} // getStandardPriceForSKU()

	// get the sale price for current row (by SKU)
	static public function getSalePriceForRow( $product_sku ) {

		// listing data feed
		$sale_price = WPLA()->memcache->getColumnValue( $product_sku, 'sale_price' );
		if ( $sale_price ) return $sale_price;

		// ListingLoader feed
		$sale_price = WPLA()->memcache->getColumnValue( $product_sku, 'sale-price' );
		if ( $sale_price ) return $sale_price;

		return '';
	} // getStandardPriceForSKU()


	// check if there is an active sale price (different from the standard price) for current row / SKU
	static public function hasActiveSalePrice( $product_sku ) {

		// check if there is a sale price for this row
		$sale_price = self::getSalePriceForRow( $product_sku );
		if ( ! $sale_price ) return false;

		// if there is a sale price, check if it's different from the standard price
		if ( $sale_price == self::getStandardPriceForRow( $product_sku ) ) return false;

		// yes, there is a sale price
		return true;
	} // hasActiveSalePrice()


    /**
     * @param $value
     * @return string
     * @deprecated
     */
    static public function convertTitle( $value ) {
	    return self::htmlEntityDecode( $value );
    }

    // Decode HTML entities using the ISO-8859-1 charset
    static public function htmlEntityDecode($value ) {
		// convert special / UTF-8 characters
		//$value = htmlentities( $value, ENT_QUOTES, 'UTF-8', false );
		// example: &#039; to '
        // $value = htmlentities( $value, ENT_QUOTES, 'UTF-8', false );
        //$value = htmlspecialchars_decode( $value, ENT_QUOTES );
        $value = html_entity_decode( $value, ENT_QUOTES, 'ISO-8859-1' );
        return $value;
	} // convertTitle()


    static public function convertContent( $value, $context = 'attribute' ) {

        // convert UTF-8 characters
        //$value = htmlentities( $value, ENT_QUOTES, 'UTF-8', false );
        //$value = htmlspecialchars_decode( $value, ENT_QUOTES );
        // $value = utf8_decode( $value ); 						// convert WP UTF-8 to Amazon ISO...

        //$value = self::fixEncoding( $value );

        // convert some stubborn UTF-8 characters
        //$utf8_char = chr(226) . chr(151) . chr(143); // bullet point (dec)
        $utf8_char = chr(0xE2) . chr(0x97) . chr(0x8F); // bullet point (hex)
        $html_char = '&bull;';
        $value     = str_replace($utf8_char, $html_char, $value);

        // fixed whitespace pasted from ms word
        // details: http://stackoverflow.com/questions/1431034/can-anyone-tell-me-what-this-ascii-character-is
        $whitespace = chr(194).chr(160);
        $value      = str_replace( $whitespace, ' ', $value );

        //$value = html_entity_decode( $value, ENT_QUOTES, 'ISO-8859-1' );

        // remove ALL links from post content by default
        if ( 'default' == get_option( 'wpla_remove_links', 'default' ) ) {
            $value = preg_replace('#<a.*?>(.*?)</a>#i', ' $1 ', $value );
        }

        // process shortcodes
        $value = self::processShortcodesInContent( $value, $context );

        // clean HTML
        $allowed_tags = get_option('wpla_allowed_html_tags','<b><i>');
        //$value = nl2br( trim( strip_tags( $value, $allowed_tags ) ) ); 	// strip html tags, trim excess whitespace, and convert line breaks to <br>
        $value = trim( strip_tags( $value, $allowed_tags ) ); 	// strip html tags, trim excess whitespace
        if ( get_option( 'wpla_convert_content_nl2br', 1 ) ) {
            $value = nl2br( $value );
        }

        $value = str_replace( array("\n","\r"), '', $value );	// remove line breaks to keep CSV intact
        $value = str_replace( array("\t"),     ' ', $value );	// replace tabs       to keep CSV intact

        // limit product_description to 2000 characters
        if ( strlen($value) > 2000 ) $value = substr($value, 0, 2000);


        // convert UTF-8 characters
        //$value = htmlentities( $value, ENT_QUOTES, 'UTF-8', false );
        //$value = htmlspecialchars_decode( $value, ENT_QUOTES );
        $value = html_entity_decode( $value, ENT_QUOTES, 'ISO-8859-1' );

        return $value;
    } // convertContent()

	/**
	 * @param string $html_content
	 * @param string $context Content or Attribute. If 'attribute' is passed, wpautop is skipped
	 *
	 * @return string
	 */
	static public function processShortcodesInContent( $html_content, $context = 'content' ) {

		// process shortcodes in main content
		$process_shortcodes = get_option( 'wpla_process_shortcodes', 'off' );

		// Setting to disable using wpautop on the post_content
        $do_wpautop = get_option( 'wpla_shortcode_do_autop', 1 );

 		if ( 'off' == $process_shortcodes ) {

 			// off - do nothing, except wpautop() for proper paragraphs
            if ( $do_wpautop && $context == 'content' ) {
                $html_content = wpautop( $html_content );
            }

 		} elseif ( 'do_shortcode' == $process_shortcodes ) {

			// process all wp shortcodes
 			$html_content = do_shortcode( $html_content );

 		} elseif ( 'remove_all' == $process_shortcodes ) {

 			// remove all shortcodes from product description
 			$post_content = $html_content;

			// find and remove all placeholders
			if ( preg_match_all( '/\[([^\]]+)\]/', $post_content, $matches ) ) {
				foreach ($matches[0] as $placeholder) {
			 		$post_content = str_replace( $placeholder, '', $post_content );
				}
			}

			// insert content into template html
	 		$html_content = $do_wpautop ? wpautop( $post_content ) : $post_content;

 		} elseif ( 'the_content' == $process_shortcodes ) {

 			// make sure, WooCommerce template functions are loaded (WC2.2)
 			if ( ! function_exists('woocommerce_product_loop_start') && version_compare( WC_VERSION, '2.2', '>=' ) ) {
 				// WC()->include_template_functions(); // won't work unless is_admin() == true
				include_once( dirname( WC_PLUGIN_FILE) . '/includes/wc-template-functions.php' );
 			}

 			// apply the_content filter to make description look the same as in WP
	 		$html_content = apply_filters('the_content', $html_content );

 		}

		return $html_content;
	} // processShortcodesInContent()


	static public function convertImageUrl( $url ) {

		// urlencode utf8 characters in image filename
        $query_string       = parse_url( $url, PHP_URL_QUERY );
        $url_without_query  = str_replace( '?'. $query_string, '', $url );

		$filename_before = basename( $url_without_query );
		$filename_after  = rawurlencode( $filename_before );
		$url_without_query = str_replace( $filename_before, $filename_after, $url_without_query );
		$url = ( $query_string ) ? $url_without_query .'?'. $query_string : $url_without_query;

		$url = self::removeHttpsFromUrl( $url );

		return $url;
	} // convertImageUrl()


	// Amazon doesn't accept image urls using https
	static function removeHttpsFromUrl( $url ) {

		// fix relative urls
		if ( '/wp-content/' == substr( $url, 0, 12 ) ) {
			$url = str_replace('/wp-content', content_url(), $url);
		}

		// fix https urls
		$url = str_replace( 'https://', 'http://', $url );
		$url = str_replace( ':443', '', $url );

		return $url;
	}


	static public function processCustomMetaShortcodes( $post_id, $field_value, $real_post_id ) {

		// custom meta shortcodes i.e. [meta_Name]
		if ( preg_match_all("/\\[meta_(.*)\\]/uUsm", $field_value, $matches ) ) {

			foreach ( $matches[1] as $meta_name ) {
                // try real post_id for single variation first #41458
                $meta_value = get_post_meta( $real_post_id, $meta_name, true );

				if ( ! $meta_value ) {
                    $meta_value = get_post_meta( $post_id, $meta_name, true );
				}

				if ( ! $meta_value ) {
					// try with _ prefix if nothing found - prevent user error
					$meta_value = get_post_meta( $post_id, '_'.$meta_name, true );
				}

				$field_value = str_replace( '[meta_'.$meta_name.']', $meta_value,  $field_value );
			}

		}

		return $field_value;
	} // processCustomMetaShortcodes()


	static public function processAttributeShortcodes( $product, $field_value, $max_length = false ) {

		// child variations: check variation attributes first
        $product_type = wpla_get_product_meta( $product, 'product_type' );
		if ( $product_type == 'variation' || $product_type == 'product-part-variation' ) {

			// match shortcodes - exit if none are found
			if ( ! preg_match_all("/\\[attribute_(.*)\\]/uUsm", $field_value, $matches ) ) return $field_value;

			// get variation attributes
			$variation_attributes = $product->get_variation_attributes();

			foreach ( $matches[1] as $attribute ) {
			    WPLA()->logger->info( 'processing attribute shortcode: '. $attribute );

				$taxonomy_name = 'attribute_pa_'.$attribute;
				if ( isset( $variation_attributes[ $taxonomy_name ] ) && $variation_attributes[ $taxonomy_name ] !== '' ){
					$attribute_slug  = $variation_attributes[ $taxonomy_name ];
					$attribute_value = WPLA_ProductWrapper::getAttributeValueFromSlug( $taxonomy_name, $attribute_slug );
					$field_value     = str_replace( '[attribute_'.$attribute.']', $attribute_value,  $field_value );

                    WPLA()->logger->info( 'new field_value: '. $field_value );
				}

			}

		} // if child variation

        $post_id = wpla_get_product_meta( $product, 'id' );
        if ( $product_type == 'variation' || $product_type == 'product-part-variation' ) {
		    // pull the parent ID
            $post_id = WPLA_ProductWrapper::getVariationParent( $post_id );
        }


		// match shortcodes (again, because they may already been processed)
		if ( preg_match_all("/\\[attribute_(.*)\\]/uUsm", $field_value, $matches ) ) {

			// $product_attributes = WPLA_ProductWrapper::getAttributes( $post_id );
			// WPLA()->logger->debug('processAttributeShortcodes() - product_attributes: '.print_r($product_attributes,1));
			// WPLA()->logger->debug('called getAttributes() for post_id '.$post_id.' - field: '.$field_value);
            WPLA()->logger->info( 'processing attribute shortcode second round' );

			// process attribute shortcodes i.e. [attribute_Brand]
			$product_attributes = WPLA()->memcache->getProductAttributes( $post_id );

			foreach ( $matches[1] as $attribute ) {
                WPLA()->logger->info( 'processing attribute shortcode: '. $attribute );

				if ( isset( $product_attributes[ 'pa_'.$attribute ] )){
					$attribute_value = self::convertContent( $product_attributes[ 'pa_'.$attribute ] );
				} else {
					$attribute_value = '';
				}
                WPLA()->logger->info( 'new $attribute_value: '. $attribute_value );

                $attribute_value = apply_filters( 'wpla_attribute_shortcode_value', $attribute_value, $attribute, $post_id );
                
				$processed_html = str_replace( '[attribute_'.$attribute.']', $attribute_value,  $field_value );

				// check if string exceeds max_length after processing shortcode
				// if ( $max_length && ( $this->mb_strlen( $processed_html ) > $max_length ) ) {
				// 	$attribute_value = '';
				// 	$processed_html = str_replace( '[attribute_'.$attribute.']', $attribute_value,  $field_value );
				// }

				$field_value = $processed_html;

			}

		}
		// WPLA()->logger->info('processAttributeShortcodes() - return value: '.print_r($field_value,1));

		return $field_value;
	} // processAttributeShortcodes()



	/**
	 * Price and Quantity update feed
	 */

	// generate csv feed for updated products
	static function buildPriceAndQuantityFeedData( $items, $account_id ) {
		// echo "<pre>";print_r($items);echo"</pre>";#die();

		// build csv
		$columns = array(
			'sku',
			'price',
			'minimum-seller-allowed-price',
			'maximum-seller-allowed-price',
			'quantity',
			'leadtime-to-ship'
		);
		$csv_header = join( "\t", $columns ) . "\n";
		$csv_body = '';

		$feed_currency_format = get_option( 'wpla_feed_currency_format', 'auto' );
		$account    		  = new WPLA_AmazonAccount( $account_id );
		$account_market_code  = $account->market_code;

        $max_feed_size = get_option( 'wpla_max_feed_size', 1000 );
        $feed_size = 0;

		foreach ( $items as $item ) {
            if ( $feed_size >= $max_feed_size ) {
                WPLA()->logger->info( 'max_feed_size reached. Breaking.');
                break;
            }

			// get WooCommerce product data
			$product_id = $item['post_id'];
			$product = WPLA_ProductWrapper::getProduct( $product_id );
			if ( ! $product ) continue;
			if ( ! $item['sku'] ) continue;
			if ( wpla_get_product_meta( $product, 'product_type' ) == 'variable' ) {
				WPLA_ListingsModel::updateWhere( array( 'id' => $item['id'] ), array( 'pnq_status' => 0 ) );
				continue; // skip parent variations in P&Q feed
			}
			// echo "<pre>";print_r($product);echo"</pre>";#die();

			// load profile fields
			$profile  		= new WPLA_AmazonProfile( $item['profile_id'] );
			$profile_fields = $profile ? maybe_unserialize( $profile->fields ) : array();

			foreach ( $columns as $col ) {
				$value = self::parseProductColumn( $col, $item, $product, $profile );
				$value = self::convertCurrencyFormat( $value, $col, $feed_currency_format, $account_market_code );
				$value = apply_filters( 'wpla_filter_listing_feed_column', $value, $col, $item, $product, $profile, false );
				$csv_body .= $value . "\t";
			}
			$csv_body .= "\n";

            $feed_size++;

			// $csv_body .= $item['sku'] . "\t";
			// // $csv_body .= 'TEST_NO_SKU' . "\t";
			// $csv_body .= $item['price'] . "\t";
			// $csv_body .= "\t";
			// $csv_body .= "\t";
			// $csv_body .= $item['quantity'] . "\t";
			// $csv_body .= "\t";
			// $csv_body .= "\n"; // EOL
		}

		// check if any rows were created
		if ( ! $csv_body ) return self::return_csv_object();

		// return csv object
		return self::return_csv_object( $csv_body, $csv_header );
	} // buildPriceAndQuantityFeedData()


	// convert prices to use decimal comma
	static function convertCurrencyFormat( $price, $col, $feed_currency_format, $account_market_code ) {

		// convert if auto mode is enabled and this is a price column
		if ( $feed_currency_format != 'auto' ) return $price;
		if ( ! in_array( $col, array('price','minimum-seller-allowed-price','maximum-seller-allowed-price') ) ) return $price;
		if ( ! in_array( $account_market_code, array('DE','FR','IT','ES') ) ) return $price;

		// convert to decimal comma
		$price = str_replace( '.', ',', $price );

		return $price;
	} // convertCurrencyFormat()


	/**
	 * Inventory Loader feed - for real products
	 */

	// generate csv feed for products using InventoryLoader
	static function buildInventoryLoaderFeedData( $items, $account_id, $profile, $append_feed = false ) {

		if ( ! $profile || ! $profile->id ) {
			WPLA()->logger->error('buildInventoryLoaderFeedData() no profile found');
			return self::return_csv_object();
		}

		$template = new WPLA_AmazonFeedTemplate( $profile->tpl_id );
		if ( ! $template || ! $template->id ) {
			WPLA()->logger->error('buildInventoryLoaderFeedData() no template found');
			return self::return_csv_object();
		}

        $feed_currency_format = get_option( 'wpla_feed_currency_format', 'auto' );
        $account    		  = new WPLA_AmazonAccount( $account_id );
        $account_market_code  = $account->market_code;

		$columns = $template->getFieldNames();
		$profile_fields = maybe_unserialize( $profile->fields );

		// echo "<pre>";print_r($items);echo"</pre>";#die();
		// echo "<pre>";print_r($template);echo"</pre>";#die();
		// echo "<pre>";print_r($profile);echo"</pre>";#die();
		// echo "<pre>";print_r($columns);echo"</pre>";#die();
		// echo "<pre>";print_r($profile_fields);echo"</pre>";#die();

		if ( ! $columns ) {
			WPLA()->logger->error('no columns found in template - tpl_id: '.$profile->tpl_id);
			WPLA()->logger->info('profile: '.print_r($profile,1));
			WPLA()->logger->info('template: '.print_r($template,1));
			WPLA()->logger->info('columns: '.print_r($columns,1));
			WPLA()->logger->info('items: '.print_r($items,1));
			return '';
		}

		// adjust template name (fptcustom)
		$template_name = $template->name;

		// header
		$csv_header  = '';
		$csv_header .= join( "\t", $columns ) . "\n";
		$csv_body    = '';

        $max_feed_size = get_option( 'wpla_max_feed_size', 1000 );
        $feed_size = 0;

		// loop products
		foreach ( $items as $item ) {
            if ( $feed_size >= $max_feed_size ) {
                WPLA()->logger->info( 'max_feed_size reached. Breaking.');
                break;
            }

			// get WooCommerce product data
			$product_id = $item['post_id'];
			$product = WPLA_ProductWrapper::getProduct( $product_id );
			if ( ! $product ) continue;
			if ( ! $item['sku'] ) continue;
			WPLA()->logger->debug('buildInventoryLoaderFeedData() - processing item '.$item['sku'].' - ID '.$product_id);

			// reset row cache
			WPLA()->memcache->clearColumnCache();

			// process product
			foreach ( $columns as $col ) {
				$value = self::parseProductColumn( $col, $item, $product, $profile );
                $value = self::convertCurrencyFormat( $value, $col, $feed_currency_format, $account_market_code );
				$value = apply_filters( 'wpla_filter_listing_feed_column', $value, $col, $item, $product, $profile, $template->name );
				$value = str_replace( array("\t","\n","\r"), ' ', $value );	// make sure there are no tabs or line breaks in any field
				$csv_body .= $value . "\t";
				WPLA()->memcache->setColumnValue( wpla_get_product_meta( $product, 'sku' ), $col, $value );
			}
			$csv_body .= "\n";
            $feed_size++;
		}

		// check if any rows were created
		if ( ! $csv_body ) return self::return_csv_object();

		// only return body when appending feed
		if ( $append_feed ) return self::return_csv_object( $csv_body, '', $template->name );

		// return csv object
		return self::return_csv_object( $csv_body, $csv_header, $template->name );

	} // buildInventoryLoaderFeedData()


	/**
	 * Product Removal Inventory Loader feed (for trashed listings)
	 */

	// generate csv feed for trashed products
	static function buildProductRemovalFeedData( $items, $account_id ) {
		// echo "<pre>";print_r($items);echo"</pre>";#die();

        $feed_currency_format = get_option( 'wpla_feed_currency_format', 'auto' );
        $account    		  = new WPLA_AmazonAccount( $account_id );
        $account_market_code  = $account->market_code;

		// build csv
		$columns = array(
			'sku',
			'product-id',
			'product-id-type',
			'price',
			'minimum-seller-allowed-price',
			'maximum-seller-allowed-price',
			'item-condition',
			'quantity',
			'add-delete',
			'will-ship-internationally',
			'expedited-shipping',
			// 'standard-plus',
			'item-note',
			'fulfillment-center-id',
			'batteries_required',
			'supplier_declared_dg_hz_regulation1',
			// 'product-tax-code',
			// 'leadtime-to-ship'
		);
		$csv_header = join( "\t", $columns ) . "\n";
		$csv_body = '';

        $max_feed_size = get_option( 'wpla_max_feed_size', 1000 );
        $feed_size = 0;

		foreach ( $items as $item ) {
            if ( $feed_size >= $max_feed_size ) {
                WPLA()->logger->info( 'max_feed_size reached. Breaking.');
                break;
            }

			// get WooCommerce product data
			$product_id = $item['post_id'];
			$product = WPLA_ProductWrapper::getProduct( $product_id );

			// Allow listings to be removed even with missing WC products #30652
			//if ( ! $product ) continue;

			if ( ! $item['sku'] ) continue;
			// echo "<pre>";print_r($product);echo"</pre>";#die();

			// load profile fields
			$profile  		= new WPLA_AmazonProfile( $item['profile_id'] );
			$profile_fields = $profile ? maybe_unserialize( $profile->fields ) : array();

			foreach ( $columns as $col ) {
				$value = self::parseProductColumn( $col, $item, $product, $profile );
                $value = self::convertCurrencyFormat( $value, $col, $feed_currency_format, $account_market_code );
				// $value = apply_filters( 'wpla_filter_listing_feed_column', $value, $col, $item, $product, $profile, false );
				$csv_body .= $value . "\t";
			}
			$csv_body .= "\n";

            $feed_size++;
		}

		// check if any rows were created
		if ( ! $csv_body ) return self::return_csv_object();

		// return csv object
		return self::return_csv_object( $csv_body, $csv_header );
	} // buildProductRemovalFeedData()



	/**
	 * Listing Loader update feed
	 */

	// generate csv feed for updated products
	static function buildListingLoaderFeedData( $items, $account_id, $append_feed = false ) {

		$lilo_version = get_option( 'wpla_lilo_version', 0 );

		if ( ! $lilo_version ){

			// define LiLo version and columns
			$template_version = '1.4';
			$columns = array(
				'sku', 												// required columns
				'price',
				'quantity',
				'product-id',
				'product-id-type',
				'condition-type',
				'condition-note',
				'ASIN-hint', 										// optional columns
				'title',
				'product-tax-code',
				'operation-type',
				'sale-price',
				'sale-start-date',
				'sale-end-date',
				'leadtime-to-ship',
				'launch-date',
				'is-giftwrap-available',
				'is-gift-message-available',
				'fulfillment-center-id',
				'main-offer-image',
				'offer-image1',
				'offer-image2',
				'offer-image3',
				'offer-image4',
				'offer-image5',
			);

		} else {

			// define LiLo version and columns
			$template_version = '2014.0703';
			$columns = array(
				'sku', 													// required columns
				'price',
				'quantity',
				'product-id',
				'product-id-type',
				'condition-type',
				'condition-note',
				'asin-hint', 											// optional columns
				'title',
				'product-tax-code',
				'operation-type',
				'sale-price',
				'sale-start-date',
				'sale-end-date',
				'leadtime-to-ship',
				'launch-date',
				'is-giftwrap-available',
				'is-gift-message-available',
				'fulfillment-center-id',
				'main-offer-image',
				'offer-image1',
				'offer-image2',
				'offer-image3',
				'offer-image4',
				'offer-image5',
				'batteries_required',									// new ListingLoader columns
				'are_batteries_included',
				'battery_cell_composition',
				'battery_type',
				'number_of_batteries',
				// 'battery_weight',									// disabled to avoid error 8058
				// 'battery_weight_unit_of_measure',					// disabled to avoid error 8058
				'number_of_lithium_metal_cells',
				'number_of_lithium_ion_cells',
				'lithium_battery_packaging',
				// 'lithium_battery_energy_content',					// disabled to avoid error 8058
				// 'lithium_battery_energy_content_unit_of_measure',	// disabled to avoid error 8058
				// 'lithium_battery_weight',							// disabled to avoid error 8058
				// 'lithium_battery_weight_unit_of_measure',			// disabled to avoid error 8058
				'supplier_declared_dg_hz_regulation1',
				'supplier_declared_dg_hz_regulation2',
				'supplier_declared_dg_hz_regulation3',
				'supplier_declared_dg_hz_regulation4',
				'supplier_declared_dg_hz_regulation5',
				'hazmat_united_nations_regulatory_id',
				'safety_data_sheet_url',
				// 'item_weight',										// possibly causing troubles when item_weight would be populated automatically
				// 'item_weight_unit_of_measure',						// while no unit was provided and the feed failed with error 8058 (#24959 / #25776)
				// 'item_volume',										// disabled to avoid error 8058
				// 'item_volume_unit_of_measure',						// disabled to avoid error 8058
				'flash_point',
				'ghs_classification_class1',
				'ghs_classification_class2',
				'ghs_classification_class3',
				// 'california_proposition_65_compliance_type', 		// US only
				// 'california_proposition_65_chemical_names1',
				// 'california_proposition_65_chemical_names2',
				// 'california_proposition_65_chemical_names3',
				// 'california_proposition_65_chemical_names4',
				// 'california_proposition_65_chemical_names5',
			);

		}

		$template_name    = 'LiLo';
		$csv_header       = 'TemplateType=Offer'. "\t" . 'Version=' . $template_version . str_repeat("\t", sizeof($columns) - 2 ) . "\n";
		$csv_header       .= join( "\t", $columns ) . "\n";
		if ( $template_version != '1.4' ) // Amazon expects LiLo 1.4 to have only two header rows reserved
			$csv_header       .= join( "\t", $columns ) . "\n";
		$csv_body         = '';

		foreach ( $items as $item ) {

			// get WooCommerce product data
			$product_id = $item['post_id'];
			$product = WPLA_ProductWrapper::getProduct( $product_id );
			if ( ! $product ) continue;
			if ( ! $item['sku'] ) continue;
            if ( $product->get_type() == 'variable' || $product->get_type() == 'variable-product-part' ) {
                WPLA()->logger->debug('skipping ListingLoader parent item '.$item['sku'].' - ID '.$product_id);

                // Set status back to online so it doesn't appear as stuck in the Changed status #29024
                WPLA_ListingsModel::updateWhere( array( 'id' => $item['id'] ), array( 'status' => 'online' ) );
                continue; // skip parent variations in ListingLoader feeds
            }

			// echo "<pre>";print_r($product);echo"</pre>";#die();
			WPLA()->logger->debug('processing ListingLoader item '.$item['sku'].' - ID '.$product_id);

			// load profile fields
			$profile  		= new WPLA_AmazonProfile( $item['profile_id'] );
			$profile_fields = $profile ? maybe_unserialize( $profile->fields ) : array();

			// reset row cache
			WPLA()->memcache->clearColumnCache();

			foreach ( $columns as $col ) {
				$value = self::parseProductColumn( $col, $item, $product, $profile );
				$value = apply_filters( 'wpla_filter_listing_feed_column', $value, $col, $item, $product, $profile, $template_name );
				$value = str_replace( array("\t","\n","\r"), ' ', $value );	// make sure there are no tabs or line breaks in any field
				$csv_body .= $value . "\t";
				WPLA()->memcache->setColumnValue( wpla_get_product_meta( $product, 'sku' ), $col, $value );
			}
			$csv_body .= "\n";

		}

		// check if any rows were created
		if ( ! $csv_body ) return self::return_csv_object();

		// only return body when appending feed
		if ( $append_feed ) return self::return_csv_object( $csv_body, '', $template_name );

		// return csv object
		return self::return_csv_object( $csv_body, $csv_header, $template_name );

	} // buildListingLoaderFeedData()







	/**
	 * Order Fulfillment feed
	 */
	static function addShippingFeedData( $feed_id, $post_id, $order_id, $account_id ) {
	    global $wpdb;
        WPLA()->logger->info('addShippingFeedData #'. $feed_id);

        // build csv
        $columns = array(
            'order_id'                          => 'order-id', 		// required
            'order_item_id'                     => 'order-item-id',
            'quantity'                          => 'quantity',
            'ship_date'                         => 'ship-date', 		// required
            'carrier_code'                      => 'carrier-code',
            'carrier_name'                      => 'carrier-name',
            'tracking_number'                   => 'tracking-number',
            'ship_method'                       => 'ship-method',
            'ship_from_address_name'            => 'ship_from_address_name',
            'ship_from_address_line1'           => 'ship_from_address_line1',
            'ship_from_address_line2'           => 'ship_from_address_line2',
            'ship_from_address_city'            => 'ship_from_address_city',
            'ship_from_address_state'           => 'ship_from_address_state_or_region',
            'ship_from_address_postal'          => 'ship_from_address_postalcode',
            'ship_from_address_country'         => 'ship_from_address_countrycode',
        );


        // reset row cache
        WPLA()->memcache->clearColumnCache();
        $shipment = [];

        foreach ( $columns as $key => $col ) {
            $value = self::parseOrderColumn( $col, $post_id );
            $shipment[ $key ] = $value;

            WPLA()->memcache->setColumnValue( 'shipfeed_oid_'.$post_id, $col, $value );
        }

        $shipment['feed_id'] = $feed_id;
        $shipment['date_added'] = current_time('mysql', true );
        WPLA()->logger->debug( 'data: '. print_r( $shipment, 1 ) );
        $wpdb->insert( $wpdb->prefix .'amazon_fulfillment_feed_items', $shipment );
        WPLA()->logger->info( 'Added #'. $wpdb->insert_id );
    }

	// generate csv feed for shipped order
	static function buildShippingFeedData( $post_id, $order_id, $account_id, $include_header = true ) {

		// build csv
		$columns = array(
			'order-id', 		// required
			'order-item-id',
			'quantity',
			'ship-date', 		// required
			'carrier-code',
			'carrier-name',
			'tracking-number',
			'ship-method',
            'ship_from_address_name',
            'ship_from_address_line1',
            'ship_from_address_line2',
            'ship_from_address_city',
            'ship_from_address_state_or_region',
            'ship_from_address_postalcode',
            'ship_from_address_countrycode',
		);
		$csv_header = join( "\t", $columns ) . "\n";
		$csv_body = '';

		// reset row cache
		WPLA()->memcache->clearColumnCache();

		foreach ( $columns as $col ) {
			$value = self::parseOrderColumn( $col, $post_id );
			$csv_body .= $value . "\t";
			WPLA()->memcache->setColumnValue( 'shipfeed_oid_'.$post_id, $col, $value );
		}
		$csv_body .= "\n";

		// check if header should be included
		if ( $include_header && $csv_body )
			return $csv_header . $csv_body;

		return $csv_body;
	} // buildShippingFeedData()


	static function parseOrderColumn( $column, $post_id ) {
		$value = '';
		$order = wc_get_order( $post_id );

		switch ( $column ) {

			case 'order-id':
				$value = $order->get_meta( '_wpla_amazon_order_id', true );
				break;

			case 'ship-date':
				// $value = get_post_meta( $post_id, '_wpla_date_shipped', true );
				// $value .= ' 00:01:23'; // without this, amazon would use 07:00:00 UTC by default

				$date = $order->get_meta( '_wpla_date_shipped', true );
				$time = $order->get_meta( '_wpla_time_shipped', true );

				// Allow custom shipping date and time #26075
                $date = apply_filters( 'wpla_custom_shipping_date', $date, $post_id );
                $time = apply_filters( 'wpla_custom_shipping_time', $time, $post_id );

				if ( DateTime::createFromFormat('Y-m-d H:i:s', $date.' '.$time) ) {

					// convert date/time from UTC to local timezone
					$tz = WPLA_DateTimeHelper::getLocalTimeZone();
					$dt = new DateTime( $date.' '.$time, new DateTimeZone( 'UTC' ) );
					$dt->setTimeZone( new DateTimeZone( $tz ) );
					$date = $dt->format('Y-m-d');
					$time = $dt->format('H:i:s');

				} else {

					// get current date in local timezone
					$tz   = WPLA_DateTimeHelper::getLocalTimeZone();
					$dt   = new DateTime( 'now', new DateTimeZone( $tz ) );
					$date = $dt->format('Y-m-d'); // add current date in local timezone

				}

                $value = $date;

                if ( 1 == get_option( 'wpla_feed_include_shipment_time', 0 ) ) {
                    $value = $date . ' ' . $time . 'Z';
                }

				/*
				$dt   = new DateTime( 'now', new DateTimeZone('UTC') );

				if ( ! $date ) {
					$date = $dt->format('Y-m-d'); // add current date in UTC
				}
				if ( ! $time ) {
					$time = $dt->format('H:i:s'); // add current time in UTC
					// $time .= '+00:00' 	      // UTC (works as well as 'Z')
					// $time .= 'Z'; 			  // Z stands for UTC timezone
				}

				$value = $date . ' ' . $time . 'Z';
				*/
				break;

			case 'carrier-code':
				$value = $order->get_meta( '_wpla_tracking_provider', true );

				if ( empty( $value ) && $tracking = self::getThirdPartyPluginTrackingData( $post_id ) ) {
					$value = 'Other';
				}

                if ( strtolower( $value ) == 'hermes' ) {
                    // Hermes needs to defined in the carrier-name instead of the carrier-code
                    $value = 'Other';
                }
				break;

			case 'carrier-name':
				$carrier = WPLA()->memcache->getColumnValue( 'shipfeed_oid_'.$post_id, 'carrier-code' );
				$value   = $order->get_meta( '_wpla_tracking_service_name', true );

				if ( $carrier != 'Other' ) {
				    // Always leave this empty if carrier has a value that's not "Other" #49684
				    $value = '';
                } else {
                    if ( empty( $value ) && $tracking = self::getThirdPartyPluginTrackingData( $post_id ) ) {
                        $value = $tracking->provider;
                    }

                    if ( empty($value) && ( $carrier == 'Other' || $carrier === false ) ) {
                        $value = get_option( 'wpla_default_shipping_service_name', '' );
                        if ( empty($value) ) $value = 'N/A'; // we can't leave carrier-name empty if carrier-code is 'Other'
                    }
                }

				break;

			case 'tracking-number':
				$value = $order->get_meta( '_wpla_tracking_number', true );

				if ( empty( $value ) && $tracking = self::getThirdPartyPluginTrackingData( $post_id ) ) {
					$value = $tracking->number;
				}
				break;

            case 'ship-method':
                $value = $order->get_meta( '_wpla_tracking_ship_method', true );
                break;

            case 'ship_from_address_name':
                $name = $order->get_meta( '_wpla_tracking_ship_from_name', true );

                if ( !empty( $name ) ) {
                    $value = $name;
                }
                break;

            case 'ship_from_address_line1':
                $line1 = $order->get_meta( '_wpla_tracking_ship_from_line_1', true );

                if ( !empty( $line1 ) ) {
                    $value = $line1;
                }
                break;

            case 'ship_from_address_line2':
                $line2 = $order->get_meta( '_wpla_tracking_ship_from_line_2', true );

                if ( !empty( $line2 ) ) {
                    $value = $line2;
                }
                break;

            case 'ship_from_address_city':
                $city = $order->get_meta( '_wpla_tracking_ship_from_city', true );

                if ( !empty( $city ) ) {
                    $value = $city;
                }
                break;

            case 'ship_from_address_state_or_region':
                $state = $order->get_meta( '_wpla_tracking_ship_from_state', true );

                if ( !empty( $state ) ) {
                    $value = $state;
                }
                break;

            case 'ship_from_address_postalcode':
                $postal = $order->get_meta( '_wpla_tracking_ship_from_postcode', true );

                if ( !empty( $postal ) ) {
                    $value = $postal;
                }
                break;

            case 'ship_from_address_countrycode':
                $country = $order->get_meta( '_wpla_tracking_ship_from_country', true );

                if ( !empty( $country ) ) {
                    $value = $country;
                }
                break;

			default:
				# code...
				break;
		}

		$value = apply_filters( 'wpla_parse_order_column_value', $value, $column, $post_id );

		return $value;
	} // parseOrderColumn()


	// helper method to determine if tracking data was set by 3rd party plugins
	static function getThirdPartyPluginTrackingData( $post_id ) {
        $order = wc_get_order( $post_id );
        // check meta fields used by WooCommerce Shipment Tracking plugin and Shipstation plugin
		$_tracking_number   = $order->get_meta( '_tracking_number', true );
		$_tracking_provider = $order->get_meta( '_tracking_provider', true );

		// check custom carrier code used by Shipment Tracking
		if ( empty( $_tracking_provider ) ) {
			$_tracking_provider = $order->get_meta( '_custom_tracking_provider', true );
		}

		// Allow plugins to insert their own tracking data
        $_tracking_number = apply_filters( 'wpla_custom_tracking_number', $_tracking_number, $post_id );
		$_tracking_provider = apply_filters( 'wpla_custom_tracking_provider', $_tracking_provider, $post_id );

		// return false unless both number and provider are set
		if ( empty( $_tracking_number   ) ) return false;
		if ( empty( $_tracking_provider ) ) return false;

		// return value pair as object
		$tracking = new stdClass();
		$tracking->number   = $_tracking_number;
		$tracking->provider = $_tracking_provider;

		return $tracking;
	}


	/**
	 * Flat File FBA Shipment Injection Fulfillment Feed
	 */

	// generate csv feed for shipped order
	static function buildFbaSubmissionFeedData( $post_id, $_order, $order_item, $listing, $account_id, $include_header = true ) {

		// build csv
		$columns = array(
			'MerchantFulfillmentOrderID', 		// required
			'DisplayableOrderID', 				// required
			'DisplayableOrderDate', 			// required
			'MerchantSKU', 						// required
			'Quantity', 						// required
			'MerchantFulfillmentOrderItemID', 	// required
			'GiftMessage',
			'DisplayableComment',
			'PerUnitDeclaredValue',
			'DisplayableOrderComment', 			// required
			'DeliverySLA', 						// required
			'AddressName', 						// required
			'AddressFieldOne', 					// required
			'AddressFieldTwo',
			'AddressFieldThree',
			'AddressCity', 						// required
			'AddressCountryCode', 				// required
			'AddressStateOrRegion', 			// required
			'AddressPostalCode', 				// required
			'AddressPhoneNumber',
			'NotificationEmail',
			'FulfillmentAction',
		);
		$csv_header = join( "\t", $columns ) . "\n";
		$csv_body = '';

		foreach ( $columns as $col ) {
			$value = self::parseFbaSubmissionColumn( $col, $post_id, $_order, $order_item, $listing );
			$csv_body .= $value . "\t";
		}
		$csv_body .= "\n";

		// check if header should be included
		if ( $include_header && $csv_body )
			return $csv_header . $csv_body;

		return $csv_body;
	} // buildFbaSubmissionFeedData()

    /**
     * @param string    $column
     * @param int       $post_id
     * @param WC_Order  $_order
     * @param $order_item
     * @param $listing
     * @return bool|float|int|mixed|NULL|string|string[]|void|WC_DateTime
     */
	static function parseFbaSubmissionColumn( $column, $post_id, $_order, $order_item, $listing ) {
		$value      = '';
		$order_id   = $_order->get_id();
        $company    = $_order->get_shipping_company();

		switch ( $column ) {

			case 'MerchantFulfillmentOrderID':
				$value = $_order->get_order_number();
				$_order->update_meta_data( '_wpla_fba_MerchantFulfillmentOrderID', $value );
				$_order->save();
				break;

			case 'DisplayableOrderID':
				$value = $_order->get_order_number();
				break;

			case 'DisplayableOrderDate':
				$value = $_order->get_date_created();
				$value = str_replace( ' ', 'T', $value );
				break;

			case 'MerchantSKU':
				$value = $listing->sku;
				break;

			case 'Quantity':
				$value = $order_item['qty'];
				break;

			case 'MerchantFulfillmentOrderItemID':
				$value = $post_id; // or use order line item id
				break;

			case 'PerUnitDeclaredValue':
				$value = $order_item['line_total'];
				break;

			case 'DisplayableOrderComment':
				$value = $_order->get_meta( '_wpla_DisplayableOrderComment', true );
				if ( empty( $value ) ) $value = get_option( 'wpla_fba_default_order_comment' );
				if ( empty( $value ) ) $value = 'Thank you for your purchase.';
				break;

			case 'DeliverySLA':
				$value = $_order->get_meta( '_wpla_DeliverySLA', true );
				if ( empty( $value ) ) $value = get_option( 'wpla_fba_default_delivery_sla' );
				if ( empty( $value ) ) $value = 'Standard';
				break;

			case 'AddressName':
				$value = $_order->get_shipping_first_name() . ' ' . $_order->get_shipping_last_name();
				break;

			case 'AddressFieldOne':
				$value = !empty( $company ) ? $company : $_order->get_shipping_address_1();
				break;

			case 'AddressFieldTwo':
                $value =  !empty( $company ) ? $_order->get_shipping_address_1() : $_order->get_shipping_address_2();
				break;

			case 'AddressFieldThree':
				$value = !empty( $company ) ? $_order->get_shipping_address_2() : '';
				break;

			case 'AddressCity':
				$value = $_order->get_shipping_city();
				break;

			case 'AddressCountryCode':
				$value = $_order->get_shipping_country();
				break;

			case 'AddressStateOrRegion':
				$value = $_order->get_shipping_state();
				break;

			case 'AddressPostalCode':
				$value = $_order->get_shipping_postcode();
				break;

			case 'AddressPhoneNumber':
				$value = $_order->get_billing_phone();
				break;

			case 'NotificationEmail':
				$value = $_order->get_meta( '_wpla_NotificationEmail', true );
				if ( empty( $value ) && ( get_option('wpla_fba_default_notification') ) ) {
					$value = $_order->get_billing_email();
				}
				break;

			case 'FulfillmentAction':
				$status = $_order->get_status();
				$value = ''; // default value: Ship
				if ( $status == 'on-hold' ) $value = 'Hold';
				break;

			default:
				# code...
				break;
		}

		return $value;
	} // parseFbaSubmissionColumn()


} // class WPLA_FeedDataBuilder
