<?php
namespace Aws\ApiGateway;

use Aws\AwsClient;
use Aws\CommandInterface;
use Psr\Http\Message\RequestInterface;

/**
 * This client is used to interact with the **AWS API Gateway** service.
 *
 * @method \Aws\Result createApiKey(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createApiKeyAsync(array $args = [])
 * @method \Aws\Result createAuthorizer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createAuthorizerAsync(array $args = [])
 * @method \Aws\Result createBasePathMapping(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createBasePathMappingAsync(array $args = [])
 * @method \Aws\Result createDeployment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createDeploymentAsync(array $args = [])
 * @method \Aws\Result createDocumentationPart(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createDocumentationPartAsync(array $args = [])
 * @method \Aws\Result createDocumentationVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createDocumentationVersionAsync(array $args = [])
 * @method \Aws\Result createDomainName(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createDomainNameAsync(array $args = [])
 * @method \Aws\Result createModel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createModelAsync(array $args = [])
 * @method \Aws\Result createRequestValidator(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createRequestValidatorAsync(array $args = [])
 * @method \Aws\Result createResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createResourceAsync(array $args = [])
 * @method \Aws\Result createRestApi(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createRestApiAsync(array $args = [])
 * @method \Aws\Result createStage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createStageAsync(array $args = [])
 * @method \Aws\Result createUsagePlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createUsagePlanAsync(array $args = [])
 * @method \Aws\Result createUsagePlanKey(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createUsagePlanKeyAsync(array $args = [])
 * @method \Aws\Result createVpcLink(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createVpcLinkAsync(array $args = [])
 * @method \Aws\Result deleteApiKey(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteApiKeyAsync(array $args = [])
 * @method \Aws\Result deleteAuthorizer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteAuthorizerAsync(array $args = [])
 * @method \Aws\Result deleteBasePathMapping(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteBasePathMappingAsync(array $args = [])
 * @method \Aws\Result deleteClientCertificate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteClientCertificateAsync(array $args = [])
 * @method \Aws\Result deleteDeployment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteDeploymentAsync(array $args = [])
 * @method \Aws\Result deleteDocumentationPart(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteDocumentationPartAsync(array $args = [])
 * @method \Aws\Result deleteDocumentationVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteDocumentationVersionAsync(array $args = [])
 * @method \Aws\Result deleteDomainName(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteDomainNameAsync(array $args = [])
 * @method \Aws\Result deleteGatewayResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteGatewayResponseAsync(array $args = [])
 * @method \Aws\Result deleteIntegration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteIntegrationAsync(array $args = [])
 * @method \Aws\Result deleteIntegrationResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteIntegrationResponseAsync(array $args = [])
 * @method \Aws\Result deleteMethod(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteMethodAsync(array $args = [])
 * @method \Aws\Result deleteMethodResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteMethodResponseAsync(array $args = [])
 * @method \Aws\Result deleteModel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteModelAsync(array $args = [])
 * @method \Aws\Result deleteRequestValidator(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteRequestValidatorAsync(array $args = [])
 * @method \Aws\Result deleteResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteResourceAsync(array $args = [])
 * @method \Aws\Result deleteRestApi(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteRestApiAsync(array $args = [])
 * @method \Aws\Result deleteStage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteStageAsync(array $args = [])
 * @method \Aws\Result deleteUsagePlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteUsagePlanAsync(array $args = [])
 * @method \Aws\Result deleteUsagePlanKey(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteUsagePlanKeyAsync(array $args = [])
 * @method \Aws\Result deleteVpcLink(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteVpcLinkAsync(array $args = [])
 * @method \Aws\Result flushStageAuthorizersCache(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise flushStageAuthorizersCacheAsync(array $args = [])
 * @method \Aws\Result flushStageCache(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise flushStageCacheAsync(array $args = [])
 * @method \Aws\Result generateClientCertificate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise generateClientCertificateAsync(array $args = [])
 * @method \Aws\Result getAccount(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAccountAsync(array $args = [])
 * @method \Aws\Result getApiKey(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getApiKeyAsync(array $args = [])
 * @method \Aws\Result getApiKeys(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getApiKeysAsync(array $args = [])
 * @method \Aws\Result getAuthorizer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAuthorizerAsync(array $args = [])
 * @method \Aws\Result getAuthorizers(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAuthorizersAsync(array $args = [])
 * @method \Aws\Result getBasePathMapping(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getBasePathMappingAsync(array $args = [])
 * @method \Aws\Result getBasePathMappings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getBasePathMappingsAsync(array $args = [])
 * @method \Aws\Result getClientCertificate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getClientCertificateAsync(array $args = [])
 * @method \Aws\Result getClientCertificates(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getClientCertificatesAsync(array $args = [])
 * @method \Aws\Result getDeployment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDeploymentAsync(array $args = [])
 * @method \Aws\Result getDeployments(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDeploymentsAsync(array $args = [])
 * @method \Aws\Result getDocumentationPart(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDocumentationPartAsync(array $args = [])
 * @method \Aws\Result getDocumentationParts(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDocumentationPartsAsync(array $args = [])
 * @method \Aws\Result getDocumentationVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDocumentationVersionAsync(array $args = [])
 * @method \Aws\Result getDocumentationVersions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDocumentationVersionsAsync(array $args = [])
 * @method \Aws\Result getDomainName(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDomainNameAsync(array $args = [])
 * @method \Aws\Result getDomainNames(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDomainNamesAsync(array $args = [])
 * @method \Aws\Result getExport(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getExportAsync(array $args = [])
 * @method \Aws\Result getGatewayResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getGatewayResponseAsync(array $args = [])
 * @method \Aws\Result getGatewayResponses(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getGatewayResponsesAsync(array $args = [])
 * @method \Aws\Result getIntegration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getIntegrationAsync(array $args = [])
 * @method \Aws\Result getIntegrationResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getIntegrationResponseAsync(array $args = [])
 * @method \Aws\Result getMethod(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getMethodAsync(array $args = [])
 * @method \Aws\Result getMethodResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getMethodResponseAsync(array $args = [])
 * @method \Aws\Result getModel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getModelAsync(array $args = [])
 * @method \Aws\Result getModelTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getModelTemplateAsync(array $args = [])
 * @method \Aws\Result getModels(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getModelsAsync(array $args = [])
 * @method \Aws\Result getRequestValidator(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getRequestValidatorAsync(array $args = [])
 * @method \Aws\Result getRequestValidators(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getRequestValidatorsAsync(array $args = [])
 * @method \Aws\Result getResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getResourceAsync(array $args = [])
 * @method \Aws\Result getResources(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getResourcesAsync(array $args = [])
 * @method \Aws\Result getRestApi(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getRestApiAsync(array $args = [])
 * @method \Aws\Result getRestApis(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getRestApisAsync(array $args = [])
 * @method \Aws\Result getSdk(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSdkAsync(array $args = [])
 * @method \Aws\Result getSdkType(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSdkTypeAsync(array $args = [])
 * @method \Aws\Result getSdkTypes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSdkTypesAsync(array $args = [])
 * @method \Aws\Result getStage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getStageAsync(array $args = [])
 * @method \Aws\Result getStages(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getStagesAsync(array $args = [])
 * @method \Aws\Result getTags(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getTagsAsync(array $args = [])
 * @method \Aws\Result getUsage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getUsageAsync(array $args = [])
 * @method \Aws\Result getUsagePlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getUsagePlanAsync(array $args = [])
 * @method \Aws\Result getUsagePlanKey(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getUsagePlanKeyAsync(array $args = [])
 * @method \Aws\Result getUsagePlanKeys(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getUsagePlanKeysAsync(array $args = [])
 * @method \Aws\Result getUsagePlans(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getUsagePlansAsync(array $args = [])
 * @method \Aws\Result getVpcLink(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getVpcLinkAsync(array $args = [])
 * @method \Aws\Result getVpcLinks(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getVpcLinksAsync(array $args = [])
 * @method \Aws\Result importApiKeys(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise importApiKeysAsync(array $args = [])
 * @method \Aws\Result importDocumentationParts(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise importDocumentationPartsAsync(array $args = [])
 * @method \Aws\Result importRestApi(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise importRestApiAsync(array $args = [])
 * @method \Aws\Result putGatewayResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putGatewayResponseAsync(array $args = [])
 * @method \Aws\Result putIntegration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putIntegrationAsync(array $args = [])
 * @method \Aws\Result putIntegrationResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putIntegrationResponseAsync(array $args = [])
 * @method \Aws\Result putMethod(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putMethodAsync(array $args = [])
 * @method \Aws\Result putMethodResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putMethodResponseAsync(array $args = [])
 * @method \Aws\Result putRestApi(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putRestApiAsync(array $args = [])
 * @method \Aws\Result tagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \Aws\Result testInvokeAuthorizer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise testInvokeAuthorizerAsync(array $args = [])
 * @method \Aws\Result testInvokeMethod(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise testInvokeMethodAsync(array $args = [])
 * @method \Aws\Result untagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \Aws\Result updateAccount(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateAccountAsync(array $args = [])
 * @method \Aws\Result updateApiKey(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateApiKeyAsync(array $args = [])
 * @method \Aws\Result updateAuthorizer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateAuthorizerAsync(array $args = [])
 * @method \Aws\Result updateBasePathMapping(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateBasePathMappingAsync(array $args = [])
 * @method \Aws\Result updateClientCertificate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateClientCertificateAsync(array $args = [])
 * @method \Aws\Result updateDeployment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateDeploymentAsync(array $args = [])
 * @method \Aws\Result updateDocumentationPart(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateDocumentationPartAsync(array $args = [])
 * @method \Aws\Result updateDocumentationVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateDocumentationVersionAsync(array $args = [])
 * @method \Aws\Result updateDomainName(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateDomainNameAsync(array $args = [])
 * @method \Aws\Result updateGatewayResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateGatewayResponseAsync(array $args = [])
 * @method \Aws\Result updateIntegration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateIntegrationAsync(array $args = [])
 * @method \Aws\Result updateIntegrationResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateIntegrationResponseAsync(array $args = [])
 * @method \Aws\Result updateMethod(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateMethodAsync(array $args = [])
 * @method \Aws\Result updateMethodResponse(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateMethodResponseAsync(array $args = [])
 * @method \Aws\Result updateModel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateModelAsync(array $args = [])
 * @method \Aws\Result updateRequestValidator(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateRequestValidatorAsync(array $args = [])
 * @method \Aws\Result updateResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateResourceAsync(array $args = [])
 * @method \Aws\Result updateRestApi(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateRestApiAsync(array $args = [])
 * @method \Aws\Result updateStage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateStageAsync(array $args = [])
 * @method \Aws\Result updateUsage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateUsageAsync(array $args = [])
 * @method \Aws\Result updateUsagePlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateUsagePlanAsync(array $args = [])
 * @method \Aws\Result updateVpcLink(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateVpcLinkAsync(array $args = [])
 */
class ApiGatewayClient extends AwsClient
{
    public function __construct(array $args)
    {
        parent::__construct($args);
        $stack = $this->getHandlerList();
        $stack->appendBuild([__CLASS__, '_add_accept_header']);
    }

    public static function _add_accept_header(callable $handler)
    {
        return function (
            CommandInterface $command,
            RequestInterface $request
        ) use ($handler) {
            $request = $request->withHeader('Accept', 'application/json');

            return $handler($command, $request);
        };
    }
}
